/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.item;

import cc.lechun.active.dao.active.ActivePropertyMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.item.IndexItemMapper;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.item.BuildPageEntity;
import cc.lechun.mall.entity.item.IndexItemEntity;
import cc.lechun.mall.entity.item.IndexItemVo;
import cc.lechun.mall.entity.item.IndexNavEntity;
import cc.lechun.mall.entity.item.IndexShowTypeEnum;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallProductPicEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.iservice.item.MallBuildPageInterface;
import cc.lechun.mall.iservice.item.MallIndexItemInterface;
import cc.lechun.mall.iservice.item.MallIndexNavInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallIndexItemService
extends BaseService
implements MallIndexItemInterface {
    @Autowired
    private IndexItemMapper indexItemMapper;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Resource
    private ActivePropertyMapper activePropertyMapper;
    @Autowired
    private MallBuildPageInterface buildPageInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallIndexNavInterface indexNavInterface;
    @Autowired
    private MallProductPicInterface picService;

    public List<IndexItemEntity> getList(String navId) {
        IndexItemEntity indexItemEntity = new IndexItemEntity();
        indexItemEntity.setNavId(navId);
        List indexItemEntities = this.indexItemMapper.getList(indexItemEntity);
        if (indexItemEntities != null && indexItemEntities.size() > 0) {
            indexItemEntities.sort((c1, c2) -> c1.getItemSn().compareTo(c2.getItemSn()));
        }
        return indexItemEntities;
    }

    @Override
    public List<IndexItemVo> getIndexItemList(String navId) {
        ArrayList<IndexItemVo> indexItemVos = new ArrayList<IndexItemVo>();
        List<IndexItemEntity> indexItemEntities = this.getList(navId);
        try {
            this.logger.info("\u680f\u76ee\u914d\u7f6e\u7684\u5546\u54c1[{}\u4e2a]:{}", (Object)indexItemEntities.size(), (Object)JsonUtils.toJson(indexItemEntities, (boolean)false));
            this.logger.info("itemList:{}", (Object)JsonUtils.toJson(indexItemEntities, (boolean)false));
            if (indexItemEntities != null && indexItemEntities.size() > 0) {
                for (IndexItemEntity i : indexItemEntities) {
                    this.logger.info("item:{}", (Object)JsonUtils.toJson((Object)i, (boolean)false));
                    IndexItemVo indexItemVo = new IndexItemVo();
                    ObjectConvert.fatherConvertToChild((Object)i, (Object)indexItemVo);
                    indexItemVo.setIsShow(1);
                    if (i.getItemType().equals(String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue())) || i.getItemType().equals(String.valueOf(SalesTypeEnum.SALES_OFF_PRODUCT.getValue()))) {
                        MallProductEntity productEntity = this.productInterface.getProduct(i.getProId());
                        if (i.getItemType().equals(String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue())) && productEntity.getProState() != 1) {
                            indexItemVo.setIsShow(0);
                            indexItemVo.setUnShowReason("\u5355\u54c1\u672a\u4e0a\u67b6");
                        }
                        indexItemVo.setItemName(productEntity != null ? productEntity.getProName() : "\u672a\u627e\u5230\u5546\u54c1");
                    } else if (i.getItemType().equals(String.valueOf(SalesTypeEnum.SALES_PROMOTION.getValue()))) {
                        MallPromotionEntity promotion = this.promotionInterface.getPromotion(i.getProId());
                        if (promotion != null) {
                            if (promotion.getStatus() == 0) {
                                indexItemVo.setIsShow(0);
                                indexItemVo.setUnShowReason("\u4fc3\u9500\u5df2\u7981\u7528");
                            }
                            if (promotion.getBeginTime().compareTo(new Date()) > 0) {
                                indexItemVo.setIsShow(0);
                                indexItemVo.setUnShowReason("\u4fc3\u9500\u672a\u5f00\u59cb\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a" + DateUtils.formatDate((Date)promotion.getBeginTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                            if (promotion.getEndTime().compareTo(new Date()) < 0) {
                                indexItemVo.setIsShow(0);
                                indexItemVo.setUnShowReason("\u4fc3\u9500\u5df2\u7ed3\u675f\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a" + DateUtils.formatDate((Date)promotion.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                        }
                        indexItemVo.setItemName(promotion != null ? promotion.getPromotionName() : "\u672a\u627e\u5230\u4fc3\u9500");
                    } else if (i.getItemType().equals(String.valueOf(SalesTypeEnum.SALES_ACTIVE.getValue()))) {
                        ActiveEntity activeEntity = this.activeInterface.getActiveEntity(i.getProId());
                        this.logger.info("\u67e5\u627e\u6d3b\u52a8[{}]\uff1a{}", (Object)i.getProId(), (Object)JsonUtils.toJson((Object)activeEntity, (boolean)false));
                        if (activeEntity != null) {
                            if (activeEntity.getStatus() == 0) {
                                indexItemVo.setIsShow(0);
                                indexItemVo.setUnShowReason("\u6d3b\u52a8\u5df2\u7981\u7528");
                            }
                            if (activeEntity.getBeginTime().compareTo(new Date()) > 0) {
                                indexItemVo.setIsShow(0);
                                indexItemVo.setUnShowReason("\u6d3b\u52a8\u672a\u5f00\u59cb\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a" + DateUtils.formatDate((Date)activeEntity.getBeginTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                            if (activeEntity.getEndTime().compareTo(new Date()) < 0) {
                                indexItemVo.setIsShow(0);
                                indexItemVo.setUnShowReason("\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a" + DateUtils.formatDate((Date)activeEntity.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                        }
                        indexItemVo.setItemName(activeEntity != null ? activeEntity.getActiveName() : "\u672a\u627e\u5230\u6d3b\u52a8");
                    } else if (i.getItemType().equals(String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()))) {
                        MallProductGroupEntity group = this.groupInterface.getGroup(i.getProId());
                        if (group.getStatus() == 0) {
                            indexItemVo.setIsShow(0);
                            indexItemVo.setUnShowReason("\u5957\u88c5\u5df2\u7981\u7528");
                        }
                        indexItemVo.setItemName(group != null ? group.getGroupName() : "\u672a\u627e\u5230\u5957\u88c5");
                    }
                    BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(i.getBuildPageId());
                    indexItemVo.setModuleListName(buildPageEntity != null ? buildPageEntity.getPageName() : "\u672a\u627e\u5230\u5217\u8868\u6a21\u677f");
                    buildPageEntity = this.buildPageInterface.getBuildPage(i.getDetailBuildPageId());
                    indexItemVo.setMobuleDetailName(buildPageEntity != null ? buildPageEntity.getPageName() : "\u672a\u627e\u5230\u8be6\u60c5\u6a21\u677f");
                    indexItemVo.setItemTypeName(SalesTypeEnum.getName(Integer.parseInt(i.getItemType())));
                    indexItemVo.setShowTypeName(IndexShowTypeEnum.getName(i.getIndexShowType()));
                    if (indexItemVo.getIsShow() == 1 && indexItemVo.getIndexShowType() == 0) {
                        indexItemVo.setIsShow(0);
                        indexItemVo.setUnShowReason("\u914d\u7f6e\u4e3a\u9996\u9875\u4e0d\u663e\u793a");
                    }
                    this.logger.info("indexItemVo:{}", (Object)JsonUtils.toJson((Object)indexItemVo, (boolean)false));
                    indexItemVos.add(indexItemVo);
                }
                this.logger.info("\u680f\u76ee\u914d\u7f6e\u7684\u5546\u54c1build\u540e[{}\u4e2a]:{}", (Object)indexItemVos.size(), (Object)JsonUtils.toJson(indexItemVos, (boolean)false));
                indexItemVos.sort(new Comparator<IndexItemVo>(){

                    @Override
                    public int compare(IndexItemVo o1, IndexItemVo o2) {
                        return o1.getIsShow() - o2.getIsShow();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u680f\u76ee\u8be6\u60c5\u9875\u51fa\u9519", (Throwable)e);
        }
        return indexItemVos;
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexItemEntity", expiration=3600)
    public IndexItemEntity getIdnexItem(@ParameterValueKeyProvider String indexItemId) {
        return (IndexItemEntity)this.indexItemMapper.selectByPrimaryKey((Serializable)((Object)indexItemId));
    }

    @Override
    public BaseJsonVo saveIndexItem(IndexItemEntity indexItemEntity) {
        int count = 0;
        BaseJsonVo baseJsonVo = this.checkPic(indexItemEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        if (indexItemEntity.getIndexItemId() == null || indexItemEntity.getIndexItemId().isEmpty()) {
            indexItemEntity.setIndexItemId(IDGenerate.getUniqueIdStr());
            count = this.indexItemMapper.insertSelective(indexItemEntity);
        } else {
            IndexItemEntity temp = (IndexItemEntity)this.indexItemMapper.selectByPrimaryKey((Serializable)((Object)indexItemEntity.getIndexItemId()));
            if (!Objects.equals(indexItemEntity.getItemType(), temp.getItemType()) && Objects.equals(temp.getProId(), indexItemEntity.getProId())) {
                return BaseJsonVo.error((String)"\u5df2\u4fee\u6539\u5546\u54c1\u7c7b\u522b\uff0c\u8bf7\u4fee\u6539\u5546\u54c1");
            }
            if (!Objects.equals(indexItemEntity.getItemType(), temp.getItemType()) && Objects.equals(temp.getBuildPageId(), indexItemEntity.getBuildPageId())) {
                return BaseJsonVo.error((String)"\u5df2\u4fee\u6539\u5546\u54c1\u7c7b\u522b\uff0c\u8bf7\u4fee\u6539\u5217\u8868\u6a21\u677f");
            }
            count = this.indexItemMapper.updateByPrimaryKeySelective(indexItemEntity);
        }
        this.removeCache(indexItemEntity.getNavId(), indexItemEntity.getIndexItemId());
        if (count > 0) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    private BaseJsonVo checkPic(IndexItemEntity indexItemEntity) {
        List tmpPics;
        List<MallProductPicEntity> picList;
        if (Objects.equals(indexItemEntity.getItemType(), String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue())) || Objects.equals(indexItemEntity.getItemType(), String.valueOf(SalesTypeEnum.SALES_OFF_PRODUCT.getValue()))) {
            picList = this.picService.getPicList(indexItemEntity.getProId());
            if (CollectionUtils.isEmpty(picList)) {
                return BaseJsonVo.error((String)"\u672a\u914d\u7f6e\u5c0f\u56fe\u3001\u5217\u8868\u56fe\u56fe\u7247\uff0c\u8bf7\u5148\u914d\u7f6e\u540e\u518d\u4e0a\u5546\u54c1");
            }
            tmpPics = picList.stream().filter(p -> Objects.equals(p.getGroupType(), ProductPicTypeEnum.PRO_LIST.getValue())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tmpPics)) {
                return BaseJsonVo.error((String)"\u672a\u914d\u7f6e\u5546\u54c1\u5217\u8868\u56fe\uff0c\u8bf7\u5148\u914d\u7f6e\u540e\u518d\u4e0a\u5546\u54c1");
            }
            tmpPics = picList.stream().filter(p -> Objects.equals(p.getGroupType(), ProductPicTypeEnum.PRO_SAMLL.getValue())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tmpPics)) {
                return BaseJsonVo.error((String)"\u672a\u914d\u7f6e\u5546\u54c1\u5c0f\u56fe\uff0c\u8bf7\u5148\u914d\u7f6e\u540e\u518d\u4e0a\u5546\u54c1");
            }
        }
        if (Objects.equals(indexItemEntity.getItemType(), String.valueOf(SalesTypeEnum.SALES_PROMOTION.getValue()))) {
            picList = this.picService.getPicList(indexItemEntity.getProId());
            if (CollectionUtils.isEmpty(picList)) {
                return BaseJsonVo.error((String)"\u672a\u914d\u7f6e\u5c0f\u56fe\u3001\u5217\u8868\u56fe\u56fe\u7247\uff0c\u8bf7\u5148\u914d\u7f6e\u540e\u518d\u4e0a\u4fc3\u9500");
            }
            tmpPics = picList.stream().filter(p -> Objects.equals(p.getGroupType(), ProductPicTypeEnum.PROMO_LIST.getValue())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tmpPics)) {
                return BaseJsonVo.error((String)"\u672a\u914d\u7f6e\u4fc3\u9500\u5217\u8868\u56fe\uff0c\u8bf7\u5148\u914d\u7f6e\u540e\u518d\u4e0a\u5546\u54c1");
            }
            tmpPics = picList.stream().filter(p -> Objects.equals(p.getGroupType(), ProductPicTypeEnum.PROMO_SAMLL.getValue())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tmpPics)) {
                return BaseJsonVo.error((String)"\u672a\u914d\u7f6e\u4fc3\u9500\u5c0f\u56fe\uff0c\u8bf7\u5148\u914d\u7f6e\u540e\u518d\u4e0a\u5546\u54c1");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteIndexItem(String indexItemId) {
        IndexItemEntity indexItemEntity = (IndexItemEntity)this.indexItemMapper.selectByPrimaryKey((Serializable)((Object)indexItemId));
        if (indexItemEntity != null) {
            this.removeCache(indexItemEntity.getNavId(), indexItemId);
        }
        if (this.indexItemMapper.deleteByPrimaryKey((Serializable)((Object)indexItemId)) == 1) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public BaseJsonVo copyIndexItem() {
        this.indexItemMapper.deleteH5();
        List<IndexNavEntity> indexNavList = this.indexNavInterface.getIndexNavList(4);
        indexNavList.forEach(indexNav -> {
            String newNavId = IDGenerate.getUniqueIdStr();
            IndexItemEntity param = new IndexItemEntity();
            param.setNavId(indexNav.getIndexNavId());
            List indexItemList = this.indexItemMapper.getList(param);
            indexItemList.forEach(indexItemEntity -> {
                indexItemEntity.setIndexItemId(IDGenerate.getUniqueIdStr());
                indexItemEntity.setNavId(newNavId);
                indexItemEntity.setBuildPageId(null);
                indexItemEntity.setDetailBuildPageId(null);
                if (indexItemEntity.getBuildPageId() != null) {
                    if (indexItemEntity.getBuildPageId() == 139) {
                        indexItemEntity.setBuildPageId(32);
                        if (indexItemEntity.getDetailBuildPageId() == 140) {
                            indexItemEntity.setDetailBuildPageId(41);
                        } else if (indexItemEntity.getDetailBuildPageId() == 141) {
                            indexItemEntity.setDetailBuildPageId(132);
                        }
                    } else if (indexItemEntity.getBuildPageId() == 148) {
                        indexItemEntity.setBuildPageId(133);
                        if (indexItemEntity.getDetailBuildPageId() == 140) {
                            indexItemEntity.setDetailBuildPageId(131);
                        } else if (indexItemEntity.getDetailBuildPageId() == 141) {
                            indexItemEntity.setDetailBuildPageId(132);
                        }
                    }
                }
                if (indexItemEntity.getBuildPageId() != null) {
                    this.indexItemMapper.insert(indexItemEntity);
                }
            });
            indexNav.setIndexNavId(newNavId);
            indexNav.setPlatformId(1);
            indexNav.setBuildPageId(39);
            indexNav.setNavBuildPageId(38);
            indexNav.setParentIndexNavId("");
            this.indexNavInterface.saveIndexNav((IndexNavEntity)indexNav);
        });
        return BaseJsonVo.success((Object)"");
    }

    private void removeCache(String indexNavId, String indexItemId) {
        this.memcachedService.delete("IndexItemEntity", String.valueOf(indexItemId));
        this.memcachedService.delete("IndexItemList", String.valueOf(indexNavId));
        this.memcachedService.delete("IndexItemListVo", String.valueOf(indexNavId));
    }

    @Override
    public String getItemDetailUrl(String modulePath, int platformId, String navId, int itemType, String itemId) {
        return modulePath + platformId + "_" + navId + "_" + itemType + "_" + itemId + ".html";
    }

    @Override
    public List<MallSelectDataVo> getItems(int itemType, int platformGroupId) {
        if (itemType == SalesTypeEnum.SALES_PRODUCT.getValue()) {
            return this.productInterface.getOptionProductList(platformGroupId);
        }
        if (itemType == SalesTypeEnum.SALES_OFF_PRODUCT.getValue()) {
            return this.productInterface.getOptionProductList4OffSale(platformGroupId);
        }
        if (itemType == SalesTypeEnum.SALES_GROUP.getValue()) {
            return this.groupInterface.getOptionGroupList(platformGroupId);
        }
        if (itemType == SalesTypeEnum.SALES_PROMOTION.getValue()) {
            return this.promotionInterface.getOptionPromotionList(platformGroupId);
        }
        if (itemType == SalesTypeEnum.SALES_ACTIVE.getValue()) {
            return this.activeInterface.getOptionActiveList(platformGroupId);
        }
        return new ArrayList<MallSelectDataVo>();
    }
}

