/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.minischeme;

import cc.lechun.active.dao.active.ActivePropertyMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActivePageEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActivePageInterface;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.minischeme.MiniSchemeMapper;
import cc.lechun.mall.entity.minischeme.MiniSchemeEntity;
import cc.lechun.mall.entity.minischeme.MiniSchemeQueryVo;
import cc.lechun.mall.entity.minischeme.MiniSchemeVo;
import cc.lechun.mall.entity.minischeme.SchemeExprieTypeEnum;
import cc.lechun.mall.entity.page.PageLinkEntity;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.iservice.minischeme.MiniSchemeInterface;
import cc.lechun.mall.iservice.page.PageLinkInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.shortlink.ShortLinkInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.URLSchemeAPI;
import weixin.popular.bean.URLScheme.SchemeResult;

@Service
public class MiniSchemeService
extends BaseService<MiniSchemeEntity, Integer>
implements MiniSchemeInterface {
    @Resource
    private MiniSchemeMapper miniSchemeMapper;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseService;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private ShortLinkInterface shortLinkInterface;
    @Autowired
    private PageLinkInterface pageLinkInterface;
    @Autowired
    private ActivePageInterface activePageInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Resource
    private ActivePropertyMapper activePropertyMapper;

    @Override
    public BaseJsonVo<MiniSchemeEntity> getMiniSchemeSystemByPara(String miniPath) {
        MiniSchemeEntity result;
        MiniSchemeEntity query = new MiniSchemeEntity();
        String regex = "\\?";
        String[] path = miniPath.trim().split(regex);
        query.setMiniPath(path[0]);
        if (path.length > 1) {
            query.setQueryPara(path[1]);
        }
        if ((result = (MiniSchemeEntity)this.miniSchemeMapper.getSingle(query)) == null) {
            query.setPlatformId(4);
            return this.saveMiniScheme(query);
        }
        return BaseJsonVo.success((Object)result);
    }

    @Override
    public BaseJsonVo deleteMiniScheme(int urlSchemeId) {
        return this.miniSchemeMapper.deleteByPrimaryKey(Integer.valueOf(urlSchemeId)) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5!");
    }

    @Override
    public BaseJsonVo saveMiniScheme(MiniSchemeEntity miniSchemeEntity) {
        if (miniSchemeEntity.getExpireType() == null) {
            miniSchemeEntity.setExpireType(SchemeExprieTypeEnum.temp.getValue());
        }
        if (miniSchemeEntity.getPlatformId() == null) {
            miniSchemeEntity.setPlatformId(4);
        }
        String accessToken = this.weiXinBaseService.getAccessTokenValueByPlatformId(miniSchemeEntity.getPlatformId());
        miniSchemeEntity.setExpiredTime(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)30));
        miniSchemeEntity.setCreateTime(DateUtils.now());
        SchemeResult schemeResult = URLSchemeAPI.getURLScheme((String)accessToken, (boolean)true, (long)(miniSchemeEntity.getExpiredTime().getTime() / 1000L), (String)miniSchemeEntity.getMiniPath(), (String)miniSchemeEntity.getQueryPara());
        if (schemeResult.isSuccess()) {
            String openLink = schemeResult.getOpenlink();
            miniSchemeEntity.setOpenLink(openLink);
            this.logger.info("\u5fae\u4fe1\u751f\u6210\u8fde\u63a5:{}", (Object)miniSchemeEntity.toString());
            String path = miniSchemeEntity.getMiniPath();
            if (StringUtils.isNotEmpty((String)miniSchemeEntity.getQueryPara())) {
                path = path + "?" + miniSchemeEntity.getQueryPara();
            }
            try {
                path = URLEncoder.encode(path, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            String longUrl = "http://wechat.lechun.cc/empty?t=" + openLink.split("&")[0].split("=")[1] + "&platformId=" + miniSchemeEntity.getPlatformId() + "&path=" + path;
            this.logger.info("\u957f\u8fde\u63a5:{}", (Object)longUrl);
            if (miniSchemeEntity.getUrlSchemeId() == null || miniSchemeEntity.getUrlSchemeId() == 0) {
                String shortLink = this.shortLinkInterface.getShorterUrl(longUrl, "", miniSchemeEntity.getSchemeName());
                this.logger.info("\u751f\u6210\u5546\u57ce\u77ed\u8fde\u63a5:{}", (Object)shortLink);
                miniSchemeEntity.setShortLink(shortLink);
                this.miniSchemeMapper.insertSelective(miniSchemeEntity);
            } else {
                if (StringUtils.isNotEmpty((String)miniSchemeEntity.getShortLink())) {
                    String key = miniSchemeEntity.getShortLink().replace("http://t.lechun.cc/", "").replace("https://t.lechun.cc/", "");
                    this.logger.info("key:{}", (Object)key);
                    String shortLink = this.shortLinkInterface.getShorterUrl(longUrl, key, StringUtils.isNotEmpty((String)miniSchemeEntity.getSchemeName()) ? miniSchemeEntity.getSchemeName() : "\u5c0f\u7a0b\u5e8f\u77e5\u8fde\u63a5");
                    if (StringUtils.isEmpty((String)shortLink)) {
                        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25,\u5c0f\u7a0b\u5e8f\u8fde\u63a5\u53c2\u6570\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u8fde\u63a5\u53ca\u53c2\u6570\u540e\u518d\u91cd\u8bd5");
                    }
                    this.logger.info("\u751f\u6210\u5546\u57ce\u77ed\u8fde\u63a5:" + shortLink);
                    miniSchemeEntity.setCreateTime(DateUtils.now());
                    miniSchemeEntity.setShortLink(shortLink);
                }
                this.miniSchemeMapper.updateByPrimaryKey(miniSchemeEntity);
            }
            return BaseJsonVo.success((Object)miniSchemeEntity);
        }
        return BaseJsonVo.error((String)("\u521b\u5efa\u5931\u8d25," + schemeResult.getErrmsg()));
    }

    @Override
    public PageInfo<MiniSchemeVo> getMiniSchemeList(MiniSchemeQueryVo miniSchemeQueryVo) {
        Page page = PageHelper.startPage((int)miniSchemeQueryVo.getCurrentPage(), (int)miniSchemeQueryVo.getPageSize());
        page.setOrderBy("URL_SCHEME_ID desc");
        List<MiniSchemeEntity> list = this.miniSchemeMapper.getMiniSchemeList(miniSchemeQueryVo);
        ArrayList<MiniSchemeVo> result = new ArrayList<MiniSchemeVo>();
        for (MiniSchemeEntity miniSchemeEntity : list) {
            MiniSchemeVo miniSchemeVo = new MiniSchemeVo();
            BeanUtils.copyProperties((Object)miniSchemeEntity, (Object)miniSchemeVo);
            PlatFormEntity platFormEntity = this.platFormInterface.getPlatForm(miniSchemeEntity.getPlatformId());
            miniSchemeVo.setPlatformName(platFormEntity == null ? "" : platFormEntity.getPlatformName());
            miniSchemeVo.setSchemeExprieTypeName(SchemeExprieTypeEnum.getName(miniSchemeEntity.getExpireType()));
            result.add(miniSchemeVo);
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(result);
        return pg;
    }

    @Override
    public BaseJsonVo getMiniSchemeSystem(Integer linkType, Integer activeType, Map<String, Object> params) {
        this.logger.info("linkType={},activeType={},params={}", new Object[]{linkType, activeType, JsonUtils.toJson(params, (boolean)false)});
        String param = "";
        String path = "";
        String activeTitle = "";
        if (Integer.valueOf(0).equals(linkType) || params.containsKey("bindCode") || params.containsKey("activeNo")) {
            String activeUrl;
            ActivePageEntity pageEntity;
            Object activeNo;
            ActiveEntity activeEntity = null;
            Object object = activeNo = params.get("activeNo") == null ? "" : params.get("activeNo").toString();
            if (StringUtils.isNotEmpty((String)activeNo)) {
                activeEntity = this.activeInterface.getActiveEntity((String)activeNo);
            } else if (params.containsKey("bindCode")) {
                activeEntity = this.activeInterface.getActiveEntityByQrcode(params.get("bindCode").toString());
            }
            if (activeEntity == null) {
                return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
            }
            activeTitle = activeEntity.getActiveName();
            if (!params.containsKey("bindCode")) {
                params.put("bindCode", activeEntity.getBindCode());
            }
            boolean limit = false;
            if (Objects.equals(activeEntity.getActiveType(), 15)) {
                ActivePropertyEntity query = new ActivePropertyEntity();
                query.setBindCode(activeEntity.getBindCode());
                List list = this.activePropertyMapper.getList(query);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    limit = list.stream().anyMatch(pp -> Objects.equals(pp.getPropertyKey(), "cashTakeType") && Objects.equals(pp.getPropertyValue(), "\u4ec5\u4e00\u6b21"));
                }
            }
            if ((pageEntity = this.activePageInterface.getActivePageEntityByActiveNo((String)activeNo)) != null && StringUtils.isNotEmpty((String)(activeUrl = pageEntity.getActiveUrl()))) {
                path = activeUrl.split("\\?")[0];
                if (activeUrl.split("\\?").length > 1) {
                    param = activeUrl.split("\\?")[1];
                }
                if (limit) {
                    param = param + "&code=" + this.encrypt16(RandomUtils.generateString((int)8));
                }
            }
        }
        if (StringUtils.isEmpty((String)path)) {
            PageLinkEntity pageLinkEntity = this.pageLinkInterface.getPageLinkByParam(linkType, activeType == null ? -1 : activeType);
            if (pageLinkEntity == null) {
                return BaseJsonVo.error((String)("\u65e0\u6cd5\u83b7\u53d6PageLink\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u8bbe\u7f6e\u4e86PageLink\uff0clinkType:" + linkType + ",activeType:" + (activeType == null ? -1 : activeType)));
            }
            this.logger.info("\u67e5\u8be2\u8fde\u63a5:{}", (Object)JsonUtils.toJson((Object)pageLinkEntity, (boolean)false));
            path = pageLinkEntity.getPageLink();
            activeTitle = pageLinkEntity.getPageTitle();
            param = pageLinkEntity.getPageLinkPara() == null ? "" : pageLinkEntity.getPageLinkPara();
            this.logger.info("\u67e5\u8be2\u8fde\u63a5param:{}", (Object)param);
            if (params != null) {
                for (String k : params.keySet()) {
                    param = param.replace("{" + k + "}", params.get(k).toString());
                }
                if (params.containsKey("ncp_bat")) {
                    String string = param = StringUtils.isNotEmpty((String)param) ? param + "&ncp_bat=" + params.get("ncp_bat").toString() : "ncp_bat=" + params.get("ncp_bat").toString();
                }
                if (param.indexOf("{") >= 0 || param.indexOf("}") >= 0) {
                    return BaseJsonVo.error((String)("\u53c2\u6570\u4e2d\u8fd8\u6709\u53d8\u91cf\u672a\u66ff\u6362,\u53c2\u6570\uff1a" + param));
                }
            }
        } else {
            for (String k : params.keySet()) {
                if (Objects.equals(k, "activeNo") || Objects.equals(k, "bindCode")) continue;
                param = param + "&" + k + "=" + params.get(k).toString();
            }
            if (param.startsWith("&")) {
                param = param.substring(1);
            }
        }
        MiniSchemeEntity schemeEntity = new MiniSchemeEntity();
        schemeEntity.setMiniPath(path);
        schemeEntity.setQueryPara(param);
        schemeEntity.setSchemeType(1);
        schemeEntity.setPlatformId(PlatFormEnum.LECHUN_MINI.getValue());
        MiniSchemeEntity entity = (MiniSchemeEntity)this.miniSchemeMapper.getSingle(schemeEntity);
        if (entity != null) {
            return BaseJsonVo.success((Object)entity);
        }
        schemeEntity.setExpireType(SchemeExprieTypeEnum.temp.getValue());
        schemeEntity.setSchemeName(activeTitle);
        return this.saveMiniScheme(schemeEntity);
    }

    public String encrypt32(String encryptStr) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] md5Bytes = md5.digest(encryptStr.getBytes());
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; ++i) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            encryptStr = hexValue.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return encryptStr;
    }

    public String encrypt16(String encryptStr) {
        return this.encrypt32(encryptStr).substring(8, 24);
    }

    public String setMiniUrl(String path, String param) {
        String reg = "(\\w+)?(\\/pages)?(\\/\\w+)(\\/index)?(\\?\\S*)?";
        String urlPathName = path.replace(reg, "$3");
        String urlSearch = param;
        String urlLink = "http://lechun.cc" + urlPathName + urlSearch;
        return "type=open&targeturl=" + this.encodeURL(urlLink);
    }

    public String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }
}

