/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.minishop;

import cc.lechun.common.enums.common.EnvironmentEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.sales.MallProductMapper;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import weixin.popular.api.shop.ProductAPI;
import weixin.popular.api.shop.ProductCatAPI;
import weixin.popular.api.shop.ShopAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.shop.AuditResult;
import weixin.popular.bean.shop.BrandListResult;
import weixin.popular.bean.shop.BrandResult;
import weixin.popular.bean.shop.cat.ProductCatInfo;
import weixin.popular.bean.shop.cat.ProductCatResult;
import weixin.popular.bean.shop.product.NewSkuInfo;
import weixin.popular.bean.shop.product.ProductListResult;
import weixin.popular.bean.shop.product.ProductResult;
import weixin.popular.util.JsonUtil;

@Service
public class MiniShopService {
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseInterface;
    @Autowired
    private MallProductMapper productMapper;
    @Autowired
    private MallProductPicInterface picService;
    @Value(value="${lechun.environment}")
    private String environment;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseJsonVo register(int platFormId) {
        BaseResult baseResult = ShopAPI.register((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId));
        return baseResult.isSuccess() ? BaseJsonVo.success((Object)"\u7533\u8bf7\u6ce8\u518c\u6210\u529f") : BaseJsonVo.error((String)baseResult.getErrmsg());
    }

    @ReadThroughSingleCache(namespace="MiniShopService.getSkuCatList", expiration=86400)
    public BaseJsonVo<List<ProductCatInfo>> getSkuCatList(@ParameterValueKeyProvider int platFormId) {
        ProductCatResult productCatResult = ProductCatAPI.getSkuCat((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId));
        return productCatResult.isSuccess() ? BaseJsonVo.success((Object)productCatResult.getThird_cat_list()) : BaseJsonVo.error((String)productCatResult.getErrmsg());
    }

    public BaseJsonVo audit_category(int platFormId, String data) {
        this.logger.info("\u4e0a\u4f20\u5ba1\u6838\u8d44\u6599:{}", (Object)data);
        BrandResult baseResult = ProductCatAPI.audit_category((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId), (String)data);
        this.logger.info("\u5ba1\u6838audit_id={},", (Object)baseResult.getAudit_id());
        return baseResult.isSuccess() ? BaseJsonVo.success((Object)("\u7c7b\u76ee\u8d44\u8d28\u4e0a\u4f20\u6210\u529f,\u8bf7\u59a5\u5584\u4fdd\u5b58 audit_id=" + baseResult.getAudit_id() + ",\u540e\u7eed\u53ef\u7528\u4e8e\u67e5\u8be2\u5ba1\u6838\u8fdb\u5ea6")) : BaseJsonVo.error((String)baseResult.getErrmsg());
    }

    public BaseJsonVo audit_Brand(int platFormId, String brand) {
        this.logger.info("\u4e0a\u4f20\u5ba1\u6838\u8d44\u6599:{}", (Object)brand.toString());
        BrandResult baseResult = ShopAPI.audit_brand((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId), (String)brand);
        this.logger.info("\u4e0a\u4f20\u5ba1\u6838\u8d44\u6599:{}", (Object)baseResult);
        this.logger.info("\u5ba1\u6838audit_id={},", (Object)(baseResult.isSuccess() ? baseResult.getAudit_id() : ""));
        return baseResult.isSuccess() ? BaseJsonVo.success((Object)("\u8d44\u8d28\u4e0a\u4f20\u6210\u529f,\u8bf7\u59a5\u5584\u4fdd\u5b58 audit_id=" + baseResult.getAudit_id() + ",\u540e\u7eed\u53ef\u7528\u4e8e\u67e5\u8be2\u5ba1\u6838\u8fdb\u5ea6")) : BaseJsonVo.error((String)baseResult.getErrmsg());
    }

    public BaseJsonVo get_brand_list(int platFormId) {
        BrandListResult baseResult = ShopAPI.get_brand_list((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId));
        return baseResult.isSuccess() ? BaseJsonVo.success((Object)baseResult.getData()) : BaseJsonVo.error((String)baseResult.getErrmsg());
    }

    public BaseJsonVo get_audit_category(int platFormId, String audit_id) {
        this.logger.info("audit_id:{}", (Object)audit_id);
        AuditResult baseResult = ShopAPI.getAuditResult((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId), (String)audit_id);
        return baseResult.isSuccess() ? BaseJsonVo.success((Object)baseResult.getData()) : BaseJsonVo.error((String)baseResult.getErrmsg());
    }

    public BaseJsonVo initProduct(int platFormId) {
        String accessToken = this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId);
        List<MallProductEntity> list = this.productMapper.getOnProductList(1000);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        list.sort((c1, c2) -> c1.getSort().compareTo(c2.getSort()));
        for (MallProductEntity productEntity : list) {
            if (productEntity.getThirdCatId() == null || productEntity.getProState() != 1 || productEntity.getProductCategoryId().equals(11) || productEntity.getProductCategoryId().equals(10)) continue;
            BaseJsonVo baseJsonVo = this.saveProduct(accessToken, productEntity);
            if (!baseJsonVo.isSuccess()) {
                result.add(productEntity.getProName());
                stringBuilder.append(productEntity.getProName() + ",");
            } else {
                this.setProductOn(accessToken, null, productEntity.getProId());
            }
            this.logger.info("\u5546\u54c1:proid={},\u4e0a\u4f20:{}", (Object)productEntity.getProId(), (Object)baseJsonVo.isSuccess());
        }
        return result.size() > 0 ? BaseJsonVo.error((String)stringBuilder.toString()) : BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo saveProduct(int platFormId, MallProductEntity productEntity) {
        if (EnvironmentEnum.PRODUCT.getValue().equals(this.environment) && productEntity.getProTypeId() != 7 && productEntity.getProTypeId() != 11 && productEntity.getProTypeId() != 10) {
            String accessToken = this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId);
            BaseJsonVo baseJsonVo = this.saveProduct(accessToken, productEntity);
            if (baseJsonVo.isSuccess()) {
                if (productEntity.getProState() == 1) {
                    this.setProductOn(accessToken, null, productEntity.getProId());
                } else {
                    this.setProductOff(accessToken, null, productEntity.getProId());
                }
            }
            return baseJsonVo;
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo saveProduct(int platFormId, String proId) {
        MallProductEntity productEntity = (MallProductEntity)this.productMapper.selectByPrimaryKey((Serializable)((Object)proId));
        if (productEntity == null) {
            return BaseJsonVo.error((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        return this.saveProduct(platFormId, productEntity);
    }

    public BaseJsonVo getProductList(int platFormId, int page, int page_size, Integer need_edit_spu) {
        String accessToken = this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId);
        ProductListResult productListResult = ProductAPI.getProductList((String)accessToken, (int)page, (int)page_size, (Integer)need_edit_spu);
        return productListResult.isSuccess() ? BaseJsonVo.success((Object)productListResult) : BaseJsonVo.error((String)productListResult.getErrmsg());
    }

    public BaseJsonVo setProductOn(int platFormId, Integer product_id, String out_product_id) {
        if (EnvironmentEnum.PRODUCT.getValue().equals(this.environment)) {
            String accessToken = this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId);
            BaseResult baseResult = ProductAPI.setProductOn((String)accessToken, (Integer)product_id, (String)out_product_id);
            return baseResult.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)baseResult.getErrmsg());
        }
        return BaseJsonVo.error((String)"\u6d4b\u8bd5\u73af\u5883\u4e0d\u652f\u6301\u4e0a\u67b6\u64cd\u4f5c!");
    }

    public BaseJsonVo setProductOn(String accessToken, Integer product_id, String out_product_id) {
        if (EnvironmentEnum.PRODUCT.getValue().equals(this.environment)) {
            BaseResult baseResult = ProductAPI.setProductOn((String)accessToken, (Integer)product_id, (String)out_product_id);
            return baseResult.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)baseResult.getErrmsg());
        }
        return BaseJsonVo.error((String)"\u6d4b\u8bd5\u73af\u5883\u4e0d\u652f\u6301\u4e0a\u67b6\u64cd\u4f5c!");
    }

    public BaseJsonVo setProductOff(int platFormId, Integer product_id, String out_product_id) {
        String accessToken = this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId);
        BaseResult baseResult = ProductAPI.setProductOff((String)accessToken, (Integer)product_id, (String)out_product_id);
        return this.setProductOff(accessToken, product_id, out_product_id);
    }

    public BaseJsonVo setProductOff(String accessToken, Integer product_id, String out_product_id) {
        BaseResult baseResult = ProductAPI.setProductOff((String)accessToken, (Integer)product_id, (String)out_product_id);
        return baseResult.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)baseResult.getErrmsg());
    }

    public BaseJsonVo deleteProduct(int platFormId, int product_id, String out_product_id) {
        String accessToken = this.weiXinBaseInterface.getAccessTokenValueByPlatformId(platFormId);
        BaseResult baseResult = ProductAPI.delProduct((String)accessToken, (Integer)product_id, (String)out_product_id);
        return baseResult.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)baseResult.getErrmsg());
    }

    private BaseJsonVo saveProduct(String accessToken, MallProductEntity productEntity) {
        try {
            Double temp;
            NewSkuInfo newSkuInfo = new NewSkuInfo();
            newSkuInfo.setOut_product_id(productEntity.getProId());
            newSkuInfo.setTitle(productEntity.getProTitle());
            newSkuInfo.setPath("pages/product_detail/index?productId=" + productEntity.getProId() + "&productType=4");
            newSkuInfo.setThird_cat_id(productEntity.getThirdCatId());
            Map<String, List<String>> picList = this.picService.getProductPicUrlMap(productEntity.getProId(), SalesTypeEnum.SALES_PRODUCT.getValue());
            newSkuInfo.setHead_img(picList.get(ProductPicTypeEnum.PRO_HEAD.getName()));
            NewSkuInfo.Sku sku = new NewSkuInfo.Sku();
            sku.setOut_product_id(productEntity.getProId());
            sku.setBarcode(productEntity.getBarCode());
            sku.setOut_sku_id(productEntity.getProId());
            ArrayList<String> attr_keyList = new ArrayList<String>();
            attr_keyList.add("\u89c4\u683c");
            sku.setAttr_key(attr_keyList);
            ArrayList<String> attr_valueList = new ArrayList<String>();
            attr_valueList.add(productEntity.getProSpec());
            sku.setAttr_value(attr_valueList);
            if (StringUtils.isNotEmpty((String)productEntity.getProPrice1())) {
                temp = Double.valueOf(productEntity.getProPrice1()) * 100.0;
                sku.setMarket_price(Integer.valueOf(temp.intValue()));
            }
            if (StringUtils.isNotEmpty((String)productEntity.getProPrice())) {
                temp = Double.valueOf(productEntity.getProPrice()) * 100.0;
                sku.setMarket_price(Integer.valueOf(temp.intValue()));
                temp = Double.valueOf(productEntity.getProPrice1()) * 100.0;
                sku.setSale_price(Integer.valueOf(temp.intValue()));
            }
            sku.setThumb_img(picList.get(ProductPicTypeEnum.PRO_SAMLL.getName()));
            sku.setStock_num(productEntity.getLimitBuyCount());
            ArrayList<NewSkuInfo.Sku> skus = new ArrayList<NewSkuInfo.Sku>();
            skus.add(sku);
            newSkuInfo.setSkus(skus);
            String json = JsonUtil.toJSONString((Object)newSkuInfo);
            this.logger.info("\u4e0a\u4f20\u5546\u54c1:{}", (Object)json);
            ProductResult productResult = ProductAPI.addProduct((String)accessToken, (String)json);
            this.logger.info("\u5546\u54c1:{},\u4fdd\u5b58\u7ed3\u679c:{}", (Object)productEntity, (Object)productResult);
            return productResult.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)productResult.getErrmsg());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u51fa\u9519");
        }
    }
}

