/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.page;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.page.PageLinkMapper;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.page.PageLinkEntity;
import cc.lechun.mall.entity.page.PageLinkOptionVo;
import cc.lechun.mall.entity.page.PageLinkQueryVo;
import cc.lechun.mall.entity.page.PageLinkTypeEnum;
import cc.lechun.mall.entity.page.PageLinkVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.page.PageLinkInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PageLinkService
extends BaseService<PageLinkEntity, Integer>
implements PageLinkInterface {
    @Resource
    private PageLinkMapper pageLinkMapper;
    @Autowired
    private DictionaryInterface dictionaryInterface;

    @Override
    public BaseJsonVo savePageLink(PageLinkEntity pageLinkEntity) {
        if (pageLinkEntity.getActiveType() != null && pageLinkEntity.getActiveType() != -1) {
            PageLinkEntity query = new PageLinkEntity();
            query.setActiveType(pageLinkEntity.getActiveType());
            query.setPageLink(pageLinkEntity.getPageLink());
            PageLinkEntity result = (PageLinkEntity)this.pageLinkMapper.getSingle(query);
            if (result != null && !result.getLinkId().equals(pageLinkEntity.getLinkId())) {
                return BaseJsonVo.error((String)"\u8fde\u63a5\u5df2\u5b58\u5728");
            }
        }
        if (pageLinkEntity.getLinkId() != null && pageLinkEntity.getLinkId() > 0) {
            this.pageLinkMapper.updateByPrimaryKeySelective(pageLinkEntity);
        } else {
            pageLinkEntity.setCreateTime(DateUtils.now());
            this.pageLinkMapper.insert(pageLinkEntity);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public PageInfo getPageLinkList(PageLinkQueryVo pageLinkQueryVo) {
        Page page = PageHelper.startPage((int)pageLinkQueryVo.getCurrentPage(), (int)pageLinkQueryVo.getPageSize());
        page.setOrderBy("LINK_ID desc");
        PageLinkEntity pageLinkEntity = new PageLinkEntity();
        BeanUtils.copyProperties((Object)pageLinkQueryVo, (Object)pageLinkEntity);
        ArrayList result = new ArrayList();
        List<PageLinkEntity> list = this.pageLinkMapper.getPageLinkList(pageLinkEntity);
        List<DictionaryEntity> dictionaryEntityList = this.dictionaryInterface.getValidDictionaryList(1000, 203);
        list.forEach(link -> {
            PageLinkVo pageLinkVo = new PageLinkVo();
            BeanUtils.copyProperties((Object)link, (Object)pageLinkVo);
            if (link.getActiveType() != null && link.getActiveType() != -1) {
                Optional<DictionaryEntity> dictionaryEntityOptional = dictionaryEntityList.stream().filter(dictionaryEntity -> dictionaryEntity.getDictionaryKey().equals(String.valueOf(link.getActiveType()))).findFirst();
                if (dictionaryEntityOptional.isPresent()) {
                    pageLinkVo.setActiveTypeName(dictionaryEntityOptional.get().getDictionaryName());
                }
            } else if (link.getLinkTpye() != null) {
                pageLinkVo.setLinkTypeName(PageLinkTypeEnum.getName(link.getLinkTpye()));
            }
            result.add(pageLinkVo);
        });
        PageInfo pg = page.toPageInfo();
        pg.setList(result);
        return pg;
    }

    @Override
    public PageLinkEntity getPageLinkByParam(Integer linkType, Integer activeType) {
        PageLinkEntity search = new PageLinkEntity();
        search.setLinkTpye(linkType);
        search.setActiveType(activeType);
        search.setDefaultPage(1);
        return (PageLinkEntity)this.pageLinkMapper.getSingle(search);
    }

    @Override
    public List<PageLinkOptionVo> getPageLinkOption(Integer platformId) {
        return this.pageLinkMapper.getPageLinkOption(platformId);
    }
}

