/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.pay;

import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.sign.InterfaceSign;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.trade.MallOrderPayMapper;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.pay.WechatRefundReturnEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderPayRecordEntity;
import cc.lechun.mall.entity.trade.MallPlatformPayTypeEntity;
import cc.lechun.mall.entity.trade.MallRefundEntity;
import cc.lechun.mall.entity.trade.MallRefundFailRecordEntity;
import cc.lechun.mall.entity.trade.MallRefundPayDetailEntity;
import cc.lechun.mall.entity.trade.MallRefundRecordEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.pay.PayInterface;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayRecordInterface;
import cc.lechun.mall.iservice.trade.MallPlatformPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallRefundFailRecordInterface;
import cc.lechun.mall.iservice.trade.MallRefundInterface;
import cc.lechun.mall.iservice.trade.MallRefundPayDetailInterface;
import cc.lechun.mall.iservice.trade.MallRefundRecordInterface;
import cc.lechun.mall.iservice.trade.OrderRefundInterface;
import cc.lechun.mall.service.trade.defineFieldHandle.DefineFiledHandleInterface;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayOrderService
extends BaseService
implements PayOrderInterface {
    @Autowired
    private PayInterface payInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallOrderPayInterface mallOrderPayInterface;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Autowired
    private MallOrderGroupProductInterface mallOrderGroupProductService;
    @Autowired
    private MallPlatformPayTypeInterface mallPlatformPayTypeInterface;
    @Autowired
    private DefineFiledHandleInterface defineFiledHandleInterface;
    @Autowired
    private MallRefundInterface refundInterface;
    @Autowired
    private MallRefundRecordInterface refundRecordInterface;
    @Autowired
    private MallOrderPayRecordInterface orderPayRecordInterface;
    @Autowired
    private MallRefundPayDetailInterface mallRefundPayDetailInterface;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private MallOrderPayMapper payMapper;
    @Autowired
    private OrderRefundInterface orderRefundInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MallRefundFailRecordInterface mallRefundFailRecordInterface;

    private List<PayInputEntity> getPayInputEntityList(String orderMainNo, String ip) {
        List<MallOrderPayEntity> mallOrderPayEntitis;
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        if (mallOrderMainEntity == null) {
            return new ArrayList<PayInputEntity>();
        }
        CustomerDetailVo customerDetail = this.customerInterface.getCustomerDetail(mallOrderMainEntity.getCustomerId(), mallOrderMainEntity.getPlatformId());
        String openId = "";
        String customerId = mallOrderMainEntity.getCustomerId();
        if (customerDetail != null) {
            openId = customerDetail.getOpenId();
            customerId = customerDetail.getCustomerId();
        }
        if ((mallOrderPayEntitis = this.mallOrderPayInterface.getList(orderMainNo)) == null) {
            return new ArrayList<PayInputEntity>();
        }
        ArrayList<PayInputEntity> inputEntitis = new ArrayList<PayInputEntity>();
        for (MallOrderPayEntity e : mallOrderPayEntitis) {
            PayInputEntity pe = new PayInputEntity();
            pe.setPayId(e.getPayId());
            pe.setOrderMainNo(orderMainNo);
            pe.setPayType(e.getPaytypeId());
            pe.setPaySubType(e.getPaySubtypeId());
            pe.setPayAmount(e.getPayamount());
            pe.setSuccess(e.getIssuccess() == 1);
            pe.setOrderCreateTime(mallOrderMainEntity.getCreateTime());
            pe.setOpenId(openId);
            pe.setOrder(e.getSort());
            pe.setTradeNo(e.getTradeNo());
            pe.setThirdTradeNo(e.getThirdTradeNo());
            pe.setCustomerId(customerId);
            pe.setIp(ip);
            pe.setCashType(e.getCashType());
            this.fillPayInputEntity(pe, mallOrderMainEntity.getPlatformId(), e.getPaySubtypeId());
            inputEntitis.add(pe);
        }
        Comparator<PayInputEntity> orderSort = Comparator.comparingInt(PayInputEntity::getOrder);
        return inputEntitis.stream().sorted(orderSort).collect(Collectors.toList());
    }

    private PayInputEntity getPayInputEntity(String tradeNo) {
        MallOrderPayEntity mallOrderPayEntity = this.mallOrderPayInterface.getSingleOrderPayByTradeNo(tradeNo);
        if (mallOrderPayEntity == null && (mallOrderPayEntity = this.mallOrderPayInterface.getSingle(tradeNo)) == null) {
            return null;
        }
        String orderMainNo = mallOrderPayEntity.getOrderMainNo();
        PayInputEntity pe = null;
        List<PayInputEntity> payInputEntities = this.getPayInputEntityList(orderMainNo, "");
        if (payInputEntities != null && (payInputEntities = payInputEntities.stream().filter(c -> c.getTradeNo().equals(tradeNo) || c.getPayId().equals(tradeNo)).collect(Collectors.toList())) != null) {
            pe = payInputEntities.get(0);
        }
        return pe;
    }

    private String getWechatPayKey(String tradeNo) {
        String key = "";
        int paySubId = 0;
        int platformId = 0;
        MallOrderPayEntity orderPayEntity = this.mallOrderPayInterface.getSingleOrderPayByTradeNo(tradeNo);
        if (orderPayEntity == null && (orderPayEntity = this.mallOrderPayInterface.getSingle(tradeNo)) == null) {
            return key;
        }
        paySubId = orderPayEntity.getPaySubtypeId();
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderPayEntity.getOrderMainNo());
        if (mallOrderMainEntity == null) {
            return key;
        }
        platformId = mallOrderMainEntity.getPlatformId();
        MallPlatformPayTypeEntity platformPayTypeEntity = this.mallPlatformPayTypeInterface.getEntityByPlatIdAndPayTypeSubId(platformId, paySubId);
        if (platformPayTypeEntity != null) {
            key = platformPayTypeEntity.getPayKey();
        }
        return key;
    }

    private void fillPayInputEntity(PayInputEntity pe, int platformId, int payTypeSubId) {
        MallPlatformPayTypeEntity platformPayTypeEntity = this.mallPlatformPayTypeInterface.getEntityByPlatIdAndPayTypeSubId(platformId, payTypeSubId);
        this.logger.error("refundfile_is_here1:" + JsonUtils.toJson((Object)platformPayTypeEntity, (boolean)false));
        if (platformPayTypeEntity != null) {
            pe.setPayKey(platformPayTypeEntity.getPayKey());
            pe.setAppId(platformPayTypeEntity.getAppid());
            pe.setBody(platformPayTypeEntity.getBody());
            pe.setMchId(platformPayTypeEntity.getMchId());
            pe.setTradeType(platformPayTypeEntity.getTradeType());
            pe.setDomain(platformPayTypeEntity.getDomain());
            pe.setAppName(platformPayTypeEntity.getAppName());
            pe.setPublicKey(platformPayTypeEntity.getPublicKey());
            pe.setRequestDomain(platformPayTypeEntity.getRequestDomain());
            pe.setCharset(platformPayTypeEntity.getCharset());
            pe.setSignType(platformPayTypeEntity.getSignType());
            pe.setReturnUrl(platformPayTypeEntity.getReturnUrl());
            pe.setNotifyUrl(platformPayTypeEntity.getNotifyUrl());
            pe.setSellerEmail(platformPayTypeEntity.getSellerEmail());
            pe.setDataFormat(platformPayTypeEntity.getDataFormat());
            pe.setTimeOut(platformPayTypeEntity.getTimeout());
            pe.setRefundCertFile(platformPayTypeEntity.getRefundCertFile());
            pe.setOrderCancelTime(DateUtils.getAddDateBySecond((Date)pe.getOrderCreateTime(), (int)platformPayTypeEntity.getTimeout()));
        }
    }

    public BaseJsonVo paySearch(String orderMainNo) {
        PayInputEntity p;
        BaseJsonVo result = new BaseJsonVo();
        List<PayInputEntity> payInputEntities = this.getPayInputEntityList(orderMainNo, "");
        if (payInputEntities == null || payInputEntities.size() == 0) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        Iterator<PayInputEntity> iterator = payInputEntities.iterator();
        while (iterator.hasNext() && (result = this.payInterface.paySearch(p = iterator.next())).isSuccess()) {
        }
        return result;
    }

    public BaseJsonVo payClose(String userId, String tradeNo, String thirdTradeNo) {
        BaseJsonVo result = new BaseJsonVo();
        PayInputEntity payInputEntity = this.getPayInputEntity(tradeNo);
        if (payInputEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        if (!payInputEntity.isSuccess()) {
            result.setError("\u6ca1\u6709\u652f\u4ed8\u6210\u529f\u4e0d\u9700\u8981\u9000\u6b3e");
            return result;
        }
        return this.payInterface.payClose(payInputEntity);
    }

    @Override
    public BaseJsonVo payClose(String customerId, String orderMainNo) {
        PayInputEntity payInputEntity1;
        BaseJsonVo result = new BaseJsonVo();
        List<PayInputEntity> payInputEntities = this.getPayInputEntityList(orderMainNo, "");
        if (payInputEntities == null || payInputEntities.size() == 0) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        this.logger.info("--------payClose--------payInputEntities={}", (Object)JSON.toJSONString(payInputEntities));
        if (payInputEntities.stream().filter(c -> c.getCashType() == 1).collect(Collectors.toList()) != null && payInputEntities.stream().filter(c -> c.getCashType() == 1).collect(Collectors.toList()).size() > 0) {
            PayInputEntity payInputEntity = (PayInputEntity)payInputEntities.stream().filter(c -> c.getCashType() == 1).collect(Collectors.toList()).get(0);
            this.logger.info("--------payClose--------payInputEntity={}", (Object)JSON.toJSONString((Object)payInputEntity));
            List<MallOrderPayRecordEntity> mallOrderPayRecordEntityList = this.orderPayRecordInterface.queryOrderPayRecordInfo(payInputEntity.getOrderMainNo(), payInputEntity.getTradeNo());
            if (mallOrderPayRecordEntityList != null && mallOrderPayRecordEntityList.size() > 0) {
                for (MallOrderPayRecordEntity mallOrderPayRecordEntity : mallOrderPayRecordEntityList) {
                    Date notifyTime;
                    this.logger.info("=========cc.lechun.mall.service.pay.PayOrderService.payClose==========mallOrderPayRecordEntity={}", (Object)JSON.toJSONString((Object)mallOrderPayRecordEntity));
                    if (!mallOrderPayRecordEntity.getPaytypeId().equals(payInputEntity.getPayType()) || (notifyTime = mallOrderPayRecordEntity.getNotifyTime()) == null) continue;
                    this.logger.info("=========cc.lechun.mall.service.pay.PayOrderService.payClose==========notifyTime={}", (Object)notifyTime);
                    result.setError("\u6682\u65f6\u65e0\u6cd5\u53d6\u6d88");
                    return result;
                }
            }
            result = this.payInterface.payClose(payInputEntity);
            this.logger.info("=========cc.lechun.mall.service.pay.PayOrderService.payClose.result==========result={}", (Object)JSON.toJSONString((Object)result));
        }
        if (!result.isSuccess()) {
            return result;
        }
        payInputEntities = payInputEntities.stream().filter(c -> c.isSuccess() && c.getCashType() == 0).collect(Collectors.toList());
        Iterator<PayInputEntity> iterator = payInputEntities.iterator();
        while (iterator.hasNext() && (result = this.payInterface.payClose(payInputEntity1 = iterator.next())).isSuccess()) {
        }
        return result;
    }

    @Override
    @Transactional
    public BaseJsonVo payRefund(String orderNo, BigDecimal returnAmount, BigDecimal wechatAmount, BigDecimal alipayAmount, BigDecimal balanceAmount) {
        this.logger.info("++++++++++++payOrderService.payRefund params+++++++++orderNo={},returnAmount={},wechatAmount={},alipayAmount={},balanceAmount={}", new Object[]{orderNo, returnAmount, wechatAmount, alipayAmount, balanceAmount});
        MallOrderEntity order = this.mallOrderInterface.getmallOrder(orderNo);
        if (order == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        MallOrderMainEntity orderMain = this.mallOrderMainInterface.selectByPrimaryKey(order.getOrderMainNo());
        if (orderMain == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        List<PayInputEntity> payInputEntityList = this.getPayInputEntityList(order.getOrderMainNo(), "");
        if (payInputEntityList == null || payInputEntityList.size() == 0) {
            return BaseJsonVo.error((String)"\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        payInputEntityList.sort((f1, f2) -> String.valueOf(f1.getPayType()).compareTo(String.valueOf(f2.getPayType())));
        BigDecimal couponAmount = new BigDecimal("0");
        if (wechatAmount.compareTo(BigDecimal.ZERO) == 0 && alipayAmount.compareTo(BigDecimal.ZERO) == 0 && balanceAmount.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal surplusAmount = returnAmount;
            for (PayInputEntity payInputEntity : payInputEntityList) {
                if (payInputEntity.getPayType() == PayTypeEnum.WECHAT_PAY.getValue() && payInputEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                    if (payInputEntity.getPayAmount().compareTo(returnAmount) >= 0) {
                        wechatAmount = returnAmount;
                        continue;
                    }
                    wechatAmount = payInputEntity.getPayAmount();
                    surplusAmount = returnAmount.subtract(payInputEntity.getPayAmount());
                    continue;
                }
                if (payInputEntity.getPayType() == PayTypeEnum.BANK_PAY.getValue() && payInputEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                    if (payInputEntity.getPayAmount().compareTo(returnAmount) >= 0) {
                        wechatAmount = returnAmount;
                        continue;
                    }
                    wechatAmount = payInputEntity.getPayAmount();
                    surplusAmount = returnAmount.subtract(payInputEntity.getPayAmount());
                    continue;
                }
                if (payInputEntity.getPayType() == PayTypeEnum.ALIPAY_PAY.getValue() && payInputEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                    if (payInputEntity.getPayAmount().compareTo(returnAmount) >= 0) {
                        alipayAmount = returnAmount;
                        continue;
                    }
                    alipayAmount = payInputEntity.getPayAmount();
                    surplusAmount = returnAmount.subtract(payInputEntity.getPayAmount());
                    continue;
                }
                if (payInputEntity.getPayType() == PayTypeEnum.BALANCE_PAY.getValue()) {
                    if (payInputEntity.getPayAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (payInputEntity.getPayAmount().compareTo(surplusAmount) >= 0) {
                        balanceAmount = surplusAmount;
                        continue;
                    }
                    balanceAmount = payInputEntity.getPayAmount();
                    continue;
                }
                if (payInputEntity.getPayType() != PayTypeEnum.COUPON_PAY.getValue() || payInputEntity.getPayAmount().compareTo(BigDecimal.ZERO) <= 0 || payInputEntity.getPayAmount().compareTo(returnAmount) < 0) continue;
                couponAmount = payInputEntity.getPayAmount();
            }
            this.logger.info("++++++++++++payOrderService.payRefund for payInputEntityList\u540e\u7684\u503c+++++++++orderNo={}\uff0creturnAmount={},wechatAmount={},alipayAmount={},balanceAmount={}\uff0ccouponAmount={}", new Object[]{orderNo, returnAmount, wechatAmount, alipayAmount, balanceAmount, couponAmount});
        }
        MallRefundEntity refund = this.refundInterface.findOrCreateRefund(orderMain, order, payInputEntityList, 1);
        this.refundInterface.updateRefundAmount(refund.getRefundId(), wechatAmount, alipayAmount, balanceAmount, couponAmount);
        for (PayInputEntity payInputEntity : payInputEntityList) {
            if (payInputEntity.getPayType() == PayTypeEnum.WECHAT_PAY.getValue()) {
                this.payRefund(refund, orderNo, payInputEntity.getTradeNo(), refund.getRefundId(), payInputEntity.getPayAmount(), wechatAmount, orderMain.getCustomerId(), "", false);
                continue;
            }
            if (payInputEntity.getPayType() == PayTypeEnum.BANK_PAY.getValue()) {
                this.payRefund(refund, orderNo, payInputEntity.getTradeNo(), refund.getRefundId(), payInputEntity.getPayAmount(), wechatAmount, orderMain.getCustomerId(), "", false);
                continue;
            }
            if (payInputEntity.getPayType() == PayTypeEnum.ALIPAY_PAY.getValue()) {
                this.payRefund(refund, orderNo, payInputEntity.getTradeNo(), refund.getRefundId(), payInputEntity.getPayAmount(), alipayAmount, orderMain.getCustomerId(), "", false);
                continue;
            }
            if (payInputEntity.getPayType() == PayTypeEnum.BALANCE_PAY.getValue()) {
                this.payRefund(refund, orderNo, payInputEntity.getTradeNo(), refund.getRefundId(), payInputEntity.getPayAmount(), balanceAmount, orderMain.getCustomerId(), "", false);
                continue;
            }
            if (payInputEntity.getPayType() != PayTypeEnum.COUPON_PAY.getValue() || refund.getRefundOrderType() != 1 || refund.getOrderStatus() >= 9) continue;
            this.payRefund(refund, orderNo, payInputEntity.getTradeNo(), refund.getRefundId(), payInputEntity.getPayAmount(), new BigDecimal(0), orderMain.getCustomerId(), "", false);
        }
        this.memcachedService.delete("refund_orderMain_status", orderMain.getOrderMainNo());
        this.updateCustomerOrderNo(orderMain);
        return BaseJsonVo.success((Object)"");
    }

    private void updateCustomerOrderNo(MallOrderMainEntity orderMain) {
        if (orderMain.getOrderClass().intValue() == OrderClassEnum.MALL_ORDER.getValue() || orderMain.getOrderClass().intValue() == OrderClassEnum.GIFTCARD_ORDER.getValue()) {
            try {
                Integer num = this.mallOrderInterface.getUserOrderCountPaid(orderMain.getCustomerId());
                boolean newUser = num == null ? true : num <= 1;
                CustomerEntity customerEntity = new CustomerEntity();
                customerEntity.setCustomerId(orderMain.getCustomerId());
                customerEntity.setCurrentOrderCount(num);
                if (newUser) {
                    customerEntity.setIsNew(1);
                    if (num == 0) {
                        customerEntity.setFirstOrderTime(null);
                    }
                }
                this.customerInterface.updateCustomerEntitySelective(customerEntity);
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.userInfo, MessageParam.messageParam((String)"", (Object)customerEntity.getCustomerId()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public BaseJsonVo payRefund(MallRefundEntity refund, String orderNo, String tradeNo, String refundBillNo, BigDecimal payAmount, BigDecimal refundAmount, String customerId, String sign, boolean needSign) {
        MallOrderEntity order;
        String urlParams;
        String signnew;
        this.logger.info("----Start----PayOrderService.payRefund param MallRefundEntity:[{}] and orderNo:[{}] and tradeNo:[{}] and refundBillNo:[{}] and payAmount:[{}] and refundAmount:[{}] and customerId:[{}] and sign:[{}] and needSign:[{}]", new Object[]{JSON.toJSONString((Object)refund), orderNo, tradeNo, refundBillNo, payAmount, refundAmount, customerId, sign, needSign});
        BaseJsonVo result = new BaseJsonVo();
        if (needSign && !(signnew = InterfaceSign.getSign((String)(urlParams = "tradeNo=" + tradeNo + "&refundBillNo=" + refundBillNo + "&payAmount=" + payAmount + "&refundAmount=" + refundAmount + "&customerId=" + customerId))).equals(sign)) {
            this.logger.error("payRefund,\u7b7e\u540d\uff1a\u4f20\u5165\uff1a" + sign + ",\u8ba1\u7b97:" + signnew);
            result.setError("\u7b7e\u540d\u9519\u8bef");
            return result;
        }
        PayInputEntity payInputEntity = this.getPayInputEntity(tradeNo);
        if (payInputEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        MallRefundRecordEntity refundRecordEntity = null;
        MallRefundEntity refundEntity = null;
        if (payInputEntity.isSuccess()) {
            refundEntity = this.refundInterface.selectByPrimaryKey(refundBillNo);
            if (refundEntity == null) {
                result.setError("\u9000\u6b3e\u5355\u53f7\u4e0d\u6b63\u786e" + refundBillNo);
                return result;
            }
            if (!refundEntity.getOrderMainNo().equals(payInputEntity.getOrderMainNo())) {
                result.setError("\u9000\u6b3e\u5355\u4e0d\u6b63\u786e");
                return result;
            }
        } else {
            result.setError("\u8ba2\u5355\u4e0d\u80fd\u9000\u6b3e");
            return result;
        }
        refundRecordEntity = this.refundRecordInterface.selectEntity(refundBillNo, tradeNo);
        payInputEntity.setRefundAmount(refundAmount);
        payInputEntity.setPayAmount(payAmount);
        payInputEntity.setRefundBillNo(refundBillNo);
        payInputEntity.setCustomerId(customerId);
        if (StringUtils.isEmpty((String)orderNo)) {
            orderNo = refundEntity.getOrderNo();
        }
        if ((order = this.mallOrderInterface.getmallOrder(orderNo)) == null) {
            result.setError("\u8ba2\u5355\u4fe1\u606f\u6709\u8bef");
            return result;
        }
        MallOrderMainEntity orderMain = this.mallOrderMainInterface.selectByPrimaryKey(order.getOrderMainNo());
        if (this.memcachedService.get("refund_orderMain_status", orderMain.getOrderMainNo()) == null) {
            this.memcachedService.set("refund_orderMain_status", orderMain.getOrderMainNo(), (Object)orderMain.getStatus());
        }
        if (orderMain == null) {
            result.setError("\u4e3b\u8ba2\u5355\u4fe1\u606f\u6709\u8bef");
            return result;
        }
        if (orderMain.getDeliverCount() > 1) {
            payInputEntity.setOrderNo(orderNo);
            if (this.memcachedService.get("refund_orderMain_status", orderMain.getOrderMainNo()) != null && (Integer)this.memcachedService.get("refund_orderMain_status", orderMain.getOrderMainNo()) >= 9 && payInputEntity.getPayType() == 3) {
                return result;
            }
        }
        result = this.payInterface.payRefund(payInputEntity);
        this.logger.info("\u9000\u6b3e\u72b6\u6001:" + JsonUtils.toJson((Object)result, (boolean)true));
        if (result.isSuccess()) {
            if (refund != null && StringUtils.isNotEmpty((String)refund.getRefundId())) {
                refund.setStatus(3);
                refund.setOperaterTime(new Date());
                this.refundInterface.updateRefund(refund);
            }
            order.setStatus(OrderStatusEnum.REFUNDED.getValue());
            orderMain.setStatus(OrderStatusEnum.REFUNDED.getValue());
            this.mallOrderMainInterface.updateOrderMain(orderMain);
            this.mallOrderInterface.updateOrder(order);
            this.refundInterface.PassOrderRefund(refundBillNo, null, null);
            WechatRefundReturnEntity refundReturnEntity = (WechatRefundReturnEntity)result.getValue();
            if (refundReturnEntity != null) {
                this.logger.info("\u652f\u4ed8\u8fd4\u56de\uff1a" + JsonUtils.toJson((Object)refundReturnEntity, (boolean)true));
                if (refundRecordEntity != null) {
                    this.refundRecordInterface.deleteEntity(refundRecordEntity.getRefundRecordId());
                }
                refundRecordEntity = new MallRefundRecordEntity();
                refundRecordEntity.setRefundRecordId(String.valueOf(IDGenerate.getUniqueID()));
                refundRecordEntity.setTradeBillNo(tradeNo);
                refundRecordEntity.setRefundBillNo(refundBillNo);
                refundRecordEntity.setCreateTime(DateUtils.now());
                refundRecordEntity.setIssuccess(1);
                refundRecordEntity.setOrderAmount(PriceUtils.multiply((BigDecimal)payAmount, (Integer)100).longValue());
                refundRecordEntity.setReceiveData(JsonUtils.toJson((Object)refundReturnEntity, (boolean)false));
                refundRecordEntity.setRefundAmount(PriceUtils.multiply((BigDecimal)refundAmount, (Integer)100).longValue());
                refundRecordEntity.setWechatApplyAmount(PriceUtils.multiply((BigDecimal)new BigDecimal(refundReturnEntity.getRefundFee()), (Integer)100).longValue());
                refundRecordEntity.setWechatTradeId(refundReturnEntity.getThirdRefundId());
                this.refundRecordInterface.insertEntity(refundRecordEntity);
            }
            this.defineFiledHandleInterface.RefundAfter(orderMain.getOrderMainNo());
        } else {
            String refundStatus = "0";
            this.mallRefundPayDetailInterface.updateRefundPayDetailStatusByRefundId(refund.getRefundId(), payInputEntity.getPayType(), refundStatus);
        }
        return result;
    }

    @Override
    public BaseJsonVo refundPay() {
        Date nowDate;
        Date refundDate;
        List<MallRefundEntity> refundEntityList;
        this.logger.info("================cc.lechun.mall.service.pay.PayOrderService.refundPay start================");
        BaseJsonVo result = new BaseJsonVo();
        int status = 2;
        int refundTime = 5;
        List<DictionaryEntity> getValidDictionaryList = this.dictionaryInterface.getValidDictionaryList(1000, 201);
        if (getValidDictionaryList != null && getValidDictionaryList.size() > 0) {
            DictionaryEntity dictionaryEntity = getValidDictionaryList.get(0);
            refundTime = Integer.valueOf(dictionaryEntity.getDictionaryKey());
        }
        if ((refundEntityList = this.refundInterface.queryRefundInfoByStatusCheckTime(status, refundDate = DateUtils.getAddDateBySecond((Date)(nowDate = new Date()), (int)(-(refundTime * 60))))) != null && refundEntityList.size() > 0) {
            for (MallRefundEntity refundEntity : refundEntityList) {
                int refundStatus;
                List<MallRefundPayDetailEntity> mallRefundPayDetailEntityList;
                MallOrderMainEntity orderMainInfo = this.mallOrderMainInterface.selectByPrimaryKey(refundEntity.getOrderMainNo());
                if (orderMainInfo == null || (mallRefundPayDetailEntityList = this.mallRefundPayDetailInterface.queryRefundPayDetailListByRefundIdStatus(refundStatus = 0, refundEntity.getRefundId())) == null || mallRefundPayDetailEntityList.size() <= 0) continue;
                String refundNo = "";
                for (MallRefundPayDetailEntity refundPayDetailEntity : mallRefundPayDetailEntityList) {
                    PayInputEntity payInputEntity;
                    MallRefundFailRecordEntity refundFailRecordEntity = new MallRefundFailRecordEntity();
                    refundFailRecordEntity.setRefundPayId(refundPayDetailEntity.getRefundPayId());
                    List<MallRefundFailRecordEntity> mallRefundFailRecordEntityList = this.mallRefundFailRecordInterface.getRefundFailRecord(refundFailRecordEntity);
                    if (mallRefundFailRecordEntityList != null && mallRefundFailRecordEntityList.size() > 0 && (refundFailRecordEntity = mallRefundFailRecordEntityList.get(0)).getReqNum() == 5) continue;
                    if (refundPayDetailEntity.getCashType() == 1) {
                        BaseJsonVo baseJsonVo = this.orderRefundInterface.buildRefundRecord(refundPayDetailEntity.getRefundPayId());
                        if (!baseJsonVo.isSuccess()) continue;
                        refundNo = baseJsonVo.getValue().toString();
                    }
                    if ((payInputEntity = this.getPayInputEntity(refundPayDetailEntity.getTradeNo())) == null) continue;
                    payInputEntity.setRefundAmount(refundPayDetailEntity.getFactReturnAmount());
                    payInputEntity.setRefundBillNo(refundNo);
                    payInputEntity.setCustomerId(refundEntity.getCustomerId());
                    if (orderMainInfo.getOrderSource() < OrderSourceEnum.CARD_PREPAY_TMALL.getValue() || orderMainInfo.getOrderSource() > OrderSourceEnum.CARD_PREPAY_SHOP.getValue()) {
                        result = this.payInterface.payRefund(payInputEntity);
                        this.logger.info("++++++++++cc.lechun.mall.service.pay.PayOrderService.refundPay payRefund++++++++++payRefundResult={},OrderMainNo={}", (Object)JSON.toJSONString((Object)result), (Object)payInputEntity.getOrderMainNo());
                        if (!result.isSuccess()) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map = result.getValue() != null ? (Map)result.getValue() : map;
                            map.put("refundPayId", refundPayDetailEntity.getRefundPayId());
                            map.put("errorMessage", result.getError_msg());
                            this.mallRefundFailRecordInterface.saveRefundFailRecordInfo(payInputEntity, map);
                            continue;
                        }
                    }
                    if (refundPayDetailEntity.getCashType() == 1) {
                        WechatRefundReturnEntity refundReturnEntity = (WechatRefundReturnEntity)result.getValue();
                        if (refundReturnEntity == null) continue;
                        this.orderRefundInterface.returnUpdateRecord(refundNo, refundReturnEntity.getThirdRefundId(), PriceUtils.multiply((BigDecimal)refundPayDetailEntity.getFactReturnAmount(), (Integer)100).longValue(), JSON.toJSONString((Object)payInputEntity), JSON.toJSONString((Object)result));
                        if (!result.isSuccess()) continue;
                        this.orderRefundInterface.successOrderRefund(refundEntity.getRefundId(), refundPayDetailEntity.getPaytypeId(), refundNo);
                        if (OrderSourceEnum.CARD_PREPAY.getValue() == orderMainInfo.getOrderSource().intValue()) {
                            this.updateMilkRefund(orderMainInfo, refundEntity, refundPayDetailEntity);
                        }
                        this.defineFiledHandleInterface.RefundAfter(orderMainInfo.getOrderMainNo());
                        continue;
                    }
                    if (!result.isSuccess()) continue;
                    this.orderRefundInterface.successOrderRefund(refundEntity.getRefundId(), refundPayDetailEntity.getPaytypeId(), null);
                    this.defineFiledHandleInterface.RefundAfter(orderMainInfo.getOrderMainNo());
                }
            }
        }
        return result;
    }

    public BaseJsonVo updateMilkRefund(MallOrderMainEntity orderMainInfo, MallRefundEntity refundEntity, MallRefundPayDetailEntity refundPayDetailEntity) {
        this.logger.info("=======+++++++++++updateMilkRefund={},orderMainInfo={}", (Object)JSON.toJSONString((Object)refundEntity), (Object)JSON.toJSONString((Object)orderMainInfo));
        BaseJsonVo updateMilkRefundJson = new BaseJsonVo();
        String otherTkOrderNo = refundEntity.getOrderMainNo();
        int orderSource = 27;
        if (!orderMainInfo.getOrderMainNo().equals(refundEntity.getOtherTkOrderNo())) {
            otherTkOrderNo = refundEntity.getOtherTkOrderNo();
            orderSource = 26;
        }
        this.logger.info("=======+++++++++++orderSource={}", (Object)orderSource);
        if (OrderSourceEnum.CARD_PREPAY.getValue() == orderSource) {
            String orderMainNo = refundEntity.getOrderMainNo();
            MallRefundEntity cardRefundEntity = new MallRefundEntity();
            cardRefundEntity.setOrderMainNo(orderMainNo);
            cardRefundEntity = this.refundInterface.getReturnAmountTotalByInfo(cardRefundEntity);
            List<MallOrderPayEntity> cardOrderPayList = this.mallOrderPayInterface.getList(orderMainNo);
            MallOrderPayEntity cardOrderPayEntity = cardOrderPayList.get(0);
            this.logger.info("===============updateMilkRefund=======cardRefundEntity={}\uff0ccardOrderPayEntity={}", (Object)JSON.toJSONString((Object)cardRefundEntity), (Object)JSON.toJSONString((Object)cardOrderPayEntity));
            if (cardRefundEntity != null && cardRefundEntity.getFactReturnAmount().compareTo(cardOrderPayEntity.getPayamount()) == 0) {
                MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
                MallOrderEntity mallOrderEntity = this.mallOrderInterface.getOrderList(orderMainNo).get(0);
                this.orderRefundInterface.updateOrderStatusRefund(orderMainNo, mallOrderEntity.getOrderNo(), OrderStatusEnum.REFUNDED.getName(), mallOrderMainEntity.getCustomerId());
            }
        }
        if (OrderSourceEnum.CARDPLAN.getValue() == orderSource) {
            if (refundEntity.getRefundOrderType() == 1) {
                this.logger.info("=======+++++++++++refundEntity.getRefundOrderType().intValue() ");
                MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(otherTkOrderNo);
                MallOrderEntity mallOrderEntity = this.mallOrderInterface.getOrderList(otherTkOrderNo).get(0);
                this.orderRefundInterface.updateOrderStatusRefund(otherTkOrderNo, mallOrderEntity.getOrderNo(), OrderStatusEnum.REFUNDED.getName(), mallOrderMainEntity.getCustomerId());
            }
            MallRefundEntity goodRefundEntity = new MallRefundEntity();
            goodRefundEntity.setOrderMainNo(refundEntity.getOrderMainNo());
            goodRefundEntity.setStatus(3);
            goodRefundEntity = this.refundInterface.getReturnAmountTotalByInfo(goodRefundEntity);
            List<MallOrderPayEntity> mallOrderPayList = this.mallOrderPayInterface.getList(refundEntity.getOrderMainNo());
            MallOrderPayEntity mallOrderPayEntity = mallOrderPayList.get(0);
            this.logger.info("==============updateMilkRefund=========mallOrderPayEntity={},goodRefundEntity={},factReturnAmountCompareToPayamount={}", new Object[]{JSON.toJSONString((Object)mallOrderPayEntity), JSON.toJSONString((Object)goodRefundEntity), goodRefundEntity.getFactReturnAmount().compareTo(mallOrderPayEntity.getPayamount())});
            if (goodRefundEntity != null && goodRefundEntity.getFactReturnAmount().compareTo(mallOrderPayEntity.getPayamount()) == 0) {
                MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(refundEntity.getOrderMainNo());
                MallOrderEntity mallOrderEntity = this.mallOrderInterface.getOrderList(refundEntity.getOrderMainNo()).get(0);
                this.orderRefundInterface.updateOrderStatusRefund(refundEntity.getOrderMainNo(), mallOrderEntity.getOrderNo(), OrderStatusEnum.REFUNDED.getName(), mallOrderMainEntity.getCustomerId());
            }
        }
        return updateMilkRefundJson;
    }

    @Override
    public BaseJsonVo mikeRefund(MallOrderMainEntity orderMainInfo, MallRefundEntity refundEntity, MallRefundPayDetailEntity refundPayDetailEntity) {
        BaseJsonVo refundPrePayJson = new BaseJsonVo();
        String otherTkOrderNo = refundEntity.getOrderMainNo();
        int orderSource = 27;
        if (orderMainInfo.getOrderSource() < OrderSourceEnum.CARD_PREPAY_TMALL.getValue() || orderMainInfo.getOrderSource() > OrderSourceEnum.CARD_PREPAY_SHOP.getValue()) {
            if (!orderMainInfo.getOrderMainNo().equals(refundEntity.getOtherTkOrderNo())) {
                otherTkOrderNo = refundEntity.getOtherTkOrderNo();
                orderSource = 26;
            }
        } else {
            orderSource = orderMainInfo.getOrderSource();
        }
        this.logger.info("=========\u8bf7\u6c42refundOrderPlan\u7684\u5165\u53c2=====OrderMainNo={},OrderSource={},Remark={},FactReturnAmount={},OperaterId={}", new Object[]{otherTkOrderNo, orderSource, refundEntity.getRemark(), refundPayDetailEntity.getFactReturnAmount(), refundEntity.getOperaterId()});
        this.logger.info("===========refundPrePayJson==========refundPrePayJson={}", (Object)JSON.toJSONString((Object)refundPrePayJson));
        return refundPrePayJson;
    }
}

