/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardBatchMapper;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrepayCardBatchService
extends BaseService<PrepayCardBatchEntity, Integer>
implements PrepayCardBatchInterface {
    @Resource
    PrepayCardBatchMapper prepayCardBatchMapper;
    @Autowired
    PrepayCardInterface prepayCardInterface;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private ActiveInterface activeInterface;

    @Override
    public PageInfo cardBatchesByPage(PageForm pageForm, PrepayCardBatchEntity cardBatchEntity) {
        String batchName = null;
        Integer batchType = null;
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        if (cardBatchEntity != null) {
            if (StringUtils.isNotEmpty((String)cardBatchEntity.getBatchName())) {
                batchName = cardBatchEntity.getBatchName();
            }
            if (cardBatchEntity.getBatchType() != null) {
                batchType = cardBatchEntity.getBatchType();
            }
        }
        if (batchType != null) {
            this.prepayCardBatchMapper.getNumCardList(batchName);
        } else {
            this.prepayCardBatchMapper.getPageList(batchName, batchType);
        }
        this.logger.info("batchName={},batchType={}", (Object)batchName, (Object)batchType);
        return page.toPageInfo();
    }

    @Override
    @Transactional
    public BaseJsonVo addBatch(PrepayCardBatchEntity batchEntity) {
        this.logger.info("addBatch-3");
        if (StringUtils.isNotEmpty((String)batchEntity.getBindCode())) {
            MallPromotionEntity promotionEntity;
            PrepayCardBatchEntity entity = new PrepayCardBatchEntity();
            entity.setBindCode(batchEntity.getBindCode());
            entity = (PrepayCardBatchEntity)this.prepayCardBatchMapper.getSingle(entity);
            if (entity != null && !entity.getBatchId().equals(batchEntity.getBatchId())) {
                return BaseJsonVo.error((String)"\u4e00\u4e2a\u6d3b\u52a8\u53ea\u80fd\u7ed1\u5b9a\u5230\u4e00\u4e2a\u6279\u6b21\uff0c\u8bf7\u91cd\u65b0\u5efa\u7acb\u6d3b\u52a8\u7ed1\u5b9a");
            }
            ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(batchEntity.getBindCode());
            if (activeEntity != null && (promotionEntity = this.promotionInterface.getMallPromotionEntityByActiveNo(activeEntity.getActiveNo())) != null) {
                batchEntity.setCardPromotionId(promotionEntity.getPromotionId());
            }
        }
        this.logger.info("addBatch-4");
        if (batchEntity.getBatchType() == 2) {
            BigDecimal rate = batchEntity.getSaleValue().divide(batchEntity.getCardPrice()).setScale(6, RoundingMode.HALF_UP);
            if (batchEntity.getRate().compareTo(rate) != 0) {
                batchEntity.setRate(rate);
            }
        }
        this.logger.info("addBatch-5");
        if (batchEntity.getBatchId() == null || batchEntity.getBatchId() == 0) {
            this.logger.info("addBatch-6");
            int rtn = this.prepayCardBatchMapper.insert(batchEntity);
            System.out.println(rtn);
        } else {
            MallPromotionEntity promotionEntity;
            ActiveEntity activeEntity;
            this.logger.info("addBatch-7");
            if (StringUtils.isNotEmpty((String)batchEntity.getCardPromotionId()) && batchEntity.getOrderSource() == 26 && (activeEntity = this.activeInterface.getActiveEntityByQrcode(batchEntity.getBindCode())) != null && (promotionEntity = this.promotionInterface.getMallPromotionEntityByActiveNo(activeEntity.getActiveNo())) != null) {
                batchEntity.setCardPromotionId(promotionEntity.getPromotionId());
            }
            this.prepayCardBatchMapper.updateByPrimaryKey(batchEntity);
        }
        this.logger.info("addBatch-8");
        if (batchEntity.getTotalCount() > 0) {
            Date createTime = DateUtils.now();
            ArrayList<PrepayCardEntity> list = new ArrayList<PrepayCardEntity>();
            List<String> pwds = this.prepayCardInterface.getPwds();
            pwds.forEach(pwd -> this.redisService.sadd("PREPAY_CARD_KEY", pwd));
            this.redisService.setExpire("PREPAY_CARD_KEY", 2L, TimeUnit.MINUTES);
            for (int i = 0; i < batchEntity.getTotalCount(); ++i) {
                PrepayCardEntity entity = new PrepayCardEntity();
                entity.setCardId(IDGenerate.getUniqueIdStr().toUpperCase());
                entity.setCardPassword(this.getPassword(12));
                entity.setBuyerCustomerId("");
                entity.setBelongCustomerId(entity.getBuyerCustomerId());
                entity.setBatchId(batchEntity.getBatchId());
                entity.setOrderMainNo("");
                entity.setTotalCount(batchEntity.getDeliverCount());
                entity.setRemainCount(entity.getTotalCount());
                entity.setStatus(0);
                entity.setOrderSource(batchEntity.getOrderSource());
                entity.setCreateTime(createTime);
                entity.setRelateCardNo("");
                entity.setBatchType(batchEntity.getBatchType());
                entity.setCardType(batchEntity.getCardType());
                entity.setBindCode(batchEntity.getBindCode());
                entity.setCardPrice(batchEntity.getCardPrice());
                entity.setSaleValue(batchEntity.getSaleValue());
                entity.setRate(batchEntity.getRate());
                list.add(entity);
            }
            this.prepayCardInterface.batchInsert(list);
            this.logger.info("addBatch-9");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo addBatchCards(Integer batchId, Integer addCount) {
        PrepayCardBatchEntity batchEntity = (PrepayCardBatchEntity)this.prepayCardBatchMapper.selectByPrimaryKey(batchId);
        List<String> pwds = this.prepayCardInterface.getPwds();
        pwds.forEach(pwd -> this.redisService.sadd("PREPAY_CARD_KEY", pwd));
        ArrayList<PrepayCardEntity> list = new ArrayList<PrepayCardEntity>();
        for (int i = 0; i < addCount; ++i) {
            PrepayCardEntity entity = new PrepayCardEntity();
            entity.setCardId(IDGenerate.getUniqueIdStr().toUpperCase());
            entity.setCardPassword(this.getPassword(12));
            entity.setBuyerCustomerId("");
            entity.setBelongCustomerId(entity.getBuyerCustomerId());
            entity.setBatchId(batchId);
            entity.setOrderMainNo("");
            entity.setTotalCount(batchEntity.getDeliverCount());
            entity.setRemainCount(entity.getTotalCount());
            entity.setStatus(0);
            entity.setOrderSource(batchEntity.getOrderSource());
            entity.setCreateTime(DateUtils.now());
            entity.setRelateCardNo("");
            entity.setBatchType(batchEntity.getBatchType());
            entity.setCardType(batchEntity.getCardType());
            entity.setBindCode(batchEntity.getBindCode());
            entity.setCardPrice(batchEntity.getCardPrice());
            entity.setSaleValue(batchEntity.getSaleValue());
            entity.setRate(batchEntity.getRate());
            list.add(entity);
        }
        this.prepayCardInterface.batchInsert(list);
        batchEntity.setTotalCount(batchEntity.getTotalCount() + addCount);
        this.prepayCardBatchMapper.updateByPrimaryKey(batchEntity);
        return BaseJsonVo.success((Object)"\u6210\u529f");
    }

    private String getPassword(int length) {
        String pwd = RandomUtils.generateUpperStringWithNum((int)length);
        if (this.redisService.sIsMember("PREPAY_CARD_KEY", pwd)) {
            return this.getPassword(length);
        }
        this.redisService.sadd("PREPAY_CARD_KEY", pwd);
        this.redisService.setExpire("PREPAY_CARD_KEY", 2L, TimeUnit.MINUTES);
        return pwd;
    }

    @Override
    public BaseJsonVo delBatch(Integer batchId) {
        return this.prepayCardBatchMapper.deleteByPrimaryKey(batchId) == 0 ? BaseJsonVo.error(null) : BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public Boolean promotionIsUsed(String promotionId) {
        PrepayCardBatchEntity param1 = new PrepayCardBatchEntity();
        param1.setProductPromotionId(promotionId);
        List list1 = this.prepayCardBatchMapper.getList(param1);
        PrepayCardBatchEntity param2 = new PrepayCardBatchEntity();
        param2.setCardPromotionId(promotionId);
        List list2 = this.prepayCardBatchMapper.getList(param2);
        return list1 != null && list1.size() > 0 || list2 != null && list2.size() > 0;
    }

    @Override
    public PrepayCardBatchEntity getRecommendCardBatch(String orderMainNo) {
        if (StringUtils.isEmpty((String)orderMainNo)) {
            return new PrepayCardBatchEntity();
        }
        return this.prepayCardBatchMapper.getRecommendCardBatch(orderMainNo);
    }

    @Override
    public List<Map<String, String>> getCardBatchHaveFree(String customerId) {
        return this.prepayCardBatchMapper.getCardBatchHaveFree(customerId);
    }

    @Override
    public List<PrepayCardBatchEntity> getCardBatchIdList(Integer cardType, String itemId, Integer itemType) {
        return this.prepayCardBatchMapper.getCardBatchIdList(cardType, itemId, itemType);
    }
}

