/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardFreeMapper;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeProductEntity;
import cc.lechun.mall.entity.vip.MallVipConditionEntity;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardFreeInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.vip.MallVipConditionInterface;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardFreeService
extends BaseService<PrepayCardFreeEntity, Integer>
implements PrepayCardFreeInterface {
    @Resource
    private PrepayCardFreeMapper prepayCardFreeMapper;
    @Autowired
    private MallFreeInterface freeInterface;
    @Autowired
    private PrepayCardBatchInterface cardBatchInterface;
    @Autowired
    private PrepayCardInterface prepayCardInterface;
    @Autowired
    private MallVipConditionInterface vipConditionInterface;

    @Override
    public List<Map<String, Object>> getCardFreeList(Integer batchId, Integer source) {
        PrepayCardFreeEntity prepayCardFreeEntity = new PrepayCardFreeEntity();
        if (batchId == null) {
            return new ArrayList<Map<String, Object>>();
        }
        if (source == null) {
            return new ArrayList<Map<String, Object>>();
        }
        prepayCardFreeEntity.setBatchId(batchId);
        prepayCardFreeEntity.setSource(source);
        prepayCardFreeEntity.setStatus(1);
        List lst = this.getList(prepayCardFreeEntity, 0L);
        LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
        for (PrepayCardFreeEntity cardFree : lst) {
            MallFreeEntity free;
            Map map = ObjectConvert.objectConvertToObjectMap((Object)cardFree);
            String freeName = "";
            if (StringUtil.isNotEmpty((String)cardFree.getFreeId()) && (free = this.freeInterface.getFree(cardFree.getFreeId())) != null) {
                freeName = free.getFreeName();
            }
            map.put("freeName", freeName);
            String freeTypeName = "";
            if (Integer.valueOf(1).equals(cardFree.getFreeType())) {
                freeTypeName = "\u5fc5\u8d60";
            }
            if (Integer.valueOf(2).equals(cardFree.getFreeType())) {
                freeTypeName = "\u9009\u8d60";
            }
            map.put("freeTypeName", freeTypeName);
            String freeProductTypeName = "";
            if (Integer.valueOf(1).equals(cardFree.getFreeProductType())) {
                freeProductTypeName = "\u51b7\u94fe";
            }
            if (Integer.valueOf(2).equals(cardFree.getFreeProductType())) {
                freeProductTypeName = "\u5e38\u6e29";
            }
            if (Integer.valueOf(3).equals(cardFree.getFreeProductType())) {
                freeProductTypeName = "\u4e2d\u6027";
            }
            map.put("freeProductTypeName", freeProductTypeName);
            String freeMethodName = "";
            if (Integer.valueOf(1).equals(cardFree.getFreeMethod())) {
                freeMethodName = "\u968f\u5361\u5355\u9001";
            }
            if (Integer.valueOf(2).equals(cardFree.getFreeMethod())) {
                freeMethodName = "\u52a0\u8d60\u54c1\u6c60";
            }
            map.put("freeMethodName", freeMethodName);
            String statusName = "";
            statusName = Integer.valueOf(1).equals(cardFree.getStatus()) ? "\u6709\u6548" : "\u65e0\u6548";
            map.put("statusName", statusName);
            results.add(map);
        }
        return results;
    }

    @Override
    public PrepayCardFreeEntity getCardFree(Integer cardFreeId) {
        if (cardFreeId == null) {
            return null;
        }
        return (PrepayCardFreeEntity)this.selectByPrimaryKey(cardFreeId, 0L);
    }

    @Override
    public BaseJsonVo saveCardFree(PrepayCardFreeEntity cardFreeEntity) {
        if (cardFreeEntity == null) {
            return BaseJsonVo.error((String)"\u5361\u8d60\u54c1\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (cardFreeEntity.getSource() == null) {
            return BaseJsonVo.error((String)"\u6765\u6e90\u4e3a\u7a7a");
        }
        if (cardFreeEntity.getSource() == 1) {
            if (cardFreeEntity.getBatchId() == null) {
                return BaseJsonVo.error((String)"\u5361\u6279\u6b21Id\u4e3a\u7a7a");
            }
            PrepayCardBatchEntity cardBatchEntity = (PrepayCardBatchEntity)this.cardBatchInterface.selectByPrimaryKey(cardFreeEntity.getBatchId());
            if (cardBatchEntity == null) {
                return BaseJsonVo.error((String)"\u5361\u6279\u6b21\u4e0d\u5b58\u5728");
            }
            if (Integer.valueOf(5).equals(cardBatchEntity.getCardType()) && Integer.valueOf(1).equals(cardFreeEntity.getFreeProductType())) {
                return BaseJsonVo.error((String)"\u5e38\u6e29\u5361\u4e0d\u652f\u6301\u9009\u62e9\u51b7\u94fe\u8d60\u54c1");
            }
            if (Integer.valueOf(1).equals(cardFreeEntity.getFreeMethod()) && Integer.valueOf(1).equals(cardFreeEntity.getFreeType())) {
                return BaseJsonVo.error((String)"\u968f\u5361\u5355\u5fc5\u8d60\u8d60\u54c1\u8bf7\u5728erp\u8bbe\u7f6e\uff0c\u672c\u7cfb\u7edf\u4e0d\u652f\u6301");
            }
        }
        if (cardFreeEntity.getSource() == 2) {
            if (cardFreeEntity.getBatchId() == null) {
                return BaseJsonVo.error((String)"\u4f1a\u5458\u7b49\u7ea7\u4e3a\u7a7a");
            }
            MallVipConditionEntity vipConditionEntity = this.vipConditionInterface.getVipConditionByLevel(cardFreeEntity.getBatchId());
            if (vipConditionEntity == null) {
                return BaseJsonVo.error((String)"\u4f1a\u5458\u7b49\u7ea7\u4e0d\u5b58\u5728");
            }
            if (Integer.valueOf(1).equals(cardFreeEntity.getFreeMethod())) {
                return BaseJsonVo.error((String)"\u7cfb\u7edf\u4e0d\u652f\u6301\u4f1a\u5458\u968f\u5361\u5355\u4e00\u8d77\u914d\u9001");
            }
        }
        if (StringUtil.isEmpty((String)cardFreeEntity.getFreeId())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u8d60\u54c1");
        }
        if (cardFreeEntity.getFreeType() == null) {
            return BaseJsonVo.error((String)"\u8d60\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (cardFreeEntity.getFreeProductType() == null) {
            return BaseJsonVo.error((String)"\u8d60\u54c1\u914d\u9001\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (cardFreeEntity.getFreeMethod() == null) {
            return BaseJsonVo.error((String)"\u8d60\u54c1\u8d60\u9001\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (cardFreeEntity.getCright() == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u8d60\u54c1\u6743\u9650");
        }
        if (cardFreeEntity.getFreeQuantity() == null) {
            return BaseJsonVo.error((String)"\u8d60\u54c1\u8d60\u9001\u6570\u91cf\u4e3a\u7a7a");
        }
        int i = this.prepayCardFreeMapper.insertOrUpdate(cardFreeEntity);
        this.remoteCache(cardFreeEntity);
        if (i == 0) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo deletePrepayCardFree(Integer cardFreeId) {
        if (cardFreeId == null) {
            return BaseJsonVo.error((String)"\u6279\u6b21\u8d60\u54c1Id");
        }
        PrepayCardFreeEntity updateEntity = new PrepayCardFreeEntity();
        updateEntity.setStatus(0);
        updateEntity.setId(cardFreeId);
        int i = this.updateByPrimaryKeySelective(updateEntity);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public List<Map<String, Object>> getCardFreeProduct(String cardId) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)cardId));
        if (prepayCardEntity == null) {
            return new ArrayList<Map<String, Object>>();
        }
        PrepayCardFreeEntity prepayCardFreeEntity = new PrepayCardFreeEntity();
        prepayCardFreeEntity.setBatchId(prepayCardEntity.getBatchId());
        prepayCardFreeEntity.setSource(1);
        prepayCardFreeEntity.setStatus(1);
        List lst = this.getList(prepayCardFreeEntity);
        lst = lst.stream().filter(c -> Integer.valueOf(1).equals(c.getCright()) || Integer.valueOf(3).equals(c.getCright())).collect(Collectors.toList());
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (PrepayCardFreeEntity freeEntity : lst) {
            if (!StringUtil.isNotEmpty((String)freeEntity.getFreeId())) continue;
            List<MallFreeProductEntity> frees = this.freeInterface.getMallFreeProduct(freeEntity.getFreeId());
            for (MallFreeProductEntity freeProductEntity : frees) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("id", prepayCardEntity.getBatchId() + "_" + freeEntity.getFreeId() + "_" + freeProductEntity.getProductId());
                map.put("batchId", prepayCardEntity.getBatchId());
                map.put("cardId", prepayCardEntity.getCardId());
                map.put("source", 1);
                map.put("quantity", freeEntity.getFreeQuantity());
                map.put("freeType", freeEntity.getFreeType());
                map.put("freeMethod", freeEntity.getFreeMethod());
                map.put("freeId", freeEntity.getFreeId());
                map.put("productId", freeProductEntity.getProductId());
                map.put("productName", freeProductEntity.getProductName());
                map.put("productType", freeProductEntity.getProductType());
                results.add(map);
            }
        }
        return results;
    }
}

