/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardItemMapper;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardItemEntity;
import cc.lechun.mall.entity.prepay.PrepayCardItemVO;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardItemService
extends BaseService<PrepayCardItemEntity, Integer>
implements PrepayCardItemInterface {
    @Resource
    private PrepayCardItemMapper prepayCardItemMapper;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    RedissonClient redissonClient;

    @Override
    public List<PrepayCardItemVO> getCardItemList(Integer cardType, Integer cardBatchId) {
        Integer batchType = null;
        if (cardBatchId != null) {
            PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(cardBatchId);
            batchType = prepayCardBatchEntity.getBatchType();
        } else {
            batchType = 2;
        }
        return this.prepayCardItemMapper.getPrepayCardItemVo(cardType, batchType, cardBatchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo saveCardItem(PrepayCardItemEntity entity, String user) {
        this.removeCache();
        if (Objects.equals(entity.getCardType(), 3)) {
            entity.setBatchType(2);
        }
        if (entity.getCardBatchId() != null) {
            PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(entity.getCardBatchId());
            entity.setBatchType(prepayCardBatchEntity.getBatchType());
        }
        RLock lock = this.redissonClient.getLock("cardItem:" + entity.getCardBatchId() + ":" + entity.getCardProductId() + ":" + entity.getCardType());
        try {
            PrepayCardItemEntity query = new PrepayCardItemEntity();
            query.setItemId(entity.getItemId());
            query.setItemType(entity.getItemType());
            query.setBatchType(entity.getBatchType());
            if (entity.getCardBatchId() != null) {
                query.setCardBatchId(entity.getCardBatchId());
            }
            PrepayCardItemEntity prepayCardItemEntity = (PrepayCardItemEntity)this.prepayCardItemMapper.getSingle(query);
            this.logger.info("\u4fdd\u5b58\u5976\u5361\u5546\u54c1:{}", (Object)entity.toString());
            entity.setRate(PriceUtils.divide((BigDecimal)entity.getSaleValue(), (BigDecimal)entity.getUnitPrice(), (int)6, (Integer)4));
            Integer i = 0;
            if (entity.getCardProductId() != null || prepayCardItemEntity != null) {
                if (prepayCardItemEntity != null && entity.getCardProductId() == null) {
                    entity.setCardProductId(prepayCardItemEntity.getCardProductId());
                }
                entity.setUpdateTime(new Date());
                entity.setUpdateUser(user);
                i = this.prepayCardItemMapper.updateByPrimaryKeySelective(entity);
                this.logger.info("\u5546\u54c1\u4fdd\u5b58:{}", (Object)(i > 0 ? 1 : 0));
            } else {
                entity.setCreateTime(new Date());
                entity.setCreateUser(user);
                i = this.prepayCardItemMapper.insertSelective(entity);
                this.logger.info("\u5546\u54c1\u4fdd\u5b58:{}", (Object)(i > 0 ? 1 : 0));
            }
            BaseJsonVo baseJsonVo = i > 0 ? BaseJsonVo.success((Object)"success") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
            return baseJsonVo;
        }
        catch (Exception ex) {
            this.logger.error("\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u653e\u5f03\u6267\u884c...", (Throwable)ex);
        }
        finally {
            lock.unlock();
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    private void removeCache() {
        this.memcachedService.delete("PrepayCardItemService.getCardItemEntityList");
    }

    @Override
    public BaseJsonVo copyCardItem(Integer sourceBatchId, Integer objBatchId, String userName) {
        if (sourceBatchId == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6e90\u6279\u6b21");
        }
        if (objBatchId == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u6279\u6b21");
        }
        PrepayCardBatchEntity source = new PrepayCardBatchEntity();
        PrepayCardBatchEntity obj = new PrepayCardBatchEntity();
        source = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(sourceBatchId);
        obj = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(objBatchId);
        if (source == null || obj == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u539f\u6279\u6b21\u6216\u76ee\u6807\u6279\u6b21\u4e0d\u5b58\u5728");
        }
        if (!Integer.valueOf(4).equals(source.getCardType()) && !Integer.valueOf(5).equals(source.getCardType())) {
            return BaseJsonVo.error((String)"\u6279\u6b21\u7c7b\u578b\u4e3a\u65b0\u5976\u5361\u624d\u53ef\u4ee5\u590d\u5236");
        }
        if (!source.getCardType().equals(obj.getCardType())) {
            return BaseJsonVo.error((String)"\u76f8\u540c\u6279\u6b21\u7c7b\u578b\u624d\u53ef\u4ee5\u590d\u5236");
        }
        this.removeCache();
        PrepayCardItemEntity item1 = new PrepayCardItemEntity();
        item1.setCardBatchId(sourceBatchId);
        List lst = this.getList(item1);
        PrepayCardItemEntity item2 = new PrepayCardItemEntity();
        item2.setCardBatchId(objBatchId);
        List lst2 = this.getList(item2);
        for (PrepayCardItemEntity item : lst2) {
            this.deleteByPrimaryKey(item.getCardProductId());
        }
        for (PrepayCardItemEntity item : lst) {
            item.setCardProductId(null);
            item.setCardBatchId(objBatchId);
            item.setCreateUser(userName + "(copy)");
            item.setCreateTime(new Date());
            item.setUpdateTime(new Date());
            item.setUpdateUser(userName);
            this.insertSelective(item);
        }
        return BaseJsonVo.success((Object)"\u590d\u5236\u6210\u529f");
    }
}

