/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.apiinvoke.mall.PrepayCardPlanInvoke;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardMapper;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardExportVO;
import cc.lechun.mall.entity.prepay.PrepayCardStatusEnum;
import cc.lechun.mall.entity.prepay.PrepayCardVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributorQiyeweixinExternalContactInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardService
extends BaseService<PrepayCardEntity, String>
implements PrepayCardInterface {
    @Resource
    PrepayCardMapper prepayCardMapper;
    @Autowired
    private PrepayCardPlanInvoke prepayCardPlanInvoke;
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    private DistributorQiyeweixinExternalContactInterface externalContactInterface;
    @Autowired
    private CustomerInterface customerInterface;

    @Override
    public int getHasCardNum(String customerId) {
        return this.prepayCardMapper.getHasCardNum(customerId);
    }

    @Override
    public BaseJsonVo setCardExpireTime(PrepayCardVo prepayCardVo) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardMapper.selectByPrimaryKey((Serializable)((Object)prepayCardVo.getCardId()));
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5361");
        }
        if (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.NOEFFECT.getValue() && prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.FINISH.getValue()) {
            return BaseJsonVo.error((String)("\u5f53\u524d\u5361" + PrepayCardStatusEnum.getName(prepayCardEntity.getStatus()) + "\u4e0d\u80fd\u5ef6\u671f"));
        }
        if (prepayCardEntity.getEndTime().after(DateUtils.now())) {
            return BaseJsonVo.error((String)("\u5f53\u524d\u5361\u8fc7\u671f\u65f6\u95f4:" + prepayCardEntity.getEndTime() + "\u65e0\u987b\u5ef6\u671f"));
        }
        PrepayCardEntity update = new PrepayCardEntity();
        update.setCardId(prepayCardVo.getCardId());
        update.setEndTime(prepayCardVo.getEndTime());
        return this.prepayCardMapper.updateByPrimaryKeySelective(update) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
    }

    @Override
    public Boolean batchIsUsed(Integer batchId) {
        PrepayCardEntity param = new PrepayCardEntity();
        param.setBatchId(batchId);
        List list = this.prepayCardMapper.getList(param);
        return list != null && list.size() != 0;
    }

    @Override
    public List<String> getPwds() {
        return this.prepayCardMapper.getPwds();
    }

    @Override
    public PageInfo<PrepayCardExportVO> getViewList(PrepayCardEntity card, PageForm pageForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.prepayCardMapper.getViewList(card);
        PageInfo pg = page.toPageInfo();
        ArrayList vos = new ArrayList();
        pg.getList().forEach(map -> {
            PrepayCardExportVO vo = new PrepayCardExportVO();
            vo.setCardId(((Map)map).get("CARD_ID").toString());
            vo.setCardPassword(((Map)map).get("CARD_PASSWORD").toString());
            if ((Integer)((Map)map).get("STATUS_NAME") == 0) {
                vo.setCreateTime("");
            } else {
                vo.setCreateTime(DateUtils.formatDate((Date)((Date)((Map)map).get("CREATE_TIME")), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            switch ((Integer)((Map)map).get("STATUS_NAME")) {
                case 0: {
                    vo.setStatusName("\u672a\u9886\u53d6");
                    break;
                }
                case 1: {
                    vo.setStatusName("\u5df2\u9886\u53d6");
                    break;
                }
                case 2: {
                    vo.setStatusName("\u5df2\u6fc0\u6d3b");
                    break;
                }
                case 3: {
                    vo.setStatusName("\u6682\u505c");
                    break;
                }
                case 4: {
                    vo.setStatusName("\u914d\u9001\u4e2d");
                    break;
                }
                case 5: {
                    vo.setStatusName("\u7981\u7528/\u9000\u6b3e");
                    break;
                }
                case 6: {
                    vo.setStatusName("\u5df2\u5b8c\u6210");
                    break;
                }
                default: {
                    vo.setStatusName("\u672a\u77e5\u72b6\u6001");
                }
            }
            vo.setUsedCount(String.valueOf((Integer)((Map)map).get("TOTAL_COUNT") - (Integer)((Map)map).get("REMAIN_COUNT")));
            vo.setNickName(((Map)map).get("NICK_NAME") == null ? null : ((Map)map).get("NICK_NAME").toString());
            vos.add(vo);
        });
        pg.setList(vos);
        return pg;
    }

    @Override
    public List<PrepayCardExportVO> getViewList(PrepayCardEntity card) {
        List<Map<String, Object>> viewList = this.prepayCardMapper.getViewList(card);
        ArrayList<PrepayCardExportVO> vos = new ArrayList<PrepayCardExportVO>();
        viewList.forEach(map -> {
            PrepayCardExportVO vo = new PrepayCardExportVO();
            vo.setCardId(map.get("CARD_ID").toString());
            vo.setCardPassword(map.get("CARD_PASSWORD").toString());
            if ((Integer)map.get("STATUS_NAME") == 0) {
                vo.setCreateTime("");
            } else {
                vo.setCreateTime(DateUtils.formatDate((Date)((Date)map.get("CREATE_TIME")), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            switch ((Integer)map.get("STATUS_NAME")) {
                case 0: {
                    vo.setStatusName("\u672a\u9886\u53d6");
                    break;
                }
                case 1: {
                    vo.setStatusName("\u5df2\u9886\u53d6");
                    break;
                }
                case 2: {
                    vo.setStatusName("\u5df2\u6fc0\u6d3b");
                    break;
                }
                case 3: {
                    vo.setStatusName("\u6682\u505c");
                    break;
                }
                case 4: {
                    vo.setStatusName("\u914d\u9001\u4e2d");
                    break;
                }
                case 5: {
                    vo.setStatusName("\u7981\u7528/\u9000\u6b3e");
                    break;
                }
                case 6: {
                    vo.setStatusName("\u5df2\u5b8c\u6210");
                    break;
                }
                default: {
                    vo.setStatusName("\u672a\u77e5\u72b6\u6001");
                }
            }
            vo.setUsedCount(String.valueOf((Integer)map.get("TOTAL_COUNT") - (Integer)map.get("REMAIN_COUNT")));
            vo.setNickName(map.get("NICK_NAME") == null ? null : map.get("NICK_NAME").toString());
            vos.add(vo);
        });
        return vos;
    }

    @Override
    public BaseJsonVo execPrepayRecommends(String orderMainNo, String openId, String phone) {
        boolean isParamPhone = false;
        if (StringUtil.isNotEmpty((String)phone)) {
            if (phone.indexOf("-") >= 0 || phone.indexOf("*") >= 0 || phone.length() != 11) {
                return BaseJsonVo.error((String)"\u624b\u673a\u53f7\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u4e0d\u652f\u6301\u865a\u62df\u53f7\u6216\u52a0\u5bc6\u53f7\u7801");
            }
            isParamPhone = true;
        }
        if (StringUtil.isNotEmpty((String)openId) && StringUtil.isNotEmpty((String)orderMainNo)) {
            CustomerEntity ee;
            openId = openId.trim();
            orderMainNo = orderMainNo.trim();
            String customerId = "";
            DistributorQiyeweixinExternalContactEntity e = new DistributorQiyeweixinExternalContactEntity();
            e.setExternalUserid(openId);
            e = (DistributorQiyeweixinExternalContactEntity)this.externalContactInterface.getSingle(e);
            if (e != null) {
                customerId = e.getCustomerId();
                if (StringUtil.isEmpty((String)phone) && StringUtil.isNotEmpty((String)e.getRemarkMobiles())) {
                    phone = e.getRemarkMobiles().split(",")[0];
                    if (StringUtil.isNotEmpty((String)phone)) {
                        if (phone.trim().length() != 11) {
                            phone = "";
                        }
                    } else {
                        phone = "";
                    }
                }
            }
            if ((ee = this.customerInterface.getCustomer(StringUtil.isNotEmpty((String)customerId) ? customerId : openId)) != null) {
                customerId = ee.getCustomerId();
                if (StringUtil.isEmpty((String)phone)) {
                    phone = ee.getMobile();
                }
            }
            if (StringUtil.isNotEmpty((String)customerId)) {
                BaseJsonVo jsonVo = this.biOrderDetailInvoke.orderBindCustomer(customerId, phone, orderMainNo, 1);
                if (!jsonVo.isSuccess()) {
                    if ("\u624b\u673a\u53f7\u4e3a\u7a7a".equals(jsonVo.getError()) && !isParamPhone) {
                        return BaseJsonVo.success((Object)"mobilenull");
                    }
                    return jsonVo;
                }
            } else {
                return BaseJsonVo.error((String)("\u8f93\u5165\u7684CUSID\u6216OPENID\u9519\u8bef\uff1a" + openId));
            }
        }
        if (StringUtil.isNotEmpty((String)orderMainNo)) {
            orderMainNo = orderMainNo.trim();
            return this.prepayCardPlanInvoke.recommendCards(orderMainNo);
        }
        BaseJsonVo<List<Map<String, String>>> baseJsonVo = this.biOrderDetailInvoke.getCanRecommendOrder();
        int i = 0;
        int total = ((List)baseJsonVo.getValue()).size();
        for (Map map : (List)baseJsonVo.getValue()) {
            BaseJsonVo jsonVo = this.prepayCardPlanInvoke.recommendCards((String)map.get("orderMainNo"));
            if (!jsonVo.isSuccess()) continue;
            ++i;
        }
        return BaseJsonVo.success((Object)("\u6267\u884c\u5b8c\u6210\uff0c\u603b\u5171:" + total + "\u6210\u529f\u52a0\u5165" + i));
    }

    @Override
    public BaseJsonVo fixCardCustomer() {
        this.prepayCardMapper.fixCardCustomer();
        return BaseJsonVo.success(null);
    }
}

