/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.price;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.price.PriceChangeMapper;
import cc.lechun.mall.entity.price.PriceChangeEntity;
import cc.lechun.mall.entity.price.PriceChangeProductEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.iservice.price.PriceChangeInterface;
import cc.lechun.mall.iservice.price.PriceChangeProductInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import com.github.pagehelper.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceChangeService
extends BaseService<PriceChangeEntity, Integer>
implements PriceChangeInterface {
    @Resource
    private PriceChangeMapper priceChangeMapper;
    @Autowired
    private PriceChangeProductInterface priceChangeProductInterface;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private MallPromotionProductInterface mallPromotionProductInterface;
    @Autowired
    MallPromotionInterface mallPromotionInterface;

    @Override
    public String getLastPriceLevel() {
        return this.priceChangeMapper.getLastPriceLevel();
    }

    @Override
    @Transactional
    public BaseJsonVo changePrice(String toPriceLevel, String createUserName) {
        String currentLevel = this.priceChangeMapper.getLastPriceLevel();
        if (toPriceLevel.equals(currentLevel)) {
            return BaseJsonVo.error((String)("\u65e0\u9700\u5207\u6362\u76f8\u540c\u4ef7\u76d8" + currentLevel));
        }
        PriceChangeEntity entity = new PriceChangeEntity();
        entity.setFromPriceLevel(currentLevel);
        entity.setToPriceLevel(toPriceLevel);
        entity.setCreateBy(createUserName);
        entity.setCreateTime(new Date());
        this.priceChangeMapper.insert(entity);
        ArrayList batchInsert = new ArrayList();
        List<MallPromotionProductEntity> promotionProductEntities = this.mallPromotionProductInterface.getNotFreePromotionProducts();
        promotionProductEntities.forEach(mallPromotionProductEntity -> {
            PriceChangeProductEntity cp = new PriceChangeProductEntity();
            if ("A".equals(toPriceLevel)) {
                mallPromotionProductEntity.setPromotionPrice(mallPromotionProductEntity.getPromotionPriceA());
                cp.setToPrice(mallPromotionProductEntity.getPromotionPriceA());
            } else if ("B".equals(toPriceLevel)) {
                mallPromotionProductEntity.setPromotionPrice(mallPromotionProductEntity.getPromotionPriceB());
                cp.setToPrice(mallPromotionProductEntity.getPromotionPriceB());
            } else if ("C".equals(toPriceLevel)) {
                mallPromotionProductEntity.setPromotionPrice(mallPromotionProductEntity.getPromotionPriceC());
                cp.setToPrice(mallPromotionProductEntity.getPromotionPriceC());
            } else if ("S".equals(toPriceLevel)) {
                mallPromotionProductEntity.setPromotionPrice(mallPromotionProductEntity.getPromotionPriceS());
                cp.setToPrice(mallPromotionProductEntity.getPromotionPriceS());
            }
            this.mallPromotionInterface.addPromotionProduct((MallPromotionProductEntity)mallPromotionProductEntity);
            cp.setChangeId(entity.getId());
            cp.setProType(2);
            cp.setProId(mallPromotionProductEntity.getPromotionId());
            cp.setFromPriceLevel(currentLevel);
            cp.setToPriceLevel(toPriceLevel);
            cp.setFromPrice(mallPromotionProductEntity.getPromotionPrice());
            batchInsert.add(cp);
        });
        List<MallProductEntity> productEntities = this.mallProductInterface.getNotFreeProductList();
        productEntities.forEach(product -> {
            this.logger.info("\u4fee\u6539\u524d\u7684product:{}", (Object)JsonUtils.toJson((Object)product, (boolean)false));
            PriceChangeProductEntity cp = new PriceChangeProductEntity();
            if ("A".equals(toPriceLevel)) {
                product.setProPrice(product.getProPriceA());
                cp.setToPrice(new BigDecimal(product.getProPriceA()));
            } else if ("B".equals(toPriceLevel)) {
                product.setProPrice(product.getProPriceB());
                cp.setToPrice(new BigDecimal(product.getProPriceB()));
            } else if ("C".equals(toPriceLevel)) {
                product.setProPrice(product.getProPriceC());
                cp.setToPrice(new BigDecimal(product.getProPriceC()));
            } else if ("S".equals(toPriceLevel)) {
                product.setProPrice(product.getProPriceS());
                cp.setToPrice(new BigDecimal(product.getProPriceS()));
            }
            this.logger.info("\u4fee\u6539\u540e\u7684product:{}", (Object)JsonUtils.toJson((Object)product, (boolean)false));
            this.mallProductInterface.addProduct((MallProductEntity)product);
            cp.setChangeId(entity.getId());
            cp.setProType(1);
            cp.setProId(product.getProId());
            cp.setProName(product.getProName());
            cp.setFromPriceLevel(currentLevel);
            cp.setToPriceLevel(toPriceLevel);
            cp.setFromPrice(StringUtil.isEmpty((String)product.getProPrice()) ? BigDecimal.ZERO : new BigDecimal(product.getProPrice()));
            batchInsert.add(cp);
        });
        this.priceChangeProductInterface.batchInsert(batchInsert);
        return BaseJsonVo.success((String)"\u64cd\u4f5c\u5b8c\u6210", null);
    }
}

