/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.quartz.job;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.core.quartz.AbstractJob;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Set;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RedisCacheCleanJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheCleanJob.class);
    @Autowired
    private RedisCacheUtil redisCacheUtil;

    protected Object doExecute(JobExecutionContext context) throws JobExecutionException, InvalidKeySpecException, NoSuchAlgorithmException {
        Set sets = this.redisCacheUtil.getKeysPattern("PK2_*");
        log.info("RedisCacheCleanJob\u5220\u9664\u7f13\u5b58PK2_\uff0c\u6570\u91cf\uff1a{}", (Object)(sets == null ? 0 : sets.size()));
        if (sets != null & sets.size() > 0) {
            for (String s : sets) {
                Set keys = this.redisCacheUtil.getCacheSet(s);
                if (!(keys != null & keys.size() > 0)) continue;
                for (String key : keys) {
                    Object o;
                    if (key == null || (o = this.redisCacheUtil.get(key)) != null) continue;
                    this.redisCacheUtil.remove(s);
                }
            }
        }
        log.info("run RedisCacheCleanJob {}", (Object)"\u5b8c\u6210");
        return "";
    }
}

