/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.quartz.job;

import cc.lechun.apiinvoke.sales.ClueCleanInvoke;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.quartz.AbstractJob;
import cc.lechun.scrm.entity.AppEnum;
import cc.lechun.scrm.entity.calendar.CalendarEntity;
import cc.lechun.scrm.iservice.calendar.CalendarInterface;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SalesClueCleanJob
extends AbstractJob {
    private static final Logger logger = LoggerFactory.getLogger(SalesClueCleanJob.class);
    @Autowired
    private ClueCleanInvoke clueCleanInvoke;
    @Autowired
    private CalendarInterface calendarInterface;

    protected Object doExecute(JobExecutionContext context) throws JobExecutionException {
        try {
            Date date = DateUtils.currentDate();
            CalendarEntity calendarEntity = (CalendarEntity)this.calendarInterface.selectByPrimaryKey(date);
            calendarEntity.setAppId(AppEnum.SALES.getValue());
            if (calendarEntity != null && Integer.valueOf(0).equals(calendarEntity.getQyWorkType())) {
                this.clueCleanInvoke.cleanClue(DateUtils.formatDate((Date)DateUtils.currentDate(), (String)""), "993385231123877888");
                this.clueCleanInvoke.autoArrangeClue(DateUtils.formatDate((Date)DateUtils.currentDate(), (String)""), "993385231123877888");
            }
            this.clueCleanInvoke.signTag(DateUtils.formatDate((Date)DateUtils.currentDate(), (String)""));
            logger.info("run SalesClueCleanJob");
        }
        catch (Exception e) {
            logger.error("run SalesClueCleanJob ERROR", (Throwable)e);
        }
        return "";
    }
}

