/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.quartz.job;

import cc.lechun.apiinvoke.csms.RefundCsmsQuartzInvoke;
import cc.lechun.apiinvoke.tmall.TmallRefundInvoke;
import cc.lechun.csmsapi.dto.refund.PlatformDTO;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.quartz.AbstractJob;
import cc.lechun.tmall.model.BaseShop;
import com.github.pagehelper.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TmallRefundJob
extends AbstractJob {
    private static final Logger logger = LoggerFactory.getLogger(TmallRefundJob.class);
    @Autowired
    private TmallRefundInvoke tmallRefundInvoke;
    @Autowired
    private RefundCsmsQuartzInvoke refundCsmsQuartzInvoke;

    protected Object doExecute(JobExecutionContext jobExecutionContext) throws Exception {
        BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"");
        logger.info("++++++++++++++TmallRefundJob++++++++++++start");
        PlatformDTO platformDTO = new PlatformDTO();
        platformDTO.setStatus("Y");
        BaseJsonVo<List<PlatformDTO>> platformInfoJson = this.refundCsmsQuartzInvoke.listPlatformInfo(platformDTO);
        logger.info("=========TmallRefundJob.platformInfoJson========platformInfoJson={}", (Object)JsonUtils.toJson(platformInfoJson, (boolean)false));
        List platformDTOList = (List)platformInfoJson.getValue();
        if (platformDTOList != null && platformDTOList.size() > 0) {
            for (PlatformDTO platformDTOParam : platformDTOList) {
                if (StringUtil.isEmpty((String)platformDTOParam.getShopToken())) continue;
                BaseShop baseShop = new BaseShop();
                baseShop.setAppSecret(platformDTOParam.getShopSecret());
                baseShop.setSessionKey(platformDTOParam.getShopToken());
                baseShop.setAppKey(platformDTOParam.getShopKey());
                baseShop.setShopId(platformDTOParam.getShopId());
                baseShop.setLastUpdateTime(platformDTOParam.getLastUpdateTime());
                baseShop.setPlatform(platformDTOParam.getPlatformName());
                if ("\u6dd8\u5b9d".equals(platformDTOParam.getPlatformName())) {
                    baseJsonVo = this.tmallRefundInvoke.getReceiveRefund(baseShop);
                }
                if (baseJsonVo.getStatus() == 200) {
                    platformDTOParam.setErrorCode("");
                    Date date = new Date((Long)baseJsonVo.getValue());
                    platformDTOParam.setLastUpdateTime(date);
                } else {
                    platformDTOParam.setErrorCode(baseJsonVo.getError_msg());
                }
                logger.info("=========TmallRefundJob.updatePlatformLastUpdateTimeByParam========platformDTOParam={}", (Object)JsonUtils.toJson((Object)platformDTOParam, (boolean)false));
                this.refundCsmsQuartzInvoke.updatePlatformLastUpdateTimeByParam(platformDTOParam);
            }
        }
        logger.info("++++++++++++++TmallRefundJob++++++++++++end");
        return null;
    }
}

