/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.apiinvoke.mall.ActiveReunionApiInvoke;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.reunion.OrderCoveryImportVo;
import cc.lechun.mall.entity.reunion.ReunionProductVO;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderRecoveryUploadListener
extends AnalysisEventListener<OrderCoveryImportVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderRecoveryUploadListener.class);
    private static final int BATCH_COUNT = 2000;
    List<OrderCoveryImportVo> list = new ArrayList<OrderCoveryImportVo>();
    ActiveReunionApiInvoke activeReunionApiInvoke;

    public OrderRecoveryUploadListener(ActiveReunionApiInvoke activeReunionApiInvoke) {
        this.activeReunionApiInvoke = activeReunionApiInvoke;
    }

    public void invoke(OrderCoveryImportVo data, AnalysisContext context) {
        LOGGER.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)JSON.toJSONString((Object)data));
        this.list.add(data);
        if (this.list.size() >= 2000) {
            this.saveData();
            this.list.clear();
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        String rst = this.saveData();
        if (StringUtils.isEmpty((String)rst)) {
            LOGGER.info("\u56de\u6536\u54c1\u5bfc\u5165\u5b8c\u6210\uff0c\u5168\u90e8\u6210\u529f");
        } else {
            LOGGER.info("\u56de\u6536\u54c1\u5bfc\u5165\u5b8c\u6210\uff0c\u5bfc\u5165\u5931\u8d25\u7684\u6709\uff1a{}", (Object)rst);
        }
    }

    private String saveData() {
        LOGGER.info("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)this.list.size());
        StringBuilder sb = new StringBuilder();
        this.list.forEach(vo -> {
            if (vo.getWaybillNo().contains("-")) {
                vo.setWaybillNo(vo.getWaybillNo().split("-")[0]);
            }
            ArrayList<ReunionProductVO> recovery = new ArrayList<ReunionProductVO>();
            ReunionProductVO reunionProductVO1 = new ReunionProductVO();
            reunionProductVO1.setProductId(96);
            reunionProductVO1.setOrderCount(Integer.valueOf(vo.getBowl()));
            ReunionProductVO reunionProductVO2 = new ReunionProductVO();
            reunionProductVO2.setProductId(126);
            reunionProductVO2.setOrderCount(Integer.valueOf(vo.getBottle()));
            ReunionProductVO reunionProductVO3 = new ReunionProductVO();
            reunionProductVO3.setProductId(97);
            reunionProductVO3.setOrderCount(Integer.valueOf(vo.getOthers()));
            recovery.add(reunionProductVO1);
            recovery.add(reunionProductVO2);
            recovery.add(reunionProductVO3);
            BaseJsonVo baseJsonVo = this.activeReunionApiInvoke.importOrderRecoveryProducts(vo.getWaybillNo(), JsonUtils.toJson(recovery, (boolean)false));
            if (baseJsonVo.isSuccess()) {
                LOGGER.info("{}\u56de\u6536\u54c1\u4fdd\u5b58\u6210\u529f\uff01\u53c2\u6570\uff1a{}", (Object)vo.getWaybillNo(), (Object)JsonUtils.toJson(recovery, (boolean)false));
            } else {
                sb.append("[").append(vo.getWaybillNo()).append("]\u4fdd\u5b58\u5931\u8d25\uff1a").append(baseJsonVo.getMessage()).append(";");
                LOGGER.error("{}\u56de\u6536\u54c1\u4fdd\u5b58\u5931\u8d25[{}]\uff1a{}", new Object[]{vo.getWaybillNo(), JsonUtils.toJson(recovery, (boolean)false), baseJsonVo.getMessage()});
            }
        });
        return sb.toString();
    }
}

