/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.apiinvoke.mall.ActiveReunionApiInvoke;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.reunion.ReunionOrderMapper;
import cc.lechun.mall.entity.reunion.ReunionCustomerLoveEntity;
import cc.lechun.mall.entity.reunion.ReunionCustomerLoveHistoryEntity;
import cc.lechun.mall.entity.reunion.ReunionOrderEntity;
import cc.lechun.mall.entity.reunion.ReunionOrderVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.reunion.ReunionCustomerLoveHistoryInterface;
import cc.lechun.mall.iservice.reunion.ReunionCustomerLoveInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReunionOrderService
extends BaseService<ReunionOrderEntity, Integer>
implements ReunionOrderInterface {
    @Resource
    private ReunionOrderMapper reunionOrderMapper;
    @Autowired
    private ReunionCustomerLoveInterface reunionCustomerLoveInterface;
    @Autowired
    private ReunionCustomerLoveHistoryInterface reunionCustomerLoveHistoryInterface;
    @Autowired
    private ReunionOrderInterface reunionOrderInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private ActiveReunionApiInvoke activeReunionApiInvoke;

    @Override
    public boolean existsBindCode(String bindCode) {
        ReunionOrderEntity param = new ReunionOrderEntity();
        param.setBindCode(bindCode);
        List list = this.getList(param);
        return list != null && list.size() > 0;
    }

    @Override
    public PageInfo<ReunionOrderVo> getVerificationReunionOrderList(Integer pageNum, Integer pageSize, Integer orderId, Integer orderStatus, String mobile, String wayNo, String userName, Date createDate, String bindcode) {
        Integer siteId = null;
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.reunionOrderMapper.getVerificationReunionOrderList(orderId, orderStatus, mobile, wayNo, siteId, createDate, bindcode);
        PageInfo pg = page.toPageInfo();
        pg.getList().forEach(vo -> {
            if (vo.getOrderStatus() == 1 && vo.getOrderSubStatus() > 11) {
                this.logger.info("\u67e5\u8be2\u56de\u6536\u5355\uff1abindcode={},customerId={}", (Object)vo.getBindCode(), (Object)vo.getCustomerId());
                String orderNo = this.orderInterface.getReunionFreightOrder(vo.getBindCode(), vo.getCustomerId());
                this.logger.info("\u67e5\u8be2\u56de\u6536\u5355\u7ed3\u679c\uff1aorderNo={}", (Object)orderNo);
                vo.setFreightOrderNo(orderNo);
            }
        });
        return pg;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo VerificationReunionOrder(Integer orderId, String userId) {
        BigDecimal loveSwap;
        if (orderId == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212ID\u4e3a\u7a7a");
        }
        ReunionOrderEntity reunionOrderEntity = (ReunionOrderEntity)this.reunionOrderMapper.selectByPrimaryKey(orderId);
        if (reunionOrderEntity == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        if (!Integer.valueOf(1).equals(reunionOrderEntity.getOrderStatus())) {
            if (Integer.valueOf(0).equals(reunionOrderEntity.getOrderStatus())) {
                return BaseJsonVo.error((String)"\u8ba1\u5212\u63d0\u4ea4\u540e\u624d\u80fd\u6838\u9500");
            }
            if (Integer.valueOf(2).equals(reunionOrderEntity.getOrderStatus())) {
                return BaseJsonVo.error((String)"\u8ba1\u5212\u5df2\u7ecf\u6838\u9500");
            }
            return BaseJsonVo.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u6838\u9500");
        }
        String customerId = reunionOrderEntity.getCustomerId();
        ReunionCustomerLoveEntity reunionCustomerLoveEntity = (ReunionCustomerLoveEntity)this.reunionCustomerLoveInterface.selectByPrimaryKey((Serializable)((Object)customerId), 0L);
        BigDecimal loveRemain = BigDecimal.ZERO;
        BigDecimal loveShare = BigDecimal.ZERO;
        BigDecimal loveRecovery = reunionOrderEntity.getLoveRecoveryAmount() == null ? BigDecimal.ZERO : reunionOrderEntity.getLoveRecoveryAmount();
        BigDecimal bigDecimal = loveSwap = reunionOrderEntity.getLoveSwapAmount() == null ? BigDecimal.ZERO : reunionOrderEntity.getLoveSwapAmount();
        if (reunionCustomerLoveEntity != null) {
            loveRemain = reunionCustomerLoveEntity.getLoveRemain() == null ? BigDecimal.ZERO : reunionCustomerLoveEntity.getLoveRemain();
            loveShare = reunionCustomerLoveEntity.getLoveShare() == null ? BigDecimal.ZERO : reunionCustomerLoveEntity.getLoveShare();
        }
        BigDecimal usedRemain = BigDecimal.ZERO;
        BigDecimal usedShare = BigDecimal.ZERO;
        BigDecimal usedRecovery = BigDecimal.ZERO;
        BigDecimal loveTotal = loveRemain.add(loveShare).add(loveRecovery);
        if (loveTotal.compareTo(loveSwap) < 0) {
            return BaseJsonVo.error((String)("\u7231\u5fc3\u503c\u603b\u8ba1\uff1a" + loveTotal + "\u5c0f\u4e8e\u7269\u54c1\u5151\u6362\u503c\uff1a" + loveSwap));
        }
        if (loveSwap.compareTo(BigDecimal.ZERO) == 0) {
            return BaseJsonVo.error((String)"\u5151\u6362\u7269\u8d44\u7231\u5fc3\u503c\u4e3a\u96f6");
        }
        String message = "";
        ReunionCustomerLoveHistoryEntity historyEntity = new ReunionCustomerLoveHistoryEntity();
        historyEntity.setBindCode(reunionOrderEntity.getBindCode());
        historyEntity.setCreateTime(new Date());
        historyEntity.setCustomerId(customerId);
        historyEntity.setOrderId(reunionOrderEntity.getOrderId());
        if (loveRecovery.compareTo(BigDecimal.ZERO) > 0) {
            historyEntity.setHitstoryType(3);
            historyEntity.setLovePrice(loveRecovery);
            this.reunionCustomerLoveHistoryInterface.insertHistory(historyEntity);
        }
        if (loveRemain.compareTo(loveSwap) >= 0) {
            usedRemain = loveSwap;
            usedShare = BigDecimal.ZERO;
            usedRecovery = BigDecimal.ZERO;
            loveRemain = loveRemain.subtract(loveSwap);
        } else if (loveRemain.add(loveShare).compareTo(loveSwap) >= 0) {
            usedRemain = loveRemain;
            usedShare = loveSwap.subtract(usedRemain);
            usedRecovery = BigDecimal.ZERO;
            loveRemain = loveRemain.subtract(usedRemain);
            loveShare = loveShare.subtract(usedShare);
        } else if (loveRemain.add(loveShare).add(loveRecovery).compareTo(loveSwap) >= 0) {
            usedRemain = loveRemain;
            usedShare = loveShare;
            usedRecovery = loveSwap.subtract(usedRemain).subtract(usedShare);
            loveRemain = loveRemain.subtract(usedRemain);
            loveShare = loveShare.subtract(usedShare);
            loveRecovery = loveRecovery.subtract(usedRecovery);
        }
        if (usedRemain.compareTo(BigDecimal.ZERO) > 0) {
            historyEntity.setHitstoryType(2);
            historyEntity.setLovePrice(usedRemain.negate());
            this.reunionCustomerLoveHistoryInterface.insertHistory(historyEntity);
        }
        if (usedShare.compareTo(BigDecimal.ZERO) > 0) {
            historyEntity.setHitstoryType(1);
            historyEntity.setLovePrice(usedShare.negate());
            this.reunionCustomerLoveHistoryInterface.insertHistory(historyEntity);
        }
        if (usedRecovery.compareTo(BigDecimal.ZERO) > 0) {
            historyEntity.setHitstoryType(5);
            historyEntity.setLovePrice(usedRecovery.negate());
            this.reunionCustomerLoveHistoryInterface.insertHistory(historyEntity);
        }
        if (!this.reunionCustomerLoveInterface.subtractLoveValue(customerId, usedRemain, usedShare)) {
            message = "\u6838\u9500\u5931\u8d25\uff0c\u66f4\u65b0\u5269\u4f59\u7231\u5fc3\u503c\u5f02\u5e38";
            throw new RuntimeException(message);
        }
        reunionOrderEntity.setLoveCostRecoveryAmount(usedRecovery);
        reunionOrderEntity.setLoveCostRemainAmount(usedRemain);
        reunionOrderEntity.setLoveCostShareAmount(usedShare);
        reunionOrderEntity.setOrderStatus(2);
        ReunionOrderEntity filter = new ReunionOrderEntity();
        filter.setOrderId(reunionOrderEntity.getOrderId());
        filter.setOrderStatus(1);
        if (this.reunionOrderInterface.updateByEntity(reunionOrderEntity, filter) == 0) {
            message = "\u6838\u9500\u5931\u8d25\uff0c\u8ba1\u5212\u72b6\u6001\u4e0d\u6b63\u786e";
            throw new RuntimeException(message);
        }
        if (loveRecovery.compareTo(BigDecimal.ZERO) > 0) {
            ReunionCustomerLoveEntity loveEntity = new ReunionCustomerLoveEntity();
            loveEntity.setCustomerId(customerId);
            loveEntity.setLoveRemain(loveRecovery);
            this.reunionCustomerLoveInterface.updateCustomerLove(loveEntity);
        }
        if (message.isEmpty()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)message);
    }

    @Override
    public BaseJsonVo cancelReunionOrder(Integer orderId) {
        ReunionOrderEntity order = (ReunionOrderEntity)this.reunionOrderMapper.selectByPrimaryKey(orderId);
        if (order.getOrderStatus() == 1 && order.getOrderSubStatus() < 14) {
            this.logger.info("\u53d6\u6d88\u5220\u9664\u8ba1\u5212\uff0corderId:{},order:{}", (Object)orderId, (Object)JsonUtils.toJson((Object)order, (boolean)false));
            this.reunionOrderMapper.deleteByPrimaryKey(orderId);
            if (order.getOrderSubStatus() == 13) {
                return this.activeReunionApiInvoke.cancleJDExpress(order.getWayNo());
            }
            return BaseJsonVo.success((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u53d6\u6d88");
    }

    @Override
    public BaseJsonVo importOrderRecovery() {
        String billwayNo = "";
        ArrayList recovery = new ArrayList();
        return null;
    }

    @Override
    public BaseJsonVo modifyReunionOrderArriveTime(Integer orderId, String selectTime) {
        ReunionOrderEntity reunionOrderEntity = (ReunionOrderEntity)this.reunionOrderMapper.selectByPrimaryKey(orderId);
        if (reunionOrderEntity == null) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        reunionOrderEntity.setArriveTime(selectTime);
        this.reunionOrderMapper.updateByPrimaryKeySelective(reunionOrderEntity);
        return BaseJsonVo.success((String)"\u4fdd\u5b58\u6210\u529f", null);
    }
}

