/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.reunion.ReunionProductMapper;
import cc.lechun.mall.entity.reunion.ReunionProductEntity;
import cc.lechun.mall.iservice.reunion.ReunionOrderInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderProductRecoveryInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderProductSwapInterface;
import cc.lechun.mall.iservice.reunion.ReunionProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReunionProductService
extends BaseService<ReunionProductEntity, Integer>
implements ReunionProductInterface {
    @Resource
    private ReunionProductMapper reunionProductMapper;
    @Autowired
    private ReunionOrderInterface reunionOrderInterface;
    @Autowired
    private ReunionOrderProductRecoveryInterface reunionOrderProductRecoveryInterface;
    @Autowired
    private ReunionOrderProductSwapInterface reunionOrderProductSwapInterface;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private RedisService redisService;

    @Override
    public PageInfo productList(String bindCode, PageForm pageForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        List<Map<String, Object>> list = this.reunionProductMapper.getProductList(bindCode);
        list.forEach(pro -> {
            Map<String, List<String>> productPicUrlMap = this.picService.getProductPicUrlMap((String)pro.get("productId"), SalesTypeEnum.SALES_PRODUCT.getValue());
            this.logger.info(JsonUtils.toJson(productPicUrlMap, (boolean)false));
            List<String> picProductSmall = productPicUrlMap.get("picProductSmall");
            if (picProductSmall != null && !picProductSmall.isEmpty()) {
                pro.put("productPic", picProductSmall.get(0));
            }
        });
        PageInfo pg = page.toPageInfo();
        pg.setList(list);
        return pg;
    }

    @Override
    @Transactional
    public BaseJsonVo saveProdcts(ReunionProductEntity reunionProductEntity) {
        if (reunionProductEntity.getId() == null || reunionProductEntity.getId() == 0) {
            ReunionProductEntity param = new ReunionProductEntity();
            param.setProductId(reunionProductEntity.getProductId());
            param.setBindCode(reunionProductEntity.getBindCode());
            List list = this.reunionProductMapper.getList(param);
            if (list != null && list.size() > 0) {
                return BaseJsonVo.error((String)"\u8be5\u5546\u54c1\u5df2\u5b58\u5728\uff0c\u76f4\u63a5\u4fee\u6539\u5c31\u597d");
            }
            reunionProductEntity.setCreateTime(DateUtils.now());
            this.reunionProductMapper.insert(reunionProductEntity);
        } else {
            ReunionProductEntity result = (ReunionProductEntity)this.reunionProductMapper.selectByPrimaryKey(reunionProductEntity.getId());
            if (!result.getBindCode().equals(reunionProductEntity.getBindCode())) {
                return BaseJsonVo.error((String)"\u8be5\u5546\u54c1\u5df2\u88ab\u7528\u6237\u56de\u6536\u8ba1\u5212\u4f7f\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u6d3b\u52a8");
            }
            if (!result.getProductType().equals(reunionProductEntity.getProductType())) {
                return BaseJsonVo.error((String)"\u8be5\u5546\u54c1\u5df2\u88ab\u7528\u6237\u56de\u6536\u8ba1\u5212\u4f7f\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u5546\u54c1\u7c7b\u578b");
            }
            if (result.getLovePrice().compareTo(reunionProductEntity.getLovePrice()) != 0) {
                return BaseJsonVo.error((String)"\u8be5\u5546\u54c1\u5df2\u88ab\u7528\u6237\u56de\u6536\u8ba1\u5212\u4f7f\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u7231\u5fc3\u503c");
            }
            this.reunionProductMapper.updateByPrimaryKeySelective(reunionProductEntity);
        }
        this.redisService.delete("REUNION_PRODUCTS");
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo copyProdcts(String bindCode, String copyFromBindCode) {
        if (this.reunionOrderInterface.existsBindCode(bindCode)) {
            return BaseJsonVo.error((String)"\u8be5\u6d3b\u52a8\u5df2\u6709\u8ba1\u5212\u751f\u6210\uff0c\u4e0d\u80fd\u4fee\u6539\u5546\u54c1");
        }
        this.reunionProductMapper.deleteByBindCode(bindCode);
        ReunionProductEntity param = new ReunionProductEntity();
        param.setBindCode(copyFromBindCode);
        List copyFrom = this.reunionProductMapper.getList(param);
        copyFrom.forEach(copyFromProduct -> {
            copyFromProduct.setId(null);
            copyFromProduct.setBindCode(bindCode);
            this.insert(copyFromProduct);
        });
        this.redisService.delete("REUNION_PRODUCTS");
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo deleteProdct(Integer id) {
        if (this.reunionOrderProductRecoveryInterface.existsProduct(id)) {
            return BaseJsonVo.error((String)"\u8be5\u5546\u54c1\u5df2\u88ab\u7528\u6237\u56de\u6536\u8ba1\u5212\u4f7f\u7528\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        if (this.reunionOrderProductSwapInterface.existsProduct(id)) {
            return BaseJsonVo.error((String)"\u8be5\u5546\u54c1\u5df2\u88ab\u7528\u6237\u56de\u6536\u8ba1\u5212\u4f7f\u7528\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        int i = this.reunionProductMapper.deleteByPrimaryKey(id);
        this.redisService.delete("REUNION_PRODUCTS");
        return i > 0 ? BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f") : BaseJsonVo.error((String)("\u5220\u9664\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u7684\u4e3b\u952e\uff1a" + id));
    }
}

