/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.reunion.ReunionSiteMapper;
import cc.lechun.mall.entity.customer.SysAreaVo;
import cc.lechun.mall.entity.customer.SysCityAreaVo;
import cc.lechun.mall.entity.customer.SysProvinceCityAreaVo;
import cc.lechun.mall.entity.reunion.ReunionOrderEntity;
import cc.lechun.mall.entity.reunion.ReunionSiteEntity;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderInterface;
import cc.lechun.mall.iservice.reunion.ReunionSiteInterface;
import cc.lechun.utils.LocationUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReunionSiteService
extends BaseService<ReunionSiteEntity, Integer>
implements ReunionSiteInterface {
    @Resource
    private ReunionSiteMapper reunionSiteMapper;
    @Autowired
    private CustomerAddressInterface customerAddressInterface;
    @Autowired
    private ReunionOrderInterface reunionOrderInterface;

    @Override
    public BaseJsonVo saveReunionSite(ReunionSiteEntity entity) {
        Map map;
        if (StringUtils.isEmpty((String)entity.getSiteName())) {
            return BaseJsonVo.error((String)"\u7ad9\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)entity.getSiteName())) {
            return BaseJsonVo.error((String)"\u7ad9\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (entity.getBeginTime() == null) {
            return BaseJsonVo.error((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (entity.getEndTime() == null) {
            return BaseJsonVo.error((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<SysProvinceCityAreaVo> provinceCityAreaVos = this.customerAddressInterface.getProvinceCityErpThr(0, 0);
        Optional<SysProvinceCityAreaVo> provinceCityAreaVo = null;
        Optional<SysCityAreaVo> cityAreaVo = null;
        Optional<SysAreaVo> areaVo = null;
        if (StringUtils.isEmpty((String)entity.getProvinceCode())) {
            return BaseJsonVo.error((String)"\u6240\u5728\u7701\u4e0d\u80fd\u4e3a\u7a7a");
        }
        provinceCityAreaVo = provinceCityAreaVos.stream().filter(c -> c.getProvinceId() == Integer.valueOf(entity.getProvinceCode()).intValue()).findFirst();
        entity.setProvinceName(provinceCityAreaVo.isPresent() ? provinceCityAreaVo.get().getProvinceName() : "");
        if (StringUtils.isEmpty((String)entity.getCityCode())) {
            return BaseJsonVo.error((String)"\u6240\u5728\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (provinceCityAreaVo != null && provinceCityAreaVo.isPresent() && provinceCityAreaVo.get().getCityVoList() != null) {
            cityAreaVo = provinceCityAreaVo.get().getCityVoList().stream().filter(c -> c.getCityId() == Integer.valueOf(entity.getCityCode()).intValue()).findFirst();
            entity.setCityName(cityAreaVo.isPresent() ? cityAreaVo.get().getCityName() : "");
        }
        if (StringUtils.isEmpty((String)entity.getAreaCode())) {
            return BaseJsonVo.error((String)"\u6240\u5728\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (cityAreaVo != null && cityAreaVo.isPresent() && ((SysCityAreaVo)cityAreaVo.get()).getAreaVoList() != null) {
            areaVo = ((SysCityAreaVo)cityAreaVo.get()).getAreaVoList().stream().filter(c -> c.getAreaId() == Integer.valueOf(entity.getAreaCode()).intValue()).findFirst();
            entity.setAreaName(areaVo.isPresent() ? areaVo.get().getAreaName() : "");
        }
        if (StringUtils.isEmpty((String)entity.getAddress())) {
            return BaseJsonVo.error((String)"\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((entity.getLongitude() == null || entity.getLatitude() == null) && (map = LocationUtils.getLocationLngLatByTengxun(entity.getAddress(), (entity.getCityName() != null ? entity.getCityName() : "") + (entity.getAreaName() != null ? entity.getAreaName() : ""))) != null && map.size() > 0) {
            entity.setLongitude(Double.valueOf(map.get("lng").toString()));
            entity.setLatitude(Double.valueOf(map.get("lat").toString()));
        }
        ReunionSiteEntity search = new ReunionSiteEntity();
        search.setSiteName(entity.getSiteName());
        search = (ReunionSiteEntity)this.reunionSiteMapper.getSingle(search);
        if (entity.getSiteId() == null) {
            if (search != null) {
                return BaseJsonVo.error((String)"\u7ad9\u70b9\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            }
            this.reunionSiteMapper.insertSelective(entity);
        } else {
            if (search != null && !search.getSiteId().equals(entity.getSiteId())) {
                return BaseJsonVo.error((String)"\u7ad9\u70b9\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            }
            this.reunionSiteMapper.updateByPrimaryKeySelective(entity);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public ReunionSiteEntity getReunionSiteEntity(Integer siteId) {
        return (ReunionSiteEntity)this.reunionSiteMapper.selectByPrimaryKey(siteId);
    }

    @Override
    public PageInfo<ReunionSiteEntity> getReunionSiteList(Integer pageNum, Integer pageSize, String siteName) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        ReunionSiteEntity reunionSiteEntity = new ReunionSiteEntity();
        if (StringUtils.isNotEmpty((String)siteName)) {
            reunionSiteEntity.setSiteName(SqlUtils.sqlLike((String)siteName, (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        this.reunionSiteMapper.getList(reunionSiteEntity);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo deleteReunionSite(Integer siteId) {
        if (siteId == null) {
            return BaseJsonVo.error((String)"siteId\u9519\u8bef");
        }
        ReunionOrderEntity reunionOrderEntity = new ReunionOrderEntity();
        reunionOrderEntity.setReunionSiteId(siteId);
        if (this.reunionOrderInterface.existsByEntity(reunionOrderEntity) > 0) {
            BaseJsonVo.error((String)"\u7ad9\u70b9\u5df2\u7ecf\u5728\u4f7f\u7528\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.reunionSiteMapper.deleteByPrimaryKey(siteId);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }
}

