/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.reunion.ReunionStockMapper;
import cc.lechun.mall.entity.reunion.ReunionProductEntity;
import cc.lechun.mall.entity.reunion.ReunionStockEntity;
import cc.lechun.mall.entity.reunion.ReunionStockVo;
import cc.lechun.mall.iservice.reunion.ReunionProductInterface;
import cc.lechun.mall.iservice.reunion.ReunionStockInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReunionStockService
extends BaseService<ReunionStockEntity, Integer>
implements ReunionStockInterface {
    @Resource
    private ReunionStockMapper reunionStockMapper;
    @Autowired
    private ReunionProductInterface reunionProductInterface;

    @Override
    public BaseJsonVo saveStock(ReunionStockVo stock) {
        if (stock == null) {
            return BaseJsonVo.error((String)"\u5bf9\u8c61\u503c\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)stock.getBindCode())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6d3b\u52a8");
        }
        if (StringUtils.isEmpty((String)stock.getProductId())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u5151\u6362\u7269\u54c1");
        }
        if (stock.getTotal() == null) {
            stock.setTotal(0);
        }
        if (stock.getRemain() == null) {
            stock.setRemain(0);
        }
        if (stock.getAddStock() == null) {
            stock.setAddStock(0);
        }
        if (stock.getRemain() + stock.getAddStock() < 0) {
            return BaseJsonVo.error((String)"\u5e93\u5b58\u5269\u4f59\u91cf\u6700\u591a\u51cf\u5c11\u5230\u96f6");
        }
        if (stock.getAddStock() == 0) {
            return BaseJsonVo.error((String)"\u589e\u52a0\u91cf\u4e3a\u96f6\uff0c\u65e0\u9700\u4fdd\u5b58");
        }
        this.reunionStockMapper.updateStock(stock);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public BaseJsonVo initStock() {
        ReunionProductEntity search = new ReunionProductEntity();
        search.setProductType(2);
        List lst = this.reunionProductInterface.getList(search);
        ReunionStockEntity stockEntity = new ReunionStockEntity();
        for (ReunionProductEntity r : lst) {
            stockEntity.setBindCode(r.getBindCode());
            stockEntity.setProductId(r.getProductId());
            ReunionStockEntity entity = (ReunionStockEntity)this.reunionStockMapper.getSingle(stockEntity);
            if (entity != null) continue;
            entity = new ReunionStockEntity();
            entity.setProductId(r.getProductId());
            entity.setBindCode(r.getBindCode());
            entity.setTotal(0);
            entity.setRemain(0);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            this.insertSelective(entity);
        }
        return BaseJsonVo.success((Object)"\u521d\u59cb\u5316\u6210\u529f");
    }

    @Override
    public PageInfo<Map<String, Object>> getStockList(Integer pageNum, Integer pageSize, ReunionStockEntity stockEntity) {
        this.initStock();
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.reunionStockMapper.getStockList(stockEntity.getBindCode());
        PageInfo pg = page.toPageInfo();
        return pg;
    }
}

