/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.active.dao.active.ActiveMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallCutRuleMapper;
import cc.lechun.mall.entity.sales.CutRuleTypeEnum;
import cc.lechun.mall.entity.sales.MallCutRuleEntity;
import cc.lechun.mall.entity.sales.MallCutRuleVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.sales.MallCutRuleInterface;
import cc.lechun.mall.iservice.user.MallUserInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallCutRuleService
extends BaseService<MallCutRuleEntity, Integer>
implements MallCutRuleInterface {
    @Resource
    private MallCutRuleMapper mallCutRuleMapper;
    @Resource
    private ActiveMapper activeMapper;
    @Autowired
    private MallUserInterface mallSysUserService;

    @Override
    public PageInfo<MallCutRuleVo> getList(String bindCode, Integer page, Integer rows) {
        Page pg = PageHelper.startPage((int)page, (int)rows);
        MallCutRuleEntity query = new MallCutRuleEntity();
        query.setBindCode(bindCode);
        this.mallCutRuleMapper.getList(query);
        ArrayList<MallCutRuleVo> result = new ArrayList<MallCutRuleVo>();
        for (MallCutRuleEntity entity : pg.toPageInfo().getList()) {
            MallUserEntity user;
            MallCutRuleVo vo = new MallCutRuleVo();
            BeanUtils.copyProperties((Object)entity, (Object)vo);
            ActiveEntity activeQuery = new ActiveEntity();
            activeQuery.setBindCode(entity.getBindCode());
            ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.getSingle(activeQuery);
            vo.setActiveName(activeEntity.getActiveName());
            if (StringUtils.isNotEmpty((String)entity.getCreateUserid()) && (user = (MallUserEntity)this.mallSysUserService.selectByPrimaryKey((Serializable)((Object)entity.getCreateUserid()))) != null) {
                vo.setCreateUsername(user.getUserNick());
            }
            vo.setRuleTypeName(CutRuleTypeEnum.getName(entity.getRuleType()));
            result.add(vo);
        }
        PageInfo pageInfo = new PageInfo(result);
        pageInfo.setTotal(pg.getTotal());
        pageInfo.setList(result);
        return pageInfo;
    }

    @Override
    public BaseJsonVo save(MallCutRuleEntity cutRuleEntity) {
        return this.mallCutRuleMapper.insertOrUpdate(cutRuleEntity) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

