/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.common.enums.sales.FreeRuleTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketBatchMapper;
import cc.lechun.mall.dao.sales.MallFreeMapper;
import cc.lechun.mall.dao.sales.MallFreeProductMapper;
import cc.lechun.mall.dao.sales.MallFreeRuleMapper;
import cc.lechun.mall.dao.sales.MallProductMapper;
import cc.lechun.mall.dao.vip.MallVipRightsMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.deliver.MallCityEntity;
import cc.lechun.mall.entity.sales.MallFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeEntityVo;
import cc.lechun.mall.entity.sales.MallFreeProductEntity;
import cc.lechun.mall.entity.sales.MallFreeProductVo;
import cc.lechun.mall.entity.sales.MallFreeRuleEntity;
import cc.lechun.mall.entity.sales.MallFreeRuleEntityVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.iservice.sales.MallPromotionBuyInterface;
import cc.lechun.mall.service.deliver.MallCityService;
import cc.lechun.mall.service.sales.MallGroupService;
import cc.lechun.mall.service.sales.MallPromotionService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallFreeService
extends BaseService
implements MallFreeInterface {
    private static final Logger log = LoggerFactory.getLogger(MallFreeService.class);
    @Autowired
    MallFreeMapper freeMapper;
    @Autowired
    MallFreeProductMapper freeProductMapper;
    @Autowired
    MallFreeRuleMapper freeRuleMapper;
    @Autowired
    MallProductMapper productService;
    @Autowired
    private MallPromotionService mallPromotionService;
    @Autowired
    private MallGroupService mallGroupService;
    @Autowired
    MallPromotionBuyInterface promotionBuyInterface;
    @Autowired
    private MallCityService mallCityService;
    @Autowired
    private MallVipRightsMapper mallVipService;
    @Autowired
    private CashticketBatchMapper cashticketBatchMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallProductCategoryInterface productCategoryInterface;

    private List<MallFreeRuleEntity> getMallFreeRule(String freeId) {
        MallFreeRuleEntity searchParam = new MallFreeRuleEntity();
        searchParam.setFreeId(freeId);
        return this.freeRuleMapper.getList(searchParam);
    }

    @Override
    public List<MallFreeProductEntity> getMallFreeProduct(String freeId) {
        MallFreeProductEntity searchParam0 = new MallFreeProductEntity();
        searchParam0.setFreeId(freeId);
        return this.freeProductMapper.getList(searchParam0);
    }

    @Override
    public PageInfo<MallFreeEntityVo> getFreeList(int pageNum, int pageSize, String freeName, int platformGroupId, Integer status) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        if (status == -1) {
            status = null;
        }
        this.freeMapper.getFreeList(freeName, platformGroupId, status);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public MallFreeEntity getFree(String freeId) {
        return (MallFreeEntity)this.freeMapper.selectByPrimaryKey((Serializable)((Object)freeId));
    }

    @Override
    public PageInfo<MallFreeProductVo> getFreeProductList(int pageNum, int pageSize, String freeId) {
        MallFreeProductEntity mallFreeProductEntity = new MallFreeProductEntity();
        mallFreeProductEntity.setFreeId(freeId);
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.freeProductMapper.getList(mallFreeProductEntity);
        ArrayList result = new ArrayList();
        PageInfo pg = page.toPageInfo();
        if (list != null) {
            result.addAll(list.stream().map(f -> {
                MallFreeProductVo mallFreeProductVo = new MallFreeProductVo();
                BeanUtils.copyProperties((Object)f, (Object)mallFreeProductVo);
                mallFreeProductVo.setProductTypeName(SalesTypeEnum.getName(f.getProductType()));
                return mallFreeProductVo;
            }).collect(Collectors.toList()));
        }
        pg.setList(result);
        return pg;
    }

    @Override
    public PageInfo<MallFreeRuleEntityVo> getFreeRuletList(int pageNum, int pageSize, String freeId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.freeRuleMapper.getFreeRuletList(freeId);
        PageInfo pg = page.toPageInfo();
        if (pg.getList() != null) {
            pg.getList().forEach(mallFreeRuleEntityVo -> {
                mallFreeRuleEntityVo.setFreeRuleTypeName(FreeRuleTypeEnum.getName(mallFreeRuleEntityVo.getFreeRuleType()));
                if (mallFreeRuleEntityVo.getFreeRuleType().intValue() == FreeRuleTypeEnum.amount_type.getValue()) {
                    mallFreeRuleEntityVo.setFreeRuleDataName(mallFreeRuleEntityVo.getFreeRuleData());
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                } else if (mallFreeRuleEntityVo.getFreeRuleType().intValue() == FreeRuleTypeEnum.product_type.getValue()) {
                    mallFreeRuleEntityVo.setFreeRuleDataName(SalesTypeEnum.getName(Integer.parseInt(mallFreeRuleEntityVo.getFreeRuleData())));
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                    if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(mallFreeRuleEntityVo.getFreeRuleData())) {
                        MallProductEntity mallproduct = (MallProductEntity)this.productService.selectByPrimaryKey((Serializable)((Object)mallFreeRuleEntityVo.getFreeRuleDataExtend()));
                        mallFreeRuleEntityVo.setFreeRuleDataExtendName(mallproduct == null ? "" : mallproduct.getProName());
                    } else if (String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(mallFreeRuleEntityVo.getFreeRuleData())) {
                        MallProductGroupEntity MallProductGroupEntity2 = this.mallGroupService.getGroup(mallFreeRuleEntityVo.getFreeRuleDataExtend());
                        mallFreeRuleEntityVo.setFreeRuleDataExtendName(MallProductGroupEntity2 == null ? "" : MallProductGroupEntity2.getGroupName());
                    } else if (String.valueOf(SalesTypeEnum.SALES_PROMOTION.getValue()).equals(mallFreeRuleEntityVo.getFreeRuleData())) {
                        MallPromotionEntity mallPromotionEntity = this.mallPromotionService.getPromotion(mallFreeRuleEntityVo.getFreeRuleDataExtend());
                        mallFreeRuleEntityVo.setFreeRuleDataExtendName(mallPromotionEntity == null ? "" : mallPromotionEntity.getPromotionName());
                    }
                } else if (mallFreeRuleEntityVo.getFreeRuleType() == 3) {
                    mallFreeRuleEntityVo.setFreeRuleDataName("");
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                    if (!StringUtils.isEmpty((String)mallFreeRuleEntityVo.getFreeRuleDataExtend())) {
                        String cityNames = "";
                        for (String s : mallFreeRuleEntityVo.getFreeRuleDataExtend().split(",")) {
                            MallCityEntity city = this.mallCityService.getCity(Integer.parseInt(s));
                            cityNames = cityNames + (city == null ? "" : city.getCityName()) + ",";
                        }
                        mallFreeRuleEntityVo.setFreeRuleDataExtendName(cityNames);
                    }
                } else if (mallFreeRuleEntityVo.getFreeRuleType().intValue() == FreeRuleTypeEnum.vip_type.getValue()) {
                    mallFreeRuleEntityVo.setFreeRuleDataName(this.mallVipService.getRightNoStatus(mallFreeRuleEntityVo.getFreeRuleData()).getRightName());
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                } else if (mallFreeRuleEntityVo.getFreeRuleType().intValue() == FreeRuleTypeEnum.coupon_type.getValue()) {
                    mallFreeRuleEntityVo.setFreeRuleDataName(((CashticketBatchEntity)this.cashticketBatchMapper.selectByPrimaryKey((Serializable)((Object)mallFreeRuleEntityVo.getFreeRuleData()))).getTicketBatchName());
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                } else if (mallFreeRuleEntityVo.getFreeRuleType().intValue() == FreeRuleTypeEnum.prepaycard_type.getValue()) {
                    mallFreeRuleEntityVo.setFreeRuleDataName(this.mallPromotionService.getPromotion(mallFreeRuleEntityVo.getFreeRuleData()).getPromotionName());
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                } else if (mallFreeRuleEntityVo.getFreeRuleType().intValue() == FreeRuleTypeEnum.category.getValue()) {
                    mallFreeRuleEntityVo.setFreeRuleDataName(this.productCategoryInterface.getMallProductCategoryEntityById(mallFreeRuleEntityVo.getFreeRuleData()).getCategoryName());
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                } else if (mallFreeRuleEntityVo.getFreeRuleType().intValue() == FreeRuleTypeEnum.user_order_type.getValue()) {
                    mallFreeRuleEntityVo.setFreeRuleDataName(Objects.equals(mallFreeRuleEntityVo.getFreeRuleData(), "1") ? "\u65b0\u7528\u6237\u9996\u5355" : "");
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                }
            });
        }
        return pg;
    }

    @Override
    public BaseJsonVo saveOrUpdateFree(MallFreeEntity mallFreeEntity) {
        if (StringUtils.isEmpty((String)mallFreeEntity.getFreeName())) {
            return BaseJsonVo.paramError((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallFreeEntity.getBeginTime() == null || mallFreeEntity.getEndTime() == null) {
            return BaseJsonVo.paramError((String)"\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallFreeEntity.getFreeId())) {
            mallFreeEntity.setFreeId(IDGenerate.getUniqueID() + "");
            mallFreeEntity.setCreateTime(DateUtils.now());
            this.freeMapper.insertSelective(mallFreeEntity);
        } else {
            this.freeMapper.updateByPrimaryKeySelective(mallFreeEntity);
        }
        return BaseJsonVo.success((Object)mallFreeEntity);
    }

    @Override
    public BaseJsonVo saveOrUpdateFreeProduct(MallFreeProductEntity mallFreeProductEntity) {
        MallFreeProductEntity result;
        if (StringUtils.isEmpty((String)mallFreeProductEntity.getProductId())) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5546\u54c1");
        }
        if (mallFreeProductEntity.getProductCount() == null) {
            return BaseJsonVo.paramError((String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String productName = "";
        if (mallFreeProductEntity.getProductType() != null) {
            if (mallFreeProductEntity.getProductType().intValue() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                MallProductEntity productEntity = (MallProductEntity)this.productService.selectByPrimaryKey((Serializable)((Object)mallFreeProductEntity.getProductId()));
                if (productEntity == null) {
                    return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5546\u54c1");
                }
                productName = productEntity.getProName();
            } else if (mallFreeProductEntity.getProductType().intValue() == SalesTypeEnum.SALES_PROMOTION.getValue()) {
                MallPromotionEntity mallPromotionEntity = this.mallPromotionService.getPromotion(mallFreeProductEntity.getProductId());
                if (mallPromotionEntity == null) {
                    return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u4fc3\u9500");
                }
                productName = mallPromotionEntity.getPromotionName();
            } else if (mallFreeProductEntity.getProductType().intValue() == SalesTypeEnum.SALES_GROUP.getValue()) {
                MallProductGroupEntity mallProductGroupEntity = this.mallGroupService.getGroup(mallFreeProductEntity.getProductId());
                if (mallProductGroupEntity == null) {
                    return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5957\u88c5");
                }
                productName = mallProductGroupEntity.getGroupName();
            }
            if (StringUtils.isEmpty((String)productName)) {
                return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5546\u54c1\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        MallFreeProductEntity temp = new MallFreeProductEntity();
        temp.setProductId(mallFreeProductEntity.getProductId());
        temp.setFreeId(mallFreeProductEntity.getFreeId());
        if (StringUtils.isNotEmpty((String)mallFreeProductEntity.getFreeProductId()) ? !(result = (MallFreeProductEntity)this.freeProductMapper.selectByPrimaryKey((Serializable)((Object)mallFreeProductEntity.getFreeProductId()))).getProductId().equals(mallFreeProductEntity.getProductId()) && this.freeProductMapper.existsByEntity(temp) >= 1 : this.freeProductMapper.existsByEntity(temp) >= 1) {
            return BaseJsonVo.paramError((String)"\u8d60\u54c1\u91cd\u590d\u914d\u7f6e");
        }
        if (productName.length() >= 32) {
            if (productName.indexOf("(") > 0) {
                productName = productName.substring(0, productName.indexOf("\uff08") - 1);
            }
            if (productName.length() >= 32) {
                productName = productName.substring(0, 31);
            }
        }
        mallFreeProductEntity.setProductName(productName);
        if (StringUtils.isEmpty((String)mallFreeProductEntity.getFreeProductId())) {
            mallFreeProductEntity.setFreeProductId(IDGenerate.getUniqueID() + "");
            this.freeProductMapper.insertSelective(mallFreeProductEntity);
        } else {
            this.freeProductMapper.updateByPrimaryKeySelective(mallFreeProductEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteFreeProduct(String freeProductId) {
        this.freeProductMapper.deleteByPrimaryKey((Serializable)((Object)freeProductId));
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveOrUpdateFreeRule(MallFreeRuleEntity mallFreeRuleEntity) {
        MallFreeRuleEntity temp = new MallFreeRuleEntity();
        if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.product_type.getValue()) {
            temp.setFreeRuleDataExtend(mallFreeRuleEntity.getFreeRuleDataExtend());
        } else if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.amount_type.getValue() || mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.vip_type.getValue() || mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.coupon_type.getValue() || mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.category.getValue()) {
            temp.setFreeRuleData(mallFreeRuleEntity.getFreeRuleData());
        }
        temp.setFreeId(mallFreeRuleEntity.getFreeId());
        temp.setFreeRuleType(mallFreeRuleEntity.getFreeRuleType());
        if (this.freeRuleMapper.existsByEntity(temp) >= 1) {
            return BaseJsonVo.paramError((String)"\u8d60\u54c1\u89c4\u5219\u91cd\u590d\u914d\u7f6e");
        }
        if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.coupon_type.getValue()) {
            temp.setFreeId(null);
            if (this.freeRuleMapper.existsByEntity(temp) >= 1) {
                return BaseJsonVo.paramError((String)"\u4f18\u60e0\u5238\u53ea\u80fd\u5173\u8054\u4e00\u4e2a\u8d60\u54c1");
            }
            this.setCashBatchFreeStatus(mallFreeRuleEntity, 1);
        }
        if (StringUtils.isEmpty((String)mallFreeRuleEntity.getFreeRuleId())) {
            mallFreeRuleEntity.setFreeRuleId(IDGenerate.getUniqueID() + "");
            this.freeRuleMapper.insertSelective(mallFreeRuleEntity);
        } else {
            this.memcachedService.delete("MallFreeService.getMallFreeRule", mallFreeRuleEntity.getFreeId());
            this.freeRuleMapper.updateByPrimaryKeySelective(mallFreeRuleEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    private void setCashBatchFreeStatus(MallFreeRuleEntity freeRuleEntity, int cashFreeStatus) {
        this.logger.info("\u8bbe\u7f6e\u4f18\u60e0\u5238\u6279\u6b21:{},\u8d60\u54c1\u5238\u7c7b\u578b:{}", (Object)freeRuleEntity.getFreeRuleData(), (Object)cashFreeStatus);
        CashticketBatchEntity cashticketBatchEntity = new CashticketBatchEntity();
        cashticketBatchEntity.setTicketBatchId(freeRuleEntity.getFreeRuleData());
        cashticketBatchEntity.setFreeCash(cashFreeStatus);
        this.cashticketBatchMapper.updateByPrimaryKeySelective(cashticketBatchEntity);
    }

    @Override
    public BaseJsonVo deleteFreeRule(String freeRuleId) {
        MallFreeRuleEntity freeRuleEntity = (MallFreeRuleEntity)this.freeRuleMapper.selectByPrimaryKey((Serializable)((Object)freeRuleId));
        if (freeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.coupon_type.getValue()) {
            this.setCashBatchFreeStatus(freeRuleEntity, 0);
        }
        this.freeRuleMapper.deleteByPrimaryKey((Serializable)((Object)freeRuleId));
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public MallFreeEntity selectByPrimaryKey(String freeId) {
        return (MallFreeEntity)this.freeMapper.selectByPrimaryKey((Serializable)((Object)freeId));
    }
}

