/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallFullcutDetailMapper;
import cc.lechun.mall.dao.sales.MallGroupProductMapper;
import cc.lechun.mall.dao.sales.MallProductMapper;
import cc.lechun.mall.entity.sales.MallFullcutDetailEntity;
import cc.lechun.mall.entity.sales.MallFullcutEntity;
import cc.lechun.mall.entity.sales.MallGroupProductEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.iservice.sales.MallFullcutDetailInterface;
import cc.lechun.mall.iservice.sales.MallFullcutInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallFullcutDetailService
extends BaseService
implements MallFullcutDetailInterface {
    @Autowired
    private MallFullcutDetailMapper fullcutDetailMapper;
    @Autowired
    private MallGroupProductMapper groupInterface;
    @Autowired
    private MallProductMapper productInterface;
    @Autowired
    private MallFullcutInterface fullcutInterface;

    @Override
    public BaseJsonVo checkGroup(String fullcutId) {
        List<MallFullcutDetailEntity> details = this.getFullcutDetails(fullcutId);
        if ((details = details.stream().filter(c -> c.getGroupType() != 4).collect(Collectors.toList())).size() > 0) {
            for (MallFullcutDetailEntity detailEntity : details) {
                if (detailEntity.getGroupId().isEmpty()) continue;
                List<MallGroupProductEntity> productEntities = this.groupInterface.getListByParam(detailEntity.getGroupId());
                int transport = 1;
                int i = 0;
                for (MallGroupProductEntity gp : productEntities) {
                    MallProductEntity productEntity = (MallProductEntity)this.productInterface.selectByPrimaryKey((Serializable)((Object)gp.getProId()));
                    if (productEntity == null) continue;
                    if (i == 0) {
                        transport = productEntity.getTransportType();
                        ++i;
                    }
                    if (transport == productEntity.getTransportType()) continue;
                    return BaseJsonVo.error((String)("\u5957\u88c5[" + gp.getGroupName() + "]\u4e2d\u5305\u542b\u5e38\u6e29\u54c1\u548c\u51b7\u94fe\u54c1\uff0c\u7cfb\u7edf\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u5957\u88c5\u6ee1\u51cf"));
                }
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<MallFullcutDetailEntity> getFullcutDetails(String fullcutId) {
        MallFullcutDetailEntity fullcutDetailEntity = new MallFullcutDetailEntity();
        fullcutDetailEntity.setFullCutId(fullcutId);
        List fullcutDetailEntities = this.fullcutDetailMapper.getList(fullcutDetailEntity);
        return fullcutDetailEntities;
    }

    @Override
    public boolean isExistsDetail(String fullcutId) {
        MallFullcutDetailEntity fullcutDetailEntity = new MallFullcutDetailEntity();
        fullcutDetailEntity.setFullCutId(fullcutId);
        Integer count = this.fullcutDetailMapper.existsByEntity(fullcutDetailEntity);
        return count > 0;
    }

    @Override
    public PageInfo getFullCutDetailList(int pageNum, int pageSize, String fullcutId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.fullcutDetailMapper.getFullCutList(fullcutId);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo saveMallFullcutDetail(MallFullcutDetailEntity mallFullcutDetailEntity) {
        MallFullcutDetailEntity query = new MallFullcutDetailEntity();
        MallFullcutEntity fullcutEntity = this.fullcutInterface.getFullCutEntity(mallFullcutDetailEntity.getFullCutId());
        if (fullcutEntity == null) {
            return BaseJsonVo.error((String)"\u6ee1\u51cf\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        if (fullcutEntity.getFullClass() == 1 && mallFullcutDetailEntity.getGroupType() == 2) {
            return BaseJsonVo.paramError((String)"\u5168\u5c40\u6ee1\u51cf\u4e0d\u652f\u6301\u7ec4\u5408");
        }
        if (mallFullcutDetailEntity.getGroupType() == 2) {
            if (StringUtils.isEmpty((String)mallFullcutDetailEntity.getGroupId())) {
                return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u7ec4\u5408");
            }
            query.setFullCutId(mallFullcutDetailEntity.getFullCutId());
            query.setGroupId(mallFullcutDetailEntity.getGroupId());
            if (this.fullcutDetailMapper.getList(query).size() > 0) {
                return BaseJsonVo.paramError((String)"\u5df2\u5b58\u5728");
            }
        } else if (mallFullcutDetailEntity.getGroupType() == 4) {
            if (StringUtils.isEmpty((String)mallFullcutDetailEntity.getProductId())) {
                return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5355\u54c1");
            }
            query.setFullCutId(mallFullcutDetailEntity.getFullCutId());
            query.setProductId(mallFullcutDetailEntity.getProductId());
            if (this.fullcutDetailMapper.getList(query).size() > 0) {
                return BaseJsonVo.paramError((String)"\u5df2\u5b58\u5728");
            }
        } else {
            return BaseJsonVo.paramError((String)"\u4fdd\u5b58\u9519\u8bef");
        }
        mallFullcutDetailEntity.setFullCutDetailId(IDGenerate.getUniqueID() + "");
        this.fullcutDetailMapper.insertSelective(mallFullcutDetailEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteMallFullcutDetail(String fullCutDetailId) {
        this.fullcutDetailMapper.deleteByPrimaryKey((Serializable)((Object)fullCutDetailId));
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveFullProductSort(MallFullcutDetailEntity detailEntity) {
        if (StringUtils.isEmpty((String)detailEntity.getFullCutDetailId())) {
            return BaseJsonVo.error((String)"\u4e3b\u952e\u4e3a\u7a7a");
        }
        if (detailEntity.getSort() == null) {
            detailEntity.setSort(0);
        }
        this.fullcutDetailMapper.updateByPrimaryKeySelective(detailEntity);
        return BaseJsonVo.success((Object)"");
    }
}

