/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.dictionary.DictionaryMapper;
import cc.lechun.mall.dao.sales.MallFullcutMapper;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.sales.FullCutTypeEnum;
import cc.lechun.mall.entity.sales.MallFullcutDetailEntity;
import cc.lechun.mall.entity.sales.MallFullcutEntity;
import cc.lechun.mall.entity.sales.MallFullcutEntityExtend;
import cc.lechun.mall.entity.sales.MallFullcutVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.sales.MallFullcutInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.service.sales.MallFullcutDetailService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallFullcutService
extends BaseService
implements MallFullcutInterface {
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallFullcutMapper fullcutMapper;
    @Autowired
    private MallFullcutDetailService mallFullcutDetailService;
    @Autowired
    private MallProductInterface productService;
    @Autowired
    private DictionaryMapper dictionaryMapper;
    @Autowired
    private DictionaryInterface dictionaryInterface;

    public MallFullcutEntity getFullcutEntity(String fullcutId) {
        return (MallFullcutEntity)this.fullcutMapper.selectByPrimaryKey((Serializable)((Object)fullcutId));
    }

    @Override
    public BaseJsonVo getEnableFullcut(MallShoppingcartVO cart) {
        return this.getEnableFullcut(cart.getBindCode());
    }

    @Override
    public BaseJsonVo getEnableFullcut(String bindCode) {
        if (bindCode == null || bindCode.isEmpty()) {
            return BaseJsonVo.paramError((String)"\u7ed1\u5b9a\u7801\u4e0d\u5b58\u5728");
        }
        String activeNo = this.activeInterface.getActiveNoByBindCode(bindCode);
        if (!this.activeInterface.checkActiveEnable(activeNo).isSuccess()) {
            return BaseJsonVo.paramError((String)"\u6d3b\u52a8\u5df2\u8fc7\u671f");
        }
        MallFullcutVo fullcutVo = this.fullcutMapper.getSingleEntityByTime(activeNo, DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"));
        if (fullcutVo == null && (fullcutVo = this.fullcutMapper.getSingleEntityByTime(bindCode, DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"))) == null) {
            return BaseJsonVo.paramError((String)"\u6d3b\u52a8\u6682\u65f6\u65e0\u6cd5\u53c2\u4e0e");
        }
        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)fullcutVo.getEndTime());
        fullcutVo.setSeconds(seconds);
        fullcutVo.setSecond(seconds / 3600L);
        fullcutVo.setMinute(seconds % 3600L / 60L);
        fullcutVo.setHour(seconds % 3600L % 60L);
        return BaseJsonVo.success((Object)fullcutVo);
    }

    @Override
    public boolean checkFullcut(MallFullcutVo fullcutVo, List<MallFullcutDetailEntity> detailEntities, MallShoppingcartVO shoppingcartVO) {
        BigDecimal[] count = new BigDecimal[]{BigDecimal.valueOf(0L)};
        List<MallProductVO> productVOs = shoppingcartVO.getProducts();
        detailEntities.forEach(f -> {
            MallProductVO productVO;
            List list = productVOs.stream().filter(c -> c.getProId().equals(f.getProductId())).collect(Collectors.toList());
            if (list != null && list.size() > 0 && (productVO = (MallProductVO)list.get(0)) != null && StringUtils.isEmpty((String)productVO.getFullCutId())) {
                productVO.setFullCutId(fullcutVo.getFullCutId());
                productVO.setUseCoupon(fullcutVo.getEnableUseCoupon());
                count[0] = fullcutVo.getType() == 1 ? PriceUtils.add((BigDecimal)count[0], (BigDecimal)BigDecimal.valueOf(productVO.getCount().intValue())) : PriceUtils.add((BigDecimal)count[0], (BigDecimal)productVO.getFactPrice().multiply(BigDecimal.valueOf(productVO.getCount().intValue())));
            }
        });
        return count[0].doubleValue() >= (double)fullcutVo.getCutNumber().intValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public BaseJsonVo saveOrUpdateFullCutList(MallFullcutEntity mallFullcutEntity, Integer isFreeFreight, String userId) {
        if (mallFullcutEntity.getBeginTime() == null || mallFullcutEntity.getEndTime() == null) {
            return BaseJsonVo.paramError((String)"\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallFullcutEntity.getBeginTime().after(mallFullcutEntity.getEndTime())) {
            return BaseJsonVo.paramError((String)"\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        if (StringUtils.isEmpty((String)mallFullcutEntity.getCutRuleName())) {
            return BaseJsonVo.paramError((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallFullcutEntity.getType() != 2 && mallFullcutEntity.getFullClass() == 1) {
            return BaseJsonVo.paramError((String)"\u5168\u5c40\u6ee1\u51cf\u53ea\u652f\u6301\u6309\u91d1\u989d\u51cf");
        }
        if (mallFullcutEntity.getType() == 2 && mallFullcutEntity.getCutRule() == 4) {
            return BaseJsonVo.paramError((String)"\u6ee1\u51cf\u7c7b\u578b\u4e3a\u91d1\u989d\u65f6\uff0c\u6ee1\u51cf\u89c4\u5219\u4e0d\u652f\u6301\u6309\u5546\u54c1\u51cf");
        }
        if (mallFullcutEntity.getFullNumber() < mallFullcutEntity.getCutNumber()) {
            return BaseJsonVo.paramError((String)("\u6682\u4e0d\u652f\u6301\u6ee1[" + mallFullcutEntity.getFullNumber() + "]\u51cf[" + mallFullcutEntity.getCutNumber() + "]"));
        }
        if (mallFullcutEntity.getType().intValue() == FullCutTypeEnum.amount_and_num.getValue()) {
            mallFullcutEntity.setFullNumber(mallFullcutEntity.getLimitCount());
        }
        if (StringUtils.isEmpty((String)mallFullcutEntity.getFullCutId())) {
            mallFullcutEntity.setFullCutId(IDGenerate.getUniqueID() + "");
            mallFullcutEntity.setCreateTime(DateUtils.now());
            ActiveEntity activeEntity = new ActiveEntity();
            activeEntity.setPayamount(new BigDecimal(0));
            activeEntity.setActiveName(mallFullcutEntity.getFullCutName() + "\u6d3b\u52a8");
            activeEntity.setActiveType(11);
            activeEntity.setBeginTime(mallFullcutEntity.getBeginTime());
            activeEntity.setEndTime(mallFullcutEntity.getEndTime());
            activeEntity.setCityId(0);
            activeEntity.setCreateTime(DateUtils.now());
            activeEntity.setDeptId(9);
            activeEntity.setInviteNum(0);
            activeEntity.setJoinNum(0);
            activeEntity.setKeywordId(0);
            activeEntity.setPayKeywordId(0);
            activeEntity.setPlatformId(1);
            activeEntity.setBindCode(IDGenerate.getUniqueIdStr());
            activeEntity.setPlatformGroupId(mallFullcutEntity.getPlatformGroupId());
            activeEntity.setStatus(mallFullcutEntity.getStatus());
            activeEntity.setTjType(1);
            activeEntity.setUseCoupon(1);
            activeEntity.setCreateUserid(userId);
            BaseJsonVo baseJsonVo = this.activeInterface.saveActive(activeEntity, null);
            if (!baseJsonVo.isSuccess()) return baseJsonVo;
            mallFullcutEntity.setActiveNo(activeEntity.getBindCode());
            this.fullcutMapper.insertSelective(mallFullcutEntity);
            this.saveFreeFreight(mallFullcutEntity, isFreeFreight);
            return BaseJsonVo.success((Object)mallFullcutEntity.getFullCutId());
        } else {
            List<MallFullcutDetailEntity> fullcutDetails;
            if (mallFullcutEntity.getCutRule() == 4 && (fullcutDetails = this.mallFullcutDetailService.getFullcutDetails(mallFullcutEntity.getFullCutId())).size() > 0 && fullcutDetails.stream().filter(c -> c.getGroupType() != 4).count() > 0L) {
                return BaseJsonVo.paramError((String)"\u6ee1\u51cf\u4e2d\u5b58\u5728\u5957\u88c5\uff0c\u6ee1\u51cf\u89c4\u5219\u4e0d\u652f\u6301\u6309\u5546\u54c1\u51cf");
            }
            BaseJsonVo baseJsonVo = this.mallFullcutDetailService.checkGroup(mallFullcutEntity.getFullCutId());
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            this.fullcutMapper.updateByPrimaryKeySelective(mallFullcutEntity);
            this.saveFreeFreight(mallFullcutEntity, isFreeFreight);
            ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(mallFullcutEntity.getActiveNo());
            if (activeEntity == null) return BaseJsonVo.success((Object)mallFullcutEntity.getFullCutId());
            activeEntity.setBeginTime(mallFullcutEntity.getBeginTime());
            activeEntity.setEndTime(mallFullcutEntity.getEndTime());
            activeEntity.setStatus(mallFullcutEntity.getStatus());
            baseJsonVo = this.activeInterface.saveActive(activeEntity, null);
            if (!baseJsonVo.isSuccess()) return BaseJsonVo.success((Object)mallFullcutEntity.getFullCutId());
        }
        return BaseJsonVo.success((Object)mallFullcutEntity.getFullCutId());
    }

    private void saveFreeFreight(MallFullcutEntity mallFullcutEntity, Integer isFreeFreight) {
        DictionaryEntity search = new DictionaryEntity();
        search.setDictionaryName(mallFullcutEntity.getActiveNo());
        search.setDictionaryTypeId(104);
        search.setStatus(Short.parseShort("1"));
        search = (DictionaryEntity)this.dictionaryMapper.getSingle(search);
        if (Objects.equals(isFreeFreight, 1)) {
            if (search == null) {
                this.dictionaryInterface.saveDictionary(mallFullcutEntity.getPlatformGroupId(), 104, mallFullcutEntity.getActiveNo(), mallFullcutEntity.getActiveNo(), 1, "\u6ee1\u51cf\uff1a" + mallFullcutEntity.getFullCutName(), 1);
            } else {
                this.dictionaryInterface.updateDictionary(search.getDictionaryId(), mallFullcutEntity.getActiveNo(), mallFullcutEntity.getActiveNo(), 1, "\u6ee1\u51cf\uff1a" + mallFullcutEntity.getFullCutName(), 1);
            }
        } else if (search != null) {
            this.dictionaryInterface.deleteDictionary(search.getDictionaryId(), mallFullcutEntity.getPlatformGroupId());
        }
    }

    @Override
    public PageInfo getFullCutList(int pageNum, int pageSize, int platformGroupId, String fullCutName, Integer fullClass, Integer status) {
        MallFullcutEntity mallFullcutEntity = new MallFullcutEntity();
        mallFullcutEntity.setPlatformGroupId(platformGroupId);
        if (!StringUtils.isEmpty((String)fullCutName)) {
            mallFullcutEntity.setFullCutName(SqlUtils.sqlLike((String)fullCutName, (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        mallFullcutEntity.setFullClass(fullClass);
        if (!Integer.valueOf(-1).equals(status)) {
            mallFullcutEntity.setStatus(status);
        }
        DictionaryEntity search = new DictionaryEntity();
        search.setDictionaryTypeId(104);
        search.setStatus(Short.parseShort("1"));
        List dics = this.dictionaryMapper.getList(search);
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        page.setOrderBy("CREATE_TIME desc ");
        List list = this.fullcutMapper.getList(mallFullcutEntity);
        List result = list.stream().map(f -> {
            MallFullcutEntityExtend mallFullcutEntityExtend = new MallFullcutEntityExtend();
            BeanUtils.copyProperties((Object)f, (Object)mallFullcutEntityExtend);
            mallFullcutEntityExtend.setIsFreeFreight(0);
            if (CollectionUtils.isNotEmpty((Collection)dics)) {
                for (DictionaryEntity d : dics) {
                    if (d.getDictionaryName() == null || d.getDictionaryName().isEmpty() || !f.getActiveNo().contains(d.getDictionaryName())) continue;
                    mallFullcutEntityExtend.setIsFreeFreight(1);
                }
            }
            return mallFullcutEntityExtend;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)page, (Object)pageInfo);
        pageInfo.setList(result);
        return pageInfo;
    }

    @Override
    public MallFullcutEntity getFullCutEntity(String fullCutid) {
        return (MallFullcutEntity)this.fullcutMapper.selectByPrimaryKey((Serializable)((Object)fullCutid));
    }

    @Override
    public MallFullcutEntityExtend getMallFullcutEntityExtend(String fullCutid) {
        MallFullcutEntity mallFullcutEntity = (MallFullcutEntity)this.fullcutMapper.selectByPrimaryKey((Serializable)((Object)fullCutid));
        MallFullcutEntityExtend mallFullcutEntityExtend = new MallFullcutEntityExtend();
        BeanUtils.copyProperties((Object)mallFullcutEntity, (Object)mallFullcutEntityExtend);
        DictionaryEntity search = new DictionaryEntity();
        search.setDictionaryName(mallFullcutEntity.getActiveNo());
        search.setDictionaryTypeId(104);
        search.setStatus(Short.parseShort("1"));
        search = (DictionaryEntity)this.dictionaryMapper.getSingle(search);
        mallFullcutEntityExtend.setIsFreeFreight(search != null ? 1 : 0);
        return mallFullcutEntityExtend;
    }

    @Override
    public BaseJsonVo addFullCutAllColdProducts(String fullCutId, int transPort) {
        if (StringUtils.isEmpty((String)fullCutId)) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6ee1\u51cf\u6d3b\u52a8");
        }
        List<MallProductEntity> productEntities = this.productService.getOnProductList(1000);
        productEntities = productEntities.stream().filter(c -> c.getTransportType() == transPort).collect(Collectors.toList());
        List<MallFullcutDetailEntity> detailEntities = this.mallFullcutDetailService.getFullcutDetails(fullCutId);
        detailEntities = detailEntities.stream().filter(c -> c.getGroupType() == 4).collect(Collectors.toList());
        for (MallProductEntity p : productEntities) {
            if (detailEntities.stream().filter(c -> p.getProId().equals(c.getProductId())).count() != 0L) continue;
            MallFullcutDetailEntity detailEntity = new MallFullcutDetailEntity();
            detailEntity.setFullCutId(fullCutId);
            detailEntity.setGroupType(4);
            detailEntity.setProductId(p.getProId());
            detailEntity.setFullCutDetailId(IDGenerate.getUniqueIdStr());
            this.mallFullcutDetailService.saveMallFullcutDetail(detailEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo delFullCutAllProducts(String fullCutId) {
        if (StringUtils.isEmpty((String)fullCutId)) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6ee1\u51cf\u6d3b\u52a8");
        }
        List<MallFullcutDetailEntity> detailEntities = this.mallFullcutDetailService.getFullcutDetails(fullCutId);
        for (MallFullcutDetailEntity d : detailEntities) {
            this.mallFullcutDetailService.deleteMallFullcutDetail(d.getFullCutDetailId());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo check(MallFullcutEntity entity) {
        if (!Integer.valueOf(1).equals(entity.getStatus())) {
            return BaseJsonVo.error((String)"\u6ee1\u51cf\u5df2\u7981\u7528");
        }
        if (entity.getBeginTime().after(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u6ee1\u51cf\u672a\u5f00\u59cb.");
        }
        if (entity.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u6ee1\u51cf\u5df2\u7ed3\u675f");
        }
        if (!this.mallFullcutDetailService.isExistsDetail(entity.getFullCutId())) {
            return BaseJsonVo.error((String)"\u6ee1\u51cf\u672a\u914d\u7f6e\u4ea7\u54c1");
        }
        return BaseJsonVo.success((Object)"");
    }
}

