/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.apiinvoke.mall.YouShuProductApiInvoke;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.sales.MallProductCategoryMapper;
import cc.lechun.mall.entity.sales.MallProductCategoryEntity;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallProductCategoryService
implements MallProductCategoryInterface {
    @Autowired
    private MallProductCategoryMapper categoryMapper;
    @Autowired
    private YouShuProductApiInvoke youShuProductApi;

    @Override
    public BaseJsonVo findAllCategory(String token) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        List<MallProductCategoryEntity> list = this.categoryMapper.findAllCategory(token);
        if (list != null && list.size() > 0) {
            BaseJsonVo2.setValue(list);
        } else {
            BaseJsonVo2.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return BaseJsonVo2;
    }

    @Override
    public PageInfo getCategoryList(int pageNum, int pageSize, MallProductCategoryEntity productCategoryEntity) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        page.setOrderBy(" SORT_ORDER ");
        List<MallProductCategoryEntity> tempList = this.categoryMapper.getCategoryList(productCategoryEntity);
        PageInfo pageInfo = page.toPageInfo();
        List<Object> firstCategoryList = new ArrayList();
        firstCategoryList = tempList.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getParentId(), "0")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(firstCategoryList)) {
            ArrayList list = new ArrayList();
            firstCategoryList.forEach(p -> {
                list.add(p);
                List<MallProductCategoryEntity> secondCategoryList = tempList.stream().filter(pp -> Objects.equals(pp.getParentId(), p.getCategoryId())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(secondCategoryList)) {
                    secondCategoryList.forEach(second -> {
                        second.setCategoryName("--" + second.getCategoryName());
                        list.add(second);
                    });
                }
            });
            pageInfo.setList(list);
        }
        return pageInfo;
    }

    @Override
    public MallProductCategoryEntity getMallProductCategoryEntityById(String id) {
        return (MallProductCategoryEntity)this.categoryMapper.selectByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public BaseJsonVo importCategory(Integer platformGroupId) {
        return this.youShuProductApi.importCategoryToYouShu(platformGroupId);
    }
}

