/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallProductPriceMapper;
import cc.lechun.mall.entity.sales.MallProductPriceEntity;
import cc.lechun.mall.iservice.sales.MallProductPriceInterface;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallProductPriceService
extends BaseService<MallProductPriceEntity, Integer>
implements MallProductPriceInterface {
    @Resource
    private MallProductPriceMapper mallProductPriceMapper;
    @Autowired
    RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo saveProductPrice(MallProductPriceEntity mallProductPriceEntity) {
        RLock lock = this.redissonClient.getLock("ProductPrice:" + mallProductPriceEntity.getProId() + mallProductPriceEntity.getProType() + mallProductPriceEntity.getPriceType());
        try {
            boolean res = lock.tryLock(100L, 10L, TimeUnit.SECONDS);
            if (res) {
                if (mallProductPriceEntity.getPriceId() == null || mallProductPriceEntity.getPriceId() == 0) {
                    this.mallProductPriceMapper.insertSelective(mallProductPriceEntity);
                } else {
                    this.mallProductPriceMapper.updateByPrimaryKeySelective(mallProductPriceEntity);
                }
                BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
                return baseJsonVo;
            }
            this.logger.error("\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u653e\u5f03\u6267\u884c...");
        }
        catch (Exception ex) {
            this.logger.error("\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u653e\u5f03\u6267\u884c...", (Throwable)ex);
        }
        finally {
            lock.unlock();
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo getProductPriceList(MallProductPriceEntity mallProductPriceEntity) {
        return null;
    }
}

