/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallPromotionProductMapper;
import cc.lechun.mall.entity.sales.MallGroupProductEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallPromotionProductService
extends BaseService
implements MallPromotionProductInterface {
    @Autowired
    private MallPromotionProductMapper promotionProductMapper;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public MallPromotionProductEntity getPromotionProduct(String promotionId, String itemId) {
        MallPromotionProductEntity promotionProductEntity = new MallPromotionProductEntity();
        promotionProductEntity.setPromotionId(promotionId);
        promotionProductEntity.setProductId(itemId);
        promotionProductEntity = (MallPromotionProductEntity)this.promotionProductMapper.getSingle(promotionProductEntity);
        return promotionProductEntity;
    }

    @Override
    public MallPromotionProductEntity getPromotionProductEntity(@ParameterValueKeyProvider String promotionId) {
        return this.promotionProductMapper.getPromotionProducts(promotionId);
    }

    @Override
    @ReadThroughSingleCache(namespace="promotionProductEntity", expiration=3600)
    public MallPromotionProductEntity getPromotionProduct(@ParameterValueKeyProvider String promotionProductId) {
        return (MallPromotionProductEntity)this.promotionProductMapper.selectByPrimaryKey((Serializable)((Object)promotionProductId));
    }

    @Override
    public void addPromotionProduct(MallPromotionProductEntity mallPromotionProductEntity) {
        this.removeCache(mallPromotionProductEntity.getPromotionId(), "");
        this.promotionProductMapper.insert(mallPromotionProductEntity);
    }

    @Override
    public void updatePromotionProduct(MallPromotionProductEntity mallPromotionProductEntity) {
        this.removeCache(mallPromotionProductEntity.getPromotionId(), mallPromotionProductEntity.getPromotionProductId());
        this.promotionProductMapper.updateByPrimaryKeySelective(mallPromotionProductEntity);
    }

    private void removeCache(String promotionId, String promotionProductId) {
        this.memcachedService.delete("promotionProductEntity", promotionProductId);
        this.memcachedService.delete("promotionProductEntity1", promotionId);
    }

    @Override
    public void removeCache(String promotionId) {
        MallPromotionProductEntity entity = this.promotionProductMapper.getPromotionProducts(promotionId);
        if (entity != null) {
            this.memcachedService.delete("promotionProductEntity", entity.getPromotionProductId());
        }
        this.memcachedService.delete("promotionProductEntity1", promotionId);
    }

    @Override
    public int getTransportType(String promotionId) {
        int transportType = TransportTypeEnum.COLD_CHAIN.getValue();
        MallPromotionProductEntity promotionProductEntity = this.getPromotionProductEntity(promotionId);
        if (promotionProductEntity != null) {
            List<MallGroupProductEntity> groupProducts;
            MallProductEntity productEntity;
            if (promotionProductEntity.getProductType().equals(String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue())) && (productEntity = this.productInterface.getProduct(promotionProductEntity.getProductId())) != null) {
                transportType = productEntity.getTransportType();
            }
            if (promotionProductEntity.getProductType().equals(String.valueOf(SalesTypeEnum.SALES_GROUP.getValue())) && (groupProducts = this.groupInterface.getGroupProducts(promotionProductEntity.getProductId())) != null && groupProducts.size() > 0) {
                for (MallGroupProductEntity g : groupProducts) {
                    MallProductEntity productEntity2 = this.productInterface.getProduct(g.getProId());
                    if (productEntity2 == null || productEntity2.getTransportType().intValue() != TransportTypeEnum.COLD_CHAIN.getValue()) continue;
                    return transportType;
                }
                transportType = TransportTypeEnum.NORMAL_CHAIN.getValue();
            }
        }
        return transportType;
    }

    @Override
    public List<MallPromotionProductEntity> getNotFreePromotionProducts() {
        return this.promotionProductMapper.getNotFreePromotionProducts();
    }
}

