/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.dictionary.DictionaryMapper;
import cc.lechun.mall.dao.sales.MallPromotionMapper;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardItemEntity;
import cc.lechun.mall.entity.sales.MallGroupProductVo;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionBuyEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionTimeEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallSaleRecommendEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionBuyInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionTimeInterface;
import cc.lechun.mall.iservice.sales.MallSaleRecommendInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MallPromotionService
extends BaseService
implements MallPromotionInterface {
    @Autowired
    ActiveInterface activeInterface;
    @Autowired
    MallPromotionMapper promotionMapper;
    @Autowired
    MallProductInterface productService;
    @Autowired
    MallGroupInterface groupService;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    MallPromotionBuyInterface promotionBuyInterface;
    @Autowired
    MallPromotionProductInterface promotionProductInterface;
    @Autowired
    MallSaleRecommendInterface saleRecommendInterface;
    @Autowired
    MallPromotionTimeInterface promotionTimeService;
    @Autowired
    MemcachedService memcachedService;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Lazy
    @Autowired
    PrepayCardBatchInterface cardBatchInterface;
    @Autowired
    private PrepayCardItemInterface prepayCardItemInterface;
    @Resource
    private DictionaryMapper dictionaryMapper;

    @Override
    public BaseJsonVo setOnlineOrOffLine(String promotionId, MallUserEntity user) {
        MallPromotionEntity promotionEntity = this.promotionInterface.getPromotion(promotionId);
        boolean miaoSha = false;
        BaseJsonVo<MallPromotionVO> baseJson = this.buildPromotionVO(promotionEntity.getPromotionId(), 1, false);
        if (baseJson.isSuccess() && (((MallPromotionVO)baseJson.getValue()).getPromotionPrice().doubleValue() <= 1.0 || ((MallPromotionVO)baseJson.getValue()).getPromotionName().indexOf("\u79d2\u6740") >= 0)) {
            miaoSha = true;
        }
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        if (promotionEntity.getStatus() != null && promotionEntity.getStatus() == 0) {
            baseJsonVo = this.checkPromotionProduct(promotionEntity);
        }
        if (baseJsonVo.isSuccess()) {
            promotionEntity.setStatus(promotionEntity.getStatus() == 1 ? 0 : 1);
            baseJsonVo = this.updatePromotion(promotionEntity);
            if (miaoSha) {
                PrepayCardBatchEntity query = new PrepayCardBatchEntity();
                query.setCardType(((MallPromotionVO)baseJson.getValue()).getSelfModeType() == 1 ? 4 : 5);
                List list = this.cardBatchInterface.getList(query);
                String message = "\u4fdd\u5b58\u6210\u529f";
                for (PrepayCardBatchEntity prepayCardBatchEntity : list) {
                    PrepayCardItemEntity entity = new PrepayCardItemEntity();
                    entity.setItemId(promotionEntity.getPromotionId());
                    entity.setItemType(SalesTypeEnum.SALES_PROMOTION.getValue());
                    entity.setOriginPrice(((MallPromotionVO)baseJson.getValue()).getOriginPrice());
                    entity.setSaleValue(((MallPromotionVO)baseJson.getValue()).getPromotionPrice());
                    entity.setUnitPrice(((MallPromotionVO)baseJson.getValue()).getPromotionPrice());
                    entity.setCardBatchId(prepayCardBatchEntity.getBatchId());
                    entity.setBatchType(prepayCardBatchEntity.getBatchType());
                    entity.setCardType(query.getCardType());
                    entity.setStatus(promotionEntity.getStatus());
                    this.prepayCardItemInterface.saveCardItem(entity, user.getUserNick());
                    message = message + promotionEntity.getPromotionName() + "\u52a0\u5165" + prepayCardBatchEntity.getBatchName() + "\u4e2d,";
                }
                this.logger.info("\u4e0a\u67b6/\u4e0b\u67b6 \u79d2\u6740:{}", (Object)message);
            }
        }
        return baseJsonVo;
    }

    private BaseJsonVo<String> checkPromotionProduct(MallPromotionEntity promotion) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo getPromotionList(int pageNum, int length, MallPromotionEntity mallPromotionEntity, Integer platformGroupId) {
        Page page = PageHelper.startPage((int)pageNum, (int)length);
        String promotionName = mallPromotionEntity.getPromotionName();
        Integer status = mallPromotionEntity.getStatus();
        Date beginTime = mallPromotionEntity.getBeginTime();
        Date endTime = mallPromotionEntity.getEndTime();
        List<MallPromotionEntity> pros = this.promotionMapper.getCmsList(mallPromotionEntity.getPromotionId(), promotionName, status, beginTime, endTime, platformGroupId);
        ArrayList list = new ArrayList();
        pros.forEach(promotion -> {
            MallPromotionProductEntity promotionProductEntity;
            Map map = ObjectConvert.beanToMap((Object)promotion);
            MallPromotionTimeEntity timeEntity = this.promotionTimeService.getSingleEntity(promotion.getPromotionId());
            if (timeEntity != null) {
                Date beginTimeType = timeEntity.getBeginTime();
                Date endTimeType = timeEntity.getEndTime();
                if (promotion.getPromotionType() == 2) {
                    beginTimeType = DateUtils.currentDate();
                    endTimeType = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
                }
                int buyCount = this.promotionBuyInterface.getPromotionBuyCount(promotion.getPromotionId(), beginTimeType, endTimeType);
                map.put("usedCount", String.valueOf(buyCount));
                map.put("balanceCount", String.valueOf(timeEntity.getLimitCount() - buyCount));
            }
            if ((promotionProductEntity = this.promotionProductInterface.getPromotionProductEntity(promotion.getPromotionId())) != null) {
                map.put("limitCount", String.valueOf(promotionProductEntity.getLimitCount()));
                map.put("promotionProductId", promotionProductEntity.getPromotionProductId());
                map.put("promotionPrice", promotionProductEntity.getPromotionPrice());
                map.put("originPrice", promotionProductEntity.getOriginPrice());
                StringBuilder productDescBuilder = new StringBuilder();
                if ("2".equals(promotionProductEntity.getProductType())) {
                    List<MallGroupProductVo> groupProductList = this.groupService.getGroupProductList(promotionProductEntity.getProductId());
                    groupProductList.forEach(groupProduct -> {
                        MallProductEntity product = this.productService.getProduct(groupProduct.getProId());
                        productDescBuilder.append((StringUtils.isNotEmpty((String)product.getProNameSx()) ? product.getProNameSx() : product.getProName()) + "*" + groupProduct.getProCount() + ",");
                    });
                } else if ("4".equals(promotionProductEntity.getProductType())) {
                    MallProductEntity product = this.productService.getProduct(promotionProductEntity.getProductId());
                    productDescBuilder.append((StringUtils.isNotEmpty((String)product.getProNameSx()) ? product.getProNameSx() : product.getProName()) + "*1");
                }
                String productDesc = productDescBuilder.toString();
                if (productDesc.endsWith(",")) {
                    productDesc = productDesc.substring(0, productDesc.length() - 1);
                }
                map.put("productDesc", productDesc);
            } else {
                map.put("promotionProductId", "");
            }
            String picUrl = null;
            try {
                Map<String, List<String>> picMap = this.picService.getProductPicUrlMap(promotion.getPromotionId(), SalesTypeEnum.SALES_PROMOTION.getValue());
                if (picMap == null || promotion.getCreateTime().compareTo(DateUtils.getDateFromString((String)"2021-07-22 17:00:00")) < 0) {
                    picMap = this.picService.getProductPicUrlMap(promotionProductEntity.getPromotionProductId(), SalesTypeEnum.SALES_PROMOTION.getValue());
                }
                picUrl = "";
                if (picMap != null && picMap.size() > 0 && picMap.containsKey("picPromotionSmall") && CollectionUtils.isNotEmpty((Collection)picMap.get("picPromotionSmall")) && StringUtils.isNotEmpty((String)picMap.get("picPromotionSmall").get(0))) {
                    picUrl = picMap.get("picPromotionSmall").get(0);
                }
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u4fc3\u9500\u56fe\u7247\u5931\u8d25", (Throwable)e);
            }
            map.put("picUrl", picUrl);
            DictionaryEntity search = new DictionaryEntity();
            search.setDictionaryName(promotion.getPromotionId());
            search.setDictionaryTypeId(104);
            search.setStatus(Short.parseShort("1"));
            search = (DictionaryEntity)this.dictionaryMapper.getSingle(search);
            map.put("isFreeFreight", search != null ? "1" : "0");
            list.add(map);
        });
        PageInfo pg = page.toPageInfo();
        pg.setList(list);
        return pg;
    }

    @Override
    public PageInfo getPromotionList(int pageNum, int length, MallPromotionEntity mallPromotionEntity) {
        Page page = PageHelper.startPage((int)pageNum, (int)length);
        this.promotionMapper.getCmsList2(mallPromotionEntity.getPromotionName(), mallPromotionEntity.getStatus(), mallPromotionEntity.getBeginTime(), mallPromotionEntity.getEndTime(), mallPromotionEntity.getPlatformGroupId());
        return page.toPageInfo();
    }

    @Override
    @ReadThroughSingleCache(namespace="promotionEntity", expiration=3600)
    public MallPromotionEntity getPromotion(@ParameterValueKeyProvider String promotionId) {
        return (MallPromotionEntity)this.promotionMapper.selectByPrimaryKey((Serializable)((Object)promotionId));
    }

    @Override
    public BaseJsonVo addPromotion(MallPromotionEntity mallPromotionEntity, int limitCount) {
        BaseJsonVo sr = new BaseJsonVo();
        if (mallPromotionEntity == null) {
            sr.setError("\u53c2\u6570\u9519\u8bef");
            return sr;
        }
        if (StringUtils.isEmpty((String)mallPromotionEntity.getPromotionId())) {
            mallPromotionEntity.setPromotionId(IDGenerate.getUniqueIdStr());
            mallPromotionEntity.setCreateTime(DateUtils.now());
            this.promotionMapper.insert(mallPromotionEntity);
        } else {
            this.removeCache(mallPromotionEntity.getPromotionId());
            this.promotionMapper.updateByPrimaryKeySelective(mallPromotionEntity);
        }
        this.promotionTimeService.addPromotionTime(mallPromotionEntity, limitCount);
        sr.setValue((Object)mallPromotionEntity);
        return sr;
    }

    @Override
    public BaseJsonVo updatePromotion(MallPromotionEntity mallPromotionEntity) {
        BaseJsonVo sr = new BaseJsonVo();
        if (mallPromotionEntity == null) {
            sr.setError("\u53c2\u6570\u9519\u8bef");
            return sr;
        }
        if (StringUtils.isEmpty((String)mallPromotionEntity.getPromotionId())) {
            mallPromotionEntity.setPromotionId(IDGenerate.getUniqueIdStr());
            mallPromotionEntity.setCreateTime(DateUtils.now());
            this.promotionMapper.insert(mallPromotionEntity);
        } else {
            this.removeCache(mallPromotionEntity.getPromotionId());
            this.promotionMapper.updateByPrimaryKeySelective(mallPromotionEntity);
        }
        return sr;
    }

    @Override
    public BaseJsonVo delPromotion(String promotionId) {
        if (StringUtils.isNotEmpty((String)promotionId)) {
            this.removeCache(promotionId);
            this.promotionMapper.deleteByPrimaryKey((Serializable)((Object)promotionId));
            return new BaseJsonVo();
        }
        BaseJsonVo sr = new BaseJsonVo();
        sr.setError("\u5185\u90e8\u9519\u8bef");
        return sr;
    }

    @Override
    public BaseJsonVo changePromotion(String promotionId) {
        MallPromotionEntity entity = this.promotionInterface.getPromotion(promotionId);
        if (entity.getStatus() == 1) {
            entity.setStatus(2);
        } else {
            entity.setStatus(1);
        }
        this.removeCache(promotionId);
        return this.updatePromotion(entity);
    }

    @Override
    public BaseJsonVo addPromotionProduct(MallPromotionProductEntity mallPromotionProductEntity) {
        BaseJsonVo sr = new BaseJsonVo();
        if (mallPromotionProductEntity == null) {
            sr.setError("\u53c2\u6570\u9519\u8bef");
            return sr;
        }
        this.removeCache(mallPromotionProductEntity.getPromotionId());
        if (StringUtils.isEmpty((String)mallPromotionProductEntity.getPromotionProductId())) {
            mallPromotionProductEntity.setPromotionProductId(IDGenerate.getUniqueIdStr());
            this.promotionProductInterface.addPromotionProduct(mallPromotionProductEntity);
            this.picService.copyProductPic(mallPromotionProductEntity.getProductId(), mallPromotionProductEntity.getPromotionId());
        } else {
            this.promotionProductInterface.updatePromotionProduct(mallPromotionProductEntity);
        }
        return sr;
    }

    private void removeCache(String promotionId) {
        MallPromotionEntity promotionEntity = this.promotionInterface.getPromotion(promotionId);
        this.memcachedService.delete("promotionEntity", promotionId);
        if (promotionEntity != null && StringUtils.isNotEmpty((String)promotionEntity.getActiveNo())) {
            this.memcachedService.delete("mallPromotionService.getMallPromotionEntityByActiveNo", promotionEntity.getActiveNo());
        }
        this.memcachedService.delete("MallPromotionService.getPromotionDeliveryType", promotionId);
    }

    @Override
    public BaseJsonVo findCurrentPromotion(Integer platformGroupId) {
        BaseJsonVo result = new BaseJsonVo();
        ArrayList vos = new ArrayList();
        List<MallPromotionEntity> promotionEntities = this.promotionMapper.findCurrentPromotions(platformGroupId);
        promotionEntities.forEach(promotionEntity -> {
            BaseJsonVo<MallPromotionVO> sr = this.buildPromotionVO(promotionEntity.getPromotionId(), 1, true);
            if (sr.isSuccess()) {
                vos.add((MallPromotionVO)sr.getValue());
            }
        });
        result.setValue(vos);
        return result;
    }

    @Override
    public List<MallPromotionVO> getCurrentPromotionList(Integer platformGroupId, boolean check) {
        ArrayList<MallPromotionVO> vos = new ArrayList<MallPromotionVO>();
        List<MallPromotionEntity> promotionEntities = this.promotionMapper.findCurrentPromotions(platformGroupId);
        if (check) {
            promotionEntities.forEach(promotionEntity -> {
                BaseJsonVo<MallPromotionVO> sr = this.buildPromotionVO(promotionEntity.getPromotionId(), 1, check);
                if (sr.isSuccess()) {
                    vos.add((MallPromotionVO)sr.getValue());
                }
            });
        } else {
            for (MallPromotionEntity promotionEntity2 : promotionEntities) {
                MallPromotionVO promotionVO = new MallPromotionVO();
                promotionVO.setPromotionName(promotionEntity2.getPromotionName());
                promotionVO.setPromotionId(promotionEntity2.getPromotionId());
                vos.add(promotionVO);
            }
        }
        return vos;
    }

    public BaseJsonVo<MallPromotionVO> buildPromotionVO(String promotionId, Integer quantity, Boolean checked) {
        BaseJsonVo sr = new BaseJsonVo();
        MallPromotionVO vo = new MallPromotionVO();
        MallPromotionEntity entity = this.promotionInterface.getPromotion(promotionId);
        if (entity == null) {
            sr.setError("\u4fc3\u9500\u4e0d\u5b58\u5728");
            vo.setValid(false);
            vo.setInvalidReason(sr.getError_msg());
            vo.setShoppingcartCheck(false);
            sr.setValue((Object)vo);
            return sr;
        }
        try {
            ObjectConvert.fatherConvertToChild((Object)entity, (Object)vo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            sr.setError("\u5546\u54c1\u4fe1\u606f\u9519\u8bef");
            return sr;
        }
        vo.setCount(quantity);
        vo.setShort(false);
        vo.setSoldOut(false);
        vo.setPromotionId(promotionId);
        vo.setShoppingcartCheck(checked);
        ArrayList proList = new ArrayList();
        ArrayList groupList = new ArrayList();
        MallPromotionProductEntity promotionProduct = this.promotionProductInterface.getPromotionProductEntity(promotionId);
        if (promotionProduct == null) {
            sr.setError("\u4fc3\u9500\u672a\u5173\u8054\u5546\u54c1");
            vo.setValid(false);
            vo.setInvalidReason(sr.getError_msg());
            vo.setShoppingcartCheck(false);
            sr.setValue((Object)vo);
            return sr;
        }
        vo.setProductType(promotionProduct.getProductType());
        vo.setOriginPrice(promotionProduct.getOriginPrice());
        vo.setPromotionPrice(promotionProduct.getPromotionPrice());
        vo.setLimitCount(promotionProduct.getLimitCount());
        vo.setPromotionProductId(promotionProduct.getPromotionProductId());
        vo.setPromotionPic(this.picService.getProductPicUrlMap(promotionProduct.getPromotionProductId(), SalesTypeEnum.SALES_PROMOTION.getValue()));
        if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(promotionProduct.getProductType()).intValue()) {
            BaseJsonVo buildProductVOsr = this.productService.buildProductVO(promotionProduct.getProductId(), quantity, null, promotionId, null, null, false, checked, null, null);
            if (buildProductVOsr.isSuccess()) {
                MallProductVO productVO = (MallProductVO)buildProductVOsr.getValue();
                if (productVO.getValid().booleanValue()) {
                    vo.setProduct((MallProductVO)buildProductVOsr.getValue());
                } else {
                    vo.setValid(false);
                    vo.setInvalidReason(productVO.getInvalidReason());
                    vo.setShoppingcartCheck(false);
                }
            } else {
                vo.setValid(false);
                vo.setInvalidReason(buildProductVOsr.getError_msg());
                vo.setShoppingcartCheck(false);
            }
        } else if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(promotionProduct.getProductType()).intValue()) {
            BaseJsonVo buildGroupVOsr = this.groupService.buildGroupVO(promotionProduct.getProductId(), quantity, promotionId, checked);
            if (buildGroupVOsr.isSuccess()) {
                MallGroupVO groupVO = (MallGroupVO)buildGroupVOsr.getValue();
                if (groupVO.getValid().booleanValue()) {
                    vo.setGroup((MallGroupVO)buildGroupVOsr.getValue());
                } else {
                    vo.setGroup((MallGroupVO)buildGroupVOsr.getValue());
                    vo.setValid(false);
                    vo.setInvalidReason(groupVO.getInvalidReason());
                    vo.setShoppingcartCheck(false);
                }
            } else {
                vo.setValid(false);
                vo.setInvalidReason(buildGroupVOsr.getError_msg());
                vo.setShoppingcartCheck(false);
            }
        }
        if (!vo.getValid().booleanValue()) {
            sr.setValue((Object)vo);
            return sr;
        }
        ArrayList<MallPromotionVO> tmpVos = new ArrayList<MallPromotionVO>();
        tmpVos.add(0, vo);
        vo.setSelfModeType(this.productService.getPromotionSelfMode(tmpVos));
        BaseJsonVo checkResult = this.checkPromotion(vo);
        if (checkResult.isSuccess()) {
            vo.setValid(true);
        } else {
            vo.setValid(false);
            vo.setInvalidReason(checkResult.getMessage());
            vo.setShoppingcartCheck(false);
        }
        sr.setValue((Object)vo);
        return sr;
    }

    @Override
    public BaseJsonVo checkPromotion(MallPromotionVO promotionVO) {
        MallPromotionTimeEntity promotionTimeEntity = this.promotionTimeService.getSingleEntityByTime(promotionVO.getPromotionId(), DateUtils.date());
        BaseJsonVo baseJsonVo = this.checkBasePromotion(promotionVO.getPromotionType(), promotionTimeEntity, promotionVO.getPromotionId(), promotionVO.getPromotionName(), promotionVO.getActiveNo(), promotionVO.getBeginTime(), promotionVO.getEndTime(), promotionVO.getStatus(), promotionVO.getSaled());
        if (baseJsonVo.isSuccess()) {
            MallPromotionProductEntity promotionProductEntity;
            if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(promotionVO.getProductType()).intValue()) {
                if (!promotionVO.getProduct().getValid().booleanValue()) {
                    return BaseJsonVo.error((String)(String.format("\u4fc3\u9500%s\u4e2d\uff0c", promotionVO.getPromotionName()).toString() + promotionVO.getProduct().getInvalidReason()));
                }
            } else if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(promotionVO.getProductType()).intValue() && !promotionVO.getGroup().getValid().booleanValue()) {
                return BaseJsonVo.error((String)(String.format("\u4fc3\u9500%s\u4e2d\uff0c", promotionVO.getPromotionName()).toString() + promotionVO.getGroup().getInvalidReason()));
            }
            if ((promotionProductEntity = this.promotionProductInterface.getPromotionProductEntity(promotionVO.getPromotionId())) != null && promotionProductEntity.getLimitCount() != 0 && promotionVO.getCount() > promotionProductEntity.getLimitCount()) {
                return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s\uff0c\u8d85\u8fc7\u8d2d\u4e70\u9650\u5236\u6570", promotionVO.getPromotionName()).toString());
            }
        } else {
            return baseJsonVo;
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo checkBasePromotion(int promotionType, MallPromotionTimeEntity promotionTimeEntity, String promotionId, String promotionName, String activeNo, Date beginTime, Date endTime, int status, int saled) {
        if (status != 1) {
            BaseJsonVo baseJsonVo = new BaseJsonVo();
            baseJsonVo.setStatus(40002);
            baseJsonVo.setMessage(String.format("\u4fc3\u9500%s,\u5df2\u7ed3\u675f", promotionName));
            return baseJsonVo;
        }
        if (beginTime.getTime() > DateUtils.now().getTime()) {
            return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s,\u5c1a\u672a\u5f00\u59cb", promotionName).toString());
        }
        if (endTime.getTime() < DateUtils.now().getTime()) {
            return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s,\u5df2\u8fc7\u671f", promotionName).toString());
        }
        if (promotionTimeEntity == null) {
            return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s,\u5c1a\u672a\u5f00\u59cb\u6216\u5df2\u8fc7\u671f", promotionName).toString());
        }
        if (promotionType == 2) {
            beginTime = DateUtils.currentDate();
            endTime = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
        }
        int buyCount = this.promotionBuyInterface.getPromotionBuyCount(promotionId, beginTime, endTime);
        if (promotionTimeEntity.getLimitCount() - (buyCount += saled) < 0) {
            return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", promotionName).toString());
        }
        if (StringUtils.isNotEmpty((String)activeNo) && !this.activeInterface.checkActiveEnable(activeNo).isSuccess()) {
            return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s\uff0c\u5173\u8054\u6d3b\u52a8\u5df2\u8fc7\u671f", promotionName).toString());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public boolean updatePromotionLimitCount(String promotionId, String itemId, int quantity, Date d1, String customerId) {
        MallPromotionEntity mallPromotionEntity = this.promotionInterface.getPromotion(promotionId);
        if (d1.compareTo(DateUtils.currentDate()) == 0) {
            d1 = DateUtils.now();
        }
        if (mallPromotionEntity.getBeginTime().after(d1) || mallPromotionEntity.getEndTime().before(d1)) {
            return false;
        }
        MallPromotionTimeEntity promotionTimeEntity = this.promotionTimeService.getSingleEntityByTime(promotionId, DateUtils.date());
        if (promotionTimeEntity != null) {
            Date beginTime = promotionTimeEntity.getBeginTime();
            Date endTime = promotionTimeEntity.getEndTime();
            if (mallPromotionEntity.getPromotionType() == 2) {
                beginTime = DateUtils.currentDate();
                endTime = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
            }
            int buyCount = this.promotionBuyInterface.getPromotionBuyCount(promotionId, beginTime, endTime);
            int limitCount = promotionTimeEntity.getLimitCount() - mallPromotionEntity.getSaled() - buyCount - quantity;
            if (limitCount < 0) {
                return false;
            }
            MallPromotionBuyEntity promotionBuyEntity = new MallPromotionBuyEntity();
            promotionBuyEntity.setPromotionId(promotionId);
            promotionBuyEntity.setBuyCount(quantity);
            promotionBuyEntity.setCreateTime(d1);
            int i = this.promotionBuyInterface.insertSelectiveEntity(mallPromotionEntity, promotionTimeEntity, promotionBuyEntity);
            if (i > 0) {
                this.removeCache(promotionId);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public BaseJsonVo updatePromotionLimitCount(MallMainOrderVo mainOrderVo, boolean reverse) {
        try {
            int red = 1;
            if (reverse) {
                red = -1;
            }
            for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
                if (orderVo.getPromotions() == null || orderVo.getPromotions().size() <= 0) continue;
                for (MallPromotionVO promotionVO : orderVo.getPromotions()) {
                    if (promotionVO.getProduct() != null && !this.updatePromotionLimitCount(promotionVO.getPromotionId(), promotionVO.getProduct().getProId(), promotionVO.getProduct().getCount() * red, DateUtils.now(), mainOrderVo.getCustomerId())) {
                        return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", promotionVO.getPromotionName()));
                    }
                    if (promotionVO.getGroup() != null && !this.updatePromotionLimitCount(promotionVO.getPromotionId(), promotionVO.getGroup().getGroupId(), promotionVO.getGroup().getCount() * red, DateUtils.now(), mainOrderVo.getCustomerId())) {
                        return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", promotionVO.getPromotionName()));
                    }
                    this.removeCache(promotionVO.getPromotionId());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
            throw new RuntimeException();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<Map> findRecommendPromotions(Integer platformGroupId) {
        ArrayList<Map> rtnList = new ArrayList<Map>();
        MallSaleRecommendEntity searchParam = new MallSaleRecommendEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        searchParam.setStatus(1);
        searchParam.setSaleType(SalesTypeEnum.SALES_PROMOTION.getValue());
        List<MallSaleRecommendEntity> sales = this.saleRecommendInterface.getList(searchParam);
        sales.forEach(entity -> {
            BaseJsonVo<MallPromotionVO> result = this.buildPromotionVO(entity.getSaleId(), 1, false);
            if (result.isSuccess() && ((MallPromotionVO)result.getValue()).getValid().booleanValue()) {
                Map promotion = ObjectConvert.objectWithSuperConvertToObjectMap((Object)result.getValue());
                promotion.put("recommendReason", entity.getRecommendReason());
                rtnList.add(promotion);
            }
        });
        return rtnList;
    }

    @Override
    public List<MallSelectDataVo> getOptionPromotionList(Integer platformGroupId) {
        return this.promotionMapper.getOptionPromotionList(platformGroupId);
    }

    @Override
    public MallPromotionEntity getMallPromotionEntityByActiveNo(String acitveNo) {
        MallPromotionEntity queryPromotionEntity = new MallPromotionEntity();
        queryPromotionEntity.setActiveNo(acitveNo);
        queryPromotionEntity.setStatus(1);
        return (MallPromotionEntity)this.promotionMapper.getSingle(queryPromotionEntity);
    }

    @Override
    public List<Map<String, Object>> getPromotionOrder(String promotionId, String start, String end) {
        if (StringUtils.isEmpty((String)start)) {
            start = DateUtils.date();
        }
        if (StringUtils.isEmpty((String)end)) {
            end = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1), (String)"") + " 23:59:59";
        }
        this.logger.info("promotionId={},start={},end={}", new Object[]{promotionId, start, end});
        return this.promotionMapper.getPromotionOrder(promotionId, start, end);
    }

    @Override
    public List<Map<String, Object>> getActivePromotions(String bindCodeOrActiveNo) {
        return this.promotionMapper.getActivePromotions(bindCodeOrActiveNo);
    }

    @Override
    public List<Map<String, Object>> getActivePromotionsByActiveType(Integer activeType) {
        return this.promotionMapper.getActivePromotionsByActiveType(activeType);
    }

    @Override
    public PageInfo<Map<String, Object>> getPromotionPriceList(String searchName, Integer currentPage, Integer pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<Map<String, Object>> pros = this.promotionMapper.getPromotionPriceList(searchName);
        for (Map<String, Object> pro : pros) {
            List<String> pics = this.picService.getProductPicUrl((String)pro.get("PROMOTION_PRODUCT_ID"), ProductPicTypeEnum.PRO_SAMLL.getValue());
            if (pics == null || pics.isEmpty()) continue;
            pro.put("PIC_URL", pics.get(0));
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(pros);
        return pg;
    }

    @Override
    public PageInfo<Map<String, Object>> getPromotionAndProductPriceList(String searchName, String showIndex, Integer currentPage, Integer pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<Map<String, Object>> pros = this.promotionMapper.getPromotionAndProductPriceList(searchName, showIndex);
        for (Map<String, Object> pro : pros) {
            List<String> pics = this.picService.getProductPicUrl((String)pro.get("PRO_ID"), ((Long)pro.get("PRO_TYPE")).intValue() == 1 ? ProductPicTypeEnum.PRO_SAMLL.getValue() : ProductPicTypeEnum.PROMO_SAMLL.getValue());
            if (pics == null || pics.isEmpty()) continue;
            pro.put("PIC_URL", pics.get(0));
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(pros);
        return pg;
    }
}

