/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.scrollpic;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.scrollpic.MallScrollPicMapper;
import cc.lechun.mall.entity.scrollpic.MallScrollPicEntity;
import cc.lechun.mall.iservice.scrollpic.MallScrollPicInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallScrollPicService
extends BaseService
implements MallScrollPicInterface {
    @Autowired
    private MallScrollPicMapper mallScrollPicMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public BaseJsonVo saveMallScrollPic(MallScrollPicEntity mallScrollPicEntity) {
        BaseJsonVo rs = this.valid(mallScrollPicEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        mallScrollPicEntity.setCreateTime(DateUtils.now());
        mallScrollPicEntity.setSiteType(mallScrollPicEntity.getPlatformId());
        this.mallScrollPicMapper.insertSelective(mallScrollPicEntity);
        return rs;
    }

    @Override
    public BaseJsonVo updateMallScrollPic(MallScrollPicEntity mallScrollPicEntity) {
        BaseJsonVo rs = this.valid(mallScrollPicEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        this.memcachedService.delete("getVailMallScrollPicDetailList", new String[]{mallScrollPicEntity.getPlatformId() + "", mallScrollPicEntity.getPicType() + ""});
        this.mallScrollPicMapper.updateByPrimaryKeySelective(mallScrollPicEntity);
        return rs;
    }

    @Override
    public MallScrollPicEntity getMallScrollPic(int scrollId) {
        return (MallScrollPicEntity)this.mallScrollPicMapper.selectByPrimaryKey(Integer.valueOf(scrollId));
    }

    @Override
    public PageInfo getMallScrollPicList(int pageNum, int pageSize, String platformIds, MallScrollPicEntity scrollPicEntity) {
        String scrollName = "";
        if (scrollPicEntity != null) {
            scrollName = scrollPicEntity.getScrollName();
        }
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallScrollPicMapper.getMallScrollPicList(platformIds, scrollName);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    private BaseJsonVo valid(MallScrollPicEntity mallScrollPicEntity) {
        if (StringUtils.isEmpty((String)mallScrollPicEntity.getScrollName())) {
            return BaseJsonVo.paramError((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallScrollPicEntity.getScrollSummary())) {
            return BaseJsonVo.paramError((String)"\u6458\u8981\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }
}

