/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.shoppingcart;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallFullcutDetailEntity;
import cc.lechun.mall.entity.sales.MallFullcutVo;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.sales.MallFullcutDetailInterface;
import cc.lechun.mall.iservice.sales.MallFullcutInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallPriceCalcService
extends BaseService
implements MallPriceCalcInterface {
    @Autowired
    private MallFullcutInterface fullcutService;
    @Autowired
    private MallFullcutDetailInterface fullcutDetailService;

    @Override
    public MallShoppingcartVO calcShoppingcartVO(MallShoppingcartVO cartVO) {
        Integer orderSource = cartVO.getOrderSource();
        this.calcProduct(cartVO);
        this.calcGroup(cartVO);
        this.calcPromotion(cartVO);
        if (OrderSourceEnum.FULLCUT.getValue() == orderSource.intValue()) {
            this.calcFullCut(cartVO);
        }
        this.totalCartVo(cartVO);
        return cartVO;
    }

    private void calcProduct(MallShoppingcartVO cartVO) {
    }

    private void calcGroup(MallShoppingcartVO cartVO) {
        if (cartVO == null || cartVO.getGroups() == null || cartVO.getGroups().size() == 0) {
            return;
        }
        List<MallGroupVO> groupList = cartVO.getGroups();
        for (MallGroupVO vo : groupList) {
            vo.setFactPrice(PriceUtils.format((BigDecimal)vo.getSalePrice()));
            this.setGroupProductPrice(vo);
        }
    }

    private void setGroupProductPrice(MallGroupVO vo) {
        block4: {
            Integer splitPriceMode;
            block3: {
                splitPriceMode = vo.getSplitPriceMode();
                if (splitPriceMode != 0) break block3;
                BigDecimal originPrice = new BigDecimal("0.00");
                for (MallProductVO productVO : vo.getProductList()) {
                    originPrice = PriceUtils.add((BigDecimal)originPrice, (BigDecimal)PriceUtils.multiply((BigDecimal)new BigDecimal(productVO.getProPrice()), (Integer)productVO.getCount()));
                }
                BigDecimal discount = PriceUtils.divide((BigDecimal)vo.getFactPrice(), (BigDecimal)originPrice);
                for (MallProductVO productVO : vo.getProductList()) {
                    productVO.setFactPrice(PriceUtils.multiply((BigDecimal)new BigDecimal(productVO.getProPrice()), (BigDecimal)discount));
                }
                break block4;
            }
            if (splitPriceMode != 0) break block4;
            for (MallProductVO productVO : vo.getProductList()) {
                productVO.setFactPrice(new BigDecimal(productVO.getProPrice()));
            }
        }
    }

    private void calcPromotion(MallShoppingcartVO cartVO) {
    }

    private void calcFullCut(MallShoppingcartVO cartVO) {
        block25: {
            List<MallFullcutDetailEntity> fullcutDetailEntities;
            MallFullcutVo fullcutVo;
            BaseJsonVo jsonVo = this.fullcutService.getEnableFullcut(cartVO);
            if (!jsonVo.isSuccess() || (fullcutVo = (MallFullcutVo)jsonVo.getValue()) == null) break block25;
            if (fullcutVo.getDoubleFreeGift() == 0) {
                cartVO.setFrees(new ArrayList<MallFreeVO>());
            }
            if (fullcutVo.getDoublePromotion() == 0) {
                cartVO.setPromotionDiffPrice(BigDecimal.valueOf(0L));
                cartVO.setPromotions(new ArrayList<MallPromotionVO>());
            }
            if ((fullcutDetailEntities = this.fullcutDetailService.getFullcutDetails(fullcutVo.getFullCutId())) != null && fullcutDetailEntities.size() > 0) {
                int quantity = 0;
                if (!this.fullcutService.checkFullcut(fullcutVo, fullcutDetailEntities, cartVO)) {
                    return;
                }
                List fullProductVos = cartVO.getProducts().stream().filter(c -> !c.getFullCutId().isEmpty() && c.getFullCutId() != null).collect(Collectors.toList());
                BigDecimal amount = new BigDecimal(0);
                if (fullProductVos != null) {
                    quantity = fullProductVos.stream().mapToInt(c -> c.getCount()).sum();
                    amount = BigDecimal.valueOf(fullProductVos.stream().mapToDouble(c -> c.getFactPrice().multiply(new BigDecimal(c.getCount())).doubleValue()).sum());
                }
                BigDecimal num = new BigDecimal(0);
                if (fullcutVo.getType() == 1) {
                    num = PriceUtils.divide((BigDecimal)BigDecimal.valueOf(quantity), (BigDecimal)BigDecimal.valueOf(fullcutVo.getFullNumber().intValue()), (int)0, (Integer)1);
                }
                if (fullcutVo.getType() == 2) {
                    num = PriceUtils.divide((BigDecimal)amount, (BigDecimal)BigDecimal.valueOf(fullcutVo.getFullNumber().intValue()), (int)0, (Integer)1);
                }
                if (num.doubleValue() > 0.0) {
                    num = PriceUtils.multiply((BigDecimal)num, (Integer)fullcutVo.getCutNumber());
                    if (fullcutVo.getCutRule() == 1) {
                        Comparator comparator = (h1, h2) -> h1.getFactPrice().compareTo(h2.getFactPrice());
                        fullProductVos.sort(comparator.reversed());
                    }
                    if (fullcutVo.getCutRule() == 2) {
                        fullProductVos.sort((v1, v2) -> v1.getFactPrice().compareTo(v2.getFactPrice()));
                    }
                    if (fullcutVo.getCutRule() == 3) {
                        Collections.shuffle(fullProductVos);
                    }
                    if (fullcutVo.getCutRule() == 4 && fullcutVo.getType() == 1) {
                        String[] productIds;
                        for (String p : productIds = fullcutVo.getProductIds().split(",")) {
                            List list = fullProductVos.stream().filter(c -> c.getProId().equals(p)).collect(Collectors.toList());
                            MallProductVO productVO = new MallProductVO();
                            if (list != null && list.size() > 0) {
                                productVO = (MallProductVO)list.get(0);
                                if (fullcutVo.getProductRule() == 1) {
                                    this.logger.info("+1\u4e4b\u524d\uff1a" + String.valueOf(productVO.getCount()));
                                    productVO.setCount(productVO.getCount() + num.intValue());
                                    productVO.setFullCutId(fullcutVo.getFullCutId());
                                    productVO.setFullcutCount(productVO.getFullcutCount() == null ? num.intValue() : productVO.getFullcutCount() + num.intValue());
                                    productVO.setFullcutAmount(productVO.getFactPrice().multiply(BigDecimal.valueOf(productVO.getFullcutCount().intValue())));
                                }
                                if (fullcutVo.getProductRule() == 2) {
                                    if (productVO.getFullcutCount() == productVO.getCount()) break;
                                    productVO.setFullCutId(fullcutVo.getFullCutId());
                                    productVO.setFullcutCount(productVO.getFullcutCount() == null ? 0 : productVO.getFullcutCount() + 1);
                                    productVO.setFullcutAmount(productVO.getFactPrice().multiply(BigDecimal.valueOf(productVO.getFullcutCount().intValue())));
                                }
                            }
                            cartVO.setFullcutName(fullcutVo.getFullCutName());
                            cartVO.setFullcutRuleName(fullcutVo.getCutRuleName());
                        }
                    } else {
                        for (MallProductVO productVO : fullProductVos) {
                            if (fullcutVo.getType() == 1 && num.doubleValue() > 0.0) {
                                if ((double)productVO.getCount().intValue() >= num.doubleValue()) {
                                    productVO.setFullCutId(fullcutVo.getFullCutId());
                                    productVO.setFullcutCount(num.intValue());
                                    productVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)num.intValue()));
                                    num = new BigDecimal(0);
                                } else {
                                    productVO.setFullCutId(fullcutVo.getFullCutId());
                                    productVO.setFullcutCount(productVO.getCount());
                                    productVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getCount()));
                                    num = PriceUtils.subtract((BigDecimal)num, (BigDecimal)new BigDecimal(productVO.getCount()));
                                }
                            }
                            if (fullcutVo.getType() == 2 && num.doubleValue() > 0.0) {
                                if (PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getCount()).compareTo(num) >= 0) {
                                    productVO.setFullCutId(fullcutVo.getFullCutId());
                                    productVO.setFullcutCount(0);
                                    productVO.setFullcutAmount(num);
                                    num = new BigDecimal(0);
                                } else {
                                    productVO.setFullCutId(fullcutVo.getFullCutId());
                                    productVO.setFullcutCount(0);
                                    productVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getCount()));
                                    num = PriceUtils.subtract((BigDecimal)num, (BigDecimal)PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getCount()));
                                }
                            }
                            cartVO.setFullcutName(fullcutVo.getFullCutName());
                            cartVO.setFullcutRuleName(fullcutVo.getCutRuleName());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void totalCartVo(MallShoppingcartVO shoppingcartVO) {
        BigDecimal[] factPrice = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] price = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] vipDiffPrice = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] promotionDiffPrice = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] fullCutAmount = new BigDecimal[]{new BigDecimal(0)};
        if (shoppingcartVO.getProducts().size() > 0) {
            shoppingcartVO.getProducts().forEach(c -> {
                if (c.getValid().booleanValue() && c.getShoppingcartCheck().booleanValue() && c.getValid().booleanValue()) {
                    factPrice[0] = PriceUtils.add((BigDecimal)factPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    price[0] = PriceUtils.add((BigDecimal)price[0], (BigDecimal)PriceUtils.multiply((BigDecimal)new BigDecimal(c.getProPrice()), (Integer)c.getCount()));
                    vipDiffPrice[0] = PriceUtils.add((BigDecimal)vipDiffPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)(c.getVipDiff() == null ? new BigDecimal(0) : c.getVipDiff()), (BigDecimal)new BigDecimal(c.getCount())));
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(c.getFullcutAmount() == null ? new BigDecimal(0) : c.getFullcutAmount()));
                }
            });
        }
        if (shoppingcartVO.getGroups().size() > 0) {
            shoppingcartVO.getGroups().forEach(c -> {
                if (c.getValid().booleanValue() && c.getShoppingcartCheck().booleanValue() && c.getValid().booleanValue()) {
                    factPrice[0] = PriceUtils.add((BigDecimal)factPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    price[0] = PriceUtils.add((BigDecimal)price[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getSalePrice(), (Integer)c.getCount()));
                }
            });
        }
        if (shoppingcartVO.getPromotions().size() > 0) {
            shoppingcartVO.getPromotions().forEach(c -> {
                if (c.getValid().booleanValue() && c.getShoppingcartCheck().booleanValue() && c.getValid().booleanValue()) {
                    factPrice[0] = PriceUtils.add((BigDecimal)factPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    price[0] = PriceUtils.add((BigDecimal)price[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getOriginPrice(), (Integer)c.getCount()));
                    vipDiffPrice[0] = PriceUtils.add((BigDecimal)vipDiffPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)(c.getVipDiff() == null ? new BigDecimal(0) : c.getVipDiff()), (BigDecimal)new BigDecimal(c.getCount())));
                    promotionDiffPrice[0] = PriceUtils.add((BigDecimal)promotionDiffPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)(c.getPromotionDiff() == null ? new BigDecimal(0) : c.getPromotionDiff()), (BigDecimal)new BigDecimal(c.getCount())));
                }
            });
        }
        shoppingcartVO.setFactPrice(factPrice[0]);
        shoppingcartVO.setPrice(price[0]);
        shoppingcartVO.setVipDiffPrice(vipDiffPrice[0]);
        shoppingcartVO.setPromotionDiffPrice(promotionDiffPrice[0]);
    }

    @Override
    public void totalOrderPrice(MallOrderVo orderVo) {
        this.calcShoppingcartVO(orderVo);
        BigDecimal[] fullCutAmount = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] freight = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal couponAmount = orderVo.getCouponAmount();
        BigDecimal orderAmount = orderVo.getFactPrice();
        if (orderVo.getProducts().size() > 0) {
            orderVo.getProducts().forEach(c -> {
                fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(c.getFullcutAmount() == null ? new BigDecimal(0) : c.getFullcutAmount()));
            });
        }
        orderAmount = PriceUtils.subtract((BigDecimal)orderAmount, (BigDecimal)fullCutAmount[0]);
        BigDecimal toatalAmount = PriceUtils.add((BigDecimal)orderAmount, (BigDecimal)(orderVo.getFreight() == null ? new BigDecimal(0) : orderVo.getFreight()));
        BigDecimal payAmount = PriceUtils.subtractToSix((BigDecimal)toatalAmount, (BigDecimal)orderVo.getBalanceAmount());
        payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)couponAmount);
        orderVo.setTotalAmount(toatalAmount);
        orderVo.setOrderAmount(orderAmount);
        orderVo.setCouponAmount(couponAmount);
        orderVo.setPayAmount(payAmount);
        orderVo.setFullcutAmount(fullCutAmount[0]);
    }

    @Override
    public void totalMainOrderPrice(MallMainOrderVo mainOrderVo) {
        BigDecimal toatalAmount;
        BigDecimal[] orderAmount = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] freight = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] couponAmount = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] balanceAmount = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] vipDiffAmount = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] promotionDiffAmount = new BigDecimal[]{new BigDecimal(0)};
        BigDecimal[] fullcutAmount = new BigDecimal[]{new BigDecimal(0)};
        mainOrderVo.getMallOrderVos().forEach(c -> {
            orderAmount[0] = PriceUtils.addNoUp((BigDecimal)orderAmount[0], (BigDecimal)c.getOrderAmount());
            freight[0] = PriceUtils.addNoUp((BigDecimal)freight[0], (BigDecimal)c.getFreight());
            balanceAmount[0] = PriceUtils.addNoUp((BigDecimal)balanceAmount[0], (BigDecimal)c.getBalanceAmount());
            couponAmount[0] = PriceUtils.addNoUp((BigDecimal)couponAmount[0], (BigDecimal)c.getCouponAmount());
            fullcutAmount[0] = PriceUtils.addNoUp((BigDecimal)fullcutAmount[0], (BigDecimal)c.getFullcutAmount());
            vipDiffAmount[0] = PriceUtils.addNoUp((BigDecimal)vipDiffAmount[0], (BigDecimal)c.getVipDiffPrice());
            promotionDiffAmount[0] = PriceUtils.addNoUp((BigDecimal)promotionDiffAmount[0], (BigDecimal)c.getPromotionDiffPrice());
            mainOrderVo.setFullcutName(c.getFullcutName());
            mainOrderVo.setFullcutRuleName(c.getFullcutRuleName());
        });
        BigDecimal payAmount = toatalAmount = PriceUtils.addNoUp((BigDecimal)orderAmount[0], (BigDecimal)freight[0]);
        payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)balanceAmount[0]);
        payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)couponAmount[0]);
        mainOrderVo.setTotalAmount(toatalAmount);
        mainOrderVo.setOrderAmount(orderAmount[0]);
        mainOrderVo.setCouponAmount(couponAmount[0]);
        mainOrderVo.setBalanceAmount(balanceAmount[0]);
        mainOrderVo.setFreight(freight[0]);
        mainOrderVo.setPayAmount(payAmount);
        mainOrderVo.setFullcutAmount(fullcutAmount[0]);
        mainOrderVo.setVipDiffPrice(vipDiffAmount[0]);
        mainOrderVo.setPromotionDiffPrice(promotionDiffAmount[0]);
        mainOrderVo.setTotalAmountANdVipDiff(toatalAmount.add(vipDiffAmount[0]).add(promotionDiffAmount[0]));
        this.calcOrderFavorable(mainOrderVo);
    }

    private void calcOrderFavorable(MallMainOrderVo mainOrderVo) {
        if (mainOrderVo != null && mainOrderVo.getOrderFavorStrategies() != null && mainOrderVo.getOrderFavorStrategies().size() > 0) {
            BigDecimal[] orderSaved = new BigDecimal[]{new BigDecimal(0)};
            mainOrderVo.getOrderFavorStrategies().forEach(favorStrategy -> {
                HashMap<String, Object> param = new HashMap<String, Object>();
                String inviteId = mainOrderVo.getMallOrderVos().get(0).getDefineField();
                try {
                    inviteId = JsonUtils.stringToMap((String)URLDecoder.decode(inviteId, "utf-8")).get("inviteId").toString();
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("\u672a\u83b7\u53d6\u5230inviteId,\u7c7b\u578b\u8f6c\u5316\u9519\u8bef");
                }
                param.put("inviteId", inviteId);
                BigDecimal moneySaved = favorStrategy.favorCalc(param);
                orderSaved[0] = PriceUtils.add((BigDecimal)orderSaved[0], (BigDecimal)moneySaved);
            });
            this.logger.info("\u62fc\u5355\u8282\u7701\uff1a" + orderSaved[0].doubleValue());
            mainOrderVo.setTotalAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getTotalAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.setOrderAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getOrderAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.setPayAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getPayAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.getMallOrderVos().get(0).setTotalAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getMallOrderVos().get(0).getTotalAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.getMallOrderVos().get(0).setOrderAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getMallOrderVos().get(0).getOrderAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.getMallOrderVos().get(0).setPayAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getMallOrderVos().get(0).getPayAmount(), (BigDecimal)orderSaved[0]));
        }
    }
}

