/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.shoppingcart;

import cc.lechun.cms.dto.GroupUserlDTO;
import cc.lechun.cms.dto.GrouplDTO;
import cc.lechun.cms.dto.InteractionQueryDo;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.shoppingcart.MallShoppingcartMapper;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.deliver.DeliverSoldProductVo;
import cc.lechun.mall.entity.deliver.DeliverVo;
import cc.lechun.mall.entity.deliver.MallFreightCalVo;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.deliver.DeliverFreightInterface;
import cc.lechun.mall.iservice.deliver.MallFreightInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingRuleInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.service.deliver.DeliverNewErpService;
import cc.lechun.mall.service.deliver.DeliverService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallShoppingcartService
extends BaseService
implements MallShoppingcartInterface {
    private static final Logger logger = LoggerFactory.getLogger(MallShoppingcartService.class);
    @Autowired
    MallProductInterface productService;
    @Autowired
    MallGroupInterface groupService;
    @Autowired
    MallPromotionInterface promotionService;
    @Autowired
    MallPriceCalcInterface calcService;
    @Autowired
    MallShoppingcartMapper cartMapper;
    @Autowired
    CustomerAddressInterface addressService;
    @Autowired
    MallShoppingRuleInterface ruleService;
    @Autowired
    PlatFormInterface platFormService;
    @Autowired
    MallPromotionProductInterface promotionProductService;
    @Autowired
    DeliverService deliverService;
    @Autowired
    private DeliverFreightInterface freightInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallFreightInterface mallFreightService;
    @Autowired
    private MallRedisLock redisLock;
    @Autowired
    DeliverNewErpService deliverNewErpService;
    @Autowired
    MallShoppingcartInterface shoppingcartInterface;
    @Autowired
    private RedisService redisService;

    @Override
    public List<GroupUserlDTO> getGroupUserlList(InteractionQueryDo interactionQueryDo) {
        ArrayList<GroupUserlDTO> result = new ArrayList<GroupUserlDTO>();
        GrouplDTO grouplDTO = new GrouplDTO();
        grouplDTO.setGroupId(interactionQueryDo.getGroupId());
        int i = 0;
        while (true) {
            Page page = PageHelper.startPage((int)i, (int)interactionQueryDo.getPageSize());
            List<GroupUserlDTO> list = this.cartMapper.getGroupUserlList(interactionQueryDo);
            logger.info("\u67e5\u8be2\u7528\u6237\u5bf9\u8c61\u6570\u91cf:{}", (Object)list.size());
            if (list.size() > 0) {
                HashSet<GroupUserlDTO> set = new HashSet<GroupUserlDTO>(list);
                result.clear();
                result.addAll(set);
                grouplDTO.setList(result);
            }
            String strJson = JSONObject.toJSONString((Object)grouplDTO);
            logger.info("json={}", (Object)strJson);
            this.redisService.convertAndSend("select.customer.channel", strJson);
            if (list == null || list.size() == 0 || list.size() < 1000) break;
            ++i;
        }
        return Collections.emptyList();
    }

    @Override
    public BaseJsonVo buildShoppingcartFromShoppingcart(Integer platformId, String customerId, Boolean checked, int isQuick) {
        BaseJsonVo sr;
        block4: {
            sr = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platformId, customerId, checked);
            if (!sr.isSuccess()) break block4;
            List vos = (List)sr.getValue();
            Iterator it = vos.iterator();
            if (isQuick == 1) {
                while (it.hasNext()) {
                    MallShoppingcartVO mallShoppingcartVO = (MallShoppingcartVO)it.next();
                    if ("1".equals(mallShoppingcartVO.getSpeedUp())) continue;
                    it.remove();
                }
            } else {
                while (it.hasNext()) {
                    MallShoppingcartVO mallShoppingcartVO = (MallShoppingcartVO)it.next();
                    if (!"1".equals(mallShoppingcartVO.getSpeedUp())) continue;
                    it.remove();
                }
            }
        }
        return sr;
    }

    @Override
    public BaseJsonVo buildShoppingcartFromShoppingcart(Integer platformId, @ParameterValueKeyProvider(order=0) String customerId, @ParameterValueKeyProvider(order=1) Boolean checked) {
        BaseJsonVo promotionSR;
        BaseJsonVo groupSR;
        BaseJsonVo sr = new BaseJsonVo();
        Integer platFormGroupId = this.platFormService.getPlatForm(platformId).getPlatformGroupId();
        MallShoppingcartVO coldChainCart = new MallShoppingcartVO();
        coldChainCart.setCustomerId(customerId);
        coldChainCart.setOrderSource(OrderSourceEnum.CART.getValue());
        coldChainCart.setPlatFormId(platformId);
        coldChainCart.setPlatFormGroupId(platFormGroupId);
        coldChainCart.setProducts(new ArrayList<MallProductVO>());
        coldChainCart.setGroups(new ArrayList<MallGroupVO>());
        coldChainCart.setPromotions(new ArrayList<MallPromotionVO>());
        coldChainCart.setSelfMadeType(1);
        MallShoppingcartVO nomalTempCart = new MallShoppingcartVO();
        nomalTempCart.setCustomerId(customerId);
        nomalTempCart.setOrderSource(OrderSourceEnum.CART.getValue());
        nomalTempCart.setPlatFormId(platformId);
        nomalTempCart.setPlatFormGroupId(platFormGroupId);
        nomalTempCart.setProducts(new ArrayList<MallProductVO>());
        nomalTempCart.setGroups(new ArrayList<MallGroupVO>());
        nomalTempCart.setPromotions(new ArrayList<MallPromotionVO>());
        nomalTempCart.setSelfMadeType(2);
        MallShoppingcartVO quickShoppingCart = new MallShoppingcartVO();
        quickShoppingCart.setCustomerId(customerId);
        quickShoppingCart.setOrderSource(OrderSourceEnum.CART.getValue());
        quickShoppingCart.setPlatFormId(platformId);
        quickShoppingCart.setPlatFormGroupId(platFormGroupId);
        quickShoppingCart.setProducts(new ArrayList<MallProductVO>());
        quickShoppingCart.setGroups(new ArrayList<MallGroupVO>());
        quickShoppingCart.setPromotions(new ArrayList<MallPromotionVO>());
        quickShoppingCart.setSpeedUp("1");
        BaseJsonVo productSR = this.buildShoppingcartProducts(customerId, checked);
        if (productSR.isSuccess() && productSR.getValue() != null) {
            List products = (List)productSR.getValue();
            logger.info("<<<><><><><><><><><><buildShoppingcartFromShoppingcart.products<><><><><><><>products={}", (Object)JSON.toJSONString((Object)products));
            products.forEach(product -> {
                if ("1".equals(product.getSpeedUp())) {
                    quickShoppingCart.getProducts().add((MallProductVO)product);
                    quickShoppingCart.setSelfMadeType(1);
                } else if (product.getSelfMadeType() == 1) {
                    coldChainCart.getProducts().add((MallProductVO)product);
                } else {
                    nomalTempCart.getProducts().add((MallProductVO)product);
                }
            });
        }
        if ((groupSR = this.buildShoppingcartGroups(customerId, checked)).isSuccess() && groupSR.getValue() != null) {
            List groups = (List)groupSR.getValue();
            groups.forEach(group -> {
                Integer coldChain = 1;
                for (MallProductVO product : group.getProductList()) {
                    if (product.getSelfMadeType() != 2) continue;
                    coldChain = 2;
                }
                if (coldChain == 1) {
                    coldChainCart.getGroups().add((MallGroupVO)group);
                } else if (coldChain == 2) {
                    nomalTempCart.getGroups().add((MallGroupVO)group);
                }
            });
        }
        if ((promotionSR = this.buildShoppingcartPromotions(customerId, checked)).isSuccess() && promotionSR.getValue() != null) {
            List promotions = (List)promotionSR.getValue();
            promotions.forEach(promotion -> {
                if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(promotion.getProductType())) {
                    MallProductVO product = promotion.getProduct();
                    if (product != null && product.getSelfMadeType() == 1) {
                        coldChainCart.getPromotions().add((MallPromotionVO)promotion);
                    } else {
                        nomalTempCart.getPromotions().add((MallPromotionVO)promotion);
                    }
                } else if (String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(promotion.getProductType())) {
                    MallGroupVO group = promotion.getGroup();
                    Integer coldChain = 1;
                    if (group != null && group.getProductList() != null && group.getProductList().size() > 0) {
                        for (MallProductVO product : group.getProductList()) {
                            if (product.getSelfMadeType() != 2) continue;
                            coldChain = 2;
                        }
                    }
                    if (coldChain == 1) {
                        coldChainCart.getPromotions().add((MallPromotionVO)promotion);
                    } else if (coldChain == 2) {
                        nomalTempCart.getPromotions().add((MallPromotionVO)promotion);
                    }
                }
            });
        }
        this.calcService.calcShoppingcartVO(coldChainCart);
        this.calcService.calcShoppingcartVO(nomalTempCart);
        this.calcService.calcShoppingcartVO(quickShoppingCart);
        this.collectProducts(coldChainCart);
        this.collectProducts(nomalTempCart);
        this.collectProducts(quickShoppingCart);
        BaseJsonVo result = new BaseJsonVo();
        ArrayList<MallShoppingcartVO> returnList = new ArrayList<MallShoppingcartVO>();
        if (coldChainCart.getProducts() != null && coldChainCart.getProducts().size() > 0 || coldChainCart.getGroups() != null && coldChainCart.getGroups().size() > 0 || coldChainCart.getPromotions() != null && coldChainCart.getPromotions().size() > 0 || coldChainCart.getFrees() != null && coldChainCart.getFrees().size() > 0) {
            returnList.add(coldChainCart);
        }
        if (nomalTempCart.getProducts() != null && nomalTempCart.getProducts().size() > 0 || nomalTempCart.getGroups() != null && nomalTempCart.getGroups().size() > 0 || nomalTempCart.getPromotions() != null && nomalTempCart.getPromotions().size() > 0 || nomalTempCart.getFrees() != null && nomalTempCart.getFrees().size() > 0) {
            returnList.add(nomalTempCart);
        }
        if (quickShoppingCart.getProducts() != null && quickShoppingCart.getProducts().size() > 0) {
            returnList.add(quickShoppingCart);
        }
        result.setValue(returnList);
        return result;
    }

    @Override
    public BaseJsonVo buildShoppingcartProducts(String customerId, Boolean checked) {
        BaseJsonVo sr = new BaseJsonVo();
        List<MallShoppingcartEntity> cartEntityList = this.cartMapper.getWechatCartByType(customerId, SalesTypeEnum.SALES_PRODUCT.getValue(), checked);
        ArrayList<MallProductVO> productVOList = new ArrayList<MallProductVO>();
        for (MallShoppingcartEntity entity : cartEntityList) {
            BaseJsonVo prosr = this.productService.buildProductVO(entity.getSalesId(), entity.getQuantity(), null, null, null, null, false, entity.getChecked() != 0, entity.getSpeedUp(), customerId);
            if (!prosr.isSuccess()) continue;
            productVOList.add((MallProductVO)prosr.getValue());
        }
        sr.setValue(productVOList);
        return sr;
    }

    @Override
    public BaseJsonVo buildShoppingcartGroups(String customerId, Boolean checked) {
        BaseJsonVo sr = new BaseJsonVo();
        List<MallShoppingcartEntity> cartEntityList = this.cartMapper.getWechatCartByType(customerId, SalesTypeEnum.SALES_GROUP.getValue(), checked);
        ArrayList<MallGroupVO> groupVOList = new ArrayList<MallGroupVO>();
        for (MallShoppingcartEntity entity : cartEntityList) {
            BaseJsonVo groupsr = this.groupService.buildGroupVO(entity.getSalesId(), entity.getQuantity(), null, entity.getChecked() != 0);
            if (!groupsr.isSuccess()) continue;
            groupVOList.add((MallGroupVO)groupsr.getValue());
        }
        sr.setValue(groupVOList);
        return sr;
    }

    @Override
    public BaseJsonVo buildShoppingcartPromotions(String customerId, Boolean checked) {
        BaseJsonVo sr = new BaseJsonVo();
        List<MallShoppingcartEntity> cartEntityList = this.cartMapper.getWechatCartByType(customerId, SalesTypeEnum.SALES_PROMOTION.getValue(), checked);
        ArrayList<MallPromotionVO> promotionVOList = new ArrayList<MallPromotionVO>();
        for (MallShoppingcartEntity entity : cartEntityList) {
            MallPromotionEntity promotionEntity = this.promotionService.getPromotion(entity.getSalesId());
            BaseJsonVo promotionsr = this.promotionService.buildPromotionVO(entity.getSalesId(), entity.getQuantity(), entity.getChecked() != 0);
            if (!promotionsr.isSuccess()) continue;
            MallPromotionVO promotionVO = (MallPromotionVO)promotionsr.getValue();
            if (promotionVO.getValid().booleanValue()) {
                promotionVOList.add(promotionVO);
                continue;
            }
            promotionVOList.add(promotionVO);
        }
        sr.setValue(promotionVOList);
        return sr;
    }

    @Override
    public void collectProducts(MallShoppingcartVO cartVO) {
        if (cartVO == null) {
            return;
        }
        ArrayList<MallProductVO> productPool = new ArrayList<MallProductVO>();
        if (cartVO.getProducts() != null) {
            for (MallProductVO mallProductVO : cartVO.getProducts()) {
                productPool.add(mallProductVO);
            }
        }
        if (cartVO.getGroups() != null) {
            for (MallGroupVO mallGroupVO : cartVO.getGroups()) {
                if (mallGroupVO == null) continue;
                for (MallProductVO proVO : mallGroupVO.getProductList()) {
                    proVO.setValid(mallGroupVO.getValid());
                    productPool.add(proVO);
                }
            }
        }
        if (cartVO.getPromotions() != null) {
            for (MallPromotionVO mallPromotionVO : cartVO.getPromotions()) {
                if (mallPromotionVO == null) continue;
                if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(mallPromotionVO.getProductType()).intValue()) {
                    if (mallPromotionVO.getProduct() == null) continue;
                    mallPromotionVO.getProduct().setValid(mallPromotionVO.getValid());
                    mallPromotionVO.getProduct().setPromotionName(mallPromotionVO.getPromotionName());
                    mallPromotionVO.getProduct().setPromotionId(mallPromotionVO.getPromotionId());
                    productPool.add(mallPromotionVO.getProduct());
                    continue;
                }
                if (SalesTypeEnum.SALES_GROUP.getValue() != Integer.valueOf(mallPromotionVO.getProductType()).intValue() || mallPromotionVO.getGroup() == null) continue;
                for (MallProductVO proVO : mallPromotionVO.getGroup().getProductList()) {
                    proVO.setValid(mallPromotionVO.getValid());
                    proVO.setPromotionId(mallPromotionVO.getPromotionId());
                    proVO.setPromotionName(mallPromotionVO.getPromotionName());
                    productPool.add(proVO);
                }
            }
        }
        if (cartVO.getFrees() != null) {
            cartVO.getFrees().forEach(vo -> {
                if (vo != null) {
                    vo.getProductList().forEach(proVO -> productPool.add((MallProductVO)proVO));
                }
            });
        }
        cartVO.setProductsPool(productPool);
    }

    @Override
    public BaseJsonVo buildCart(Integer platformId, String customerId, CustomerAddressVo addr, Boolean isQuick) {
        long startTime = System.currentTimeMillis();
        logger.info("***********buildCart\u8c03\u7528\u6b21\u6570\u63d0\u793a********");
        String speedUpStr = "0";
        int generalSort = 0;
        int quickSort = 1;
        logger.info("========\u5730\u5740\u662f\u5426\u6025\u901f\u8fbe======speedUpStr={}", (Object)speedUpStr);
        if (isQuick == null) {
            isQuick = false;
        }
        BaseJsonVo result = new BaseJsonVo();
        BaseJsonVo sr = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platformId, customerId, false);
        if (sr.isSuccess()) {
            List cartVOs = (List)sr.getValue();
            logger.info("--buildCart.cartVOs------------cartVOs={}", (Object)JSON.toJSONString((Object)cartVOs));
            HashMap<String, Object> quickMap = new HashMap<String, Object>();
            HashMap<String, Object> generalMap = new HashMap<String, Object>();
            HashMap returnMap = new HashMap();
            Integer[] count = new Integer[]{0, 0, 0, 0, 0, 0};
            BigDecimal[] price = new BigDecimal[]{new BigDecimal("0")};
            BigDecimal[] factPrice = new BigDecimal[]{new BigDecimal("0")};
            Integer[] quickCount = new Integer[]{0, 0, 0, 0, 0, 0};
            BigDecimal[] quickPrice = new BigDecimal[]{new BigDecimal("0")};
            BigDecimal[] quickFactPrice = new BigDecimal[]{new BigDecimal("0")};
            AtomicReference<Boolean> coldGroups = new AtomicReference<Boolean>(false);
            AtomicReference<Boolean> nomalGroups = new AtomicReference<Boolean>(false);
            String[] speedUp = new String[]{"0", "0"};
            String[] coldBalanceStatus = new String[]{"true"};
            String[] nomalBalanceStatus = new String[]{"true"};
            String[] quickBalanceStatus = new String[]{"true"};
            String balanceStatus = "2";
            Integer[] balanceStatusFlag = new Integer[]{0, 0};
            String[] promotionIds = new String[]{""};
            String[] groupIds = new String[]{""};
            String[] productIds = new String[]{""};
            logger.info("========buildCart======cartVOs={}", (Object)JSON.toJSONString((Object)cartVOs));
            cartVOs.forEach(cartVO -> {
                cartVO.getProducts().forEach(product -> {
                    if ("1".equals(product.getSpeedUp())) {
                        speedUp[0] = product.getSpeedUp();
                        if (product.getValid().booleanValue()) {
                            productIds[0] = productIds[0] + product.getProId() + ",";
                            quickCount[0] = quickCount[0] + 1;
                            quickCount[5] = quickCount[5] + product.getCount();
                            if (product.getShoppingcartCheck().booleanValue()) {
                                quickCount[3] = quickCount[3] + product.getCount();
                            }
                            if (cartVO.getSelfMadeType() == 1) {
                                quickCount[1] = quickCount[1] + 1;
                            } else {
                                quickCount[2] = quickCount[2] + 1;
                            }
                        } else {
                            quickCount[4] = quickCount[4] + 1;
                        }
                        if ("true".equals(quickBalanceStatus[0]) && product.getStockCount() < product.getCount()) {
                            quickBalanceStatus[0] = "false";
                        }
                    } else if (product.getValid().booleanValue()) {
                        productIds[0] = productIds[0] + product.getProId() + ",";
                        count[0] = count[0] + 1;
                        count[5] = count[5] + product.getCount();
                        if (product.getShoppingcartCheck().booleanValue()) {
                            count[3] = count[3] + product.getCount();
                        }
                        if (cartVO.getSelfMadeType() == 1) {
                            count[1] = count[1] + 1;
                            if (coldBalanceStatus[0] == "true" && product.getStockCount() < product.getCount()) {
                                coldBalanceStatus[0] = "false";
                            }
                        } else {
                            count[2] = count[2] + 1;
                            if (nomalBalanceStatus[0] == "true" && product.getStockCount() < product.getCount()) {
                                nomalBalanceStatus[0] = "false";
                            }
                        }
                    } else {
                        count[4] = count[4] + 1;
                    }
                });
                cartVO.getGroups().forEach(group -> {
                    if (group.getValid().booleanValue()) {
                        groupIds[0] = groupIds[0] + group.getGroupId() + ",";
                        count[0] = count[0] + 1;
                        count[5] = count[5] + group.getCount();
                        if (group.getShoppingcartCheck().booleanValue()) {
                            count[3] = count[3] + group.getCount();
                        }
                        if (cartVO.getSelfMadeType() == 1) {
                            count[1] = count[1] + 1;
                        } else {
                            count[2] = count[2] + 1;
                        }
                    } else {
                        count[4] = count[4] + 1;
                    }
                });
                cartVO.getPromotions().forEach(promotion -> {
                    if (promotion.getValid().booleanValue()) {
                        promotionIds[0] = promotionIds[0] + promotion.getPromotionId() + ",";
                        count[0] = count[0] + 1;
                        count[5] = count[5] + promotion.getCount();
                        if (promotion.getShoppingcartCheck().booleanValue()) {
                            count[3] = count[3] + promotion.getCount();
                        }
                        if (cartVO.getSelfMadeType() == 1) {
                            count[1] = count[1] + 1;
                        } else {
                            count[2] = count[2] + 1;
                        }
                    } else {
                        count[4] = count[4] + 1;
                    }
                });
                if ("1".equals(cartVO.getSpeedUp())) {
                    quickPrice[0] = PriceUtils.add((BigDecimal)cartVO.getPrice(), (BigDecimal)quickPrice[0]);
                    quickFactPrice[0] = PriceUtils.add((BigDecimal)cartVO.getFactPrice(), (BigDecimal)quickFactPrice[0]);
                } else {
                    price[0] = PriceUtils.add((BigDecimal)cartVO.getPrice(), (BigDecimal)price[0]);
                    factPrice[0] = PriceUtils.add((BigDecimal)cartVO.getFactPrice(), (BigDecimal)factPrice[0]);
                }
                DeliverVo deliverVo = this.deliverNewErpService.getDeliverByErp((MallShoppingcartVO)cartVO, addr, null, 1, 1);
                if (StringUtils.isEmpty((String)deliverVo.getPickDate())) {
                    if (deliverVo.getDeliverDates() != null && deliverVo.getDeliverDates().size() > 0) {
                        balanceStatusFlag[0] = 1;
                        balanceStatusFlag[1] = 1;
                    } else if (!(balanceStatusFlag[0] == 1 && balanceStatusFlag[1] == 1 || deliverVo.getInventory() != -1 && deliverVo.getInventory() != -2 && deliverVo.getDeliverDates() != null)) {
                        balanceStatusFlag[0] = 0;
                        balanceStatusFlag[1] = 1;
                    }
                }
                if ("1".equals(cartVO.getSpeedUp())) {
                    if (cartVO.getSelfMadeType() == 1) {
                        quickMap.put("coldChainCart", cartVO);
                        quickMap.put("coldChainDeliver", deliverVo);
                    } else {
                        quickMap.put("nomalTempCart", cartVO);
                        quickMap.put("nomalTempDeliver", deliverVo);
                    }
                } else if (cartVO.getSelfMadeType() == 1) {
                    generalMap.put("coldChainCart", cartVO);
                    generalMap.put("coldChainDeliver", deliverVo);
                } else {
                    generalMap.put("nomalTempCart", cartVO);
                    generalMap.put("nomalTempDeliver", deliverVo);
                }
            });
            if (quickMap.containsKey("coldChainDeliver")) {
                returnMap.put("deliver", quickMap.get("coldChainDeliver"));
                quickMap.remove("coldChainDeliver");
                quickMap.remove("nomalTempDeliver");
            } else if (quickMap.containsKey("nomalTempDeliver")) {
                returnMap.put("deliver", quickMap.get("nomalTempDeliver"));
                quickMap.remove("nomalTempDeliver");
            } else if (generalMap.containsKey("coldChainDeliver")) {
                DeliverVo coldDeliverVo = (DeliverVo)generalMap.get("coldChainDeliver");
                DeliverVo nomalDeliverVo = (DeliverVo)generalMap.get("nomalTempDeliver");
                DeliverVo newDeliverVo = new DeliverVo();
                if (nomalDeliverVo != null && nomalDeliverVo.getDeliverDates() != null && nomalDeliverVo.getDeliverDates().size() > 0) {
                    block0: for (int i = 0; i < nomalDeliverVo.getDeliverDates().size(); ++i) {
                        DeliverSoldProductVo nomalDeliverSoldProductVo = nomalDeliverVo.getDeliverDates().get(i);
                        if (coldDeliverVo == null || coldDeliverVo.getDeliverDates() == null || coldDeliverVo.getDeliverDates().size() <= 0) continue;
                        for (DeliverSoldProductVo coldDeliverSoldProductVo : coldDeliverVo.getDeliverDates()) {
                            if (!nomalDeliverSoldProductVo.getTime().equals(coldDeliverSoldProductVo.getTime())) continue;
                            coldDeliverSoldProductVo.getProductForms().addAll(nomalDeliverSoldProductVo.getProductForms());
                            nomalDeliverVo.getDeliverDates().set(i, null);
                            continue block0;
                        }
                    }
                    if (coldDeliverVo != null && coldDeliverVo.getDeliverDates() != null && coldDeliverVo.getDeliverDates().size() > 0) {
                        for (DeliverSoldProductVo deliverSoldProductVo : nomalDeliverVo.getDeliverDates()) {
                            if (deliverSoldProductVo == null) continue;
                            coldDeliverVo.getDeliverDates().add(deliverSoldProductVo);
                        }
                        coldDeliverVo.getDeliverDates().sort((f1, f2) -> String.valueOf(f1.getTime()).compareTo(String.valueOf(f2.getTime())));
                    } else {
                        coldDeliverVo = nomalDeliverVo;
                    }
                }
                returnMap.put("deliver", coldDeliverVo);
                generalMap.remove("coldChainDeliver");
                generalMap.remove("nomalTempDeliver");
            } else if (generalMap.containsKey("nomalTempDeliver")) {
                returnMap.put("deliver", generalMap.get("nomalTempDeliver"));
                generalMap.remove("nomalTempDeliver");
            } else {
                MallShoppingcartVO cartVO2 = new MallShoppingcartVO();
                cartVO2.setOrderSource(OrderSourceEnum.CART.getValue());
                cartVO2.setPlatFormId(platformId);
                cartVO2.setPlatFormGroupId(this.platFormService.getPlatFormGroupId(platformId));
                cartVO2.setDeliverCount(1);
                returnMap.put("deliver", this.deliverNewErpService.getDeliverByErp(cartVO2, addr, null, -1, 1));
            }
            BigDecimal freightAmount = new BigDecimal("0");
            BigDecimal quickFreightAmount = new BigDecimal("0");
            ArrayList<MallFreightCalVo> mallFreightCalVoList = new ArrayList<MallFreightCalVo>();
            String coldchainNotice = "";
            String nomalNotice = "";
            String quickNotice = "";
            if (!coldGroups.get().booleanValue() || !nomalGroups.get().booleanValue()) {
                if (count[1] + count[2] <= 0 && quickCount[1] + quickCount[2] <= 0) {
                    if ("1".equals(speedUpStr)) {
                        quickSort = 0;
                        generalSort = 1;
                    }
                    freightAmount = new BigDecimal("0");
                    quickFreightAmount = new BigDecimal("0");
                    coldBalanceStatus[0] = "false";
                    nomalBalanceStatus[0] = "false";
                    quickBalanceStatus[0] = "false";
                } else {
                    MallFreightCalVo mallFreightCalVo;
                    if ("1".equals(speedUpStr)) {
                        if (quickCount[1] + quickCount[2] > 0) {
                            quickSort = 0;
                            generalSort = 1;
                        } else {
                            quickBalanceStatus[0] = "false";
                        }
                    }
                    if (count[1] + count[2] <= 0) {
                        coldBalanceStatus[0] = "false";
                        nomalBalanceStatus[0] = "false";
                    }
                    int sizeCart = cartVOs.size() - 1;
                    if ("1".equals(speedUp[0])) {
                        mallFreightCalVo = new MallFreightCalVo();
                        mallFreightCalVo.setCityId(addr.getCityId().toString());
                        mallFreightCalVo.setOrderSource(OrderSourceEnum.CART.getValue());
                        mallFreightCalVo.setDeliverId("3");
                        mallFreightCalVo.setProductId(productIds[0]);
                        mallFreightCalVo.setPromotionId(promotionIds[0]);
                        mallFreightCalVo.setGorupId(groupIds[0]);
                        if (cartVOs != null && cartVOs.size() > 1) {
                            mallFreightCalVo.setAmount(((MallShoppingcartVO)cartVOs.get(sizeCart)).getPrice());
                            mallFreightCalVo.setPlatFormGroupId(((MallShoppingcartVO)cartVOs.get(sizeCart)).getPlatFormGroupId());
                            mallFreightCalVo.setBindCode(((MallShoppingcartVO)cartVOs.get(sizeCart)).getBindCode());
                        } else {
                            mallFreightCalVo.setAmount(((MallShoppingcartVO)cartVOs.get(0)).getPrice());
                            mallFreightCalVo.setPlatFormGroupId(((MallShoppingcartVO)cartVOs.get(0)).getPlatFormGroupId());
                        }
                        mallFreightCalVoList.add(mallFreightCalVo);
                    }
                    if ("0".equals(speedUp[1])) {
                        logger.info("------------buildCart--cartVOs=================={}", (Object)JSON.toJSONString((Object)cartVOs));
                        if (count[1] > 0) {
                            mallFreightCalVo = new MallFreightCalVo();
                            mallFreightCalVo.setCityId(addr.getCityId().toString());
                            mallFreightCalVo.setOrderSource(OrderSourceEnum.CART.getValue());
                            mallFreightCalVo.setDeliverId("1");
                            mallFreightCalVo.setPlatFormGroupId(((MallShoppingcartVO)cartVOs.get(0)).getPlatFormGroupId());
                            mallFreightCalVo.setAmount(((MallShoppingcartVO)cartVOs.get(0)).getPrice());
                            mallFreightCalVo.setProductId(productIds[0]);
                            mallFreightCalVo.setPromotionId(promotionIds[0]);
                            mallFreightCalVo.setGorupId(groupIds[0]);
                            mallFreightCalVo.setBindCode(((MallShoppingcartVO)cartVOs.get(0)).getBindCode());
                            mallFreightCalVoList.add(mallFreightCalVo);
                        }
                        if (count[2] > 0) {
                            mallFreightCalVo = new MallFreightCalVo();
                            mallFreightCalVo.setCityId(addr.getCityId().toString());
                            mallFreightCalVo.setOrderSource(OrderSourceEnum.CART.getValue());
                            mallFreightCalVo.setDeliverId("2");
                            mallFreightCalVo.setPlatFormGroupId(((MallShoppingcartVO)cartVOs.get(sizeCart)).getPlatFormGroupId());
                            mallFreightCalVo.setAmount(((MallShoppingcartVO)cartVOs.get(sizeCart)).getPrice());
                            mallFreightCalVo.setProductId(productIds[0]);
                            mallFreightCalVo.setPromotionId(promotionIds[0]);
                            mallFreightCalVo.setGorupId(groupIds[0]);
                            mallFreightCalVo.setBindCode(((MallShoppingcartVO)cartVOs.get(0)).getBindCode());
                            mallFreightCalVoList.add(mallFreightCalVo);
                        }
                    }
                    JSONArray freightArray = this.mallFreightService.getFreightByCityAmountDeliveryType(mallFreightCalVoList, coldGroups.get(), nomalGroups.get());
                    logger.info("\u8ba1\u7b97\u8fd0\u8d39mallFreightCalVoList={},\u8fd4\u56de\u8fd0\u8d39freightArray={}", (Object)JSON.toJSONString(mallFreightCalVoList), (Object)freightArray);
                    if (freightArray != null && freightArray.size() > 0) {
                        for (JSONObject freightObject : freightArray) {
                            String freightAmountStr = freightObject.getString("freightAmount");
                            String deliveryType = freightObject.getString("deliveryType");
                            if ("1".equals(deliveryType)) {
                                coldchainNotice = freightObject.getString("coldchainNotice");
                                coldBalanceStatus[0] = freightObject.getString("coldBalanceStatus");
                                freightAmount = freightAmount.add(new BigDecimal(freightAmountStr));
                            }
                            if ("2".equals(deliveryType)) {
                                nomalNotice = freightObject.getString("nomalNotice");
                                nomalBalanceStatus[0] = freightObject.getString("nomalBalanceStatus");
                                freightAmount = freightAmount.add(new BigDecimal(freightAmountStr));
                            }
                            if (!"3".equals(deliveryType)) continue;
                            logger.info("=====quickBalanceStatus[0]=======quickBalanceStatus[0]={},quickBalanceStatusAndTrue={}", (Object)quickBalanceStatus[0], (Object)"true".equals(quickBalanceStatus[0]));
                            if ("true".equals(quickBalanceStatus[0])) {
                                quickBalanceStatus[0] = freightObject.getString("quickBalanceStatus");
                                logger.info("=======quickBalanceStatusAndTrue={}", (Object)"true".equals(quickBalanceStatus[0]));
                            }
                            quickNotice = freightObject.getString("quickNotice");
                            quickFreightAmount = quickFreightAmount.add(new BigDecimal(freightAmountStr));
                        }
                    } else {
                        freightAmount = new BigDecimal("0");
                        quickFreightAmount = new BigDecimal("0");
                    }
                }
            }
            if (coldGroups.get().booleanValue()) {
                coldchainNotice = "\u5df2\u514d\u8fd0\u8d39";
                coldBalanceStatus[0] = "true";
            }
            if (nomalGroups.get().booleanValue()) {
                nomalNotice = "\u5df2\u514d\u8fd0\u8d39";
                nomalBalanceStatus[0] = "true";
            }
            if ("true".equals(nomalBalanceStatus[0]) && "true".equals(coldBalanceStatus[0])) {
                balanceStatus = "1";
            }
            if (balanceStatusFlag[0] == 1 && balanceStatusFlag[1] == 1) {
                balanceStatus = "3";
            }
            generalMap.put("coldchainNotice", coldchainNotice);
            generalMap.put("nomalNotice", nomalNotice);
            generalMap.put("nomalBalanceStatus", nomalBalanceStatus[0]);
            generalMap.put("coldBalanceStatus", coldBalanceStatus[0]);
            generalMap.put("quickNotice", quickNotice);
            generalMap.put("quickBalanceStatus", quickBalanceStatus[0]);
            generalMap.put("balanceStatus", balanceStatus);
            generalMap.put("count", count[0]);
            generalMap.put("invalidCount", count[4]);
            generalMap.put("coldchainCount", count[1]);
            generalMap.put("nomalCount", count[2]);
            generalMap.put("price", PriceUtils.add((BigDecimal)price[0], (BigDecimal)freightAmount));
            generalMap.put("factPrice", PriceUtils.add((BigDecimal)factPrice[0], (BigDecimal)freightAmount));
            generalMap.put("totalQuantity", count[3]);
            generalMap.put("totalQuantityWithUncheck", count[5]);
            generalMap.put("sort", generalSort);
            generalMap.put("freight", freightAmount);
            generalMap.put("commodityTotalPrice", price[0]);
            quickMap.put("coldchainNotice", coldchainNotice);
            quickMap.put("nomalNotice", nomalNotice);
            quickMap.put("nomalBalanceStatus", nomalBalanceStatus[0]);
            quickMap.put("coldBalanceStatus", coldBalanceStatus[0]);
            quickMap.put("quickNotice", quickNotice);
            quickMap.put("quickBalanceStatus", quickBalanceStatus[0]);
            quickMap.put("balanceStatus", quickBalanceStatus[0]);
            quickMap.put("count", quickCount[0]);
            quickMap.put("invalidCount", quickCount[4]);
            quickMap.put("coldchainCount", quickCount[1]);
            quickMap.put("nomalCount", quickCount[2]);
            quickMap.put("price", PriceUtils.add((BigDecimal)quickPrice[0], (BigDecimal)quickFreightAmount));
            quickMap.put("factPrice", PriceUtils.add((BigDecimal)quickFactPrice[0], (BigDecimal)quickFreightAmount));
            quickMap.put("freight", quickFreightAmount);
            quickMap.put("commodityTotalPrice", quickPrice[0]);
            quickMap.put("totalQuantity", quickCount[3]);
            quickMap.put("totalQuantityWithUncheck", quickCount[5]);
            quickMap.put("sort", quickSort);
            int totalQuantity = 0;
            int totalQuantityWithUncheck = 0;
            returnMap.put("address", addr);
            if ("1".equals(speedUpStr)) {
                returnMap.put("quickCart", quickMap);
                totalQuantity = count[3] + quickCount[3];
                totalQuantityWithUncheck = count[5] + quickCount[5];
            } else {
                totalQuantity = count[3];
                totalQuantityWithUncheck = count[5];
            }
            returnMap.put("totalQuantity", totalQuantity);
            returnMap.put("totalQuantityWithUncheck", totalQuantityWithUncheck);
            returnMap.put("generalCart", generalMap);
            result.setValue(returnMap);
            long endTime = System.currentTimeMillis();
            long time = endTime - startTime;
            if (time > 1000L) {
                logger.info("*************************cc.lechun.mall.service.shoppingcart.buildCart.Time*************************time={}", (Object)time);
            }
            return result;
        }
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseJsonVo addCart(Integer platformId, String customerId, Integer salesType, String salesId, String activeNo, Integer quantity, Boolean isQuick) {
        logger.info("=====================addCart\u8abf\u7528\u6b21\u6578==================");
        BaseJsonVo result = new BaseJsonVo();
        try {
            boolean tryLock;
            block46: {
                block45: {
                    MallShoppingcartEntity entity;
                    block47: {
                        block48: {
                            block50: {
                                block49: {
                                    tryLock = this.redisLock.tryLock("mall_shopping_cart_entity", "mallShoppingcartEntity", 60000L);
                                    long startTime = System.nanoTime();
                                    logger.info("==============\u8bbe\u7f6e\u9501====tryLock={},\u6642\u9593\u958b\u59cbstartTime={}", (Object)tryLock, (Object)startTime);
                                    if (!tryLock) break block46;
                                    entity = this.cartMapper.getAddProduct(customerId, salesType, salesId, isQuick == null || isQuick == false ? "0" : "1");
                                    if (quantity <= 0) break block47;
                                    if (entity != null) break block48;
                                    entity = new MallShoppingcartEntity();
                                    entity.setCustomerId(customerId);
                                    entity.setPromotionId(SalesTypeEnum.SALES_PROMOTION.getValue() == salesType.intValue() ? salesId : "");
                                    entity.setChannelId((short)1);
                                    if (SalesTypeEnum.SALES_PROMOTION.getValue() != salesType.intValue()) break block49;
                                    MallPromotionProductEntity product2 = this.promotionProductService.getPromotionProductEntity(salesId);
                                    if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(product2.getProductType())) {
                                        entity.setGroupType(SalesTypeEnum.SALES_PRODUCT.getValue());
                                        entity.setProductId(product2.getProductId());
                                        break block50;
                                    } else if (String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(product2.getProductType())) {
                                        entity.setGroupType(SalesTypeEnum.SALES_GROUP.getValue());
                                        entity.setGroupId(product2.getProductId());
                                    }
                                    break block50;
                                }
                                if (SalesTypeEnum.SALES_PRODUCT.getValue() == salesType.intValue()) {
                                    entity.setGroupType(salesType);
                                    entity.setProductId(salesId);
                                } else if (SalesTypeEnum.SALES_GROUP.getValue() == salesType.intValue()) {
                                    entity.setGroupType(salesType);
                                    entity.setGroupId(salesId);
                                }
                            }
                            entity.setQuantity(0);
                            entity.setCreateTime(DateUtils.now());
                            entity.setUpdateTime(entity.getCreateTime());
                            entity.setActiveNo(activeNo);
                            entity.setActiveName(activeNo);
                            entity.setUniqueId(platformId + customerId + "1" + salesId);
                            entity.setSalesType(salesType);
                            entity.setSalesId(salesId);
                            entity.setChecked(1);
                            String speedupStr = isQuick != false ? "1" : "0";
                            logger.info("isQuick={},speedupStr={}", (Object)isQuick, (Object)speedupStr);
                            entity.setSpeedUp(speedupStr);
                            entity.setUniqueId(platformId + customerId + speedupStr + salesId);
                            entity.setPlatformGroupId(this.platFormService.getPlatFormGroupId(platformId));
                        }
                        if (SalesTypeEnum.SALES_PRODUCT.getValue() == salesType.intValue()) {
                            BaseJsonVo productSR = this.productService.buildProductVO(entity.getSalesId(), entity.getQuantity() + quantity, null, null, null, null, false, false, entity.getSpeedUp(), null);
                            if (!productSR.isSuccess()) {
                                result.setError("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728");
                                BaseJsonVo product3 = result;
                                return product3;
                            }
                            MallProductVO product3 = (MallProductVO)productSR.getValue();
                            if (!product3.getValid().booleanValue()) {
                                result.setError(product3.getInvalidReason());
                                BaseJsonVo baseJsonVo = result;
                                return baseJsonVo;
                            }
                            Boolean flag = true;
                            if (!flag.booleanValue()) {
                                result.setError("\u5f53\u524d\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                                BaseJsonVo baseJsonVo = result;
                                return baseJsonVo;
                            }
                        } else if (SalesTypeEnum.SALES_GROUP.getValue() == salesType.intValue()) {
                            BaseJsonVo groupSR = this.groupService.buildGroupVO(salesId, entity.getQuantity() + quantity, null, false);
                            if (!groupSR.isSuccess()) {
                                result.setError("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728");
                                BaseJsonVo group = result;
                                return group;
                            }
                            MallGroupVO group = (MallGroupVO)groupSR.getValue();
                            if (!group.getValid().booleanValue()) {
                                result.setError(group.getInvalidReason());
                                BaseJsonVo flag = result;
                                return flag;
                            }
                            Boolean[] flag = new Boolean[]{true};
                            group.getProductList().forEach(product -> {
                                flag[0] = true;
                            });
                            if (!flag[0].booleanValue()) {
                                result.setError("\u5f53\u524d\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                                BaseJsonVo baseJsonVo = result;
                                return baseJsonVo;
                            }
                        } else if (SalesTypeEnum.SALES_PROMOTION.getValue() == salesType.intValue()) {
                            BaseJsonVo promotionSR = this.promotionService.buildPromotionVO(salesId, entity.getQuantity() + quantity, false);
                            if (!promotionSR.isSuccess()) {
                                result.setError("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728");
                                BaseJsonVo baseJsonVo = result;
                                return baseJsonVo;
                            }
                            MallPromotionVO promotion = (MallPromotionVO)promotionSR.getValue();
                            if (!promotion.getValid().booleanValue()) {
                                result.setError(promotion.getInvalidReason());
                                BaseJsonVo flag = result;
                                return flag;
                            }
                            if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(promotion.getProductType())) {
                                MallProductVO product4 = promotion.getProduct();
                                Boolean flag = true;
                                if (!flag.booleanValue()) {
                                    result.setError("\u5f53\u524d\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                                    BaseJsonVo baseJsonVo = result;
                                    return baseJsonVo;
                                }
                            } else {
                                if (!String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(promotion.getProductType())) {
                                    result.setError("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728");
                                    BaseJsonVo baseJsonVo = result;
                                    return baseJsonVo;
                                }
                                MallGroupVO group = promotion.getGroup();
                                Boolean[] flag = new Boolean[]{true};
                                group.getProductList().forEach(product -> {
                                    flag[0] = true;
                                });
                                if (!flag[0].booleanValue()) {
                                    result.setError("\u5f53\u524d\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                                    BaseJsonVo baseJsonVo = result;
                                    return baseJsonVo;
                                }
                            }
                        }
                        entity.setQuantity(entity.getQuantity() + quantity);
                        logger.info("------------addCart----------------Quantity={}", (Object)entity.getQuantity());
                        if (entity.getShoppingId() == null) {
                            logger.info("------------addCart----------------entity={}", (Object)JSON.toJSONString((Object)entity));
                            this.cartMapper.insert(entity);
                            break block45;
                        } else {
                            entity.setChecked(1);
                            this.cartMapper.updateByPrimaryKeySelective(entity);
                        }
                        break block45;
                    }
                    if (entity == null) {
                        BaseJsonVo promotionSR = result;
                        return promotionSR;
                    }
                    if (entity.getQuantity() > 0 && entity.getQuantity() > Math.abs(quantity)) {
                        entity.setQuantity(entity.getQuantity() + quantity);
                        entity.setChecked(1);
                        this.cartMapper.updateByPrimaryKeySelective(entity);
                    } else {
                        BaseJsonVo removeResult = this.removeCartProduct(entity.getShoppingId());
                        if (!removeResult.isSuccess()) {
                            result.setError(removeResult.getError_msg());
                        }
                    }
                }
                this.removeCache(customerId);
            }
            long endTime = System.nanoTime();
            logger.info("==============\u8bbe\u7f6e\u9501====tryLock={},\u6642\u9593\u7d50\u675fendTime={}", (Object)tryLock, (Object)endTime);
            logger.info("===================\u67b7\u9396\u4ee3\u78bc\u584a\u57f7\u884c\u5b8c\u7562=================");
            return result;
        }
        finally {
            logger.info("===============redisLock.unlock============");
            this.redisLock.unlock("mall_shopping_cart_entity");
        }
    }

    @Override
    public BaseJsonVo removeCartProduct(Integer shoppingId) {
        BaseJsonVo result = new BaseJsonVo();
        MallShoppingcartEntity entity = (MallShoppingcartEntity)this.cartMapper.selectByPrimaryKey(shoppingId);
        if (entity == null) {
            return result;
        }
        int affectedRows = this.cartMapper.deleteByPrimaryKey(shoppingId);
        if (affectedRows > 0) {
            return result;
        }
        result.setError("\u5220\u9664\u5931\u8d25");
        return result;
    }

    @Override
    public BaseJsonVo removeCartProduct(String customerId, String saleId) {
        BaseJsonVo result = new BaseJsonVo();
        int affectedRows = this.cartMapper.deleteCartProduct(customerId, saleId);
        this.removeCache(customerId);
        if (affectedRows > 0) {
            return result;
        }
        result.setError("\u5220\u9664\u5931\u8d25");
        return result;
    }

    @Override
    public BaseJsonVo removeCartInvalid(Integer platformId, String customerId) {
        BaseJsonVo sr = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platformId, customerId, false);
        if (sr.isSuccess()) {
            List cartList = (List)sr.getValue();
            cartList.forEach(cart -> {
                cart.getProducts().forEach(product -> {
                    if (!product.getValid().booleanValue()) {
                        this.removeCartProduct(customerId, product.getProId());
                    }
                });
                cart.getGroups().forEach(group -> {
                    if (!group.getValid().booleanValue()) {
                        this.removeCartProduct(customerId, group.getGroupId());
                    }
                });
                cart.getPromotions().forEach(promotion -> {
                    if (!promotion.getValid().booleanValue()) {
                        this.removeCartProduct(customerId, promotion.getPromotionId());
                    }
                });
            });
        }
        this.removeCache(customerId);
        return sr;
    }

    @Override
    public BaseJsonVo removeCartChecked(Integer platformId, String customerId, Boolean checked, Integer isQuick) {
        BaseJsonVo result = new BaseJsonVo();
        int rmCount = this.cartMapper.removeChecked(customerId, checked, isQuick);
        if (rmCount == 0) {
            result.setError("\u6e05\u9664\u8d2d\u7269\u8f66\u5931\u8d25");
        } else {
            result.setValue((Object)rmCount);
        }
        this.removeCache(customerId);
        return result;
    }

    @Override
    public BaseJsonVo findAddOnProducts(Integer platformId, String customerId, Integer selfMadeType) {
        BaseJsonVo result = new BaseJsonVo();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ArrayList addOnProducts = new ArrayList();
        List<MallProductEntity> allProducts = this.productService.getOnAndShowProductList(this.platFormService.getPlatForm(platformId).getPlatformGroupId());
        List<MallShoppingcartEntity> cartProducts = this.cartMapper.getWechatCartByType(customerId, SalesTypeEnum.SALES_PRODUCT.getValue(), false);
        if (allProducts != null && cartProducts != null && allProducts.size() > 0) {
            allProducts.forEach(allProduct -> {
                BaseJsonVo prosr;
                List filterList;
                if (selfMadeType.equals(allProduct.getSelfMadeType()) && ((filterList = cartProducts.stream().filter(cartProduct -> cartProduct.getSalesId().equals(allProduct.getProId())).collect(Collectors.toList())) == null || filterList.size() == 0) && (prosr = this.productService.buildProductVO(allProduct.getProId(), 1, null, null, null, null, false, false, null, null)).isSuccess()) {
                    addOnProducts.add((MallProductVO)prosr.getValue());
                }
            });
        }
        returnMap.put("addOnProducts", addOnProducts);
        BaseJsonVo sr = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platformId, customerId, false);
        if (sr.isSuccess()) {
            List cartVOs = (List)sr.getValue();
            cartVOs.get(selfMadeType - 1);
            if (selfMadeType.equals(1)) {
                // empty if block
            }
            returnMap.put("notice", "");
            returnMap.put("count", ((MallShoppingcartVO)cartVOs.get(selfMadeType - 1)).getProducts().size() + ((MallShoppingcartVO)cartVOs.get(selfMadeType - 1)).getGroups().size() + ((MallShoppingcartVO)cartVOs.get(selfMadeType - 1)).getPromotions().size());
            returnMap.put("price", ((MallShoppingcartVO)cartVOs.get(selfMadeType - 1)).getPrice());
            returnMap.put("factPrice", ((MallShoppingcartVO)cartVOs.get(selfMadeType - 1)).getFactPrice());
            result.setValue(returnMap);
            return result;
        }
        return sr;
    }

    @Override
    public BaseJsonVo checkCart(Integer platformId, String customerId, Integer checkType, String salesId) {
        BaseJsonVo result = new BaseJsonVo();
        if (1 == checkType) {
            this.cartMapper.checkAll(customerId, true);
        } else if (-1 == checkType) {
            this.cartMapper.checkAll(customerId, false);
        } else if (2 == checkType) {
            BaseJsonVo sr = this.shoppingcartInterface.buildShoppingcartFromShoppingcart(platformId, customerId, false);
            if (sr.isSuccess()) {
                List shoppingcartVOs = (List)sr.getValue();
                MallShoppingcartVO coldChainCart = (MallShoppingcartVO)shoppingcartVOs.get(0);
                coldChainCart.getProducts().forEach(product -> this.cartMapper.checkProduct(customerId, product.getProId(), true));
                coldChainCart.getGroups().forEach(group -> this.cartMapper.checkProduct(customerId, group.getGroupId(), true));
                coldChainCart.getPromotions().forEach(promotion -> this.cartMapper.checkProduct(customerId, promotion.getPromotionId(), true));
            }
        } else if (-2 == checkType) {
            BaseJsonVo sr = this.buildShoppingcartFromShoppingcart(platformId, customerId, false);
            if (sr.isSuccess()) {
                List shoppingcartVOs = (List)sr.getValue();
                MallShoppingcartVO coldChainCart = (MallShoppingcartVO)shoppingcartVOs.get(0);
                coldChainCart.getProducts().forEach(product -> this.cartMapper.checkProduct(customerId, product.getProId(), false));
                coldChainCart.getGroups().forEach(group -> this.cartMapper.checkProduct(customerId, group.getGroupId(), false));
                coldChainCart.getPromotions().forEach(promotion -> this.cartMapper.checkProduct(customerId, promotion.getPromotionId(), false));
            }
        } else if (3 == checkType) {
            BaseJsonVo sr = this.buildShoppingcartFromShoppingcart(platformId, customerId, false);
            if (sr.isSuccess()) {
                List shoppingcartVOs = (List)sr.getValue();
                MallShoppingcartVO nomalCart = (MallShoppingcartVO)shoppingcartVOs.get(1);
                nomalCart.getProducts().forEach(product -> this.cartMapper.checkProduct(customerId, product.getProId(), true));
                nomalCart.getGroups().forEach(group -> this.cartMapper.checkProduct(customerId, group.getGroupId(), true));
                nomalCart.getPromotions().forEach(promotion -> this.cartMapper.checkProduct(customerId, promotion.getPromotionId(), true));
            }
        } else if (-3 == checkType) {
            BaseJsonVo sr = this.buildShoppingcartFromShoppingcart(platformId, customerId, false);
            if (sr.isSuccess()) {
                List shoppingcartVOs = (List)sr.getValue();
                MallShoppingcartVO nomalCart = (MallShoppingcartVO)shoppingcartVOs.get(1);
                nomalCart.getProducts().forEach(product -> this.cartMapper.checkProduct(customerId, product.getProId(), false));
                nomalCart.getGroups().forEach(group -> this.cartMapper.checkProduct(customerId, group.getGroupId(), false));
                nomalCart.getPromotions().forEach(promotion -> this.cartMapper.checkProduct(customerId, promotion.getPromotionId(), false));
            }
        } else if (4 == checkType) {
            this.cartMapper.checkProduct(customerId, salesId, true);
        } else if (-4 == checkType) {
            this.cartMapper.checkProduct(customerId, salesId, false);
        }
        this.removeCache(customerId);
        return result;
    }

    @Override
    public List<Object> findRecommends(Integer platformGroupId) {
        ArrayList<Object> objs = new ArrayList<Object>();
        List<Map> products = this.productService.findRecommendProducts(platformGroupId);
        List<Map> groups = this.groupService.findRecommendGroups(platformGroupId);
        List<Map> promotions = this.promotionService.findRecommendPromotions(platformGroupId);
        if (products != null && products.size() > 0) {
            objs.addAll(products);
        }
        if (groups != null && groups.size() > 0) {
            objs.addAll(groups);
        }
        if (promotions != null && promotions.size() > 0) {
            objs.addAll(promotions);
        }
        return objs;
    }

    @Override
    public BaseJsonVo buildEmptyCart() {
        BaseJsonVo sr = new BaseJsonVo();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("address", null);
        map.put("deliver", null);
        map.put("coldchainCount", 0);
        map.put("count", 0);
        map.put("factPrice", 0);
        map.put("freight", 0);
        map.put("invalidCount", 0);
        map.put("nomalCount", 0);
        map.put("price", 0);
        map.put("totalQuantity", 0);
        map.put("totalQuantityWithUncheck", 0);
        sr.setValue(map);
        return sr;
    }

    private void removeCache(String customerId) {
        this.memcachedService.delete("shoppingcart", new String[]{customerId, String.valueOf(true)});
        this.memcachedService.delete("shoppingcart", new String[]{customerId, String.valueOf(false)});
    }

    private void test(String customerId) {
    }
}

