/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.shoppingcart;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.shoppingcart.OutStockMapper;
import cc.lechun.mall.entity.shoppingcart.OutStockEntity;
import cc.lechun.mall.entity.shoppingcart.OutStockQueryVo;
import cc.lechun.mall.entity.shoppingcart.ShoppingcartSoldoutRecordEntity;
import cc.lechun.mall.iservice.shoppingcart.OutStockInterface;
import cc.lechun.mall.iservice.shoppingcart.ShoppingcartSoldoutRecordInterface;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutStockService
extends BaseService<OutStockEntity, Integer>
implements OutStockInterface {
    @Resource
    private OutStockMapper outStockMapper;
    @Autowired
    private ShoppingcartSoldoutRecordInterface shoppingcartSoldoutRecordInterface;
    @Autowired
    private RedisService redisService;

    @Override
    public PageInfo getOutStockList(OutStockQueryVo outStockQueryVo) {
        Page page = PageHelper.startPage((int)outStockQueryVo.getCurrentPage(), (int)outStockQueryVo.getPageSize());
        page.setOrderBy("PICKUP_DATE desc");
        OutStockEntity outStockEntity = new OutStockEntity();
        BeanUtils.copyProperties((Object)outStockQueryVo, (Object)outStockEntity);
        this.outStockMapper.getList(outStockEntity);
        return page.toPageInfo();
    }

    @Override
    public BaseJsonVo updateRecord(Date datetime) {
        List<ShoppingcartSoldoutRecordEntity> list = this.shoppingcartSoldoutRecordInterface.getNewOutStockList(datetime);
        if (list.size() > 0) {
            list.forEach(shoppingcartSoldoutRecordEntity -> {
                String key = shoppingcartSoldoutRecordEntity.getCustomerId() + shoppingcartSoldoutRecordEntity.getProvince() + shoppingcartSoldoutRecordEntity.getCity() + shoppingcartSoldoutRecordEntity.getCity() + (StringUtils.isEmpty((String)shoppingcartSoldoutRecordEntity.getProductId()) ? "" : shoppingcartSoldoutRecordEntity.getProductId()) + (StringUtils.isEmpty((String)shoppingcartSoldoutRecordEntity.getPromotionId()) ? "" : shoppingcartSoldoutRecordEntity.getPromotionId()) + (StringUtils.isEmpty((String)shoppingcartSoldoutRecordEntity.getGroupId()) ? "" : shoppingcartSoldoutRecordEntity.getGroupId()) + DateUtils.formatDate((Date)shoppingcartSoldoutRecordEntity.getCreateTime(), (String)"yyyy-MM-dd");
                if (this.redisService.get(key = MD5.sign((String)"lechun", (String)key)) == null) {
                    String delivervoStr = shoppingcartSoldoutRecordEntity.getDelivervoStr();
                    JSONObject jsonObject = JSONObject.parseObject((String)delivervoStr);
                    JSONArray jsonArray = jsonObject.getJSONArray("deliverDates");
                    ArrayList result = new ArrayList();
                    if (jsonArray != null) {
                        jsonArray.forEach(object -> {
                            JSONObject dateProduct = (JSONObject)object;
                            JSONArray productJsonArray = dateProduct.getJSONArray("productForms");
                            if (productJsonArray != null) {
                                productJsonArray.forEach(productJSON -> {
                                    if (this.redisService.get("OutStockRecord1:" + shoppingcartSoldoutRecordEntity.getId().toString()) == null) {
                                        OutStockEntity outStockEntity = new OutStockEntity();
                                        BeanUtils.copyProperties((Object)shoppingcartSoldoutRecordEntity, (Object)outStockEntity);
                                        JSONObject product = (JSONObject)productJSON;
                                        BeanUtils.copyProperties((Object)product, (Object)outStockEntity);
                                        outStockEntity.setProductCount(product.getInteger("productCount") - product.getInteger("salesCount"));
                                        outStockEntity.setPickupDate(product.getString("pickupDate"));
                                        outStockEntity.setBarCode(product.getString("barCode"));
                                        if (outStockEntity.getPickupDate() != null) {
                                            result.add(outStockEntity);
                                            outStockEntity.setId(null);
                                            this.redisService.save("OutStockRecord1:" + shoppingcartSoldoutRecordEntity.getId().toString(), 1, 86400L);
                                        }
                                    }
                                });
                            }
                        });
                    }
                    if (result.size() > 0) {
                        this.outStockMapper.batchInsert(result);
                    }
                    this.redisService.save(key, 1, 86400L);
                }
            });
        }
        return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
    }
}

