/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.shortlink;

import cc.lechun.active.dao.active.MallUrlMapper;
import cc.lechun.active.entity.active.MallUrlEntity;
import cc.lechun.active.entity.active.MallUrlQueryVo;
import cc.lechun.active.entity.active.MallUrlVisiteVo;
import cc.lechun.active.entity.active.MallUrlVo;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.minischeme.OperateTypeEnum;
import cc.lechun.mall.iservice.shortlink.ShortLinkInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShortLinkService
extends BaseService
implements ShortLinkInterface {
    @Autowired
    private MallUrlMapper mallUrlMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public BaseJsonVo delete(String key) {
        if (key.lastIndexOf("/") > 0) {
            key = key.substring(key.lastIndexOf("/") + 1);
        }
        this.memcachedService.delete("ShortLinkService.getMallUrl", key);
        this.mallUrlMapper.deleteByPrimaryKey((Serializable)((Object)key));
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo<MallUrlVo> getShortLinkList(MallUrlQueryVo mallUrlQueryVo) {
        Page page = PageHelper.startPage((int)mallUrlQueryVo.getCurrentPage(), (int)mallUrlQueryVo.getPageSize());
        page.setOrderBy("CREATE_TIME desc");
        MallUrlEntity mallUrlEntity = new MallUrlEntity();
        if (StringUtils.isNotEmpty((String)mallUrlQueryVo.getUrlKey())) {
            mallUrlEntity.setUrlKey(mallUrlQueryVo.getUrlKey());
        }
        if (StringUtils.isNotEmpty((String)mallUrlQueryVo.getUrl())) {
            mallUrlEntity.setUrl(mallUrlQueryVo.getUrl());
        }
        if (StringUtils.isNotEmpty((String)mallUrlQueryVo.getUrlName())) {
            mallUrlEntity.setUrlName(SqlUtils.sqlLike((String)mallUrlQueryVo.getUrlName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        List<MallUrlEntity> list = this.mallUrlMapper.getShortList(mallUrlEntity);
        ArrayList<MallUrlVo> result = new ArrayList<MallUrlVo>();
        for (MallUrlEntity urlEntity : list) {
            if (StringUtils.isNotEmpty((String)urlEntity.getUrlKey())) {
                urlEntity.setUrlKey("http://t.lechun.cc/" + urlEntity.getUrlKey());
            }
            MallUrlVo mallUrlVo = new MallUrlVo();
            mallUrlVo.setOperateType(urlEntity.getUrl().indexOf("platformId=4") > 0 ? 0 : OperateTypeEnum.canEdit.getValue());
            BeanUtils.copyProperties((Object)urlEntity, (Object)mallUrlVo);
            result.add(mallUrlVo);
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(page.getTotal());
        pageInfo.setList(result);
        return pageInfo;
    }

    @Override
    @ReadThroughSingleCache(namespace="ShortLinkService.getMallUrl", expiration=3600)
    public String getMallUrl(@ParameterValueKeyProvider String urlKey) {
        MallUrlEntity mallUrlEntity = (MallUrlEntity)this.mallUrlMapper.selectByPrimaryKey((Serializable)((Object)urlKey));
        return mallUrlEntity == null ? "" : mallUrlEntity.getUrl();
    }

    @Override
    public BaseJsonVo saveMallUrl(String urlKey, String longUrl, Date expiredTime, String urlName) {
        MallUrlEntity mallUrlEntity = new MallUrlEntity();
        mallUrlEntity.setUrl(longUrl);
        mallUrlEntity.setUrlKey(urlKey);
        mallUrlEntity.setExpiredTime(expiredTime);
        mallUrlEntity.setCreateTime(DateUtils.now());
        mallUrlEntity.setUrlName(urlName);
        this.removeCache(mallUrlEntity);
        this.logger.info("\u4fdd\u5b58\u77ed\u8fde\u63a5:{}", (Object)mallUrlEntity.toString());
        return this.mallUrlMapper.insertSelective(mallUrlEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    private void removeCache(MallUrlEntity urlEntity) {
        if (urlEntity != null) {
            this.memcachedService.delete("ShortLinkService.getMallUrl", urlEntity.getUrlKey());
        }
    }

    private void setCache(MallUrlEntity urlEntity) {
        if (urlEntity != null) {
            this.memcachedService.set("ShortLinkService.getMallUrl:" + urlEntity.getUrlKey(), (Object)urlEntity.getUrl());
        }
    }

    private String shortUrl(String url, int i, String key) {
        String sMD5EncryptResult;
        String[] chars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        String hex = sMD5EncryptResult = DigestUtils.md5Hex((String)(key + url));
        String sTempSubString = hex.substring(i * 8, i * 8 + 8);
        long lHexLong = 0x3FFFFFFFL & Long.parseLong(sTempSubString, 16);
        String outChars = "";
        for (int j = 0; j < 7; ++j) {
            long index = 0x3DL & lHexLong;
            outChars = outChars + chars[(int)index];
            lHexLong >>= 5;
        }
        MallUrlEntity mallUrlEntity = new MallUrlEntity();
        mallUrlEntity.setUrlKey(outChars);
        if (this.mallUrlMapper.getSingle(mallUrlEntity) == null) {
            return outChars;
        }
        return this.shortUrl(url, i + 1, i + 1 + key);
    }

    @Override
    public String getShorterUrl(String longUrl, String urlKey, String urlName) {
        this.logger.info("\u4fdd\u5b58\u77ed\u8fde\u63a5:{},{},{}", new Object[]{longUrl, urlKey, urlName});
        MallUrlEntity query = new MallUrlEntity();
        query.setUrl(longUrl);
        if (StringUtils.isNotEmpty((String)urlKey)) {
            query.setUrlKey(urlKey);
        }
        if ((query = (MallUrlEntity)this.mallUrlMapper.getSingle(query)) != null) {
            return "http://t.lechun.cc/" + query.getUrlKey();
        }
        if (StringUtils.isEmpty((String)urlKey)) {
            String key = "";
            String temp = ".lechun.cc";
            key = this.shortUrl(longUrl, 0, 0 + temp);
            BaseJsonVo vo = this.saveMallUrl(key, longUrl, DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)30), urlName);
            if (vo.isSuccess()) {
                MallUrlEntity urlEntity = new MallUrlEntity();
                urlEntity.setUrlKey(key);
                urlEntity.setUrl(longUrl);
                this.removeCache(urlEntity);
                this.setCache(urlEntity);
            }
            return "http://t.lechun.cc/" + key;
        }
        MallUrlEntity urlEntity = new MallUrlEntity();
        urlEntity.setUrlKey(urlKey);
        urlEntity.setUrl(longUrl);
        if (StringUtils.isNotEmpty((String)urlName)) {
            urlEntity.setUrlName(urlName);
        }
        urlEntity.setUpdateTime(DateUtils.now());
        urlEntity.setExpiredTime(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)30));
        this.removeCache(urlEntity);
        this.logger.info(urlEntity.toString());
        return this.mallUrlMapper.updateByPrimaryKeySelective(urlEntity) > 0 ? "http://t.lechun.cc/" + urlKey : "";
    }

    @Override
    @ReadThroughSingleCache(namespace="ShortLinkService.getShortLinkAccessCount", expiration=300)
    public List<MallUrlVisiteVo> getShortLinkAccessCount(@ParameterValueKeyProvider String urlKey) {
        return this.mallUrlMapper.getShortLinkAccessCount(urlKey);
    }

    @Override
    public Integer getShortLinkAccessLastCount(String urlKey) {
        List<MallUrlVisiteVo> lst = this.getShortLinkAccessCount(urlKey);
        if (lst != null && lst.size() > 0) {
            MallUrlVisiteVo vo = lst.get(lst.size() - 1);
            return vo.getAccessCount();
        }
        return 0;
    }
}

