/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sync;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sync.MallAarrrMapper;
import cc.lechun.mall.entity.sync.ExcelAaRrrDataVo;
import cc.lechun.mall.entity.sync.MallAarrrEntity;
import cc.lechun.mall.iservice.sync.MallAarrrInterface;
import cc.lechun.utils.ExcelUtil;
import com.alibaba.fastjson.JSON;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MallAarrrService
extends BaseService<MallAarrrEntity, String>
implements MallAarrrInterface {
    @Resource
    private MallAarrrMapper mallAarrrMapper;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseJsonVo importAaRrrData(MultipartFile file) {
        BaseJsonVo baseJson = new BaseJsonVo();
        try (InputStream inputStream = file.getInputStream();){
            List<ExcelAaRrrDataVo> excelAaRrrDataVos = ExcelUtil.readExcel(new BufferedInputStream(inputStream), ExcelAaRrrDataVo.class);
            this.logger.info(">>>>>>>>>importAaRrrData rows:{} excelDataVos={}", (Object)excelAaRrrDataVos.size(), (Object)JSON.toJSONString(excelAaRrrDataVos));
            BaseJsonVo baseJsonVo = this.importAaRrrData(excelAaRrrDataVos);
            return baseJsonVo;
        }
        catch (Exception e) {
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
            e.printStackTrace();
            return baseJson;
        }
    }

    public BaseJsonVo importAaRrrData(List<ExcelAaRrrDataVo> excelAaRrrDataVos) {
        BaseJsonVo baseJson = new BaseJsonVo();
        HashSet setStr = new HashSet();
        try {
            if (excelAaRrrDataVos != null && excelAaRrrDataVos.size() > 0) {
                ArrayList<MallAarrrEntity> mallAarrrEntityList = new ArrayList<MallAarrrEntity>();
                for (ExcelAaRrrDataVo excelAaRrrDataVo : excelAaRrrDataVos) {
                    MallAarrrEntity mallAarrrEntity = new MallAarrrEntity();
                    BeanUtils.beanCopy((Object)excelAaRrrDataVo, (Object)mallAarrrEntity);
                    mallAarrrEntity.setId(IDGenerate.getUniqueIdStr());
                    mallAarrrEntity.setExtend1("");
                    mallAarrrEntity.setExtend2("");
                    mallAarrrEntity.setExtend3("");
                    mallAarrrEntity.setExtend4("");
                    mallAarrrEntity.setExtend5("");
                    mallAarrrEntityList.add(mallAarrrEntity);
                }
                this.logger.info("===========importAaRrrData====mallAarrrEntityList={}", (Object)JSON.toJSONString(mallAarrrEntityList));
                this.mallAarrrMapper.batchInsert(mallAarrrEntityList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return baseJson;
    }
}

