/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sync;

import cc.lechun.apiinvoke.csms.RefundCsmsQuartzInvoke;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.csmsapi.dto.refund.RefundPayCollectDTO;
import cc.lechun.csmsapi.dto.refund.RefundPayDetailSyncDTO;
import cc.lechun.csmsapi.dto.refund.RefundProductSyncDTO;
import cc.lechun.csmsapi.dto.refund.RefundSyncParamDTO;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallProductGroupMapper;
import cc.lechun.mall.dao.trade.MallOrderGroupProductMapper;
import cc.lechun.mall.dao.trade.MallOrderProductMapper;
import cc.lechun.mall.dao.trade.MallRefundMapper;
import cc.lechun.mall.dao.trade.MallRefundPayDetailMapper;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallRefundEntity;
import cc.lechun.mall.entity.trade.MallRefundPayDetailEntity;
import cc.lechun.mall.iservice.sync.RefundSyncCsmsInterface;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RefundSyncCsmsService
extends BaseService
implements RefundSyncCsmsInterface {
    @Autowired
    private MallRefundMapper mallRefundMapper;
    @Autowired
    private MallRefundPayDetailMapper mallRefundPayDetailMapper;
    @Autowired
    private MallOrderProductMapper mallOrderProductMapper;
    @Autowired
    private MallOrderGroupProductMapper mallOrderGroupProductMapper;
    @Autowired
    private MallProductGroupMapper groupMapper;
    @Autowired
    private RefundCsmsQuartzInvoke refundCsmsQuartzInvoke;

    @Override
    public BaseJsonVo refundSyncCsms(String startTime, String status, String orderMainNo) {
        this.logger.info("*********RefundSyncCsmsService refundSyncCsms************startTime={},status={},orderMainNo={}", new Object[]{startTime, status, orderMainNo});
        ArrayList<String> listStatus = new ArrayList<String>();
        String[] statusList = null;
        if (StringUtils.isNotEmpty((String)status)) {
            for (String s : statusList = status.split(",")) {
                listStatus.add(s);
            }
        }
        List<MallRefundEntity> refundEntityList = this.mallRefundMapper.listRefunds(startTime, listStatus, orderMainNo);
        this.logger.info("*********RefundSyncCsmsService refundSyncCsms************refundEntityList={}", (Object)JsonUtils.toJson(refundEntityList, (boolean)false));
        if (refundEntityList != null && refundEntityList.size() > 0) {
            ArrayList<RefundSyncParamDTO> refundSyncParamDTOList = new ArrayList<RefundSyncParamDTO>();
            for (MallRefundEntity mallRefundEntity : refundEntityList) {
                List<MallOrderProductEntity> mallOrderProductEntityList;
                ArrayList<RefundPayCollectDTO> refundPayCollectDTOList = new ArrayList<RefundPayCollectDTO>();
                RefundSyncParamDTO refundSyncParamDTO = new RefundSyncParamDTO();
                refundSyncParamDTO.setRefundNo(mallRefundEntity.getRefundId());
                refundSyncParamDTO.setOrderMainNo(mallRefundEntity.getOrderMainNo());
                refundSyncParamDTO.setOrderNo(mallRefundEntity.getOrderNo());
                refundSyncParamDTO.setPayAmount(mallRefundEntity.getTotalAmount());
                refundSyncParamDTO.setIsRefundCoupon(Integer.valueOf(2));
                if (mallRefundEntity.getOrderStatus() <= 10) {
                    refundSyncParamDTO.setAfterSaleType("1");
                    refundSyncParamDTO.setRefundType(Integer.valueOf(1));
                    if (mallRefundEntity.getRefundOrderType() == 1) {
                        refundSyncParamDTO.setIsRefundCoupon(Integer.valueOf(1));
                    }
                } else {
                    refundSyncParamDTO.setAfterSaleType("2");
                    switch (mallRefundEntity.getRefundOrderType()) {
                        case 1: {
                            refundSyncParamDTO.setRefundType(Integer.valueOf(2));
                            break;
                        }
                        case 2: {
                            refundSyncParamDTO.setRefundType(Integer.valueOf(1));
                            break;
                        }
                        default: {
                            refundSyncParamDTO.setRefundType(Integer.valueOf(1));
                        }
                    }
                }
                refundSyncParamDTO.setRefundAmountApply(mallRefundEntity.getReturnAmount());
                refundSyncParamDTO.setRefundAmountCheck(mallRefundEntity.getFactReturnAmount());
                refundSyncParamDTO.setRefundReason(mallRefundEntity.getReason());
                switch (mallRefundEntity.getStatus()) {
                    case 1: {
                        refundSyncParamDTO.setRefundStatus(Integer.valueOf(1));
                        break;
                    }
                    case 2: {
                        refundSyncParamDTO.setRefundStatus(Integer.valueOf(2));
                        break;
                    }
                    case 3: {
                        refundSyncParamDTO.setRefundStatus(Integer.valueOf(4));
                        break;
                    }
                    case 4: {
                        refundSyncParamDTO.setRefundStatus(Integer.valueOf(3));
                        break;
                    }
                    case 5: {
                        refundSyncParamDTO.setRefundStatus(Integer.valueOf(5));
                        break;
                    }
                    default: {
                        refundSyncParamDTO.setRefundStatus(Integer.valueOf(1));
                    }
                }
                refundSyncParamDTO.setOtherTkOrderNo(mallRefundEntity.getOtherTkOrderNo());
                refundSyncParamDTO.setLogisticsName("");
                refundSyncParamDTO.setLogisticsId("");
                refundSyncParamDTO.setLogisticsNo("");
                refundSyncParamDTO.setCreateId(mallRefundEntity.getOperaterId());
                refundSyncParamDTO.setCreateTime(mallRefundEntity.getCreateTime());
                refundSyncParamDTO.setUpdateId(mallRefundEntity.getChecker());
                refundSyncParamDTO.setUpdateTime(mallRefundEntity.getCheckTime());
                refundSyncParamDTO.setDataPlatform("wx_mall");
                BigDecimal[] payAmountCheck = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] wechatPayAmountCheck = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] aliPayAmountCheck = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] bankPayAmountCheck = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] balanceCheck = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] payAmount = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] wechatPayAmount = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] aliPayAmount = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] bankPayAmount = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] balance = new BigDecimal[]{BigDecimal.ZERO};
                Integer[] payType = new Integer[]{null};
                MallRefundPayDetailEntity mallRefundPayDetailEntity = new MallRefundPayDetailEntity();
                mallRefundPayDetailEntity.setRefundId(mallRefundEntity.getRefundId());
                List mallRefundPayDetailEntityList = this.mallRefundPayDetailMapper.getList(mallRefundPayDetailEntity);
                if (mallRefundPayDetailEntityList.size() > 0) {
                    for (MallRefundPayDetailEntity mallRefundPayDetailEntity1 : mallRefundPayDetailEntityList) {
                        RefundPayCollectDTO refundPayCollectDTO = new RefundPayCollectDTO();
                        refundPayCollectDTO.setRefundPayCollectNo(IDGenerate.getUniqueIdStr());
                        refundPayCollectDTO.setRefundNo(mallRefundEntity.getRefundId());
                        refundPayCollectDTO.setOrderNo(mallRefundEntity.getOrderNo());
                        refundPayCollectDTO.setPaytypeId(Integer.valueOf(mallRefundPayDetailEntity1.getPaytypeId()));
                        switch (mallRefundPayDetailEntity1.getPaytypeId()) {
                            case 2: {
                                refundPayCollectDTO.setPaytypeName("\u5fae\u4fe1");
                                refundPayCollectDTO.setRefundPayAmountApply(mallRefundPayDetailEntity1.getReturnAmount());
                                refundPayCollectDTO.setRefundPayAmountCheck(mallRefundPayDetailEntity1.getFactReturnAmount());
                                break;
                            }
                            case 3: {
                                refundPayCollectDTO.setPaytypeName("\u4f18\u60e0\u5238");
                                break;
                            }
                            case 7: {
                                refundPayCollectDTO.setPaytypeName("\u62db\u5546");
                                refundPayCollectDTO.setRefundPayAmountApply(mallRefundPayDetailEntity1.getReturnAmount());
                                refundPayCollectDTO.setRefundPayAmountCheck(mallRefundPayDetailEntity1.getFactReturnAmount());
                                break;
                            }
                            case 8: {
                                refundPayCollectDTO.setPaytypeName("\u4f59\u989d");
                                refundPayCollectDTO.setRefundPayAmountApply(mallRefundPayDetailEntity1.getReturnAmount());
                                refundPayCollectDTO.setRefundPayAmountCheck(mallRefundPayDetailEntity1.getFactReturnAmount());
                                break;
                            }
                            default: {
                                refundPayCollectDTO.setPaytypeName("\u65e0\u9700\u652f\u4ed8");
                            }
                        }
                        refundPayCollectDTO.setTradeNo(mallRefundPayDetailEntity1.getTradeNo());
                        refundPayCollectDTO.setIsSuccess(mallRefundPayDetailEntity1.getRefundStatus());
                        refundPayCollectDTO.setCreateId(mallRefundEntity.getOperaterId());
                        refundPayCollectDTO.setCreateTime(mallRefundEntity.getCreateTime());
                        refundPayCollectDTO.setUpdateId(mallRefundEntity.getChecker());
                        refundPayCollectDTO.setUpdateTime(mallRefundEntity.getCheckTime());
                        refundPayCollectDTOList.add(refundPayCollectDTO);
                        if (mallRefundPayDetailEntity1.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue()) {
                            wechatPayAmountCheck[0] = mallRefundPayDetailEntity1.getFactReturnAmount();
                            payType[0] = mallRefundPayDetailEntity1.getPaytypeId();
                            payAmountCheck[0] = mallRefundPayDetailEntity1.getFactReturnAmount();
                            wechatPayAmount[0] = mallRefundPayDetailEntity1.getReturnAmount();
                            payAmount[0] = mallRefundPayDetailEntity1.getReturnAmount();
                        } else if (mallRefundPayDetailEntity1.getPaytypeId().intValue() == PayTypeEnum.ALIPAY_PAY.getValue()) {
                            aliPayAmountCheck[0] = mallRefundPayDetailEntity1.getFactReturnAmount();
                            payType[0] = mallRefundPayDetailEntity1.getPaytypeId();
                            payAmountCheck[0] = mallRefundPayDetailEntity1.getFactReturnAmount();
                            aliPayAmount[0] = mallRefundPayDetailEntity1.getReturnAmount();
                            payAmount[0] = mallRefundPayDetailEntity1.getReturnAmount();
                        } else if (mallRefundPayDetailEntity1.getPaytypeId().intValue() == PayTypeEnum.BANK_PAY.getValue()) {
                            bankPayAmountCheck[0] = mallRefundPayDetailEntity1.getFactReturnAmount();
                            payType[0] = mallRefundPayDetailEntity1.getPaytypeId();
                            payAmountCheck[0] = mallRefundPayDetailEntity1.getFactReturnAmount();
                            bankPayAmount[0] = mallRefundPayDetailEntity1.getReturnAmount();
                            payAmount[0] = mallRefundPayDetailEntity1.getReturnAmount();
                        } else if (mallRefundPayDetailEntity1.getPaytypeId().intValue() == PayTypeEnum.MILKBANK_PAY.getValue()) {
                            payType[0] = mallRefundPayDetailEntity1.getPaytypeId();
                            payAmountCheck[0] = mallRefundPayDetailEntity1.getFactReturnAmount();
                            payAmount[0] = mallRefundPayDetailEntity1.getReturnAmount();
                        }
                        if (mallRefundPayDetailEntity1.getPaytypeId().intValue() != PayTypeEnum.BALANCE_PAY.getValue()) continue;
                        balanceCheck[0] = mallRefundPayDetailEntity1.getFactReturnAmount();
                        balance[0] = mallRefundPayDetailEntity1.getReturnAmount();
                    }
                }
                if ((mallOrderProductEntityList = this.mallOrderProductMapper.getOrderProductInfoByOrderMianNo(mallRefundEntity.getOrderMainNo())).size() > 0) {
                    ArrayList<RefundProductSyncDTO> refundProductSyncDTOList = new ArrayList<RefundProductSyncDTO>();
                    ArrayList<RefundPayDetailSyncDTO> refundPayDetailSyncDTOList = new ArrayList<RefundPayDetailSyncDTO>();
                    MallOrderGroupProductEntity mallOrderGroupProductEntityQuery = new MallOrderGroupProductEntity();
                    mallOrderGroupProductEntityQuery.setOrderMainNo(mallRefundEntity.getOrderMainNo());
                    List mallOrderGroupProductEntityList = this.mallOrderGroupProductMapper.getList(mallOrderGroupProductEntityQuery);
                    if (mallOrderGroupProductEntityList.size() > 0) {
                        BigDecimal productUnitPriceSum = mallOrderGroupProductEntityList.stream().map(orderGroupProduct -> orderGroupProduct.getUnitPrice().multiply(new BigDecimal(orderGroupProduct.getQuantity().toString()))).reduce(BigDecimal.ZERO, BigDecimal::add);
                        this.logger.info("***********refundSyncCsms  productUnitPriceSum*********productUnitPriceSum={}", (Object)productUnitPriceSum);
                        for (MallOrderGroupProductEntity mallOrderGroupProductEntity : mallOrderGroupProductEntityList) {
                            BigDecimal productRate = BigDecimal.ZERO.compareTo(productUnitPriceSum) == 0 ? BigDecimal.ONE : mallOrderGroupProductEntity.getUnitPrice().multiply(new BigDecimal(mallOrderGroupProductEntity.getQuantity().toString())).divide(productUnitPriceSum, 10, RoundingMode.HALF_EVEN);
                            RefundProductSyncDTO refundProductSyncDTO = new RefundProductSyncDTO();
                            refundProductSyncDTO.setRefundProductNo(IDGenerate.getUniqueIdStr());
                            refundProductSyncDTO.setRefundNo(refundSyncParamDTO.getRefundNo());
                            refundProductSyncDTO.setProductId(mallOrderGroupProductEntity.getProductId());
                            refundProductSyncDTO.setProductPrice(mallOrderGroupProductEntity.getOriginPrice());
                            refundProductSyncDTO.setProductName(mallOrderGroupProductEntity.getProductName());
                            refundProductSyncDTO.setProductNum(mallOrderGroupProductEntity.getQuantity());
                            refundProductSyncDTO.setPayAmount(mallOrderGroupProductEntity.getOriginPriceSum());
                            refundProductSyncDTO.setProductRefundAmount(payAmount[0].add(balance[0]).multiply(productRate).setScale(2, 4));
                            refundProductSyncDTO.setRefundCashAmountApply(payAmount[0].multiply(productRate).setScale(2, 4));
                            refundProductSyncDTO.setRefundBalanceAmountApply(balance[0].multiply(productRate).setScale(2, 4));
                            refundProductSyncDTO.setRefundCashAmountCheck(payAmountCheck[0].multiply(productRate).setScale(2, 4));
                            refundProductSyncDTO.setRefundBalanceAmountCheck(balanceCheck[0].multiply(productRate).setScale(2, 4));
                            if (mallOrderGroupProductEntity.getGroupType() == 2) {
                                refundProductSyncDTO.setIsGroup(Integer.valueOf(1));
                                refundProductSyncDTO.setGroupId(mallOrderGroupProductEntity.getGroupId());
                                refundProductSyncDTO.setGroupName(((MallProductGroupEntity)this.groupMapper.selectByPrimaryKey((Serializable)((Object)mallOrderGroupProductEntity.getGroupId()))).getGroupName());
                            }
                            refundProductSyncDTO.setCreateId(mallRefundEntity.getOperaterId());
                            refundProductSyncDTO.setCreateTime(mallRefundEntity.getCreateTime());
                            refundProductSyncDTO.setUpdateId(mallRefundEntity.getChecker());
                            refundProductSyncDTO.setUpdateTime(mallRefundEntity.getCheckTime());
                            refundProductSyncDTOList.add(refundProductSyncDTO);
                            for (MallRefundPayDetailEntity mallRefundPayDetailEntity1 : mallRefundPayDetailEntityList) {
                                RefundPayDetailSyncDTO refundPayDetailSyncDTO = new RefundPayDetailSyncDTO();
                                if ((mallRefundPayDetailEntity1.getPaytypeId() != 3 || refundSyncParamDTO.getIsRefundCoupon() != 1) && mallRefundPayDetailEntity1.getPaytypeId() == 3) continue;
                                refundPayDetailSyncDTO.setRefundPayDetailNo(IDGenerate.getUniqueIdStr());
                                refundPayDetailSyncDTO.setRefundNo(refundSyncParamDTO.getRefundNo());
                                refundPayDetailSyncDTO.setOrderNo(mallRefundEntity.getOrderNo());
                                refundPayDetailSyncDTO.setRefundProductNo(refundProductSyncDTO.getRefundProductNo());
                                refundPayDetailSyncDTO.setPaytypeId(mallRefundPayDetailEntity1.getPaytypeId());
                                switch (mallRefundPayDetailEntity1.getPaytypeId()) {
                                    case 2: {
                                        refundPayDetailSyncDTO.setPaytypeName("\u5fae\u4fe1");
                                        refundPayDetailSyncDTO.setRefundPayAmountApply(refundProductSyncDTO.getRefundCashAmountApply());
                                        refundPayDetailSyncDTO.setRefundPayAmountCheck(refundProductSyncDTO.getRefundCashAmountCheck());
                                        break;
                                    }
                                    case 3: {
                                        refundPayDetailSyncDTO.setPaytypeName("\u4f18\u60e0\u5238");
                                        break;
                                    }
                                    case 7: {
                                        refundPayDetailSyncDTO.setPaytypeName("\u62db\u5546");
                                        refundPayDetailSyncDTO.setRefundPayAmountApply(refundProductSyncDTO.getRefundCashAmountApply());
                                        refundPayDetailSyncDTO.setRefundPayAmountCheck(refundProductSyncDTO.getRefundCashAmountCheck());
                                        break;
                                    }
                                    case 8: {
                                        refundPayDetailSyncDTO.setPaytypeName("\u4f59\u989d");
                                        refundPayDetailSyncDTO.setRefundPayAmountApply(refundProductSyncDTO.getRefundBalanceAmountApply());
                                        refundPayDetailSyncDTO.setRefundPayAmountCheck(refundProductSyncDTO.getRefundBalanceAmountCheck());
                                        break;
                                    }
                                    default: {
                                        refundPayDetailSyncDTO.setPaytypeName("\u65e0\u9700\u652f\u4ed8");
                                    }
                                }
                                refundPayDetailSyncDTO.setTradeNo(mallRefundPayDetailEntity1.getTradeNo());
                                refundPayDetailSyncDTO.setIsSuccess(mallRefundPayDetailEntity1.getRefundStatus());
                                refundPayDetailSyncDTO.setCreateId(mallRefundEntity.getOperaterId());
                                refundPayDetailSyncDTO.setCreateTime(mallRefundEntity.getCreateTime());
                                refundPayDetailSyncDTO.setUpdateId(mallRefundEntity.getChecker());
                                refundPayDetailSyncDTO.setUpdateTime(mallRefundEntity.getCheckTime());
                                refundPayDetailSyncDTOList.add(refundPayDetailSyncDTO);
                            }
                        }
                    }
                    refundSyncParamDTO.setRefundProductSyncDTOList(refundProductSyncDTOList);
                    refundSyncParamDTO.setRefundPayDetailSyncDTOList(refundPayDetailSyncDTOList);
                }
                refundSyncParamDTO.setRefundPayCollectDTOList(refundPayCollectDTOList);
                refundSyncParamDTOList.add(refundSyncParamDTO);
            }
            this.refundCsmsQuartzInvoke.refundSyncCsms(refundSyncParamDTOList);
        }
        return BaseJsonVo.success((Object)"");
    }
}

