/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.cashticket.CashticketEntity;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.iservice.cashticket.CashticketInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderMessageQueueInterface;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallOrderMessageQueueService
extends BaseService
implements MallOrderMessageQueueInterface {
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private CashticketInterface cashticketInterface;
    @Autowired
    private RedisService redisService;

    @Override
    public void sendCommitOrderQueue(MallMainOrderVo mallMainOrderVo) {
        try {
            CashticketEntity cashticket;
            List<CashticketVo> cashticketVos;
            HashMap<String, String> cot = new HashMap<String, String>();
            cot.put("userId", mallMainOrderVo.getCustomerId());
            cot.put("orderMainNo", mallMainOrderVo.getMainOrderNo());
            String ticketNo = "";
            if (mallMainOrderVo.getCashticketVos() != null && (cashticketVos = mallMainOrderVo.getCashticketVos()) != null && cashticketVos.size() > 0 && cashticketVos.get(0).getEnable() == 1 && (cashticket = this.cashticketInterface.getCashticket(cashticketVos.get(0).getTicketCustomerId())) != null) {
                ticketNo = cashticket.getTicketNo();
            }
            cot.put("ticketNo", ticketNo);
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.orderSubmit, MessageParam.messageParam((String)mallMainOrderVo.getMainOrderNo(), cot));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendConfirmGoodsQueue(String customerId, String orderMainNo, String orderNo) {
        HashMap<String, String> cot = new HashMap<String, String>();
        cot.put("userId", customerId);
        cot.put("orderMainNo", orderMainNo);
        cot.put("orderNo", orderNo);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.confirmGoods, MessageParam.messageParam((String)orderMainNo, cot));
    }

    @Override
    public void sendCancelOrderQueue(String orderMainNo) {
        HashMap<String, String> cot = new HashMap<String, String>();
        cot.put("orderMainNo", orderMainNo);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.omsOrderCancel, MessageParam.messageParam((String)orderMainNo, cot));
    }

    @Override
    public void sendDeliverGoodsQueue(String orderMainNo) {
        HashMap<String, String> cot = new HashMap<String, String>();
        cot.put("orderMainNo", orderMainNo);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.ecOrderTakeGood, MessageParam.messageParam((String)orderMainNo, cot));
    }

    public void sendRefundApplyQueue(String orderMainNo) {
        HashMap<String, String> cot = new HashMap<String, String>();
        cot.put("orderMainNo", orderMainNo);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.ecOrderRefundApply, MessageParam.messageParam((String)orderMainNo, cot));
    }

    @Override
    public void sendRefundQueue(String orderMainNo) {
        HashMap<String, String> cot = new HashMap<String, String>();
        cot.put("orderMainNo", orderMainNo);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.ecOrderRefund, MessageParam.messageParam((String)orderMainNo, cot));
    }

    public void sendOrderUpdateQueue(String orderMainNo) {
        HashMap<String, String> cot = new HashMap<String, String>();
        cot.put("orderMainNo", orderMainNo);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.omsOrderUpdate, MessageParam.messageParam((String)orderMainNo, cot));
    }
}

