/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.cms.dto.MallOrderPayDto;
import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.trade.MallOrderPayMapper;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.OrderPayExportVo;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.service.trade.cache.MallOrderPayCacheService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallOrderPayService
extends MallOrderPayCacheService
implements MallOrderPayInterface {
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallOrderPayMapper mallOrderPayMapper;
    @Autowired
    private MallPayTypeInterface payTypeInterface;

    public BaseJsonVo updatePayTypeByOrderMainNo(String orderMainNo, int payTypeId, int payTypeSubId) {
        BaseJsonVo result = new BaseJsonVo();
        MallPayTypeEntity mallPayTypeEntity = this.payTypeInterface.getPayType(payTypeId);
        if (mallPayTypeEntity == null) {
            result.setError("\u652f\u4ed8\u7c7b\u578b\u9519\u8bef");
            return result;
        }
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        if (mallOrderMainEntity == null) {
            result.setError("\u8ba2\u5355\u4e0d\u5b58\u5728No:" + orderMainNo);
            return result;
        }
        if (mallOrderMainEntity.getStatus().intValue() != OrderStatusEnum.UNPAY.getValue()) {
            result.setError("\u672a\u4ed8\u6b3e\u7684\u8ba2\u5355\u624d\u80fd\u4fee\u6539\u8ba2\u5355\u72b6\u6001");
            return result;
        }
        if (mallPayTypeEntity.getCashType() != 1) {
            result.setError("\u53ea\u6709\u73b0\u91d1\u7c7b\u578b\u7684\u652f\u4ed8\u65b9\u5f0f\u624d\u53ef\u4ee5\u66f4\u6539");
            return result;
        }
        mallPayTypeEntity = this.payTypeInterface.getPayType(payTypeSubId);
        if (mallPayTypeEntity == null) {
            result.setError("\u652f\u4ed8\u7c7b\u578b\u9519\u8bef");
            return result;
        }
        if (mallPayTypeEntity.getCashType() != 1) {
            result.setError("\u53ea\u6709\u73b0\u91d1\u7c7b\u578b\u7684\u652f\u4ed8\u65b9\u5f0f\u624d\u53ef\u4ee5\u66f4\u6539");
            return result;
        }
        MallOrderPayEntity mallOrderPayEntity = new MallOrderPayEntity();
        mallOrderPayEntity.setOrderMainNo(orderMainNo);
        mallOrderPayEntity.setCashType(1);
        List mallOrderPayEntityList = this.mallOrderPayMapper.getList(mallOrderPayEntity);
        if (mallOrderPayEntityList == null || mallOrderPayEntityList.size() == 0) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        if (mallOrderPayEntityList.size() > 1) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u5f02\u5e38");
            return result;
        }
        mallOrderPayEntity = (MallOrderPayEntity)mallOrderPayEntityList.get(0);
        if (mallOrderPayEntity.getIssuccess() == 1) {
            result.setError("\u8be5\u652f\u4ed8\u65b9\u5f0f\u5df2\u7ecf\u652f\u4ed8\uff0c\u4e0d\u80fd\u66f4\u6539");
            return result;
        }
        result.setValue((Object)mallOrderPayEntity);
        if (mallOrderPayEntity.getPaytypeId() == payTypeId && mallOrderPayEntity.getPaySubtypeId() == payTypeSubId) {
            result.setMessage("0");
            return result;
        }
        mallOrderPayEntity.setTradeNo(IDGenerate.getUniqueIdStr());
        mallOrderPayEntity.setPaytypeId(payTypeId);
        mallOrderPayEntity.setPaySubtypeId(payTypeSubId);
        if (!this.updateByPrimaryKey(mallOrderPayEntity)) {
            result.setError("\u66f4\u65b0\u5931\u8d25");
        }
        return result;
    }

    @Override
    public boolean updateByPrimaryKey(MallOrderPayEntity mallOrderPayEntity) {
        int i = this.mallOrderPayMapper.updateByPrimaryKeySelective(mallOrderPayEntity);
        return i == 1;
    }

    @Override
    public boolean insertOrderPay(MallOrderPayEntity orderPayEntity) {
        int i = this.mallOrderPayMapper.insertSelective(orderPayEntity);
        return i == 1;
    }

    public boolean deleteByPrimaryKey(String payId) {
        return this.mallOrderPayMapper.deleteByPrimaryKey((Serializable)((Object)payId)) == 1;
    }

    @Override
    public MallOrderPayEntity getSingle(String payId) {
        return (MallOrderPayEntity)this.mallOrderPayMapper.selectByPrimaryKey((Serializable)((Object)payId));
    }

    private MallOrderPayEntity createEntity(String orderMainNo, int payTypeId, String payTypeName, int couponId, String couponNo, BigDecimal amount, int paySubTypeId, int sort, int cashType) {
        MallOrderPayEntity orderPayEntity = new MallOrderPayEntity();
        String payId = String.valueOf(IDGenerate.getUniqueID());
        orderPayEntity.setCreateTime(DateUtils.now());
        orderPayEntity.setOrderMainNo(orderMainNo);
        orderPayEntity.setSort(sort);
        orderPayEntity.setTradeNo(payId);
        orderPayEntity.setPaySubtypeId(paySubTypeId);
        orderPayEntity.setCashticketId(couponId);
        orderPayEntity.setCashticketNo(couponNo);
        orderPayEntity.setCashType(cashType);
        orderPayEntity.setIssuccess(0);
        orderPayEntity.setPayamount(amount);
        orderPayEntity.setPaytypeId(payTypeId);
        orderPayEntity.setPaytypeName(payTypeName);
        orderPayEntity.setPrePayId("");
        orderPayEntity.setSuccessTime(null);
        orderPayEntity.setThirdTradeNo("");
        orderPayEntity.setPayId(payId);
        return orderPayEntity;
    }

    @Transactional
    public void splitOrderPayForSubType(MallOrderPayEntity orderPayEntity, Map<String, Object> wealth) {
        try {
            BigDecimal store = new BigDecimal(wealth.get("store").toString());
            BigDecimal present = new BigDecimal(wealth.get("present").toString());
            BigDecimal card = new BigDecimal(wealth.get("card").toString());
            if (orderPayEntity.getIssuccess() == 1) {
                MallOrderPayEntity tempOrderPay;
                if (store.doubleValue() != 0.0) {
                    store = store.divide(new BigDecimal(100));
                    orderPayEntity.setPaySubtypeId(PaySubTypeEnum.BALANCE_SUB_CHARGE_PAY.getValue());
                    orderPayEntity.setPayamount(store);
                    if (!this.updateByPrimaryKey(orderPayEntity)) {
                        throw new RuntimeException("\u66f4\u65b0\u5b50\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38");
                    }
                } else {
                    this.deleteByPrimaryKey(orderPayEntity.getPayId());
                }
                if (present.doubleValue() != 0.0) {
                    present = present.divide(new BigDecimal(100));
                    tempOrderPay = new MallOrderPayEntity();
                    BeanUtils.copyProperties((Object)orderPayEntity, (Object)tempOrderPay);
                    tempOrderPay.setPaySubtypeId(PaySubTypeEnum.BALANCE_SUB_GIVE_PAY.getValue());
                    tempOrderPay.setPayamount(present);
                    tempOrderPay.setPayId(String.valueOf(IDGenerate.getUniqueID()));
                    tempOrderPay.setTradeNo(tempOrderPay.getPayId());
                    if (!this.insertOrderPay(tempOrderPay)) {
                        throw new RuntimeException("\u6dfb\u52a0\u5b50\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38");
                    }
                }
                if (card.doubleValue() != 0.0) {
                    card = card.divide(new BigDecimal(100));
                    tempOrderPay = new MallOrderPayEntity();
                    BeanUtils.copyProperties((Object)orderPayEntity, (Object)tempOrderPay);
                    tempOrderPay.setPaySubtypeId(PaySubTypeEnum.BALANCE_SUB_GIFTCARD_PAY.getValue());
                    tempOrderPay.setPayamount(card);
                    tempOrderPay.setPayId(String.valueOf(IDGenerate.getUniqueID()));
                    tempOrderPay.setTradeNo(tempOrderPay.getPayId());
                    if (!this.insertOrderPay(tempOrderPay)) {
                        throw new RuntimeException("\u6dfb\u52a0\u5b50\u652f\u4ed8\u65b9\u5f0f\u5f02\u5e38");
                    }
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.logger.error(e.toString());
        }
    }

    @Override
    public MallOrderPayEntity getOrderPayInfoByOrderMainNoPayType(int paytypeId, String orderMainNo) {
        return this.mallOrderPayMapper.getOrderPayInfoByOrderMainNoPayType(paytypeId, orderMainNo);
    }

    @Override
    public MallOrderPayEntity getPayAmountSum(String orderMainNo) {
        return this.mallOrderPayMapper.getPayAmountSum(orderMainNo);
    }

    @Override
    public List<OrderPayExportVo> getOrderPayInfo(String createTime) {
        return this.mallOrderPayMapper.getOrderPayInfo(createTime);
    }

    @Override
    public MallOrderPayDto getOrderPayByTradeNoByCsms(String tradeNo) {
        MallOrderPayEntity orderPayEntity = new MallOrderPayEntity();
        orderPayEntity.setTradeNo(tradeNo);
        List<MallOrderPayDto> lst = this.mallOrderPayMapper.getOrderPayByTradeNoByCsms(orderPayEntity);
        if (lst != null && lst.size() > 0) {
            return lst.get(0);
        }
        return null;
    }
}

