/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.apiinvoke.bi.BIBalanceAnalysisInvoke;
import cc.lechun.cms.dto.GroupUserlDTO;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.constants.trade.OrderStatusClassConstants;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderDetailVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallRegularInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MallRefundPayDetailInterface;
import cc.lechun.mall.iservice.trade.MallSplitOrderInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.trade.cache.MallOrderCacheService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MallOrderService
extends MallOrderCacheService
implements MallOrderInterface {
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private MallPriceCalcInterface priceCalcInterface;
    @Autowired
    private MallRegularInterface regularInterface;
    @Autowired
    private MallShoppingcartInterface shoppingcartInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallSplitOrderInterface splitOrderInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private MallOrderProductInterface orderProductService;
    @Autowired
    private MallOrderGroupProductInterface orderGroupProductInterface;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private MallOrderPayInterface mallOrderPayInterface;
    @Autowired
    private MallOrderSyncInfoInterface orderSyncInfoService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MallRefundPayDetailInterface mallRefundPayDetailInterface;
    @Value(value="${lechun.environment}")
    private String environment;
    @Autowired
    BIBalanceAnalysisInvoke biBalanceAnalysisInvoke;

    @Override
    public List<GroupUserlDTO> getPickupOrderList(Integer smallerDay, Integer greaterDay) {
        ArrayList<GroupUserlDTO> result = new ArrayList<GroupUserlDTO>();
        List<Map<String, String>> list = this.mallOrderMapper.getPickupOrderList(greaterDay, smallerDay);
        if (list != null) {
            list.forEach(customerInfo -> {
                GroupUserlDTO groupUserlDTO = new GroupUserlDTO();
                groupUserlDTO.setCustomerId(((String)customerInfo.get("customerId")).toString());
                groupUserlDTO.setMobile(((String)customerInfo.get("mobile")).toString());
                groupUserlDTO.setOpenId(((String)customerInfo.get("openId")).toString());
                this.logger.info("\u67e5\u8be2\u7528\u6237:{}", (Object)groupUserlDTO.toString());
                result.add(groupUserlDTO);
            });
            HashSet<GroupUserlDTO> set = new HashSet<GroupUserlDTO>(result);
            result.clear();
            result.addAll(set);
        }
        return result;
    }

    @Override
    public boolean updateOrder(MallOrderEntity orderEntity) {
        int i = this.mallOrderMapper.updateByPrimaryKeySelective(orderEntity);
        return i == 1;
    }

    public boolean insertOrder(MallOrderEntity orderEntity) {
        int i = this.mallOrderMapper.insertSelective(orderEntity);
        return i == 1;
    }

    public boolean deleteOrder(String orderNo, String customerId) {
        MallOrderEntity orderEntity = new MallOrderEntity();
        orderEntity.setStatus(OrderStatusEnum.DELETE.getValue());
        orderEntity.setDeleteTime(DateUtils.now());
        orderEntity.setOrderNo(orderNo);
        return this.updateOrder(orderEntity);
    }

    @Override
    public boolean cancelOrder(String orderNo, String customerId) {
        MallOrderEntity orderEntity = new MallOrderEntity();
        orderEntity.setStatus(OrderStatusEnum.CANCEL.getValue());
        orderEntity.setOrderNo(orderNo);
        orderEntity.setCancelTime(DateUtils.now());
        return this.updateOrder(orderEntity);
    }

    @Override
    public boolean paySuccessOrder(String orderNo, String statusName) {
        MallOrderEntity orderEntity = new MallOrderEntity();
        Integer status = OrderStatusEnum.getValue(statusName);
        orderEntity.setStatus(status);
        orderEntity.setOrderNo(orderNo);
        return this.updateOrder(orderEntity);
    }

    public boolean exportOrderSuccess(MallOrderMainEntity mainOrder, MallOrderEntity order) {
        Boolean b = this.updateOrderStatus(order.getOrderNo(), OrderStatusEnum.EXPORT.getName(), mainOrder.getCustomerId(), order.getStatus());
        if (b.booleanValue()) {
            List<MallOrderEntity> orderList = this.getOrderList(mainOrder.getOrderMainNo());
            boolean allExport = true;
            for (MallOrderEntity orderEntity : orderList) {
                if (orderEntity.getStatus().intValue() == OrderStatusEnum.EXPORT.getValue()) continue;
                allExport = false;
                break;
            }
            if (allExport) {
                return this.orderMainInterface.updateOrderMainStatus(mainOrder.getOrderMainNo(), OrderStatusEnum.EXPORT.getName(), mainOrder.getCustomerId(), mainOrder.getStatus());
            }
        }
        return b;
    }

    public boolean exportOrderSuccess(String orderMainNo, String orderNo) {
        return this.exportOrderSuccess(this.orderMainInterface.selectByPrimaryKey(orderMainNo), this.getmallOrder(orderNo));
    }

    @Override
    public boolean updateOrderStatus(String OrderNo, String orderStatus, String customerId, int oldStatus) {
        Integer status = OrderStatusEnum.getValue(orderStatus);
        if (status == null) {
            return false;
        }
        MallOrderEntity orderEntity = this.tradeCommonInterface.getUpdateStatusOrderEntity(OrderNo, status);
        return this.updateOrder(orderEntity);
    }

    @Override
    public List<MallOrderEntity> findOrders(String orderMainNo) {
        MallOrderEntity searchParam = new MallOrderEntity();
        searchParam.setOrderMainNo(orderMainNo);
        return this.mallOrderMapper.getList(searchParam);
    }

    @Override
    public Integer getUserOrderCount(String customerId) {
        return this.mallOrderMapper.getUserOrderCount(customerId);
    }

    @Override
    public Integer getUserOrderCountPaid(String customerId) {
        return this.mallOrderMapper.getUserOrderCountPaid(customerId);
    }

    public List<MallOrderVo> ShoppingConvertOrder(List<MallShoppingcartVO> shoppingcartVOs) {
        ArrayList<MallOrderVo> orderVos = new ArrayList<MallOrderVo>();
        for (MallShoppingcartVO shoppingcartVO : shoppingcartVOs) {
            MallOrderVo orderVo = new MallOrderVo();
            try {
                Iterator<MallProductVO> itrProduct = shoppingcartVO.getProducts().iterator();
                while (itrProduct.hasNext()) {
                    if (itrProduct.next().getValid().booleanValue()) continue;
                    itrProduct.remove();
                }
                Iterator<MallGroupVO> itrGroup = shoppingcartVO.getGroups().iterator();
                while (itrGroup.hasNext()) {
                    if (itrGroup.next().getValid().booleanValue()) continue;
                    itrGroup.remove();
                }
                Iterator<MallPromotionVO> itrPromotion = shoppingcartVO.getPromotions().iterator();
                while (itrPromotion.hasNext()) {
                    if (itrPromotion.next().getValid().booleanValue()) continue;
                    itrPromotion.remove();
                }
                Iterator<MallProductVO> itrProductsPool = shoppingcartVO.getProductsPool().iterator();
                while (itrProductsPool.hasNext()) {
                    if (itrProductsPool.next().getValid().booleanValue()) continue;
                    itrProductsPool.remove();
                }
                if (!(shoppingcartVO.getProducts() != null && shoppingcartVO.getProducts().size() != 0 || shoppingcartVO.getGroups() != null && shoppingcartVO.getGroups().size() != 0 || shoppingcartVO.getPromotions() != null && shoppingcartVO.getPromotions().size() != 0)) continue;
                ObjectConvert.fatherConvertToChild((Object)shoppingcartVO, (Object)orderVo);
                orderVo.setQuantity(orderVo.getProductsPool().stream().mapToInt(e -> e.getCount()).sum());
                orderVos.add(orderVo);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return orderVos;
    }

    private List<MallOrderVo> getOrderVos(List<MallProductVO> productVOs, List<MallGroupVO> groupVOs, List<MallPromotionVO> promotionVOs, String customerId, int orderSource, int platFormId, int deliverCount, int deliverPeriod, int deliverType, String bindCode, String defineFiled, MallOrderCacheVo orderCacheVo) {
        ArrayList<MallOrderVo> orderVos = new ArrayList();
        MallOrderVo orderVo = new MallOrderVo();
        orderVo.setProducts(productVOs);
        orderVo.setGroups(groupVOs);
        orderVo.setPromotions(promotionVOs);
        orderVo.setCustomerId(customerId);
        orderVo.setOrderSource(orderSource);
        orderVo.setPlatFormId(platFormId);
        orderVo.setPlatFormGroupId(this.platFormInterface.getPlatFormGroupId(platFormId));
        orderVo.setDeliverCount(deliverCount);
        orderVo.setDeliverPeriod(deliverPeriod);
        orderVo.setDeliverType(deliverType);
        orderVo.setTransportType(this.productInterface.getTransportType(orderVo));
        orderVo.setBindCode(bindCode);
        orderVo.setDefineField(defineFiled);
        orderVo.setSelfMadeType(this.productInterface.getSelfMode(orderVo));
        if (deliverType != 1) {
            this.priceCalcInterface.totalOrderPrice(orderVo);
            this.shoppingcartInterface.collectProducts(orderVo);
            orderVo.setQuantity(orderVo.getProductsPool().stream().mapToInt(e -> e.getCount()).sum());
            if (orderCacheVo.getCacheType() == 2) {
                for (int i = 1; i <= deliverCount; ++i) {
                    if (i == 1) {
                        orderVo.setDeliverSequence(i);
                        orderVo.setDeliverCount(1);
                        orderVos.add(orderVo);
                        continue;
                    }
                    MallOrderVo tmpVo = new MallOrderVo();
                    BeanUtils.copyProperties((Object)orderVo, (Object)tmpVo);
                    tmpVo.setDeliverSequence(i);
                    tmpVo.setDeliverCount(1);
                    orderVos.add(tmpVo);
                }
            } else {
                orderVos.add(orderVo);
            }
        } else {
            orderVos = this.splitOrderInterface.splitOrder(orderVo);
        }
        return orderVos;
    }

    @Override
    public List<MallOrderEntity> getOrderList(String orderMainNo) {
        MallOrderEntity orderEntity = new MallOrderEntity();
        orderEntity.setOrderMainNo(orderMainNo);
        return this.mallOrderMapper.getList(orderEntity);
    }

    public List<MallOrderEntity> getOrderList(String orderMainNo, String orderNo) {
        MallOrderEntity orderEntity = new MallOrderEntity();
        orderEntity.setOrderMainNo(orderMainNo);
        if (orderNo != null && !orderNo.isEmpty()) {
            ArrayList<MallOrderEntity> orderEntities = new ArrayList<MallOrderEntity>();
            orderEntities.add((MallOrderEntity)this.mallOrderMapper.selectByPrimaryKey((Serializable)((Object)orderNo)));
            return orderEntities;
        }
        return this.mallOrderMapper.getList(orderEntity);
    }

    @Override
    public void getOrderInfo(OrderListVo orderListVo) {
        String orderNo = orderListVo.getOrderNo();
        List<Object> orderEntities = new ArrayList();
        orderEntities = this.getOrderList(orderListVo.getOrderMainNo());
        if (orderEntities != null && orderEntities.size() > 0) {
            orderListVo.setOrderNo(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getOrderNo());
            orderListVo.setDeliverDate(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getDeliverDate());
            orderListVo.setPickUpDate(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getPickupTime());
            orderListVo.setEvaluateStatus(orderEntities.stream().filter(order -> order.getEvaluateStatus() == 0).findAny().isPresent() ? 0 : 1);
            if (orderListVo.getOrderClass() == 1 && orderListVo.getEvaluateStatus() == 0 && orderListVo.getStatus() == OrderStatusEnum.COMPLETION.getValue()) {
                orderListVo.setCanEvaluateStatus(1);
            }
            orderListVo.setSubBalanceAmount(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getBalanceAmount());
            orderListVo.setSubCouponAmount(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getCouponAmount());
            orderListVo.setSubFreight(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getFreight());
            orderListVo.setSubOrderAmount(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getOrderAmount());
            orderListVo.setSubPayAmount(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getPayAmount());
            orderListVo.setSubTotalAmount(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getTotalAmount());
            orderListVo.setPsTimes(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getPsTimes());
            orderListVo.setArrivedTime(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getArrivedTime());
            orderListVo.setWayBillNo(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getWaybillNo());
            orderListVo.setAddressType(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getAddressType());
            orderListVo.setConsigneeProvincename(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeProvincename());
            orderListVo.setConsigneeCityname(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeCityname());
            orderListVo.setConsigneeAreaname(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeAreaname());
            orderListVo.setConsigneeAreaid(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeAreaid());
            orderListVo.setConsigneeHousenum(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeHousenum());
            orderListVo.setConsigneeAddr(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeAddr());
            orderListVo.setConsigneeName(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeName());
            orderListVo.setConsigneePhone(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneePhone());
            orderListVo.setDeliverName(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getDeliverName());
            orderListVo.setSpeedUp(Integer.valueOf(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getSpeedUp()));
            orderListVo.setStatus(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getStatus());
            boolean exists = false;
            ArrayList<MallOrderDetailVo> orderDetailVos = new ArrayList<MallOrderDetailVo>();
            for (MallOrderEntity mallOrderEntity : orderEntities) {
                if (orderEntities.size() > 1 && (mallOrderEntity.getDeliverDate() != null && mallOrderEntity.getDeliverDate().after(DateUtils.currentDate()) && !exists || mallOrderEntity.getOrderNo().equals(orderNo))) {
                    orderListVo.setOrderNo(mallOrderEntity.getOrderNo());
                    orderListVo.setDeliverDate(mallOrderEntity.getDeliverDate());
                    orderListVo.setPickUpDate(mallOrderEntity.getPickupTime());
                    orderListVo.setEvaluateStatus(mallOrderEntity.getEvaluateStatus());
                    if (orderListVo.getOrderClass() == 1 && orderListVo.getEvaluateStatus() == 0 && orderListVo.getStatus() == OrderStatusEnum.COMPLETION.getValue()) {
                        orderListVo.setCanEvaluateStatus(1);
                    }
                    orderListVo.setSubBalanceAmount(mallOrderEntity.getBalanceAmount());
                    orderListVo.setSubCouponAmount(mallOrderEntity.getCouponAmount());
                    orderListVo.setSubFreight(mallOrderEntity.getFreight());
                    orderListVo.setSubOrderAmount(mallOrderEntity.getOrderAmount());
                    orderListVo.setSubPayAmount(mallOrderEntity.getPayAmount());
                    orderListVo.setSubTotalAmount(mallOrderEntity.getTotalAmount());
                    orderListVo.setPsTimes(mallOrderEntity.getPsTimes());
                    orderListVo.setArrivedTime(mallOrderEntity.getArrivedTime());
                    orderListVo.setWayBillNo(mallOrderEntity.getWaybillNo());
                    orderListVo.setAddressType(mallOrderEntity.getAddressType());
                    orderListVo.setConsigneeProvincename(mallOrderEntity.getConsigneeProvincename());
                    orderListVo.setConsigneeCityname(mallOrderEntity.getConsigneeCityname());
                    orderListVo.setConsigneeAreaname(mallOrderEntity.getConsigneeAreaname());
                    orderListVo.setConsigneeAreaid(mallOrderEntity.getConsigneeAreaid());
                    orderListVo.setConsigneeHousenum(mallOrderEntity.getConsigneeHousenum());
                    orderListVo.setConsigneeAddr(mallOrderEntity.getConsigneeAddr());
                    orderListVo.setConsigneeName(mallOrderEntity.getConsigneeName());
                    orderListVo.setConsigneePhone(mallOrderEntity.getConsigneePhone());
                    orderListVo.setDeliverName(mallOrderEntity.getDeliverName());
                    orderListVo.setStatus(mallOrderEntity.getStatus());
                    exists = true;
                }
                MallOrderDetailVo orderDetailVo = new MallOrderDetailVo();
                orderDetailVo.setOrderMainNo(orderListVo.getOrderMainNo());
                orderDetailVo.setOrderNo(mallOrderEntity.getOrderNo());
                orderDetailVo.setPsTimes(mallOrderEntity.getPsTimes());
                int statusClass = this.getStatusClass(mallOrderEntity, orderListVo.getOrderClass());
                orderDetailVo.setStatusClassName(OrderStatusClassConstants.getStatusClassName(statusClass));
                orderDetailVo.setStatusName(OrderStatusEnum.getName(mallOrderEntity.getStatus()));
                orderDetailVos.add(orderDetailVo);
            }
            orderListVo.setOrderDetailVos(orderDetailVos);
            orderListVo.setDeliverDateShow(DateUtils.formatDate((Date)orderListVo.getDeliverDate(), (String)"MM\u6708dd\u65e5"));
        }
    }

    @Override
    public MallOrderEntity getmallOrder(String orderNo) {
        return (MallOrderEntity)this.mallOrderMapper.selectByPrimaryKey((Serializable)((Object)orderNo));
    }

    @Override
    public MallOrderEntity getmallOrder(MallOrderEntity orderEntity) {
        return (MallOrderEntity)this.mallOrderMapper.getSingle(orderEntity);
    }

    @Override
    public BaseJsonVo updateOrderEvaluate(String orderNo) {
        MallOrderEntity mallOrderEntity = new MallOrderEntity();
        mallOrderEntity.setOrderNo(orderNo);
        mallOrderEntity.setEvaluateStatus(1);
        this.mallOrderMapper.updateByPrimaryKeySelective(mallOrderEntity);
        return BaseJsonVo.success((Object)"\u66f4\u65b0\u8bc4\u4ef7\u6210\u529f");
    }

    @Override
    public int getStatusClass(MallOrderEntity order, Integer orderClass) {
        return this.getStatusClass(order.getStatus(), order.getEvaluateStatus(), orderClass);
    }

    @Override
    public int getStatusClass(Integer orderStatus, Integer evaluateStatus, Integer orderClass) {
        int statusClass = OrderStatusClassConstants.getStatusClassByStatus(orderStatus);
        if (statusClass == 4 && orderClass == 1 && evaluateStatus == 1) {
            statusClass = 7;
        }
        return statusClass;
    }

    @Override
    public BaseJsonVo edbOrderSync(String orderMainNo) {
        return BaseJsonVo.success((Object)"\u4e0d\u518d\u540c\u6b65EDB\uff0c\u6539\u4e3a\u540c\u6b65OMS");
    }

    @Override
    public BaseJsonVo confirmOrder(String orderNo) {
        return BaseJsonVo.success((Object)"\u4e0d\u518d\u540c\u6b65EDB\uff0c\u73b0\u5728\u540c\u6b65OMS");
    }

    @Override
    public BaseJsonVo edbOrderSyncQuartz() {
        List<String> orderMainNos = this.mallOrderMapper.findUnsyncEdbOrders();
        this.logger.info("EDB\u540c\u6b65\u4efb\u52a1\uff0c\u5373\u5c06\u540c\u6b65\uff1a" + orderMainNos.toString());
        orderMainNos.forEach(orderMainNo -> this.edbOrderSync((String)orderMainNo));
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo findUnsyncEDBOrders(int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<Map<String, Object>> orderMainNos = this.mallOrderMapper.findUnsyncEdbOrdersDetail();
        orderMainNos.forEach(order -> {
            order.put("ORDER_CLASS", OrderClassEnum.getName((Integer)order.get("ORDER_CLASS")) + "(" + order.get("ORDER_CLASS") + ")");
            order.put("ORDER_SOURCE", OrderSourceEnum.getName((Integer)order.get("ORDER_SOURCE")) + "(" + order.get("ORDER_SOURCE") + ")");
            order.put("MAIN_STATUS", OrderStatusEnum.getName((Integer)order.get("MAIN_STATUS")) + "(" + order.get("MAIN_STATUS") + ")");
            order.put("SUB_STATUS", OrderStatusEnum.getName((Integer)order.get("SUB_STATUS")) + "(" + order.get("SUB_STATUS") + ")");
        });
        PageInfo pg = page.toPageInfo();
        pg.setList(orderMainNos);
        return pg;
    }

    @Override
    public List<Map<String, String>> getUnConfirmedOrders(Date fifteenDaysAgo) {
        return this.mallOrderMapper.getUnConfirmedOrders(fifteenDaysAgo);
    }

    @Override
    public void backupWealthData() {
        String curDate = DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyyMMdd");
        this.logger.info(curDate);
        this.mallOrderMapper.insertWealthBack(curDate);
        try {
            BaseJsonVo<Map<String, Object>> mapBaseJsonVo = this.biBalanceAnalysisInvoke.countSpecialCardEveryday("");
            if (mapBaseJsonVo.isSuccess()) {
                this.mallOrderMapper.insertSpecialBack((Map)mapBaseJsonVo.getValue());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5907\u4efd\u5976\u5361\u4f59\u989d\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public BaseJsonVo countSpecialCardEverydayBatch(String datetime) {
        if (StringUtils.isEmpty((String)datetime)) {
            Date _datetime;
            Date beginDate = DateUtils.StrToDate((String)"2019-11-29 00:00:00");
            Date endDate = DateUtils.StrToDate((String)"2023-05-06 00:00:00");
            int i = 0;
            while ((_datetime = DateUtils.getAddDateByDay((Date)beginDate, (int)i)).compareTo(endDate) <= 0) {
                datetime = DateUtils.formatDate((Date)_datetime, (String)"yyyy-MM-dd HH:mm:ss");
                BaseJsonVo<Map<String, Object>> mapBaseJsonVo = this.biBalanceAnalysisInvoke.countSpecialCardEveryday(datetime);
                if (mapBaseJsonVo.isSuccess()) {
                    this.mallOrderMapper.insertSpecialBack((Map)mapBaseJsonVo.getValue());
                }
                ++i;
            }
        } else {
            BaseJsonVo<Map<String, Object>> mapBaseJsonVo = this.biBalanceAnalysisInvoke.countSpecialCardEveryday(datetime);
            if (mapBaseJsonVo.isSuccess()) {
                this.mallOrderMapper.insertSpecialBack((Map)mapBaseJsonVo.getValue());
            }
        }
        return BaseJsonVo.success(null);
    }

    @Override
    public Map<String, BigDecimal> getFinalOrderAmount(String orderNo) {
        MallOrderEntity orderEntity;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal refundAmount = BigDecimal.ZERO;
        HashedMap map = new HashedMap();
        if (StringUtils.isNotEmpty((String)orderNo) && (orderEntity = (MallOrderEntity)this.mallOrderMapper.selectByPrimaryKey((Serializable)((Object)orderNo))) != null) {
            amount = orderEntity.getOrderAmount().subtract(orderEntity.getCouponAmount());
            BaseJsonVo js = this.mallRefundPayDetailInterface.getOrderRefundInfo(null, orderNo);
            if (js.isSuccess()) {
                List detailVos = (List)js.getValue();
                refundAmount = BigDecimal.valueOf(detailVos.stream().filter(c -> c.getPaytypeId() != 3).mapToDouble(c -> c.getFactReturnAmount().doubleValue()).sum());
            }
        }
        map.put("orderAmount", amount);
        map.put("refundAmount", refundAmount);
        return map;
    }

    @Override
    public List<MallOrderEntity> getDeliveringOrder() {
        return this.mallOrderMapper.getDeliveringOrder();
    }

    @Override
    public String getReunionFreightOrder(String bindcode, String customerId) {
        return this.mallOrderMapper.getReunionFreightOrder(bindcode, customerId);
    }

    @Override
    public int getDouyinOrderNum(String customerId, String orderMainNo) {
        if (StringUtils.isEmpty((String)customerId) || StringUtils.isEmpty((String)orderMainNo)) {
            return 0;
        }
        return this.mallOrderMapper.getDouyinOrderNum(customerId, orderMainNo);
    }

    @Override
    public Set<String> getOrderConsigneeMobiles(Date beginDate, Date endDate, Integer limitCount) {
        return this.mallOrderMapper.getOrderConsigneeMobiles(beginDate, endDate, limitCount);
    }
}

