/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.apiinvoke.mall.OrderSyncInvoke;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallOrderFailsMapper;
import cc.lechun.mall.dao.trade.MallOrderSyncInfoMapper;
import cc.lechun.mall.entity.trade.MallOrderFailsEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderSyncInfoEntity;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallOrderSyncInfoService
extends BaseService
implements MallOrderSyncInfoInterface {
    @Autowired
    private MallOrderSyncInfoMapper orderSyncInfoMapper;
    @Autowired
    private MallOrderFailsMapper orderFailsMapper;
    @Autowired
    OrderSyncInvoke orderSyncInvoke;
    @Autowired
    MallOrderMainInterface orderMainInterface;

    @Override
    public BaseJsonVo recordInfo(MallOrderSyncInfoEntity entity) {
        if (entity == null) {
            return BaseJsonVo.error((String)"\u8c03\u7528\u4fe1\u606f\u4e3a\u7a7a");
        }
        int insertResult = this.orderSyncInfoMapper.insert(entity);
        if (insertResult > 0) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public List<MallOrderSyncInfoEntity> getList(MallOrderSyncInfoEntity syncInfo) {
        return this.orderSyncInfoMapper.getList(syncInfo);
    }

    @Override
    public Boolean isSuccessSyncEdb(String orderMainNo, String orderNo) {
        MallOrderSyncInfoEntity syncInfoEntity = new MallOrderSyncInfoEntity();
        if (orderMainNo != null && !orderMainNo.isEmpty()) {
            syncInfoEntity.setOrderMainNo(orderMainNo);
        }
        if (orderNo != null && !orderNo.isEmpty()) {
            syncInfoEntity.setOrderNo(orderNo);
        }
        syncInfoEntity.setSuccess(1);
        List<MallOrderSyncInfoEntity> syncInfoEntities = this.getList(syncInfoEntity);
        if (syncInfoEntities == null || syncInfoEntities.size() == 0) {
            return false;
        }
        return true;
    }

    @Override
    public BaseJsonVo recordOrderFails(MallOrderFailsEntity entity) {
        int insertResult = this.orderFailsMapper.insert(entity);
        if (insertResult > 0) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo batchSyncOrderToOMS(String orderMainNo) {
        if (StringUtils.isNotEmpty((String)orderMainNo)) {
            BaseJsonVo rst = this.orderSyncInvoke.syncOrderToOMS(orderMainNo);
            if (!rst.isSuccess()) {
                this.logger.info("[{}]\u540c\u6b65\u5230OMS\u9519\u8bef\uff1a{}", (Object)orderMainNo, (Object)rst.getError_msg());
            }
            return rst;
        }
        this.logger.info("\u6279\u91cf\u540c\u6b65OMS\u8ba2\u5355\u5f00\u59cb");
        Boolean[] allSuccess = new Boolean[]{true};
        List<Map<String, Object>> orderMainNos = this.orderSyncInfoMapper.getBatchUnsyncedOrderMainNos();
        int[] i = new int[]{0};
        orderMainNos.forEach(order -> {
            if ((Integer)order.get("MAIN_STATUS") > 2) {
                BaseJsonVo rst = this.orderSyncInvoke.syncOrderToOMS((String)order.get("ORDER_MAIN_NO"));
                if (!rst.isSuccess()) {
                    allSuccess[0] = false;
                    this.logger.error("[{}]\u540c\u6b65\u5230OMS\u9519\u8bef\uff1a{}", order.get("ORDER_MAIN_NO"), (Object)rst.getError_msg());
                    i[0] = i[0] + 1;
                    this.orderSyncInfoMapper.insertSyncFailOrder((String)order.get("ORDER_NO"));
                } else {
                    this.orderSyncInfoMapper.deleteSyncFailOrder((String)order.get("ORDER_NO"));
                    this.logger.info("[{}]\u540c\u6b65\u5230OMS\u6210\u529f", order.get("ORDER_MAIN_NO"));
                }
            }
        });
        this.logger.error("\u5931\u8d25\u4e86\u8fd9\u4e48\u591a : " + i[0]);
        return allSuccess[0] != false ? BaseJsonVo.success(null) : BaseJsonVo.error((String)"\u90e8\u5206\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u67e5\u770b");
    }

    @Override
    public BaseJsonVo batchSyncOrderPaySuccessToOMS() {
        List<String> unsyncedOrderPaySuccessMainNos = this.orderSyncInfoMapper.getBatchUnsyncedOrderPaySuccessMainNos();
        this.logger.info("\u540c\u6b65\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u67e5\u8be2\u51fa\u4e86\u8fd9\u4e48\u591a\uff1a{}", (Object)unsyncedOrderPaySuccessMainNos.size());
        unsyncedOrderPaySuccessMainNos.forEach(unsyncedOrderPaySuccessMainNo -> this.omsOrderSyncStatus((String)unsyncedOrderPaySuccessMainNo, OrderStatusEnum.PAYCONFIRM));
        return BaseJsonVo.success((Object)"\u540c\u6b65\u5b8c\u6210");
    }

    @Override
    public BaseJsonVo batchSyncOrderConfirmSuccessToOMS() {
        List<String> unsyncedOrderConfirmMainNos = this.orderSyncInfoMapper.getBatchUnsyncedOrderConfirmMainNos();
        this.logger.info("\u540c\u6b65\u8ba2\u5355\u7b7e\u6536\u6210\u529f\uff0c\u67e5\u8be2\u51fa\u4e86\u8fd9\u4e48\u591a\uff1a{}", (Object)unsyncedOrderConfirmMainNos.size());
        unsyncedOrderConfirmMainNos.forEach(unsyncedOrderConfirmMainNo -> this.omsOrderSyncStatus((String)unsyncedOrderConfirmMainNo, OrderStatusEnum.COMPLETION));
        return BaseJsonVo.success((Object)"\u540c\u6b65\u5b8c\u6210");
    }

    @Override
    public PageInfo findUnSyncOrderToOMS(String orderMainNo, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<Map<String, Object>> orderMainNos = this.orderSyncInfoMapper.getUnsyncedOrderMainNos(orderMainNo);
        orderMainNos.forEach(order -> {
            order.put("ORDER_CLASS", OrderClassEnum.getName((Integer)order.get("ORDER_CLASS")) + "(" + order.get("ORDER_CLASS") + ")");
            order.put("ORDER_SOURCE", OrderSourceEnum.getName((Integer)order.get("ORDER_SOURCE")) + "(" + order.get("ORDER_SOURCE") + ")");
            order.put("MAIN_STATUS", OrderStatusEnum.getName((int)((Integer)order.get("MAIN_STATUS"))) + "(" + order.get("MAIN_STATUS") + ")");
            order.put("SUB_STATUS", OrderStatusEnum.getName((int)((Integer)order.get("SUB_STATUS"))) + "(" + order.get("SUB_STATUS") + ")");
        });
        PageInfo pg = page.toPageInfo();
        pg.setList(orderMainNos);
        return pg;
    }

    @Override
    public BaseJsonVo omsOrderSyncStatus(String orderMainNo, OrderStatusEnum orderStatusEnum) {
        BaseJsonVo rstt = this.orderSyncInvoke.orderStatusSyncToOMS(orderMainNo, "", orderStatusEnum.getValue());
        if (!rstt.isSuccess()) {
            this.logger.info("\u8ba2\u5355[{}]\u652f\u4ed8\u3001\u7b7e\u6536\u6210\u529f\u72b6\u6001\u540c\u6b65\u5230OMS\u9519\u8bef\uff0c\u539f\u56e0\uff1a{}", (Object)orderMainNo, (Object)rstt.getError_msg());
        }
        this.logger.info("\u8fd9\u4e2a\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u72b6\u6001\u540c\u6b65\u6210\u529f\u4e86\uff1a{}", (Object)orderMainNo);
        return rstt;
    }

    @Override
    public BaseJsonVo omsOrderSyncStatus() {
        List<MallOrderMainEntity> list = this.orderMainInterface.getTempList();
        if (list.size() > 0) {
            for (MallOrderMainEntity orderMainEntity : list) {
                BaseJsonVo rstt = this.orderSyncInvoke.orderStatusSyncToOMS(orderMainEntity.getOrderMainNo(), "", orderMainEntity.getStatus());
                if (!rstt.isSuccess()) {
                    this.logger.info("\u8ba2\u5355[{}] \u72b6\u6001{}\u540c\u6b65\u5230OMS\u9519\u8bef\uff0c\u539f\u56e0\uff1a{}", new Object[]{orderMainEntity.getStatus(), orderMainEntity.getOrderMainNo(), rstt.getError_msg()});
                }
                this.logger.info("\u8fd9\u4e2a\u8ba2\u5355\u72b6\u6001\u540c\u6b65\u6210\u529f\u4e86\uff1a{}", (Object)orderMainEntity.getOrderMainNo());
            }
        }
        return BaseJsonVo.success((Object)"");
    }
}

