/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.apiinvoke.mall.MiniShopInvoke;
import cc.lechun.apiinvoke.mall.YouShuOrderApiInvoke;
import cc.lechun.common.constants.trade.OrderStatusClassConstants;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.ChannelEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.deliver.MallAreaEntity;
import cc.lechun.mall.entity.deliver.MallCityEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.trade.CancelOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInItemVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderProductVo;
import cc.lechun.mall.entity.trade.MallOrderRecordEntity;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import cc.lechun.mall.iservice.deliver.MallCityInterface;
import cc.lechun.mall.iservice.inventory.InventoryInterface;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderRecordInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.service.trade.defineFieldHandle.DefineFiledHandleInterface;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallTradeService
extends BaseService
implements MallTradeInterface {
    @Autowired
    private InventoryInterface inventoryInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private MallOrderGroupProductInterface orderGroupProductInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private DefineFiledHandleInterface defineFiledHandleInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    private MallProductPicInterface productPicInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallAreaInterface areaInterface;
    @Autowired
    private MallCityInterface cityInterface;
    @Autowired
    private MallOrderRecordInterface orderRecordInterface;
    @Autowired
    private MallPromotionProductInterface mallPromotionProductInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Value(value="${autoConfirmDays:15}")
    private Integer autoConfirmDays;
    @Autowired
    private MiniShopInvoke miniShopInvoke;
    @Autowired
    private YouShuOrderApiInvoke youShuOrderApiInvoke;

    @Override
    public OrderListVo getOrderDetail(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        return this.getOrderDetail(orderMainEntity);
    }

    @Override
    public OrderListVo getOrderDetail(MallOrderMainEntity orderMainEntity) {
        OrderListVo orderListVo = this.orderMainInterface.getOrderMainDetail(orderMainEntity.getCustomerId(), orderMainEntity.getOrderMainNo());
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setOrderMainNo(orderMainEntity.getOrderMainNo());
        List<MallOrderProductEntity> orderProductEntities = this.orderProductInterface.getOrderProductList(orderProductEntity);
        ArrayList<MallOrderProductVo> orderProductVos = new ArrayList<MallOrderProductVo>();
        for (MallOrderProductEntity p : orderProductEntities) {
            MallOrderProductVo orderProductVo = new MallOrderProductVo();
            if (p.getGroupType() == 1) {
                orderProductVo.setItemId(p.getPromotionId());
            } else if (p.getGroupType() == 2) {
                orderProductVo.setItemId(p.getGroupId());
            } else if (p.getGroupType() == 4) {
                orderProductVo.setItemId(p.getProductId());
            } else if (p.getGroupType() == 5) {
                orderProductVo.setItemId(p.getActivityNo());
            }
            orderProductVo.setProductType(p.getGroupType());
            orderProductVo.setFactPrice(p.getUnitPrice());
            orderProductVo.setItemName(p.getProductName());
            orderProductVo.setQuantity(p.getQuantity() - (p.getRefundCount() == null ? 0 : p.getRefundCount()));
            orderProductVo.setTotalPrice(p.getTotalPrice().subtract(p.getRefundAmount() == null ? BigDecimal.ZERO : p.getRefundAmount()).setScale(2, 4));
            orderProductVo.setUnitPrice(p.getOriginalPrice());
            orderProductVo.setOrderProductId(p.getOrderProductNo());
            orderProductVos.add(orderProductVo);
        }
        orderListVo.setOrderProductVos(orderProductVos);
        List<MallOrderEntity> orderList = this.orderInterface.getOrderList(orderMainEntity.getOrderMainNo());
        orderListVo.setConsigneeAddr(orderList.get(0).getConsigneeAddr());
        orderListVo.setConsigneeAreaname(orderList.get(0).getConsigneeAreaname());
        orderListVo.setConsigneeCityname(orderList.get(0).getConsigneeCityname());
        orderListVo.setConsigneeProvincename(orderList.get(0).getConsigneeProvincename());
        orderListVo.setConsigneeName(orderList.get(0).getConsigneeName());
        orderListVo.setConsigneePhone(orderList.get(0).getConsigneePhone());
        this.logger.info("\u8ba2\u5355\u660e\u7ec6:{}", (Object)orderListVo.toString());
        return orderListVo;
    }

    @Override
    public BaseJsonVo cancelCustomerOrder(String customerId, String orderMainNo, int cancelSource) {
        this.logger.info("*************\u8fdb\u5165\u53d6\u6d88\u8ba2\u5355service********\u65b9\u6cd5cancelCustomerOrder*************");
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        this.defineFiledHandleInterface.cancelOrderBefore(customerId, orderMainNo, cancelSource);
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (customerId == null || customerId.isEmpty()) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!customerId.equals(orderMainEntity.getCustomerId())) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0e\u8ba2\u5355\u4e0d\u4e00\u81f4");
        }
        if (orderMainEntity.getStatus().intValue() == OrderStatusEnum.CANCEL.getValue()) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u5df2\u7ecf\u53d6\u6d88");
        }
        if (orderMainEntity.getStatus().intValue() != OrderStatusEnum.UNPAY.getValue()) {
            return BaseJsonVo.error((String)"\u8be5\u72b6\u6001\u4e0d\u80fd\u53d6\u6d88");
        }
        if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARDPLAN.getValue()) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u4e3a\u5976\u5361\u8ba2\u5355\uff0c\u4e0d\u80fd\u53d6\u6d88");
        }
        Date createTime = orderMainEntity.getCreateTime();
        String canCancelTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)-10, (String)"yyyy-MM-dd HH:mm:ss");
        if (DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)createTime, (String)"yyyy-MM-dd HH:mm:ss"), (String)canCancelTime) < 0L) {
            this.logger.info("======cancelCustomerOrder====createTime:[{}],canCancelTime:[{}],DateDiff:[{}]", new Object[]{createTime, canCancelTime, DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)createTime, (String)"yyyy-MM-dd HH:mm:ss"), (String)canCancelTime)});
            return BaseJsonVo.error((String)"\u6682\u65f6\u65e0\u6cd5\u53d6\u6d88");
        }
        try {
            this.logger.info("*************\u8fdb\u5165\u53d6\u6d88\u8ba2\u5355service********\u5173\u95ed\u652f\u4ed8************");
            BaseJsonVo result = this.payOrderInterface.payClose(customerId, orderMainNo);
            this.logger.info("-------------------cancelCustomerOrder.closePay.result------result={}", (Object)JSON.toJSONString((Object)result));
            if (!result.isSuccess() && !result.getError_msg().startsWith("E006")) {
                return BaseJsonVo.error((String)result.getError_msg());
            }
            this.logger.info("*************\u8fdb\u5165\u53d6\u6d88\u8ba2\u5355service********\u4e0b\u4e00\u6b65\u91ca\u653e\u5e93\u5b58*************");
            BaseJsonVo baseJsonVo = this.inventoryInterface.unLockProductInventory(orderMainNo, orderMainEntity.getPlatformId());
            if (!baseJsonVo.isSuccess()) {
                this.logger.info("*************\u8ba2\u5355{}\u8fd4\u8fd8\u5e93\u5b58\u5931\u8d25,\u53d6\u6d88\u5931\u8d25*************", (Object)orderMainNo);
                return baseJsonVo;
            }
            this.logger.info("*************\u5f00\u59cb\u8bbe\u7f6e\u8ba2\u5355\u5df2\u53d6\u6d88{}*************", (Object)orderMainNo);
            if (!this.orderMainInterface.cancelOrderMain(orderMainNo, customerId)) {
                this.logger.info("*************\u8ba2\u5355{}\u53d6\u6d88\u5931\u8d25*************", (Object)orderMainNo);
                return BaseJsonVo.error((String)"\u53d6\u6d88\u8ba2\u5355\u5931\u8d25");
            }
            this.logger.info("*************\u8ba2\u5355\u5df2\u53d6\u6d88{}*************", (Object)orderMainNo);
            this.defineFiledHandleInterface.cancelOrderAfter(customerId, orderMainNo, cancelSource);
            this.youShuOrderApiInvoke.addOrder(orderMainNo);
            return BaseJsonVo.success((Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u53d6\u6d88\u8ba2\u5355\u9519\u8bef", (Throwable)e);
            return BaseJsonVo.error((String)"\u53d6\u6d88\u8ba2\u5355\u9519\u8bef");
        }
    }

    @Override
    public PageInfo<OrderListVo> getOrderList(String customerId, int statusClass, int pageSize, int pageCount) {
        PageInfo<OrderListVo> orderMainEntities;
        int[] statusArr = null;
        if (statusClass != 0) {
            statusArr = OrderStatusClassConstants.getStatusByStatusClass(statusClass);
        }
        if ((orderMainEntities = this.orderMainInterface.getOrderMainList4cms(customerId, statusArr, statusClass, pageSize, pageCount)) == null || orderMainEntities.getList().size() == 0) {
            return null;
        }
        ExecutorService pool = Executors.newFixedThreadPool(10);
        for (final OrderListVo orderMain : orderMainEntities.getList()) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    MallTradeService.this.processOrderInfo(orderMain);
                }
            });
            if (orderMain.getStatus() <= 2 || orderMain.getStatus() >= 25 || orderMain.getOrderClass() == 2 || orderMain.getOrderSource() == 21 || orderMain.getOrderSource() == 22) {
                orderMain.setCanShare(2);
                continue;
            }
            orderMain.setCanShare(1);
        }
        pool.shutdown();
        try {
            boolean loop = true;
            while (loop = !pool.awaitTermination(2L, TimeUnit.SECONDS)) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (statusClass == 4) {
            orderMainEntities.getList().removeIf(c -> c.getOrderClass() != 1 || c.getEvaluateStatus() == 1 || c.getOrderNo() == null);
        }
        return orderMainEntities;
    }

    public void processOrderInfo(OrderListVo orderMain) {
        MallCityEntity cityEntity;
        String orderNo = orderMain.getOrderNo();
        this.orderInterface.getOrderInfo(orderMain);
        if (orderMain.getOrderNo() == null || orderMain.getOrderNo().isEmpty()) {
            return;
        }
        List<MallOrderPayEntity> orderPayEntities = this.orderPayInterface.getList(orderMain.getOrderMainNo());
        orderMain.setBalanceAmount(orderPayEntities.stream().filter(c -> c.getPaytypeId().intValue() == PayTypeEnum.BALANCE_PAY.getValue()).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add));
        orderMain.setCouponAmount(orderPayEntities.stream().filter(c -> c.getPaytypeId().intValue() == PayTypeEnum.COUPON_PAY.getValue()).map(c -> c.getPayamount()).reduce(BigDecimal.ZERO, BigDecimal::add));
        orderMain.setChannelName(ChannelEnum.getName(orderMain.getChannelId()));
        orderMain.setStatusName(OrderStatusEnum.getName(orderMain.getStatus()));
        int statusClass1 = this.orderInterface.getStatusClass(orderMain.getStatus(), orderMain.getEvaluateStatus(), orderMain.getOrderClass());
        orderMain.setStatusClass(statusClass1);
        if (orderMain.getStatus() == OrderStatusEnum.UNPAY.getValue()) {
            int cancelTimes = 570;
            long i = DateUtils.getDateDiffSecond((String)DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"), (String)DateUtils.getAddDateBySecond((Date)orderMain.getCreateTime(), (int)cancelTimes, (String)"yyyy-MM-dd HH:mm:ss"));
            if (i < 0L) {
                i = 0L;
            }
            orderMain.setCancelTimes(i);
            if (i == 0L) {
                statusClass1 = this.orderInterface.getStatusClass(orderMain.getStatus(), orderMain.getEvaluateStatus(), orderMain.getOrderClass());
                orderMain.setStatusClass(statusClass1);
            }
        } else {
            orderMain.setCancelTimes(0L);
        }
        boolean isEdit = this.orderMainInterface.iseditOrder(orderMain.getOrderNo(), orderMain.getDeliverDate(), orderMain.getPickUpDate(), orderMain.getPlatformGroupId(), orderMain.getStatus());
        orderMain.setEdit(isEdit);
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setOrderMainNo(orderMain.getOrderMainNo());
        if (orderNo != null && !orderNo.isEmpty()) {
            orderProductEntity.setOrderNo(orderNo);
        }
        List<MallOrderProductEntity> orderProductEntities = this.orderProductInterface.getOrderProductList(orderProductEntity);
        ArrayList<MallOrderProductVo> orderProductVos = new ArrayList<MallOrderProductVo>();
        int transportType = 1;
        for (MallOrderProductEntity p : orderProductEntities) {
            MallOrderProductVo orderProductVo = new MallOrderProductVo();
            if (p.getGroupType() == 1) {
                orderProductVo.setItemId(p.getPromotionProductId());
                orderProductVo.setPicUrl(this.productPicInterface.getProductPicUrl(p.getPromotionProductId() == null ? "" : p.getPromotionProductId(), ProductPicTypeEnum.PROMO_SAMLL.getValue()).get(0));
            }
            if (p.getGroupType() == 2) {
                orderProductVo.setItemId(p.getGroupId());
                orderProductVo.setPicUrl(this.productPicInterface.getProductPicUrl(p.getGroupId() == null ? "" : p.getGroupId(), ProductPicTypeEnum.GRO_SAMLL.getValue()).get(0));
            }
            if (p.getGroupType() == 4) {
                orderProductVo.setItemId(p.getProductId());
                orderProductVo.setPicUrl(this.productPicInterface.getProductPicUrl(p.getProductId() == null ? "" : p.getProductId(), ProductPicTypeEnum.PRO_SAMLL.getValue()).get(0));
            }
            if (p.getGroupType() == 5) {
                orderProductVo.setItemId(p.getActivityNo());
                orderProductVo.setPicUrl(this.productPicInterface.getProductPicUrl(p.getActivityNo() == null ? "" : p.getActivityNo(), ProductPicTypeEnum.ACT_SAMLL.getValue()).get(0));
            }
            orderProductVo.setProductType(p.getGroupType());
            orderProductVo.setFactPrice(p.getUnitPrice());
            orderProductVo.setItemName(p.getProductName());
            orderProductVo.setQuantity(p.getQuantity());
            orderProductVo.setTotalPrice(p.getTotalPrice());
            orderProductVo.setUnitPrice(p.getOriginalPrice());
            orderProductVo.setOrderProductId(p.getOrderProductNo());
            MallProductEntity productEntity = this.productInterface.getProduct(p.getProductId());
            if (productEntity != null) {
                orderProductVo.setProDw(productEntity.getProDw());
                orderProductVo.setProTypeId(productEntity.getProTypeId());
                orderProductVo.setProTitle(productEntity.getProTitle());
            } else {
                orderProductVo.setProDw("\u5957");
            }
            orderProductVos.add(orderProductVo);
        }
        transportType = this.productInterface.getTransportType(this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(orderMain.getOrderNo()));
        orderMain.setOrderProductVos(orderProductVos);
        MallAreaEntity areaEntity = this.areaInterface.getArea(orderMain.getConsigneeAreaid());
        if (areaEntity != null && (cityEntity = this.cityInterface.getCity(areaEntity.getCityId())) != null) {
            orderMain.setOpenCityStatus(cityEntity.getOpenCityStatus());
        }
        orderMain.setTransportType(transportType);
        if (transportType == 2) {
            orderMain.setDeliverDateShow(this.tradeCommonInterface.getDelayDateName(DateUtils.formatDate((Date)orderMain.getCreateTime(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getDeliverDate(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getPickUpDate(), (String)"yyyy-MM-dd"), "", orderMain.getOrderSource(), orderMain.getTransportType(), orderMain.getOpenCityStatus(), orderMain.getStatusClass(), orderMain.getDeliverType(), orderMain.getOrderClass()));
        } else {
            orderMain.setDeliverDateShow(this.tradeCommonInterface.getDelayDateName(DateUtils.formatDate((Date)orderMain.getCreateTime(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getDeliverDate(), (String)"yyyy-MM-dd"), DateUtils.formatDate((Date)orderMain.getPickUpDate(), (String)"yyyy-MM-dd"), "", orderMain.getOrderSource(), orderMain.getTransportType(), orderMain.getOpenCityStatus(), orderMain.getStatusClass(), orderMain.getDeliverType(), orderMain.getOrderClass()));
        }
        orderMain.setStatusClass(this.orderInterface.getStatusClass(orderMain.getStatus(), orderMain.getEvaluateStatus(), orderMain.getOrderClass()));
        orderMain.setStatusClassName(OrderStatusClassConstants.getStatusClassName(orderMain.getStatusClass()));
        this.logger.info(orderMain.toString());
    }

    @Override
    public void batchCancelOrder() {
        this.logger.info("*************\u8fdb\u5165\u6279\u91cf\u53d6\u6d88\u8ba2\u5355\u65b9\u6cd5*****batchCancelOrder************");
        int sendMessageSecond = 300;
        int second = 600;
        int size = 50;
        String sendMessageTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)(-sendMessageSecond), (String)"yyyy-MM-dd HH:mm:ss");
        String cancelTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)(-second), (String)"yyyy-MM-dd HH:mm:ss");
        List<CancelOrderVo> cancelOrderVos = this.orderMainInterface.getBacthCancelMainOrderList(sendMessageTime, size);
        String memcacheKey = "lechun_sendmessage_cancelorder_";
        for (CancelOrderVo c : cancelOrderVos) {
            int balanceTime = second / 60 - sendMessageSecond / 60;
            this.logger.info("*************\u8fdb\u5165\u6279\u91cf\u53d6\u6d88\u8ba2\u5355\u65b9\u6cd5********batchCancelOrder*********CreateTime={},cancelTime={}", (Object)DateUtils.formatDate((Date)c.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (Object)cancelTime);
            this.logger.info("****************DateUtils.getDateDiffSecond(DateUtils.formatDate(c.getCreateTime(),\"yyyy-MM-dd HH:mm:ss\"),cancelTime)>=0**********res={}", (Object)(DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)c.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)cancelTime) >= 0L ? 1 : 0));
            if (DateUtils.getDateDiffSecond((String)DateUtils.formatDate((Date)c.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)cancelTime) < 0L) continue;
            BaseJsonVo baseJsonVo = this.cancelCustomerOrder(c.getCustomerId(), c.getOrderMainNo(), 2);
            MallOrderRecordEntity orderRecordEntity = new MallOrderRecordEntity();
            orderRecordEntity.setOrderMainNo(c.getOrderMainNo());
            orderRecordEntity.setCancelCount(c.getIsExists() + 1);
            if (c.getIsExists() == 0) {
                this.orderRecordInterface.insert(orderRecordEntity);
                continue;
            }
            orderRecordEntity.setRecordId(c.getRecordId());
            this.orderRecordInterface.update(orderRecordEntity);
        }
    }

    @Override
    public BaseJsonVo autoConfirmGoods() {
        this.logger.info(this.autoConfirmDays.toString());
        this.logger.info(String.valueOf(0 - this.autoConfirmDays));
        this.logger.info(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(0 - this.autoConfirmDays)).toString());
        this.logger.info(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(0 - this.autoConfirmDays)), (String)"yyyy-MM-dd"));
        this.logger.info(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(0 - this.autoConfirmDays)), (String)"yyyy-MM-dd") + " 00:00:00");
        this.logger.info(DateUtils.getDateFromString((String)(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(0 - this.autoConfirmDays)), (String)"yyyy-MM-dd") + " 00:00:00")).toString());
        Date fifteenDaysAgo = DateUtils.getDateFromString((String)(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(0 - this.autoConfirmDays)), (String)"yyyy-MM-dd") + " 00:00:00"));
        List<Map<String, String>> orders = this.orderInterface.getUnConfirmedOrders(fifteenDaysAgo);
        orders.forEach(order -> this.confirmGoods((String)order.get("CUSTOMER_ID"), (String)order.get("ORDER_MAIN_NO"), (String)order.get("ORDER_NO")));
        return BaseJsonVo.success(null);
    }

    @Override
    @Transactional
    public BaseJsonVo confirmGoods(String customerId, String orderMainNo, String orderNo) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        this.defineFiledHandleInterface.confirmGoodsBefore(customerId, orderMainNo, orderNo);
        if (orderMainEntity == null || !orderMainEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27");
        }
        ArrayList sqlUpdate = new ArrayList();
        List<MallOrderEntity> orderList = this.orderInterface.getOrderList(orderMainNo);
        if (orderList == null || orderList.size() == 0) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        boolean isAllComplete = true;
        boolean success = false;
        try {
            for (MallOrderEntity order : orderList) {
                int statusSubClass = this.orderInterface.getStatusClass(order.getStatus(), order.getEvaluateStatus(), orderMainEntity.getOrderClass());
                if (StringUtils.isNotEmpty((String)orderNo)) {
                    if (orderNo.equals(order.getOrderNo()) && statusSubClass == 3) {
                        success = this.orderInterface.updateOrderStatus(orderNo, OrderStatusEnum.COMPLETION.getName(), customerId, order.getStatus());
                        if (!success) {
                            throw new RuntimeException("\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
                        }
                        statusSubClass = 4;
                    }
                } else if (statusSubClass == 3) {
                    success = this.orderInterface.updateOrderStatus(order.getOrderNo(), OrderStatusEnum.COMPLETION.getName(), customerId, order.getStatus());
                    if (!success) {
                        throw new RuntimeException("\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
                    }
                    statusSubClass = 4;
                }
                if (statusSubClass != 0 && statusSubClass != 1 && statusSubClass != 2 && statusSubClass != 3) continue;
                isAllComplete = false;
            }
            if (isAllComplete && !(success = this.orderMainInterface.updateOrderMainStatus(orderMainNo, OrderStatusEnum.COMPLETION.getName(), customerId, orderMainEntity.getStatus()))) {
                throw new RuntimeException("\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
            }
            this.defineFiledHandleInterface.confirmGoodsAfter(orderMainEntity, orderNo);
            this.miniShopInvoke.orderRecieve(orderMainNo);
            return BaseJsonVo.success((Object)"\u786e\u8ba4\u6536\u8d27\u6210\u529f");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.logger.error("user:" + customerId + ",\u4e3b\u8ba2\u5355\uff1a" + orderMainNo + ",\u5b50\u8ba2\u5355\uff1a" + orderNo + ",\u5f02\u5e38\uff1a" + e.getMessage());
            return BaseJsonVo.error((String)"\u786e\u8ba4\u6536\u8d27\u5931\u8d25");
        }
    }

    public int getTransportType(List<MallOrderCacheInItemVo> itemVoList) {
        int type = 0;
        boolean normatTransport = false;
        if (itemVoList == null || itemVoList.size() == 0) {
            this.logger.error("\u8f93\u5165\u5546\u54c1\u96c6\u5408\u4e3a\u4e3a\u7a7a");
            return type;
        }
        block16: for (MallOrderCacheInItemVo vo : itemVoList) {
            this.logger.info("\u4fc3\u9500\u7c7b\u578b\u4e3a:" + vo.getItemType() + ",\u4fc3\u9500id=" + vo.getItemId());
            if (vo.getItemType() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                type = this.getType(vo.getItemId());
                switch (type) {
                    case 1: {
                        continue block16;
                    }
                    case 2: {
                        normatTransport = true;
                        continue block16;
                    }
                }
                continue;
            }
            if (vo.getItemType() == SalesTypeEnum.SALES_GROUP.getValue()) {
                List<MallProductEntity> list = this.productInterface.getProductListByGroupId(vo.getItemId());
                type = this.getType(list);
                switch (type) {
                    case 1: {
                        continue block16;
                    }
                    case 2: {
                        normatTransport = true;
                        break;
                    }
                }
                continue;
            }
            if (vo.getItemType() == SalesTypeEnum.SALES_PROMOTION.getValue()) {
                MallPromotionProductEntity mallPromotionProductEntity = this.mallPromotionProductInterface.getPromotionProductEntity(vo.getItemId());
                this.logger.info("\u4fc3\u9500\u7ed1\u5b9a\u5957\u88c5\u7c7b\u578b:" + Integer.valueOf(mallPromotionProductEntity.getProductType()));
                if (mallPromotionProductEntity != null) {
                    if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(mallPromotionProductEntity.getProductType()).intValue()) {
                        List<MallProductEntity> list = this.productInterface.getProductListByGroupId(mallPromotionProductEntity.getProductId());
                        type = this.getType(list);
                        switch (type) {
                            case 1: {
                                continue block16;
                            }
                            case 2: {
                                normatTransport = true;
                                break;
                            }
                        }
                        continue;
                    }
                    if (SalesTypeEnum.SALES_PRODUCT.getValue() != Integer.valueOf(mallPromotionProductEntity.getProductType()).intValue()) continue;
                    type = this.getType(mallPromotionProductEntity.getProductId());
                    switch (type) {
                        case 1: {
                            continue block16;
                        }
                        case 2: {
                            normatTransport = true;
                            break;
                        }
                    }
                    continue;
                }
                this.logger.error("\u4fc3\u9500id\u4e0d\u5b58\u5728,promotionId=" + vo.getItemId());
                throw new RuntimeException("\u4fc3\u9500\u4e0d\u5b58\u5728");
            }
            this.logger.error("\u65e0\u6548\u7684\u7c7b\u578b, ItemType=" + vo.getItemType());
            throw new RuntimeException("\u65e0\u6548\u7684\u7c7b\u578b");
        }
        if (normatTransport && type == 3) {
            type = 2;
        }
        return type;
    }

    private int getType(String productId) {
        int type = 0;
        Integer transportType = this.productInterface.getProduct(productId).getTransportType();
        if (transportType != null) {
            if (TransportTypeEnum.COLD_CHAIN.getValue() == transportType.intValue()) {
                type = 1;
            } else if (TransportTypeEnum.NORMAL_CHAIN.getValue() == transportType.intValue()) {
                type = 2;
            } else if (TransportTypeEnum.ONLINE_SEND.getValue() == transportType.intValue()) {
                type = 3;
            }
        }
        return type;
    }

    private int getType(List<MallProductEntity> list) {
        int type = 0;
        boolean normatTransport = false;
        for (MallProductEntity item : list) {
            this.logger.info("\u904d\u5386\u5957\u88c5\u4ea7\u54c1:" + item.getProId());
            type = this.getType(item.getProId());
            this.logger.info("\u904d\u5386\u5957\u88c5\u4ea7\u54c1,type=" + type);
            switch (type) {
                case 1: {
                    break;
                }
                case 2: {
                    normatTransport = true;
                    break;
                }
            }
        }
        if (normatTransport && type == 3) {
            type = 2;
        }
        this.logger.info("\u8fd4\u56de\u503c,type=" + type);
        return type;
    }
}

