/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.defineFieldHandle;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.sales.MallPromotionBuyEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionTimeEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.iservice.sales.MallPromotionBuyInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionTimeInterface;
import cc.lechun.mall.iservice.trade.MallOrderMessageQueueInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.service.trade.defineFieldHandle.DefineFiledHandleInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefineFiledHandleService
extends BaseService
implements DefineFiledHandleInterface {
    @Autowired
    private MallOrderMessageQueueInterface messageQueueService;
    @Autowired
    private MallOrderProductInterface mallOrderProductInterface;
    @Autowired
    private MallPromotionBuyInterface mallPromotionBuyInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallPromotionTimeInterface promotionTimeService;
    @Autowired
    private MallPromotionInterface promotionService;

    @Override
    public BaseJsonVo cancelOrderBefore(String customerId, String orderMainNo, int cancelSource) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo cancelOrderAfter(String customerId, String orderMainNo, int cancelSource) {
        List<MallOrderProductEntity> mallOrderProductEntityList = this.mallOrderProductInterface.getOrderProductInfoByOrderMianNoPromotion(orderMainNo);
        if (mallOrderProductEntityList.size() > 0) {
            int i;
            ArrayList<String> promotionIdList = new ArrayList<String>();
            ArrayList<MallPromotionBuyEntity> mallPromotionBuyEntityList = new ArrayList<MallPromotionBuyEntity>();
            for (MallOrderProductEntity mallOrderProductEntity : mallOrderProductEntityList) {
                MallPromotionBuyEntity promotionBuyEntity = new MallPromotionBuyEntity();
                promotionBuyEntity.setPromotionId(mallOrderProductEntity.getPromotionId());
                promotionBuyEntity.setBuyCount(-mallOrderProductEntity.getQuantity().intValue());
                promotionBuyEntity.setCreateTime(DateUtils.now());
                mallPromotionBuyEntityList.add(promotionBuyEntity);
                promotionIdList.add(mallOrderProductEntity.getPromotionId());
            }
            if (mallPromotionBuyEntityList != null && mallPromotionBuyEntityList.size() > 0 && (i = this.mallPromotionBuyInterface.insertPromotionBuyBatch(mallPromotionBuyEntityList)) > 0 && promotionIdList.size() > 0 && promotionIdList != null) {
                for (String promotionId : promotionIdList) {
                    MallPromotionEntity promotionEntity = this.promotionService.getPromotion(promotionId);
                    MallPromotionTimeEntity promotionTimeEntity = this.promotionTimeService.getSingleEntityByTime(promotionId, DateUtils.date());
                    if (promotionTimeEntity != null && promotionEntity != null) {
                        Date beginTime = promotionTimeEntity.getBeginTime();
                        Date endTime = promotionTimeEntity.getEndTime();
                        if (promotionEntity.getPromotionType() == 2) {
                            beginTime = DateUtils.currentDate();
                            endTime = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
                        }
                        this.mallPromotionBuyInterface.clearPromotionBuyCache(promotionId, beginTime, endTime);
                    }
                    this.memcachedService.delete("promotionEntity", promotionId);
                }
            }
        }
        this.messageQueueService.sendCancelOrderQueue(orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo confirmGoodsBefore(String customerId, String orderMainNo, String orderNo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo confirmGoodsAfter(MallOrderMainEntity orderMainEntity, String orderNo) {
        try {
            this.messageQueueService.sendConfirmGoodsQueue(orderMainEntity.getCustomerId(), orderMainEntity.getOrderMainNo(), orderNo);
            return BaseJsonVo.success((Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u786e\u8ba4\u6536\u8d27\u51fa\u9519,\u8ba2\u5355\u53f7:{},\u7528\u6237customerId={}", new Object[]{orderMainEntity.getOrderMainNo(), orderMainEntity.getCustomerId(), e});
            throw new RuntimeException(e);
        }
    }

    @Override
    public BaseJsonVo TakeGoodAfter(String orderMainNo) {
        this.messageQueueService.sendDeliverGoodsQueue(orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo RefundAfter(String orderMainNo) {
        this.messageQueueService.sendRefundQueue(orderMainNo);
        return BaseJsonVo.success((Object)"");
    }
}

