/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.user;

import cc.lechun.apiinvoke.baseservice.BaseServiceInvoke;
import cc.lechun.apiinvoke.baseservice.UserInvoke;
import cc.lechun.common.dingding.DingdingUtils;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.user.MallRoleMapper;
import cc.lechun.mall.dao.user.MallRoleResourceMapper;
import cc.lechun.mall.dao.user.MallUserMapper;
import cc.lechun.mall.dao.user.MallUserRoleMapper;
import cc.lechun.mall.entity.user.MallRoleResourceEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.entity.user.MallUserEntityVo;
import cc.lechun.mall.entity.user.MallUserMenuRsVo;
import cc.lechun.mall.entity.user.MallUserMenuVo;
import cc.lechun.mall.entity.user.MallUserRoleEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.iservice.IOrgPaperService;
import com.dingtalk.api.response.OapiUserListbypageResponse;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class SysUserService
implements SysUserInterface {
    @Autowired
    MallUserMapper mallUserMapper;
    @Autowired
    MallUserRoleMapper mallUserRoleMapper;
    @Autowired
    MallRoleResourceMapper mallRoleResourceMapper;
    @Autowired
    MallRoleMapper mallRoleMapper;
    @Autowired
    IOrgPaperService paperService;
    @Autowired
    RedisCacheUtil redisCacheUtil;
    @Autowired
    SysUserInterface sysUserInterface;
    @Autowired
    DingdingUtils dingdingUtils;
    @Autowired
    BaseServiceInvoke baseServiceInvoke;
    @Autowired
    UserInvoke userInvoke;

    @Override
    public MallUserEntity getSingle(MallUserEntity mallUserEntity) {
        return (MallUserEntity)this.mallUserMapper.getSingle(mallUserEntity);
    }

    @Override
    @InvalidateSingleCache(namespace="getFinancialSubordinate")
    public BaseJsonVo saveMallUser(MallUserEntity mallUserEntity) {
        BaseJsonVo rs = this.validUser(mallUserEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        mallUserEntity.setUserId(IDGenerate.getUniqueID() + "");
        mallUserEntity.setCreateTime(DateUtils.now());
        mallUserEntity.setUserType(1);
        mallUserEntity.setPassword(MD5.sign((String)"lechun", (String)mallUserEntity.getPassword()));
        this.mallUserMapper.insertSelective(mallUserEntity);
        this.mallUserMapper.insertBaseService(mallUserEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @InvalidateSingleCache(namespace="getFinancialSubordinate")
    public BaseJsonVo updateMallUser(MallUserEntity mallUserEntity) {
        BaseJsonVo rs = this.validUser(mallUserEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        this.mallUserMapper.updateByPrimaryKeySelective(mallUserEntity);
        this.userInvoke.updateUser(JsonUtils.toJson((Object)mallUserEntity, (boolean)false));
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo validUser(MallUserEntity mallUserEntity) {
        if (StringUtils.isEmpty((String)mallUserEntity.getUserName())) {
            return BaseJsonVo.paramError((String)"\u767b\u5f55\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getUserNick())) {
            return BaseJsonVo.paramError((String)"\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getUserId()) && StringUtils.isEmpty((String)mallUserEntity.getPassword())) {
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallUserEntity.getPlatformGroupId() == null) {
            return BaseJsonVo.paramError((String)"\u6240\u5c5e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="SysUserService.getMallUserList", expiration=7200)
    public PageInfo getMallUserList(@ParameterValueKeyProvider(order=0) Integer pageNum, @ParameterValueKeyProvider(order=1) Integer pageSize, @ParameterValueKeyProvider(order=2) String userName, @ParameterValueKeyProvider(order=3) Integer status, @ParameterValueKeyProvider(order=4) String userNick, @ParameterValueKeyProvider(order=5) Integer platformGroupId, Integer financialDeptId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallUserList(userName, StringUtils.isEmpty((String)userNick) ? null : userNick, status, platformGroupId, financialDeptId);
        return page.toPageInfo();
    }

    @Override
    @ReadThroughSingleCache(namespace="getMallUserNickName", expiration=7200)
    public String getMallUserNickName(@ParameterValueKeyProvider String user_id) {
        MallUserEntity mallUserEntity = this.getMallUser(user_id);
        return mallUserEntity == null ? "" : mallUserEntity.getUserNick();
    }

    @Override
    public MallUserEntity getMallUser(String user_id) {
        return (MallUserEntity)this.mallUserMapper.selectByPrimaryKey((Serializable)((Object)user_id));
    }

    @Override
    public MallUserEntity getSysUser4name(String user_name) {
        return this.mallUserMapper.getSysUser4name(user_name);
    }

    @Override
    public List<MallUserMenuRsVo> getSysUserMenu(String user_id) {
        List<MallUserMenuVo> ls = this.mallUserMapper.getUserMenuList(user_id);
        ArrayList<MallUserMenuRsVo> rs = new ArrayList<MallUserMenuRsVo>();
        ls.stream().collect(Collectors.groupingBy(o -> o.getParentResourceId())).entrySet().forEach(longListEntry -> {
            MallUserMenuRsVo rsvo = new MallUserMenuRsVo();
            rsvo.setMenu_list((List)longListEntry.getValue());
            rsvo.setParentResourceId((Long)longListEntry.getKey());
            rsvo.setParentResourceName(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceName());
            rsvo.setParentResourceIcon(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceIcon());
            rsvo.setParentResourceOrder(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceOrder());
            rsvo.getMenu_list().sort((o1, o2) -> o1.getParentResourceOrder() - o2.getParentResourceOrder());
            rs.add(rsvo);
        });
        rs.sort((o1, o2) -> o1.getParentResourceOrder() - o2.getParentResourceOrder());
        return rs;
    }

    @Override
    public List<Integer> getSysUserRoleList(String user_id) {
        return this.mallUserMapper.getSysUserRoleList(user_id);
    }

    @Override
    public List<String> getSysUserResourceList(String user_id) {
        return this.mallUserMapper.getSysUserResourceList(user_id);
    }

    @Override
    public PageInfo getMallUserRoleList(int pageNum, int pageSize, String userId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallUserRoleList(userId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void saveUserRole(MallUserRoleEntity mallUserRoleEntity) {
        this.mallUserRoleMapper.insertSelective(mallUserRoleEntity);
    }

    @Override
    public void deleteUserRole(int id) {
        this.mallUserRoleMapper.deleteByPrimaryKey(Integer.valueOf(id));
    }

    @Override
    public PageInfo getMallRoleResourceList(int pageNum, int pageSize, String roleId, int resourceType) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallRoleResourceList(roleId, resourceType);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void saveRoleResource(MallRoleResourceEntity mallRoleResourceEntity) {
        this.mallRoleResourceMapper.insertSelective(mallRoleResourceEntity);
    }

    @Override
    public void deleteRoleResource(long id) {
        this.mallRoleResourceMapper.deleteByPrimaryKey(Long.valueOf(id));
    }

    @Override
    public BaseJsonVo syncSysUsers() {
        this.mallUserMapper.syncSysUsers();
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo getBaseUserList(int type, String userId) {
        List<Map<String, String>> users = this.mallUserMapper.getBaseUserList(type);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String resourcePath = request.getParameter("pageRouterUrl");
        if ("cooperate".equals(resourcePath)) {
            List<String> twiceUsers = this.paperService.getThankTwiceThisMonth(userId);
            List<MallUserEntity> equalUser = this.sysUserInterface.getEqualDeptUser(userId);
            for (Map<String, String> user : users) {
                if (userId.equals(user.get("USER_ID"))) {
                    user.put("enable", (String)((Object)Integer.valueOf(0)));
                    continue;
                }
                if (twiceUsers.contains(user.get("USER_ID"))) {
                    user.put("enable", (String)((Object)Integer.valueOf(0)));
                    continue;
                }
                if (equalUser.stream().filter(c -> c.getUserId().equals(user.get("USER_ID"))).count() > 0L) {
                    user.put("enable", (String)((Object)Integer.valueOf(0)));
                    continue;
                }
                user.put("enable", (String)((Object)Integer.valueOf(1)));
            }
        }
        return BaseJsonVo.success(users);
    }

    @Override
    public Integer getRoleUserCount(Integer roleId) {
        Integer count = this.mallUserRoleMapper.getUserCount(roleId);
        return count == null ? 0 : count;
    }

    @Override
    public Set<String> getDirectSubordinate(String userId, Boolean isDimission) {
        Set<String> subordinate = this.mallUserMapper.findAllSubordinate(userId, isDimission);
        return subordinate;
    }

    @Override
    public Set<String> getSubordinate(String userId) {
        Set<String> subordinate = this.mallUserMapper.findAllSubordinate(userId, true);
        HashSet<String> rtn = new HashSet<String>();
        rtn.addAll(subordinate);
        if (subordinate != null) {
            for (String s : subordinate) {
                rtn.addAll(this.getSubordinate(s));
            }
        }
        return rtn;
    }

    @Override
    @ReadThroughSingleCache(namespace="getFinancialSubordinate", expiration=300)
    public Set<String> getFinancialSubordinate(@ParameterValueKeyProvider(order=0) String userId) {
        Set<String> allFinancialSubordinate = this.mallUserMapper.findAllFinancialSubordinate(userId);
        return allFinancialSubordinate;
    }

    @Override
    public Boolean isLeadershipRelation(String leaderId, String subordinateId) {
        if (this.getSubordinate(leaderId).contains(subordinateId)) {
            return true;
        }
        return false;
    }

    public Set<String> getLeaderInfo(String userId) {
        Set<String> leadeInfo = this.mallUserMapper.findLeaderByUserId(userId);
        HashSet<String> rtn = new HashSet<String>();
        rtn.addAll(leadeInfo);
        if (leadeInfo != null && leadeInfo.size() > 0 && !leadeInfo.contains(userId)) {
            for (String s : leadeInfo) {
                rtn.addAll(this.getLeaderInfo(s));
            }
        }
        return rtn;
    }

    @Override
    @ReadThroughSingleCache(namespace="isLeadershipRelationNew", expiration=300)
    public Boolean isLeadershipRelationNew(@ParameterValueKeyProvider(order=0) String leaderId, @ParameterValueKeyProvider(order=1) String subordinateId) {
        Set<String> leadeInfo = this.mallUserMapper.findLeaderByUserId(subordinateId);
        if (leadeInfo.contains(leaderId)) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isLeadership(String leaderId, String subordinateId) {
        String key = "isLeadership_" + leaderId + "_" + subordinateId;
        Object o = this.redisCacheUtil.get(key);
        if (o != null) {
            return (Boolean)o;
        }
        MallUserEntity param = new MallUserEntity();
        param.setLeader(leaderId);
        param.setUserId(subordinateId);
        List list = this.mallUserMapper.getList(param);
        if (list == null || list.size() == 0) {
            this.redisCacheUtil.set(key, (Object)false, Long.valueOf(300L));
            return false;
        }
        this.redisCacheUtil.set(key, (Object)true, Long.valueOf(300L));
        return true;
    }

    @Override
    @ReadThroughSingleCache(namespace="getSysUserList4RoleId", expiration=300)
    public List<MallUserEntity> getSysUserList4RoleId(@ParameterValueKeyProvider(order=0) Integer roleId) {
        return this.mallUserMapper.getSysUserList4RoleId(roleId);
    }

    @Override
    public List<MallUserEntityVo> getMallUserInfoByParam(String userName, String userNick, String dingdingId, Integer platformGroupId) {
        return this.mallUserMapper.getMallUserInfoByParam(userName, userNick, dingdingId, null, platformGroupId);
    }

    @Override
    public List<MallUserEntityVo> getMallUserInfoByParam(String userName, String userNick, String dingdingId, String mobile, Integer platformGroupId) {
        return this.mallUserMapper.getMallUserInfoByParam(userName, userNick, dingdingId, mobile, platformGroupId);
    }

    @Override
    public int updateUserDingDingIdById(String userId, String dingdingId) {
        return this.mallUserMapper.updateUserDingDingIdById(userId, dingdingId);
    }

    @Override
    public List<MallUserEntity> getSysUserListByStatus() {
        return this.mallUserMapper.getSysUserListByStatus();
    }

    @Override
    public List<Map<String, Object>> getDeparts() {
        return this.mallUserMapper.getDeparts();
    }

    @Override
    public List<MallUserEntity> getEqualDeptUser(String userId) {
        MallUserEntity user = this.getMallUser(userId);
        if (user != null && user.getDeptId() != null) {
            MallUserEntity param = new MallUserEntity();
            param.setDeptId(user.getDeptId());
            return this.mallUserMapper.getList(param);
        }
        return new ArrayList<MallUserEntity>();
    }

    @Override
    public List<MallUserEntity> getUserList(MallUserEntity userEntity) {
        if (userEntity == null) {
            return new ArrayList<MallUserEntity>();
        }
        return this.mallUserMapper.getList(userEntity);
    }

    @Override
    public List<MallUserEntity> getLeaderUserList() {
        Object[] map;
        List<MallUserEntity> userEntities = this.getUserList(new MallUserEntity());
        userEntities = userEntities.stream().filter(c -> StringUtils.isNotEmpty((String)c.getLeader())).collect(Collectors.toList());
        ArrayList<MallUserEntity> leaderEntities = new ArrayList<MallUserEntity>();
        for (Object u : map = userEntities.stream().map(c -> c.getLeader()).distinct().toArray()) {
            MallUserEntity leader = this.getMallUser(u.toString());
            if (leader == null) continue;
            leaderEntities.add(leader);
        }
        return leaderEntities;
    }

    @Override
    public int updateUserLevelById(String userId, String level) {
        MallUserEntity up = new MallUserEntity();
        up.setUserId(userId);
        up.setLevel(level);
        this.mallUserMapper.updateBaseService(up);
        return this.mallUserMapper.updateUserLevelById(userId, level);
    }

    @Override
    public MallUserEntity getSysUserNameByUserId(String user_name) {
        return this.mallUserMapper.getSysUserNameByUserId(user_name);
    }

    @Override
    public BaseJsonVo updateUserDingdingId() {
        List<OapiUserListbypageResponse.Userlist> lst = this.dingdingUtils.getAllUsers();
        List<MallUserEntity> userList = this.mallUserMapper.getNoneDingdingIdUserList();
        for (MallUserEntity u : userList) {
            List tmpList = lst.stream().filter(c -> StringUtils.equals((String)c.getName(), (String)u.getUserNick())).collect(Collectors.toList());
            if (tmpList.size() == 1) {
                u.setDingdingId(((OapiUserListbypageResponse.Userlist)tmpList.get(0)).getUserid());
                if (StringUtils.isEmpty((String)u.getMobile())) {
                    u.setMobile(((OapiUserListbypageResponse.Userlist)tmpList.get(0)).getMobile());
                }
            } else if (tmpList.size() > 1) {
                if ((tmpList = tmpList.stream().filter(c -> StringUtils.equals((String)c.getMobile(), (String)u.getMobile())).collect(Collectors.toList())).size() == 1) {
                    u.setDingdingId(((OapiUserListbypageResponse.Userlist)tmpList.get(0)).getUserid());
                    if (StringUtils.isEmpty((String)u.getMobile())) {
                        u.setMobile(((OapiUserListbypageResponse.Userlist)tmpList.get(0)).getMobile());
                    }
                } else {
                    tmpList = lst.stream().filter(c -> StringUtils.equals((String)c.getName(), (String)u.getUserNick())).collect(Collectors.toList());
                    for (OapiUserListbypageResponse.Userlist dingdingUser : tmpList) {
                        List<MallUserEntityVo> userEntityVos = this.sysUserInterface.getMallUserInfoByParam(null, null, dingdingUser.getUserid(), 1000);
                        if (userEntityVos.size() != 0) continue;
                        u.setDingdingId(dingdingUser.getUserid());
                        if (!StringUtils.isEmpty((String)u.getMobile())) continue;
                        u.setMobile(dingdingUser.getMobile());
                    }
                }
            }
            if (!StringUtils.isNotEmpty((String)u.getDingdingId())) continue;
            this.mallUserMapper.updateByPrimaryKey(u);
            this.mallUserMapper.updateBaseService(u);
        }
        return BaseJsonVo.success((Object)"\u6267\u884c\u5b8c\u6210");
    }

    @Override
    public boolean valideRole(String userId, String roleName) {
        PageForm pageForm = new PageForm();
        pageForm.setCurrentPage(1);
        pageForm.setPageSize(1000);
        List<Object> lst = new ArrayList();
        BaseJsonVo jsonVo = this.baseServiceInvoke.getMallUserRoleList(pageForm, userId);
        System.out.println("role\u8fd4\u56de\uff1a" + JsonUtils.toJson((Object)jsonVo, (boolean)true));
        if (jsonVo.isSuccess()) {
            LinkedHashMap pageInfo = (LinkedHashMap)jsonVo.getValue();
            lst = (List)pageInfo.get("list");
            lst = lst.stream().filter(c -> c.get("roleName").equals(roleName)).collect(Collectors.toList());
        }
        System.out.println("role\u8fd4\u56de\uff1a" + JsonUtils.toJson((Object)jsonVo, (boolean)true));
        System.out.println("role\u8fd4\u56deList\uff1a" + JsonUtils.toJson(lst, (boolean)true));
        return lst.size() != 0;
    }

    @Override
    public List<String> getRoleDataRight(String userId, @Nullable String pageRouterUrl, @Nullable Integer dataType) {
        HttpServletRequest request;
        if (StringUtils.isEmpty((String)userId)) {
            return new ArrayList<String>();
        }
        if (StringUtils.isEmpty((String)pageRouterUrl) && (request = RequestDetail.getCurrentRequest()) != null) {
            pageRouterUrl = request.getParameter("pageRouterUrl");
        }
        if (StringUtils.isEmpty((String)pageRouterUrl) && dataType == null) {
            return new ArrayList<String>();
        }
        return this.mallUserRoleMapper.getRoleDataRight(userId, pageRouterUrl, dataType);
    }

    @ReadThroughSingleCache(namespace="getAllUserOptionList", expiration=300)
    public BaseJsonVo<List<Pair<String, String>>> getAllUserOptionList(@ParameterValueKeyProvider(order=0) Integer financialDeptId) {
        Page page = PageHelper.startPage((int)1, (int)5000);
        this.mallUserMapper.getMallUserList(null, null, -2, 1000, Objects.equals(financialDeptId, null) || Objects.equals(financialDeptId, 0) ? null : financialDeptId);
        List list = page.toPageInfo().getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List result = list.stream().map(u -> Pair.of((Object)u.getUserId(), (Object)u.getUserNick())).collect(Collectors.toList());
            return BaseJsonVo.success(result);
        }
        return BaseJsonVo.success((Object)CollectionUtils.EMPTY_COLLECTION);
    }
}

