/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.vip;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.user.MallUserMapper;
import cc.lechun.mall.dao.vip.MallVipConditionMapper;
import cc.lechun.mall.dao.vip.MallVipDiscountRangeMapper;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.entity.vip.MallVipConditionEntity;
import cc.lechun.mall.entity.vip.MallVipDiscountRangeEntity;
import cc.lechun.mall.entity.vip.MallVipDiscountRangeVo;
import cc.lechun.mall.iservice.vip.MallVipDiscountRangeInterface;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallVipDiscountRangeService
extends BaseService<MallVipDiscountRangeEntity, Integer>
implements MallVipDiscountRangeInterface {
    @Resource
    private MallVipDiscountRangeMapper mallVipDiscountRangeMapper;
    @Resource
    private MallVipConditionMapper vipConditionMapper;
    @Resource
    private MallUserMapper mallUserMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveVipDiscountRangeEntity(MallVipDiscountRangeEntity vipDiscountRangeEntity) {
        MallVipDiscountRangeEntity query = new MallVipDiscountRangeEntity();
        query.setLevel(vipDiscountRangeEntity.getLevel());
        List list = this.mallVipDiscountRangeMapper.getList(query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List<Integer> idList = list.stream().map(r -> r.getId()).collect(Collectors.toList());
            this.mallVipDiscountRangeMapper.batchDelete(idList.toArray(new Integer[idList.size()]));
        }
        vipDiscountRangeEntity.setCreateTime(new Date());
        this.mallVipDiscountRangeMapper.insert(vipDiscountRangeEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<MallVipDiscountRangeVo> getVipDiscountRangeList(MallVipDiscountRangeEntity vipDiscountRangeEntity) {
        List list = this.mallVipDiscountRangeMapper.getList(vipDiscountRangeEntity);
        List<MallVipDiscountRangeVo> result = list.stream().map(item -> {
            MallVipDiscountRangeVo vipDiscountRangeVo = new MallVipDiscountRangeVo();
            BeanUtils.copyProperties((Object)item, (Object)vipDiscountRangeVo);
            MallVipConditionEntity query = new MallVipConditionEntity();
            query.setLevel(item.getLevel());
            MallVipConditionEntity vipConditionEntity = (MallVipConditionEntity)this.vipConditionMapper.getSingle(query);
            vipDiscountRangeVo.setLevelName(vipConditionEntity.getLevelName());
            vipDiscountRangeVo.setLevelType(vipConditionEntity.getLevelType());
            for (String source : item.getOrderSource().split(",")) {
                vipDiscountRangeVo.setOrderSourceName(OrderSourceEnum.getName(Integer.valueOf(source)) + "," + (StringUtils.isNotEmpty((String)vipDiscountRangeVo.getOrderSourceName()) ? vipDiscountRangeVo.getOrderSourceName() : ""));
            }
            MallUserEntity mallUserEntity = (MallUserEntity)this.mallUserMapper.selectByPrimaryKey((Serializable)((Object)item.getCreateUser()));
            vipDiscountRangeVo.setCreateUserName(mallUserEntity.getUserNick());
            return vipDiscountRangeVo;
        }).collect(Collectors.toList());
        return result;
    }
}

