/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.vip;

import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.common.enums.customer.VipRightTypeEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.vip.MallVipConditionMapper;
import cc.lechun.mall.dao.vip.MallVipLogMapper;
import cc.lechun.mall.dao.vip.MallVipMapper;
import cc.lechun.mall.dao.vip.MallVipRewardsMapper;
import cc.lechun.mall.dao.vip.MallVipRewardsRelationMapper;
import cc.lechun.mall.dao.vip.MallVipRightsMapper;
import cc.lechun.mall.dao.vip.MallVipTasksMapper;
import cc.lechun.mall.dao.vip.MallVipTasksRelationMapper;
import cc.lechun.mall.dao.vip.MallVipTasksRewardsMapper;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.vip.MallVipConditionEntity;
import cc.lechun.mall.entity.vip.MallVipEntity;
import cc.lechun.mall.entity.vip.MallVipLogEntity;
import cc.lechun.mall.entity.vip.MallVipRewardsEntity;
import cc.lechun.mall.entity.vip.MallVipRewardsRelationEntity;
import cc.lechun.mall.entity.vip.MallVipRightsEntity;
import cc.lechun.mall.entity.vip.MallVipRightsVo;
import cc.lechun.mall.entity.vip.MallVipTasksEntity;
import cc.lechun.mall.entity.vip.MallVipTasksRelationEntity;
import cc.lechun.mall.entity.vip.MallVipTasksRewardsEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.service.thirdparty.OldWealthUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallVipService
extends BaseService
implements MallVipInterface {
    @Autowired
    private MallVipMapper vipMapper;
    @Autowired
    private MallVipConditionMapper vipConditionMapper;
    @Autowired
    MallVipTasksMapper tasksMapper;
    @Autowired
    MallVipTasksRelationMapper vipTaskRelationMapper;
    @Autowired
    MallVipTasksRewardsMapper vipTasksRewardsMapper;
    @Autowired
    MallVipRewardsMapper vipRewardsMapper;
    @Autowired
    MallVipRewardsRelationMapper vipRewardsRelationMapper;
    @Autowired
    MallVipRightsMapper vipRightsMapper;
    @Autowired
    MallVipLogMapper vipLogMapper;
    @Autowired
    @Lazy
    private CustomerInterface customerService;
    @Lazy
    @Autowired
    private MallOrderMainInterface orderMainService;
    @Lazy
    @Autowired
    private MallOrderInterface orderService;
    @Autowired
    private OldWealthUtil oldWealthUtil;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    @Lazy
    private ActiveCashticketInterface activeCashticketService;
    @Autowired
    private DictionaryInterface dicService;
    @Autowired
    private ActiveQrcodeInterface qrcodeService;
    @Lazy
    @Autowired
    private MallVipInterface vipInterface;
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;

    @Override
    @ReadThroughSingleCache(namespace="VIP")
    public List<MallVipConditionEntity> conditionList(@ParameterValueKeyProvider Integer platformGroupId) {
        MallVipConditionEntity searchParam = new MallVipConditionEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        return this.vipConditionMapper.getList(searchParam);
    }

    @Override
    public PageInfo conditionList(Integer platformGroupId, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        PageInfo pg = page.toPageInfo();
        pg.setList(this.conditionList(platformGroupId));
        return pg;
    }

    @Override
    public BaseJsonVo saveVipCondition(MallVipConditionEntity vipCondition) {
        List conditions;
        if (vipCondition.getLevelType() == 2) {
            MallVipConditionEntity param1 = new MallVipConditionEntity();
            param1.setBindCode(vipCondition.getBindCode());
            conditions = this.vipConditionMapper.getList(param1);
            if (conditions.size() > 0) {
                if (StringUtil.isNotEmpty((String)vipCondition.getId())) {
                    conditions = conditions.stream().filter(c -> !c.getId().equals(vipCondition.getId())).collect(Collectors.toList());
                }
                if (conditions != null && conditions.size() > 0) {
                    BaseJsonVo sr = new BaseJsonVo();
                    sr.setError("\u5b58\u5728\u7684\u7ed1\u5b9a\u7801");
                    return sr;
                }
            }
        }
        if (StringUtil.isEmpty((String)vipCondition.getId())) {
            MallVipConditionEntity param = new MallVipConditionEntity();
            param.setLevel(vipCondition.getLevel());
            conditions = this.vipConditionMapper.getList(param);
            if (conditions != null && conditions.size() > 0) {
                BaseJsonVo sr = new BaseJsonVo();
                sr.setError("\u5b58\u5728\u7684\u7b49\u7ea7");
                return sr;
            }
            vipCondition.setId(IDGenerate.getUniqueIdStr());
            this.vipConditionMapper.insert(vipCondition);
        } else {
            this.vipConditionMapper.updateByPrimaryKey(vipCondition);
        }
        return new BaseJsonVo();
    }

    @Override
    public List<MallVipRewardsEntity> rewardsList(Integer platformGroupId) {
        MallVipRewardsEntity param = new MallVipRewardsEntity();
        param.setPlatformGroupId(platformGroupId);
        List list = this.vipRewardsMapper.getList(param);
        return list;
    }

    @Override
    public PageInfo rewardsList(Integer platformGroupId, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        PageInfo pg = page.toPageInfo();
        List<MallVipRewardsEntity> list = this.rewardsList(platformGroupId);
        ArrayList listData = new ArrayList();
        list.forEach(reward -> {
            ActiveQrcodeEntity qrcode;
            Map map = ObjectConvert.beanToMap((Object)reward);
            map.put("rewardDataName", reward.getRewardData());
            if ("1".equals(reward.getRewardType()) && (qrcode = this.qrcodeService.getQrcode(reward.getRewardData())) != null) {
                map.put("rewardDataName", qrcode.getQrcodeName());
            }
            listData.add(map);
        });
        pg.setList(listData);
        return pg;
    }

    @Override
    public BaseJsonVo saveVipRewards(MallVipRewardsEntity vipRewards) {
        if (StringUtil.isEmpty((String)vipRewards.getId())) {
            vipRewards.setId(IDGenerate.getUniqueIdStr());
            this.vipRewardsMapper.insert(vipRewards);
        } else {
            this.vipRewardsMapper.updateByPrimaryKeySelective(vipRewards);
        }
        return new BaseJsonVo();
    }

    @Override
    public void deleteVipRewards(String id) {
        this.vipRewardsMapper.deleteByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public List<MallVipRightsVo> rightsList(Integer platformGroupId) {
        return this.vipRightsMapper.getVipRights(platformGroupId);
    }

    @Override
    public List<MallVipRightsVo> getVipListByStatus(Integer platformGroupId) {
        List<MallVipRightsVo> rights = this.vipRightsMapper.getVipRights(platformGroupId);
        rights = rights.stream().filter(vipRightVo -> "1".equals(vipRightVo.getStatus())).collect(Collectors.toList());
        return rights;
    }

    @Override
    public PageInfo rightsList(Integer platformGroupId, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        this.rightsList(platformGroupId);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public MallVipRightsEntity getRight(String rightId) {
        return this.vipRightsMapper.getRight(rightId);
    }

    @Override
    public BaseJsonVo saveVipRights(MallVipRightsEntity vipRights) {
        if (StringUtil.isEmpty((String)vipRights.getId())) {
            MallVipConditionEntity mallVipConditionEntity = new MallVipConditionEntity();
            List vipConditionEntities = this.vipConditionMapper.getList(mallVipConditionEntity);
            if (vipConditionEntities != null && vipConditionEntities.size() > 0) {
                ArrayList mallVipRightsEntityList = new ArrayList();
                vipRights.setRightId(RandomUtils.generateStrId());
                vipRights.setHasRight("0");
                for (MallVipConditionEntity vipConditionEntity : vipConditionEntities) {
                    vipRights.setId(IDGenerate.getUniqueIdStr());
                    vipRights.setLevel(vipConditionEntity.getLevel());
                    this.vipRightsMapper.insert(vipRights);
                }
            }
        } else {
            this.vipRightsMapper.updateByRightId(vipRights);
        }
        return new BaseJsonVo();
    }

    @Override
    public BaseJsonVo updateByIdLevel(MallVipRightsEntity vipRights) {
        this.vipRightsMapper.updateByIdLevel(vipRights);
        return new BaseJsonVo();
    }

    @Override
    public void deleteVipRights(String rightId) {
        this.vipRightsMapper.deleteByRightId(rightId);
    }

    @Override
    public BaseJsonVo rightsChangeStatus(String id, String hasRight) {
        hasRight = "0".equals(hasRight) ? "1" : "0";
        this.vipRightsMapper.rightsChangeStatus(id, hasRight);
        return new BaseJsonVo();
    }

    @Override
    public List<MallVipTasksEntity> tasksList(Integer platformGroupId) {
        MallVipTasksEntity param = new MallVipTasksEntity();
        param.setPlatformGroupId(platformGroupId);
        List list = this.tasksMapper.getList(param);
        return list;
    }

    @Override
    public PageInfo tasksList(Integer platformGroupId, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        PageInfo pg = page.toPageInfo();
        pg.setList(this.tasksList(platformGroupId));
        return pg;
    }

    @Override
    public BaseJsonVo saveVipTasks(MallVipTasksEntity vipTasks) {
        if (StringUtil.isEmpty((String)vipTasks.getId())) {
            vipTasks.setId(IDGenerate.getUniqueIdStr());
            this.tasksMapper.insert(vipTasks);
        } else {
            this.tasksMapper.updateByPrimaryKeySelective(vipTasks);
        }
        return new BaseJsonVo();
    }

    @Override
    public void deleteVipTasks(String id) {
        this.tasksMapper.deleteByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public List<MallVipTasksRewardsEntity> tasksRewardsList(Integer platformGroupId) {
        MallVipTasksRewardsEntity param = new MallVipTasksRewardsEntity();
        param.setPlatformGroupId(platformGroupId);
        List list = this.vipTasksRewardsMapper.getList(param);
        return list;
    }

    @Override
    public PageInfo tasksRewardsList(Integer platformGroupId, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        PageInfo pg = page.toPageInfo();
        List<MallVipTasksRewardsEntity> list = this.tasksRewardsList(platformGroupId);
        ArrayList listData = new ArrayList();
        list.forEach(reward -> {
            ActiveQrcodeEntity qrcode;
            Map map = ObjectConvert.beanToMap((Object)reward);
            map.put("rewardDataName", reward.getRewardData());
            if ("1".equals(reward.getRewardType()) && (qrcode = this.qrcodeService.getQrcode(reward.getRewardData())) != null && qrcode.getActiveQrcodeId() != null && StringUtils.isNotEmpty((String)qrcode.getQrcodeName())) {
                map.put("rewardDataName", qrcode.getQrcodeName());
            }
            listData.add(map);
        });
        pg.setList(listData);
        return pg;
    }

    @Override
    public BaseJsonVo saveVipTasksRewards(MallVipTasksRewardsEntity vipTasksRewards) {
        MallVipTasksEntity entity = (MallVipTasksEntity)this.tasksMapper.selectByPrimaryKey((Serializable)((Object)vipTasksRewards.getTaskId()));
        vipTasksRewards.setTaskName(entity.getTaskName());
        vipTasksRewards.setTaskType(entity.getTaskType());
        if (StringUtil.isEmpty((String)vipTasksRewards.getId())) {
            vipTasksRewards.setId(IDGenerate.getUniqueIdStr());
            this.vipTasksRewardsMapper.insert(vipTasksRewards);
        } else {
            this.vipTasksRewardsMapper.updateByPrimaryKeySelective(vipTasksRewards);
        }
        return new BaseJsonVo();
    }

    @Override
    public void deleteVipTasksRewards(String id) {
        this.vipTasksRewardsMapper.deleteByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public BaseJsonVo customerLevelUp(String customerId, String orderMainNo) {
        BaseJsonVo sr = this.checkCustomerCanLevelUp(customerId, orderMainNo);
        if (sr.isSuccess()) {
            Map checkResult = (Map)sr.getValue();
            Integer platformGroupId = this.customerService.getCustomer(customerId).getPlatformGroupId();
            Integer orderCount = this.orderService.getUserOrderCount(customerId);
            MallVipEntity vipInfo = this.vipInterface.getUserVipInfo(customerId);
            Integer sourceLevel = vipInfo.getLevel();
            MallVipConditionEntity condition = this.vipConditionMapper.getTargetLevel(orderCount);
            Integer targetLevel = condition.getLevel();
            if (targetLevel > sourceLevel) {
                if (sourceLevel == 0) {
                    vipInfo.setId(String.valueOf(IDGenerate.getUniqueID()));
                    vipInfo.setLevel(targetLevel);
                    vipInfo.setIsReward(0);
                    this.vipMapper.insert(vipInfo);
                } else {
                    vipInfo.setLevel(targetLevel);
                    this.vipMapper.updateByPrimaryKeySelective(vipInfo);
                }
                this.vipInterface.deleteUserVipInfoCache(customerId);
                this.customerVipTaskRelation(customerId);
                this.customerVipRewardRelation(customerId);
                this.vipInterface.deleteUserVipInfoCache(customerId);
                Calendar rightNow = Calendar.getInstance();
                int hour = rightNow.get(11);
                if (hour < 22 && hour > 7) {
                    this.sendTemplateVipLevelUpNoticeMessage(customerId);
                }
            } else {
                MallVipLogEntity log = new MallVipLogEntity();
                log.setId(String.valueOf(IDGenerate.getUniqueID()));
                log.setCustomerId(customerId);
                log.setPlatformGroupId(platformGroupId);
                log.setFromLevel(sourceLevel);
                log.setToLevel(sourceLevel);
                log.setOrderMainNo(orderMainNo);
                log.setOrderNo(checkResult.get("orderNo").toString());
                log.setOrderNum(orderCount);
                log.setRemark("");
                log.setLevelup((short)0);
                this.vipLogMapper.insert(log);
            }
        } else {
            return sr;
        }
        return null;
    }

    @Override
    public BaseJsonVo checkCustomerCanLevelUp(String customerId, String orderMainNo) {
        BaseJsonVo result = new BaseJsonVo();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("canLevelUp", false);
        returnMap.put("customerId", customerId);
        returnMap.put("orderMainNo", orderMainNo);
        returnMap.put("orderNo", "");
        MallOrderMainEntity mainOrder = this.orderMainService.selectByPrimaryKey(orderMainNo);
        if (mainOrder.getDeliverCount() == 1 && OrderStatusEnum.COMPLETION.getValue() == mainOrder.getStatus().intValue()) {
            List<MallOrderEntity> orderList = this.orderService.findOrders(orderMainNo);
            if (orderList != null && orderList.size() > 0) {
                returnMap.put("canLevelUp", true);
                returnMap.put("orderNo", orderList.get(0).getOrderNo());
                result.setValue(returnMap);
                return result;
            }
            result.setValue(returnMap);
            result.setError("\u67e5\u8be2\u4e0d\u5230\u5b50\u8ba2\u5355");
            return result;
        }
        if (mainOrder.getDeliverCount() > 1) {
            List<MallOrderEntity> orderList = this.orderService.findOrders(orderMainNo);
            for (MallOrderEntity order : orderList) {
                if (OrderStatusEnum.COMPLETION.getValue() != order.getStatus().intValue()) continue;
                returnMap.put("orderNo", orderList.get(0).getOrderNo());
            }
            returnMap.put("canLevelUp", true);
            result.setValue(returnMap);
            return result;
        }
        result.setError("\u8ba2\u5355\u95ee\u9898\u65e0\u6cd5\u5347\u7ea7");
        return result;
    }

    @Override
    public MallVipEntity getUserVipInfo(String customerId) {
        MallVipEntity searchParam = new MallVipEntity();
        if (customerId.isEmpty()) {
            searchParam.setPlatformGroupId(0);
            searchParam.setLevel(0);
            return searchParam;
        }
        return this.vipInterface.getUserVipInfoBycustomerId(customerId);
    }

    @Override
    @ReadThroughSingleCache(namespace="VIP", expiration=300)
    public MallVipEntity getUserVipInfoBycustomerId(@ParameterValueKeyProvider String customerId) {
        MallVipEntity searchParam = new MallVipEntity();
        searchParam.setCustomerId(customerId);
        MallVipEntity entity = (MallVipEntity)this.vipMapper.getSingle(searchParam);
        if (entity == null || entity.getLevel() == null) {
            searchParam.setPlatformGroupId(this.customerService.getCustomer(customerId).getPlatformGroupId());
            searchParam.setLevel(0);
            return searchParam;
        }
        return entity;
    }

    @Override
    public void deleteUserVipInfoCache(String customerId) {
        this.memcachedService.delete("VIP", customerId);
        this.memcachedService.delete("VIP_CENTER_INFO", customerId);
    }

    @Override
    @Transactional
    public void customerVipTaskRelation(String customerId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        Integer curLevel = vip.getLevel();
        List<MallVipConditionEntity> conditions = this.conditionList(customer.getPlatformGroupId());
        conditions.forEach(condition -> {
            List<MallVipTasksRelationEntity> checkTaskRelations;
            if (curLevel >= condition.getLevel() && ((checkTaskRelations = this.vipTaskRelationMapper.findThisLevelTasksRelation(customerId, condition.getLevel())) == null || checkTaskRelations.size() == 0)) {
                List<MallVipTasksEntity> tasks = this.tasksMapper.findTasksByLevel(condition.getLevel());
                List<MallVipTasksRelationEntity> taskRelations = this.vipTaskRelationMapper.findCustomerTasksRelation(customerId);
                tasks.forEach(task -> {
                    if (!("3164445118971216140".equals(task.getId()) && this.isFinishedTask5yuan(customerId).booleanValue() || "3164420955670229136".equals(task.getId()) && this.isFinishedTask12ask(customerId).booleanValue() || taskRelations.stream().anyMatch(taskRelation -> taskRelation.getTaskId().equals(task.getId())))) {
                        MallVipTasksRelationEntity entity = new MallVipTasksRelationEntity();
                        entity.setId(IDGenerate.getUniqueIdStr());
                        entity.setCustomerId(customerId);
                        entity.setTaskId(task.getId());
                        entity.setTaskType(task.getTaskType());
                        entity.setTaskName(task.getTaskName());
                        entity.setPlatformGroupId(this.customerService.getCustomer(customerId).getPlatformGroupId());
                        entity.setIsFinished("0");
                        entity.setRecommendTimes(0);
                        this.vipTaskRelationMapper.insert(entity);
                    }
                });
            }
        });
    }

    @Override
    @Transactional
    public void customerVipRewardRelation(String customerId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        Integer curLevel = vip.getLevel();
        List<MallVipConditionEntity> conditions = this.conditionList(customer.getPlatformGroupId());
        conditions.forEach(condition -> {
            List<MallVipRewardsRelationEntity> checkRewardsRelations;
            if (curLevel >= condition.getLevel() && ((checkRewardsRelations = this.vipRewardsRelationMapper.findThisLevelRewardsRelation(customerId, condition.getLevel())) == null || checkRewardsRelations.size() == 0)) {
                List<MallVipRewardsEntity> rewards = this.vipRewardsMapper.findRewardsByLevel(condition.getLevel());
                List<MallVipRewardsRelationEntity> rewardsRelations = this.vipRewardsRelationMapper.findCustomerRewardsRelation(customerId);
                ArrayList sqls = new ArrayList();
                rewards.forEach(reward -> {
                    if (!rewardsRelations.stream().anyMatch(rewardRelation -> rewardRelation.getRewardId().equals(reward.getId()))) {
                        MallVipRewardsRelationEntity entity = new MallVipRewardsRelationEntity();
                        entity.setId(IDGenerate.getUniqueIdStr());
                        entity.setCustomerId(customerId);
                        entity.setRewardId(reward.getId());
                        entity.setRewardName(reward.getRewardName());
                        entity.setRewardType(reward.getRewardType());
                        entity.setPlatformGroupId(this.customerService.getCustomer(customerId).getPlatformGroupId());
                        entity.setHasReceived("0");
                        this.vipRewardsRelationMapper.insert(entity);
                    }
                });
            }
        });
    }

    @Override
    public BaseJsonVo customerVipReward(String customerId, String relationId, Integer platformId) {
        BaseJsonVo result = new BaseJsonVo();
        if (StringUtils.isEmpty((String)customerId) || StringUtils.isEmpty((String)relationId)) {
            result.setError("\u7f3a\u5c11\u53c2\u6570");
            return result;
        }
        MallVipRewardsRelationEntity rewardsRelation = (MallVipRewardsRelationEntity)this.vipRewardsRelationMapper.selectByPrimaryKey((Serializable)((Object)relationId));
        if (rewardsRelation == null) {
            result.setError("\u7528\u6237\u6ca1\u6709\u8be5\u5956\u52b1");
            return result;
        }
        if ("1".equals(rewardsRelation.getHasReceived())) {
            result.setError("\u5df2\u9886\u53d6\u8be5\u5956\u52b1");
            return result;
        }
        MallVipRewardsEntity rewards = (MallVipRewardsEntity)this.vipRewardsMapper.selectByPrimaryKey((Serializable)((Object)rewardsRelation.getRewardId()));
        if (rewards == null) {
            result.setError("\u7cfb\u7edf\u65e0\u8be5\u5956\u52b1");
            return result;
        }
        Boolean hasReceived = false;
        if ("1".equals(rewards.getRewardType())) {
            this.activeCashticketService.sendTicket4BaseAsynchronous(customerId, rewards.getRewardData(), "", platformId, true);
            hasReceived = true;
        } else if ("2".equals(rewards.getRewardType())) {
            for (int i = 0; i < 5; ++i) {
                try {
                    Boolean rtnMap = this.oldWealthUtil.increaseWealth(customerId, Integer.valueOf(rewards.getRewardData()), "\u4f1a\u5458\u5347\u7ea7", "\u4f1a\u5458\u5347\u81f3" + rewards.getLevel() + "\u7ea7");
                    if (!rtnMap.booleanValue()) continue;
                    i = 5;
                    hasReceived = true;
                    continue;
                }
                catch (IOException e) {
                    this.logger.error("", (Throwable)e);
                }
            }
        }
        if (!hasReceived.booleanValue()) {
            result.setError("\u53d1\u9001\u5956\u52b1\u5931\u8d25");
            return result;
        }
        rewardsRelation.setHasReceived("1");
        this.vipRewardsRelationMapper.updateByPrimaryKeySelective(rewardsRelation);
        this.vipInterface.deleteUserVipInfoCache(customerId);
        return result;
    }

    @Override
    @ReadThroughSingleCache(namespace="VIP_CENTER_INFO", expiration=300)
    public Map<String, Object> centerInfo(@ParameterValueKeyProvider String customerId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        List<MallVipConditionEntity> conditionList = this.conditionList(customer.getPlatformGroupId());
        ArrayList conditions = new ArrayList();
        for (MallVipConditionEntity condition : conditionList) {
            HashMap<String, Object> _condition = new HashMap<String, Object>();
            _condition.put("ID", condition.getId());
            _condition.put("LEVEL", condition.getLevel());
            _condition.put("ORDER_NUM", condition.getOrderNum());
            _condition.put("LEVEL_IMG_URL", this.picService.getProductPicUrl(condition.getId() == null ? "" : condition.getId(), ProductPicTypeEnum.VIP_CONDITION_POP.getValue()).get(0));
            conditions.add(_condition);
        }
        rtnMap.put("CONDITIONS", conditions);
        Integer orderCount = this.orderService.getUserOrderCount(customerId);
        Integer curLevel = (int)this.vipInterface.getUserVipInfo(customerId).getLevel();
        rtnMap.put("ORDER_COUNT", orderCount);
        rtnMap.put("CURRENT_LEVEL", curLevel);
        List<Map<String, Object>> userRewards = this.vipRewardsRelationMapper.findUserRewards(customerId);
        List<Map<String, Object>> vipRewards = this.vipRewardsMapper.findVipHasnotRewards(curLevel);
        userRewards.addAll(vipRewards);
        List<Map<String, Object>> vipRightsHas = this.vipRightsMapper.findVipHasRights(curLevel);
        List<Map<String, Object>> vipRightsHasNot = this.vipRightsMapper.findVipHasNotRights(curLevel);
        vipRightsHasNot.addAll(vipRightsHas);
        ArrayList levelSet = new ArrayList();
        for (MallVipConditionEntity condition : conditionList) {
            HashMap<String, Object> levelRtnRecord = new HashMap<String, Object>();
            levelRtnRecord.put("ORDER_COUNT_DIFF", condition.getOrderNum() - orderCount < 0 ? 0 : condition.getOrderNum() - orderCount);
            levelRtnRecord.put("LEVEL", condition.getLevel());
            if (condition.getLevel() <= curLevel) {
                Map<String, Object> thisLevelTime = this.vipLogMapper.findCustomerLevelUpTime(customerId, condition.getLevel());
                if (thisLevelTime != null && thisLevelTime.size() > 0) {
                    levelRtnRecord.put("THIS_LEVEL_TIME", thisLevelTime.get("CREATE_TIME"));
                } else {
                    levelRtnRecord.put("THIS_LEVEL_TIME", "");
                }
                levelRtnRecord.put("LIGHT", "ON");
            } else {
                levelRtnRecord.put("THIS_LEVEL_TIME", "");
                levelRtnRecord.put("LIGHT", "OFF");
            }
            ArrayList<Map<String, Object>> rewardsRecordSet = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> reward : userRewards) {
                if (((Integer)reward.get("LEVEL")).intValue() != condition.getLevel().intValue()) continue;
                if ("ON".equals(reward.get("LIGHT"))) {
                    reward.put("REWARD_ICON_URL", this.picService.getProductPicUrl(reward.get("REWARD_ID").toString(), ProductPicTypeEnum.VIP_REWARD_ICON.getValue()).get(0));
                } else {
                    reward.put("REWARD_ICON_URL", this.picService.getProductPicUrl(reward.get("REWARD_ID").toString(), ProductPicTypeEnum.VIP_REWARD_ICON_DARK.getValue()).get(0));
                }
                reward.put("REWARD_IMG_URL", this.picService.getProductPicUrl(reward.get("REWARD_ID").toString(), ProductPicTypeEnum.VIP_REWARD_POP.getValue()).get(0));
                rewardsRecordSet.add(reward);
            }
            levelRtnRecord.put("REWARDS", rewardsRecordSet);
            ArrayList<Map<String, Object>> rightsRecordSet = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> right : vipRightsHasNot) {
                if (((Integer)right.get("LEVEL")).intValue() != condition.getLevel().intValue()) continue;
                if ("ON".equals(right.get("LIGHT"))) {
                    right.put("RIGHT_ICON_URL", this.picService.getProductPicUrl(right.get("ID").toString(), ProductPicTypeEnum.VIP_RIGHT_ICON.getValue()).get(0));
                } else {
                    right.put("RIGHT_ICON_URL", this.picService.getProductPicUrl(right.get("ID").toString(), ProductPicTypeEnum.VIP_RIGHT_ICON_DARK.getValue()).get(0));
                }
                right.put("RIGHT_IMG_URL", this.picService.getProductPicUrl(right.get("ID").toString(), ProductPicTypeEnum.VIP_RIGHT_POP.getValue()).get(0));
                if (right.get("RIGHT_IMG_URL") != null && StringUtils.isNotEmpty((String)String.valueOf(right.get("RIGHT_IMG_URL")))) {
                    right.put("SHOW_POP", 1);
                } else {
                    right.put("SHOW_POP", 0);
                }
                if (Integer.valueOf(String.valueOf(right.get("STATUS"))) == 0) {
                    right.put("HAS_RECEIVED", 3);
                }
                rightsRecordSet.add(right);
            }
            levelRtnRecord.put("RIGHTS", rightsRecordSet);
            levelSet.add(levelRtnRecord);
        }
        rtnMap.put("LEVELS_DATA", levelSet);
        return rtnMap;
    }

    @Override
    public MallVipRightsEntity checkCustomerRight(String customerId, String rightId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        MallVipEntity vip = this.getUserVipInfo(customerId);
        MallVipRightsEntity searchParam = new MallVipRightsEntity();
        searchParam.setPlatformGroupId(customer.getPlatformGroupId());
        searchParam.setStatus("1");
        searchParam.setRightId(rightId);
        searchParam.setHasRight("1");
        searchParam.setLevel(vip.getLevel());
        return (MallVipRightsEntity)this.vipRightsMapper.getSingle(searchParam);
    }

    @Override
    public BaseJsonVo finishTask(String customerId, String taskId) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        MallVipTasksEntity task = (MallVipTasksEntity)this.tasksMapper.selectByPrimaryKey((Serializable)((Object)taskId));
        if (task == null) {
            result.setError("\u4efb\u52a1\u4e0d\u5b58\u5728");
            return result;
        }
        MallVipTasksRelationEntity searchParam = new MallVipTasksRelationEntity();
        searchParam.setCustomerId(customerId);
        searchParam.setTaskId(taskId);
        searchParam.setIsFinished("0");
        MallVipTasksRelationEntity taskRelation = (MallVipTasksRelationEntity)this.vipTaskRelationMapper.getSingle(searchParam);
        if (taskRelation == null) {
            result.setError("\u7528\u6237\u6ca1\u6709\u8be5\u4efb\u52a1\u6216\u8005\u5df2\u5b8c\u6210\u4e86\u8be5\u4efb\u52a1");
            return result;
        }
        Boolean hasReceived = true;
        String rewardSql = "SELECT ID,TASK_ID,TASK_TYPE,TASK_NAME,REWARD_TYPE,REWARD_NAME,REWARD_DATA,STATUS FROM t_mall_customer_vip_tasks_rewards WHERE TASK_ID = '" + taskId + "'";
        MallVipTasksRewardsEntity searchParam2 = new MallVipTasksRewardsEntity();
        searchParam2.setTaskId(taskId);
        List rewards = this.vipTasksRewardsMapper.getList(searchParam2);
        if (rewards != null && rewards.size() > 0) {
            for (MallVipTasksRewardsEntity reward : rewards) {
                BaseJsonVo vo;
                if ("1".equals(reward.getRewardType())) {
                    this.activeCashticketService.sendTicket4BaseAsynchronous(customerId, reward.getRewardData(), "", 1000, false);
                    continue;
                }
                if (!"2".equals(reward.getRewardType()) || (vo = this.accountBalanceInterface.activeCharge(customerId, new BigDecimal(reward.getRewardData()).divide(new BigDecimal(100)), taskRelation.getTaskName(), true, "\u5b8c\u6210" + taskRelation.getTaskName() + "\u8d60\u9001", taskRelation.getTaskId())).isSuccess()) continue;
                hasReceived = false;
            }
        }
        if (hasReceived.booleanValue()) {
            taskRelation.setIsFinished("1");
            taskRelation.setCreateTime(DateUtils.now());
            this.vipTaskRelationMapper.updateByPrimaryKeySelective(taskRelation);
        } else {
            result.setError(customerId + "|" + taskId + "|\u53d1\u9001\u4efb\u52a1\u5956\u54c1\u5931\u8d25");
        }
        this.vipInterface.deleteUserVipInfoCache(customerId);
        return result;
    }

    @Override
    public Boolean isFinishedTask12ask(String customerId) {
        List<Map<String, Object>> list = this.vipTaskRelationMapper.isFinishedTask12ask(customerId);
        if (list == null || list.size() == 0) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean isFinishedTask5yuan(String customerId) {
        Map<String, Object> list = this.vipTaskRelationMapper.isFinishedTask5yuan(customerId);
        Map<String, Object> existWhite = this.vipTaskRelationMapper.existsWhiteList(customerId, 1);
        if (list != null && list.size() != 0 && ("2".equals(list.get("status")) || "3".equals(list.get("status"))) && (existWhite == null || existWhite.size() == 0 || existWhite.get("_exist") == null)) {
            return true;
        }
        return false;
    }

    private Boolean checkFinishTaskBindMobile(String customerId) {
        CustomerEntity customer = this.customerService.getCustomer(customerId);
        if (StringUtils.isNotEmpty((String)customer.getMobile())) {
            return true;
        }
        return false;
    }

    @Override
    public BaseJsonVo finishTaskBindMobile(String customerId) {
        this.finishTask(customerId, "1022869204455526400");
        return new BaseJsonVo();
    }

    @Override
    public BaseJsonVo finishTaskImproveInfo(String customerId) {
        this.finishTask(customerId, "1022869402032410624");
        return new BaseJsonVo();
    }

    @Override
    public BaseJsonVo finishEvaluate(String customerId) {
        this.finishTask(customerId, "3164445155423067970");
        return new BaseJsonVo();
    }

    @Override
    public BaseJsonVo sendTemplateVipLevelUpNoticeMessage(String customerId) {
        return null;
    }

    @Override
    public BaseJsonVo updateVipLevel(String customerId, Integer level) {
        MallVipEntity vip = this.vipInterface.getUserVipInfo(customerId);
        int sourceLevel = vip.getLevel();
        int targetLevel = level;
        this.vipInterface.deleteUserVipInfoCache(customerId);
        BaseJsonVo vo = null;
        if (vip == null) {
            vip.setId(IDGenerate.getUniqueIdStr());
            vip.setIsReward(0);
            vip.setLevel(targetLevel);
            vo = this.vipMapper.insert(vip) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5347\u7ea7\u5931\u8d25");
        } else {
            vip.setLevel(targetLevel);
            vo = this.vipMapper.updateByPrimaryKeySelective(vip) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5347\u7ea7\u5931\u8d25");
        }
        this.saveVipLog(customerId, vip, sourceLevel);
        return vo;
    }

    private void saveVipLog(String customerId, MallVipEntity vip, int sourceLevel) {
        this.customerVipTaskRelation(customerId);
        this.customerVipRewardRelation(customerId);
        MallVipLogEntity log = new MallVipLogEntity();
        log.setId(String.valueOf(IDGenerate.getUniqueID()));
        log.setCustomerId(customerId);
        log.setPlatformGroupId(vip.getPlatformGroupId());
        log.setFromLevel(sourceLevel);
        log.setToLevel(sourceLevel);
        log.setOrderMainNo("");
        log.setOrderNo("");
        log.setOrderNum(0);
        log.setRemark("");
        log.setLevelup((short)1);
        this.vipLogMapper.insert(log);
    }

    public boolean checkVipRightByType(String customerId, String rightType) {
        if (String.valueOf(VipRightTypeEnum.RIGHT_XINPINCHANGXIAN.getValue()).equals(rightType)) {
            return true;
        }
        MallVipEntity vipEntity = this.vipInterface.getUserVipInfo(customerId);
        int level = 0;
        if (vipEntity != null) {
            level = vipEntity.getLevel();
        }
        MallVipRightsEntity rightsEntity = new MallVipRightsEntity();
        rightsEntity.setLevel(level);
        rightsEntity.setStatus("1");
        rightsEntity.setRightType(rightType);
        rightsEntity.setHasRight("1");
        List vipRightsEntities = this.vipRightsMapper.getList(rightsEntity);
        return vipRightsEntities != null && vipRightsEntities.size() != 0;
    }

    @Override
    public Boolean isVipDayNow() {
        Object isVipDayStr = this.memcachedService.get("VIP", "VIP_DAY");
        if (isVipDayStr == null || StringUtils.isEmpty((String)isVipDayStr.toString())) {
            return false;
        }
        Map r = (Map)JSON.parseObject((String)isVipDayStr.toString(), HashMap.class);
        if (r == null || "0".equals(r.get("isEffective").toString())) {
            return false;
        }
        Long now = DateUtils.nowMillis();
        if (now >= Long.valueOf(r.get("endTime").toString()) || now < Long.valueOf(r.get("startTime").toString())) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getMallVipDay() {
        Object isVipDayStr = this.memcachedService.get("VIP", "VIP_DAY");
        if (isVipDayStr == null || StringUtils.isEmpty((String)isVipDayStr.toString())) {
            return null;
        }
        return (Map)JSON.parseObject((String)isVipDayStr.toString(), HashMap.class);
    }

    @Override
    public void setVipDay(Map<String, Object> map) {
        if (map != null) {
            this.memcachedService.set("VIP", "VIP_DAY", (Object)JSON.toJSONString(map));
        }
    }

    @Override
    public List<MallSelectDataVo> getOptionConditionList(Integer platformGroupId) {
        return this.vipConditionMapper.getOptionConditionList(platformGroupId);
    }

    @Override
    public List<MallSelectDataVo> getOptionTaskList(Integer platformGroupId) {
        return this.tasksMapper.getOptionTaskList(platformGroupId);
    }

    @Override
    public List<MallSelectDataVo> getOptionVipQrcodesList(Integer platformGroupId) {
        DictionaryEntity entity = this.dicService.getDictionary(platformGroupId, 53, "0");
        if (entity != null && StringUtils.isNotEmpty((String)entity.getDictionaryName())) {
            return this.vipConditionMapper.getOptionVipQrcodesList(entity.getDictionaryName());
        }
        return null;
    }

    @Override
    public BaseJsonVo getVipCount(Integer platformGroupId) {
        return BaseJsonVo.success((Object)"");
    }
}

