/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.common.vo.jms.MessageResult;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.weixin.MallMessageConfigMapper;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.SubscribeMessageEntity;
import cc.lechun.mall.entity.weixin.MallMessageConfigEntity;
import cc.lechun.mall.entity.weixin.MallMessageConfigVo;
import cc.lechun.mall.entity.weixin.MessageRemainEntity;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.SubscribeMessageInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.weixin.MallMessageConfigInterface;
import cc.lechun.mall.iservice.weixin.MessageRemainInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.utils.PinYinHelper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallMessageConfigService
extends BaseService
implements MallMessageConfigInterface {
    private static final String OPENID_UNSEND_IN_REDIS_KEY = "OPENID_UNSEND_IN_REDIS_KEY";
    private static final String NAMES_UNSEND_IN_REDIS_KEY = "NAMES_UNSEND_IN_REDIS_KEY";
    @Autowired
    private MallMessageConfigMapper messageConfigMapper;
    @Autowired
    private WeiXinKeywordInterface keywordInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private SubscribeMessageInterface subscribeMessageInterface;
    @Autowired
    MessageRemainInterface messageRemainInterface;

    @Override
    public List<MallMessageConfigEntity> getMessageConfigEntityList(Integer platformGroupId, String action) {
        MallMessageConfigEntity messageConfigEntity = new MallMessageConfigEntity();
        messageConfigEntity.setActionId(action);
        messageConfigEntity.setPlatformGroupId(platformGroupId);
        return this.messageConfigMapper.getList(messageConfigEntity);
    }

    @Override
    public List<MallMessageConfigEntity> getMessageConfigEntityList(String action) {
        MallMessageConfigEntity messageConfigEntity = new MallMessageConfigEntity();
        messageConfigEntity.setActionId(action);
        return this.messageConfigMapper.getList(messageConfigEntity);
    }

    @Override
    public BaseJsonVo save(MallMessageConfigEntity messageConfigEntity) {
        boolean b = false;
        MallMessageConfigEntity messageConfigEntitySearch = new MallMessageConfigEntity();
        messageConfigEntitySearch.setPlatformId(messageConfigEntity.getPlatformId());
        messageConfigEntitySearch.setMessageType(messageConfigEntity.getMessageType());
        if (messageConfigEntity.getMessageConfigId() == null || messageConfigEntity.getMessageConfigId() == 0) {
            if (Objects.equals(messageConfigEntity.getMessageType(), MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue()) || Objects.equals(messageConfigEntity.getMessageType(), MessageTypeEnum.SMS_MESSAGE.getValue())) {
                WeiXinKeywordEntity weiXinKeywordEntity = this.keywordInterface.getWeiXinKeywordById(messageConfigEntity.getMessageId());
                messageConfigEntity.setActionId(PinYinHelper.getPinYin(weiXinKeywordEntity.getKeyword()));
                messageConfigEntity.setActionName(weiXinKeywordEntity.getKeyword());
            } else if (Objects.equals(messageConfigEntity.getMessageType(), MessageTypeEnum.TEMPLATE_MESSAGE.getValue()) || Objects.equals(messageConfigEntity.getMessageType(), MessageTypeEnum.MP_SUBSCRIBE_MESSAGE.getValue())) {
                TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(messageConfigEntity.getMessageId());
                if (StringUtils.isNotEmpty((String)templateMessageEntity.getMessageNameOrigin())) {
                    messageConfigEntity.setActionId(PinYinHelper.getPinYin(templateMessageEntity.getMessageNameOrigin()));
                    messageConfigEntity.setActionName(templateMessageEntity.getMessageNameOrigin());
                } else if (StringUtils.isNotEmpty((String)templateMessageEntity.getMessageName())) {
                    messageConfigEntity.setActionId(PinYinHelper.getPinYin(templateMessageEntity.getMessageName()));
                    messageConfigEntity.setActionName(templateMessageEntity.getMessageName());
                }
            }
            if (messageConfigEntity.getActionId().length() > 50) {
                messageConfigEntity.setActionId(messageConfigEntity.getActionId().substring(0, 49));
            }
            messageConfigEntitySearch.setActionId(messageConfigEntity.getActionId());
            messageConfigEntitySearch = (MallMessageConfigEntity)this.messageConfigMapper.getSingle(messageConfigEntitySearch);
            if (messageConfigEntitySearch != null) {
                return BaseJsonVo.error((String)("\u52a8\u4f5cId\u5df2\u5b58\u5728" + messageConfigEntity.getActionId()));
            }
            messageConfigEntity.setCreateTime(DateUtils.now());
            b = this.messageConfigMapper.insertSelective(messageConfigEntity) > 0;
        } else {
            if (Objects.equals(messageConfigEntity.getMessageType(), MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue()) || Objects.equals(messageConfigEntity.getMessageType(), MessageTypeEnum.SMS_MESSAGE.getValue())) {
                WeiXinKeywordEntity weiXinKeywordEntity = this.keywordInterface.getWeiXinKeywordById(messageConfigEntity.getMessageId());
                messageConfigEntity.setActionId(PinYinHelper.getPinYin(weiXinKeywordEntity.getKeyword()));
                messageConfigEntity.setActionName(weiXinKeywordEntity.getKeyword());
            } else if (Objects.equals(messageConfigEntity.getMessageType(), MessageTypeEnum.TEMPLATE_MESSAGE.getValue()) || Objects.equals(messageConfigEntity.getMessageType(), MessageTypeEnum.MP_SUBSCRIBE_MESSAGE.getValue())) {
                TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(messageConfigEntity.getMessageId());
                if (StringUtils.isNotEmpty((String)templateMessageEntity.getMessageNameOrigin())) {
                    messageConfigEntity.setActionId(PinYinHelper.getPinYin(templateMessageEntity.getMessageNameOrigin()));
                    messageConfigEntity.setActionName(templateMessageEntity.getMessageNameOrigin());
                } else if (StringUtils.isNotEmpty((String)templateMessageEntity.getMessageName())) {
                    messageConfigEntity.setActionId(PinYinHelper.getPinYin(templateMessageEntity.getMessageName()));
                    messageConfigEntity.setActionName(templateMessageEntity.getMessageName());
                }
            }
            if (messageConfigEntity.getActionId().length() > 50) {
                messageConfigEntity.setActionId(messageConfigEntity.getActionId().substring(0, 49));
            }
            messageConfigEntitySearch.setActionId(messageConfigEntity.getActionId());
            messageConfigEntitySearch = (MallMessageConfigEntity)this.messageConfigMapper.getSingle(messageConfigEntitySearch);
            if (messageConfigEntitySearch != null && messageConfigEntitySearch.getMessageConfigId().intValue() != messageConfigEntitySearch.getMessageConfigId().intValue()) {
                return BaseJsonVo.error((String)("\u52a8\u4f5cId\u5df2\u5b58\u5728" + messageConfigEntity.getActionId()));
            }
            b = this.messageConfigMapper.updateByPrimaryKeySelective(messageConfigEntity) > 0;
        }
        this.removeCache(messageConfigEntity.getMessageConfigId(), messageConfigEntity.getPlatformId(), messageConfigEntity.getActionId(), messageConfigEntity.getActiveNo(), messageConfigEntity.getActionType());
        if (b) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public MallMessageConfigEntity select(int messageConfigId) {
        return (MallMessageConfigEntity)this.messageConfigMapper.selectByPrimaryKey(Integer.valueOf(messageConfigId));
    }

    @Override
    public List<MallMessageConfigVo> getMessageConfigList(MallMessageConfigEntity messageConfigEntity) {
        ArrayList<MallMessageConfigVo> configVos = new ArrayList<MallMessageConfigVo>();
        if (messageConfigEntity != null) {
            List configEntities;
            Page page = PageHelper.startPage((int)1, (int)100);
            page.setOrderBy("CREATE_TIME desc");
            if ("".equals(messageConfigEntity.getActionId())) {
                messageConfigEntity.setActionId(null);
            }
            if ((configEntities = this.messageConfigMapper.getList(messageConfigEntity)) != null) {
                for (MallMessageConfigEntity configEntity : configEntities) {
                    String messageName = "";
                    if (configEntity != null) {
                        TemplateMessageEntity templateMessageEntity;
                        if (configEntity.getMessageType().intValue() == MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue() || configEntity.getMessageType().intValue() == MessageTypeEnum.SMS_MESSAGE.getValue()) {
                            WeiXinKeywordEntity keywordEntity = this.keywordInterface.getWeiXinKeywordById(configEntity.getMessageId());
                            if (keywordEntity != null) {
                                messageName = keywordEntity.getKeyword();
                            }
                        } else if ((configEntity.getMessageType().intValue() == MessageTypeEnum.TEMPLATE_MESSAGE.getValue() || configEntity.getMessageType().intValue() == MessageTypeEnum.MP_SUBSCRIBE_MESSAGE.getValue()) && (templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(configEntity.getMessageId())) != null) {
                            messageName = templateMessageEntity.getMessageName();
                        }
                    }
                    MallMessageConfigVo configVo = new MallMessageConfigVo();
                    try {
                        ObjectConvert.fatherConvertToChild((Object)configEntity, (Object)configVo);
                        configVo.setMessageName(messageName);
                        configVos.add(configVo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return configVos;
    }

    @Override
    public boolean delete(Integer messageConfigId) {
        MallMessageConfigEntity configEntity = this.select(messageConfigId);
        this.removeCache(configEntity.getMessageConfigId(), configEntity.getPlatformId(), configEntity.getActionId(), configEntity.getActiveNo(), configEntity.getActionType());
        return this.messageConfigMapper.deleteByPrimaryKey(messageConfigId) > 0;
    }

    @Override
    public BaseJsonVo getMessageConfig(Integer messageConfigId, Map<String, String> variable) {
        MallMessageConfigEntity configEntity = this.select(messageConfigId);
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        if (configEntity.getMessageType() == 1) {
            BaseJsonVo baseJsonVo = this.keywordInterface.getKeywordContent(configEntity.getMessageId(), variable);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            map.put(configEntity.getMessageType(), baseJsonVo.getValue());
        } else if (configEntity.getMessageType() == 2) {
            BaseJsonVo baseJsonVo = this.templateMessageInterface.getTemplateMessageContent(configEntity.getMessageId(), variable);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            map.put(configEntity.getMessageType(), baseJsonVo.getValue());
        }
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo pushCustomerNum(String customerType, String action) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("total", Long.valueOf(this.messageConfigMapper.getCustomerList4customer("").size()));
        map.put("succ", 0L);
        map.put("receivNum", 0L);
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo deleteImportCustomer(String action) {
        return this.messageConfigMapper.deleteImportCustomer(action) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public void setMessageCanPush(String action, Integer status, Integer oldStatus) {
        this.messageConfigMapper.setCustomerPushStatus(action, status, oldStatus);
    }

    @Override
    public void pushNoticeMQ(String customerType, String action, Date sendTime, int pageSize) {
        this.logger.info("\u63a5\u6536\u53c2\u6570:customerType={},action={},sendTime={}", new Object[]{customerType, action, sendTime});
        int pageNum = 0;
        MessageRemainEntity query = new MessageRemainEntity();
        query.setStatus(1);
        if (StringUtils.isNotEmpty((String)action)) {
            query.setAction(action);
        }
        if (StringUtils.isNotEmpty((String)customerType)) {
            query.setType(customerType);
        }
        PageInfo<MessageRemainEntity> pageInfo = this.messageRemainInterface.getDateList(query, pageNum, pageSize);
        try {
            this.logger.info("\u63a8\u9001\u6d88\u606f\u961f\u5217\u540d\u5355\u662f\u5426\u4e3a\u7a7a\uff1a" + (pageInfo.getTotal() <= 0L));
            this.logger.info("\u5c06\u8981\u63a8\u9001\u7528\u6237\u8bb0\u5f55\u6570:{}", (Object)pageInfo.getTotal());
            if (pageInfo.getTotal() > 0L) {
                Map<String, List<MessageRemainEntity>> prodMap = pageInfo.getList().stream().collect(Collectors.groupingBy(MessageRemainEntity::getAction));
                ArrayList<Map<String, String>> tempNameList = new ArrayList<Map<String, String>>();
                for (Map.Entry<String, List<MessageRemainEntity>> entry : prodMap.entrySet()) {
                    for (MessageRemainEntity remainEntity : entry.getValue()) {
                        HashMap<String, String> itemMap = new HashMap<String, String>();
                        itemMap.put("NICK_NAME", remainEntity.getNickName());
                        itemMap.put("date", DateUtils.date());
                        itemMap.put("CUSTOMER_ID", remainEntity.getCustomerId());
                        tempNameList.add(itemMap);
                        this.messageRemainInterface.setPushStatus(remainEntity);
                    }
                    if (tempNameList.size() >= 1) {
                        this.pushNoticeMQ(entry.getKey(), tempNameList, pageNum);
                        ++pageNum;
                    }
                    this.logger.info("\u6d88\u606f\u961f\u5217\u63a8\u9001\u6b21\u6570:{}", (Object)pageNum);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void pushNoticeMQ(String action) {
        PageInfo<Map<String, String>> pageInfo;
        this.logger.info("\u63a5\u6536\u53c2\u6570:action={}", (Object)action);
        int pageNum = 0;
        int pageSize = 1000;
        int i = 0;
        while (!CollectionUtils.isEmpty((Collection)(pageInfo = this.getCustomerList4Message(i, pageSize)).getList())) {
            this.pushNoticeMQ(action, pageInfo.getList(), pageNum);
            this.logger.info("\u6d88\u606f\u961f\u5217\u63a8\u9001\u6b21\u6570:{}", (Object)i);
            ++i;
        }
        this.messageConfigMapper.setCustomerPushStatus(action, 2, 1);
    }

    public PageInfo<Map<String, String>> getCustomerList4Message(int pageNum, int pageSize) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.messageConfigMapper.getCustomerList4Message();
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo pushNoticeMQFromRedisSet() {
        Integer popNumPage = this.dictionaryInterface.getDictionaryToInteger(1000, 56, "2");
        popNumPage = popNumPage == null || popNumPage == 0 ? 50 : popNumPage;
        Integer perSize = 100;
        for (int i = 0; i < popNumPage; ++i) {
            ArrayList<Map<String, String>> tempNameList = new ArrayList<Map<String, String>>();
            for (int j = 0; j < perSize; ++j) {
                Map name = (Map)this.redisService.spop(NAMES_UNSEND_IN_REDIS_KEY);
                if (name == null) {
                    i = popNumPage;
                    break;
                }
                this.redisService.sremove(OPENID_UNSEND_IN_REDIS_KEY, (String)name.get("CUSTOMER_ID"));
                tempNameList.add(name);
            }
            this.logger.info("\u8981\u63a8\u9001\u6a21\u677f\u6d88\u606f\u4e86[" + i + "]\uff1a" + JsonUtils.toJson(tempNameList, (boolean)true));
            this.pushNoticeMQ("all", tempNameList, i);
        }
        return BaseJsonVo.success((Object)"");
    }

    private void clearMessageCache(String customerType, String action) {
        boolean temp = this.redisService.delete("TEMPLETE_ACTIVE_SEND_OPENID_LIST2" + customerType + action);
        this.logger.info("\u63a8\u9001\u6210\u529f\u8bb0\u5f55\u7f13\u5b58\u6e05\u9664:customerType={},{},action=", new Object[]{temp, customerType, action});
        this.redisService.delete("TEMPLETE_ACTIVE_SEND_OPENID_TOTAL_NUM" + customerType + action);
        this.redisService.delete("TEMPLETE_ACTIVE_SEND_OPENID_SUCC_NUM" + customerType + action);
        this.redisService.delete("RedisConstantstempleteActiveSendOpenIdSendNum:" + customerType + ":" + action);
        this.logger.info("\u63a8\u9001\u6210\u529f\u4eba\u5a04\u8bb0\u5f55\u7f13\u5b58\u6e05\u9664{}:customerType={},action={}", new Object[]{temp, customerType, action});
    }

    @Override
    public Boolean pushNoticeMQ(String action, List<Map<String, String>> tempNameList, int pageNum) {
        return this.pushNoticeMQ(action, "", tempNameList, pageNum);
    }

    @Override
    public Boolean pushNoticeMQ(String action, String custid, List<Map<String, String>> tempNameList, int pageNum) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("action", action);
        messageMap.put("custid", custid);
        messageMap.put("list", tempNameList);
        this.logger.info("\u6d88\u606f\u961f\u5217\u63a8\u9001\u6d88\u606f\uff1a" + JsonUtils.toJson(messageMap, (boolean)true));
        MessageResult mr = this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.templeteMessageSend, new MessageParam(String.valueOf(pageNum), messageMap));
        this.logger.info("\u63a8\u9001\u6d88\u606f\u961f\u5217\u7ed3\u679c\uff1a" + mr.isStatus() + "  " + mr.getMsg().toString());
        return mr.isStatus();
    }

    private List<Map<String, String>> getCustomerList(String action, String customerType, int pageNum, int pageSize) {
        if ("uploadUser".equals(customerType)) {
            return this.messageConfigMapper.getCustomerList4customer("");
        }
        if ("test".equals(customerType)) {
            return this.messageConfigMapper.getCustomerList4Test();
        }
        if ("all".equals(customerType)) {
            return this.messageConfigMapper.getCustomerList(1);
        }
        if ("fresh".equals(customerType)) {
            return this.messageConfigMapper.getCustomerList4FreshCity();
        }
        if ("subscribe".equals(customerType)) {
            return this.getCustomerList(action);
        }
        return this.messageConfigMapper.getCustomerList4customer("");
    }

    private List<Map<String, String>> getCustomerList(String action) {
        TemplateMessageEntity templateMessageEntity;
        MallMessageConfigEntity query = new MallMessageConfigEntity();
        query.setActionId(action);
        MallMessageConfigEntity messageConfigEntity = (MallMessageConfigEntity)this.messageConfigMapper.getSingle(query);
        if (messageConfigEntity == null) {
            return new ArrayList<Map<String, String>>();
        }
        HashSet set = new HashSet();
        if (messageConfigEntity.getMessageType().intValue() == MessageTypeEnum.TEMPLATE_MESSAGE.getValue() && Objects.equals((templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(messageConfigEntity.getMessageId())).getPlatformId(), PlatFormEnum.LECHUN_MINI.getValue())) {
            List<SubscribeMessageEntity> list = this.subscribeMessageInterface.getCustomerList(templateMessageEntity.getTemplateId());
            for (SubscribeMessageEntity subscribeMessageEntity : list) {
                CustomerEntity customerDetailVo = this.customerService.getCustomer(subscribeMessageEntity.getCustomerId());
                if (customerDetailVo == null) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("NICK_NAME", customerDetailVo.getNickName());
                map.put("CUSTOMER_ID", customerDetailVo.getCustomerId());
                set.add(map);
            }
        }
        return new ArrayList<Map<String, String>>(set);
    }

    @Override
    public Integer getPushCustomizedNoticeMQNum(String action, Integer platformId, String connector, Integer lastCreateTimeBegin, Integer lastCreateTimeEnd, Integer totalOrderNumBegin, Integer totalOrderNumEnd, Integer perOrderCostBegin, Integer perOrderCostEnd) {
        List<Map<String, String>> customers = this.getCustomizedList(platformId, connector, lastCreateTimeBegin, lastCreateTimeEnd, totalOrderNumBegin, totalOrderNumEnd, perOrderCostBegin, perOrderCostEnd);
        return customers.size();
    }

    @Override
    public void pushCustomizedNoticeMQ(String action, Integer platformId, String connector, Integer lastCreateTimeBegin, Integer lastCreateTimeEnd, Integer totalOrderNumBegin, Integer totalOrderNumEnd, Integer perOrderCostBegin, Integer perOrderCostEnd) {
        List<Map<String, String>> customers = this.getCustomizedList(platformId, connector, lastCreateTimeBegin, lastCreateTimeEnd, totalOrderNumBegin, totalOrderNumEnd, perOrderCostBegin, perOrderCostEnd);
        int pageNum = 0;
        int pageSize = 1000;
        String customerType = IDGenerate.getUniqueIdStr();
        try {
            if (customers == null) {
                return;
            }
            this.logger.info("\u5c06\u8981\u63a8\u9001\u7528\u6237\u8bb0\u5f55\u6570:{}", (Object)customers.size());
            ArrayList<Map<String, String>> tempNameList = new ArrayList<Map<String, String>>();
            for (int i = 0; i < customers.size(); ++i) {
                tempNameList.add(customers.get(i));
                if (i <= 0 || i % pageSize != 0) continue;
                this.pushNoticeMQ(action, tempNameList, pageNum);
                ++pageNum;
                tempNameList = new ArrayList();
            }
            if (tempNameList.size() >= 1) {
                this.pushNoticeMQ(action, tempNameList, pageNum);
                ++pageNum;
            }
            this.logger.info("\u6d88\u606f\u961f\u5217\u63a8\u9001\u6b21\u6570:{}", (Object)pageNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Map<String, String>> getCustomizedList(Integer platformId, String connector, Integer lastCreateTimeBegin, Integer lastCreateTimeEnd, Integer totalOrderNumBegin, Integer totalOrderNumEnd, Integer perOrderCostBegin, Integer perOrderCostEnd) {
        this.logger.info("platformid : " + platformId);
        this.logger.info("connector : " + connector);
        this.logger.info("lastCreateTimeBegin : " + lastCreateTimeBegin);
        this.logger.info("lastCreateTimeEnd : " + lastCreateTimeEnd);
        this.logger.info("totalOrderNumBegin : " + totalOrderNumBegin);
        this.logger.info("totalOrderNumEnd : " + totalOrderNumEnd);
        this.logger.info("perOrderCostBegin : " + perOrderCostBegin);
        this.logger.info("perOrderCostEnd : " + perOrderCostEnd);
        String lastCreateTimeBeginStr = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)(0 - lastCreateTimeBegin)), (String)"yyyy-MM-dd");
        String lastCreateTimeEndStr = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)(1 - lastCreateTimeEnd)), (String)"yyyy-MM-dd");
        if ("1".equals(connector)) {
            return this.messageConfigMapper.getCustomizedListAND(platformId, lastCreateTimeBeginStr, lastCreateTimeEndStr, totalOrderNumBegin, totalOrderNumEnd, perOrderCostBegin, perOrderCostEnd);
        }
        return this.messageConfigMapper.getCustomizedListOR(platformId, lastCreateTimeBeginStr, lastCreateTimeEndStr, totalOrderNumBegin, totalOrderNumEnd, perOrderCostBegin, perOrderCostEnd);
    }

    private void removeCache(Integer messageConfigId, Integer platformId, String actionId, String activeNo, Integer actionType) {
        this.memcachedService.delete("MallMessageConfigService.getMessageConfigEntity", new String[]{String.valueOf(platformId), actionId});
        this.memcachedService.delete("MallMessageConfigService.getMessageConfigEntity", new String[]{activeNo, String.valueOf(actionType)});
        this.memcachedService.delete("MallMessageConfigService.select", String.valueOf(messageConfigId));
        this.memcachedService.delete("MallMessageConfigService.getMessageConfig", String.valueOf(messageConfigId));
    }

    @Override
    public String putAllUsersIntoRedisSet() {
        int i = 0;
        while (true) {
            PageInfo<Map<String, String>> allNickNameAndOpenId = this.customerService.getAllNickNameAndOpenId(i);
            allNickNameAndOpenId.getList().forEach(map -> {
                boolean addSuccess = this.redisService.sadd(OPENID_UNSEND_IN_REDIS_KEY, map.get("CUSTOMER_ID"));
                if (addSuccess) {
                    this.redisService.sadd(NAMES_UNSEND_IN_REDIS_KEY, map);
                }
            });
            if (allNickNameAndOpenId.getList() == null || allNickNameAndOpenId.getList().size() < 10000) break;
            ++i;
        }
        return null;
    }
}

