/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.MessageBlackListMapper;
import cc.lechun.mall.entity.weixin.MessageBlackListEntity;
import cc.lechun.mall.iservice.weixin.MessageBlackListInterface;
import cc.lechun.mall.iservice.weixin.MessageErpBlackListInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageBlackListService
extends BaseService<MessageBlackListEntity, Integer>
implements MessageBlackListInterface {
    @Resource
    private MessageBlackListMapper messageBlackListMapper;
    @Autowired
    private MessageErpBlackListInterface erpBlackListInterface;

    @Override
    public PageInfo list(Integer pageNumber, Integer pageSize, MessageBlackListEntity blackListEntity) {
        Page page = PageHelper.startPage((int)pageNumber, (int)pageSize);
        page.setOrderBy(" black_type ");
        if (blackListEntity == null) {
            blackListEntity = new MessageBlackListEntity();
        }
        List lst = this.messageBlackListMapper.getList(blackListEntity);
        for (MessageBlackListEntity l : lst) {
            if (StringUtils.isNotEmpty((String)l.getPhone())) {
                l.setPhone("" + l.getPhone().split(",").length);
            } else {
                l.setPhone("0");
            }
            if (StringUtils.isNotEmpty((String)l.getOpenId())) {
                l.setOpenId("" + l.getOpenId().split(",").length);
            } else {
                l.setOpenId("0");
            }
            if (StringUtils.isNotEmpty((String)l.getCustomerId())) {
                l.setCustomerId("" + l.getCustomerId().split(",").length);
            } else {
                l.setCustomerId("0");
            }
            Integer erpShopPhoneCount = 0;
            if (StringUtils.isNotEmpty((String)l.getErpShopId())) {
                erpShopPhoneCount = this.erpBlackListInterface.getPhoneCount(l.getErpShopId(), 1);
            }
            l.setErpShopId("" + erpShopPhoneCount);
            Integer erpCustomerPhoneCount = 0;
            if (StringUtils.isNotEmpty((String)l.getErpCustomerId())) {
                erpCustomerPhoneCount = this.erpBlackListInterface.getPhoneCount(l.getErpCustomerId(), 2);
            }
            l.setErpCustomerId("" + erpCustomerPhoneCount);
        }
        return page.toPageInfo();
    }

    @Override
    public BaseJsonVo save(MessageBlackListEntity blackListEntity) {
        if (blackListEntity.getBlackType() == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u9ed1\u540d\u5355\u7c7b\u578b");
        }
        if (blackListEntity.getId() == null) {
            this.insertSelective(blackListEntity);
        } else {
            this.updateByPrimaryKeySelective(blackListEntity);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }
}

