/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.weixin.MallMessageConfigEntity;
import cc.lechun.mall.entity.weixin.MallTemplateMessageLogEntity;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MallMessageConfigInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageLogInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.MessageAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.message.message.Message;
import weixin.popular.bean.message.message.TextMessage;
import weixin.popular.bean.message.templatemessage.MiniSubscribeMessage;
import weixin.popular.bean.message.templatemessage.TemplateMessage;
import weixin.popular.bean.message.templatemessage.TemplateMessageItem;
import weixin.popular.bean.message.templatemessage.TemplateMessageResult;
import weixin.popular.bean.message.templatemessage.WxopenTemplateMessage;

@Service
public class MessageService
implements MessageInterface {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private TemplateMessageLogInterface templateMessageLogInterface;
    @Autowired
    private MallMessageConfigInterface messageConfigInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    private WeiXinKeywordInterface keywordInterface;
    @Autowired
    private RedisService redisService;

    @Override
    public BaseResult sendCustomerTextMessage4CustmoerId(String customerId, Integer platFormId, String content, int messageId) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, platFormId);
        BaseResult baseResult = new BaseResult();
        if (customerDetailVo == null) {
            baseResult.setErrcode("\u7528\u6237\u4e0d\u5b58\u5728");
            baseResult.setErrcode("1001");
            this.log.info("\u7528\u6237\u4e0d\u5b58\u5728,customerId={}", (Object)customerId);
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return this.sendCustomerTextMessage(customerDetailVo.getOpenId(), platFormId, content, messageId);
    }

    @Override
    public BaseResult sendCustomerTextMessage(String openId, Integer platFormId, String content, int messageId) {
        String accessToken = this.weiXinBaseService.getAccessTokenValueByPlatformId(platFormId);
        return this.sendCustomerTextMessage4Base(openId, accessToken, content, messageId, platFormId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseResult sendCustomerTextMessage4Base(String openId, String accessToken, String content, int messageId, Integer platFormId) {
        BaseResult baseResult = new BaseResult();
        if (StringUtils.isEmpty((String)openId)) {
            baseResult.setErrmsg("\u7528\u6237\u4e0d\u5b58\u5728");
            baseResult.setErrcode("1001");
            return baseResult;
        }
        if (StringUtils.isEmpty((String)content)) {
            baseResult.setErrmsg("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            baseResult.setErrcode("1002");
            return baseResult;
        }
        if (StringUtils.isEmpty((String)accessToken)) {
            this.log.info("\u83b7\u53d6accessToken\u5931\u8d25,accessToken\u4e3a\u7a7a");
            baseResult.setErrmsg("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            baseResult.setErrcode("1003");
            return baseResult;
        }
        String key = String.valueOf((openId + ":" + content).hashCode());
        Object existslogId = this.memcachedService.get("", key);
        if (existslogId != null && this.templateMessageLogInterface.exists(existslogId.toString())) {
            baseResult.setErrmsg("\u6d88\u606f\u5185\u5bb9\u5df2\u53d1\u9001\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u9001");
            baseResult.setErrcode("1005");
            return baseResult;
        }
        TextMessage textMessage = new TextMessage(openId, content);
        try {
            String logId = IDGenerate.getUniqueIdStr();
            baseResult = MessageAPI.messageCustomSend((String)accessToken, (Message)textMessage);
            MallTemplateMessageLogEntity templateMessageLogEntity = new MallTemplateMessageLogEntity();
            templateMessageLogEntity.setLogId(logId);
            templateMessageLogEntity.setCreateTime(DateUtils.now());
            templateMessageLogEntity.setErrCode(baseResult.getErrcode());
            templateMessageLogEntity.setMessageId(messageId);
            templateMessageLogEntity.setMessageName("");
            templateMessageLogEntity.setMessageText(content);
            templateMessageLogEntity.setOpenId(openId);
            templateMessageLogEntity.setSource(1);
            templateMessageLogEntity.setTemplateId("");
            templateMessageLogEntity.setUrl("");
            this.templateMessageLogInterface.save(templateMessageLogEntity);
            if (baseResult.isSuccess()) {
                this.memcachedService.set("", key, (Object)logId, 86400);
            } else if (!"40001".equals(baseResult.getErrcode())) {
                // empty if block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            baseResult.setErrcode("1004");
            this.log.info("\u7528\u6237:{},\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u5931\u8d25,\u9519\u8bef\u6d88\u606f:{}", new Object[]{openId, content, e.getMessage()});
            return baseResult;
        }
        if (baseResult.isSuccess()) {
            this.log.info("\u7528\u6237:{},\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u6210\u529f", (Object)openId, (Object)content);
            return baseResult;
        }
        this.log.info("\u7528\u6237:{},\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u5931\u8d25,\u9519\u8bef\u6d88\u606f:", new Object[]{openId, content, baseResult.getErrmsg()});
        return baseResult;
    }

    @Override
    public TemplateMessageResult messageTemplateSend(Integer platFormId, String openId, String url, String templeteId, LinkedHashMap<String, TemplateMessageItem> data) {
        String accessToken = this.weiXinBaseService.getAccessTokenValueByPlatformId(platFormId);
        return this.messageTemplateSend(accessToken, openId, url, templeteId, data);
    }

    @Override
    public BaseResult miniMessageSubscribeSend(Integer platFormId, Integer messageId, MiniSubscribeMessage message) {
        String accessToken = this.weiXinBaseService.getAccessTokenByPlatformId(platFormId).getAccessToken();
        return this.miniMessageSubscribeSendBase(accessToken, message, messageId, platFormId, true);
    }

    @Override
    public TemplateMessageResult messageTemplateSend(String accessToken, String openId, String url, String templeteId, LinkedHashMap<String, TemplateMessageItem> data) {
        TemplateMessage templateMessage = new TemplateMessage();
        templateMessage.setTemplate_id(templeteId);
        templateMessage.setTouser(openId);
        if (StringUtils.isNotEmpty((String)url)) {
            templateMessage.setUrl(url);
        }
        templateMessage.setData(data);
        return this.messageTemplateSendBase(accessToken, templateMessage, 0, 0);
    }

    private TemplateMessageResult messageTemplateSendBase(String access_token, TemplateMessage templateMessage, Integer messageId, Integer platformId) {
        return this.messageTemplateSendBase(access_token, templateMessage, messageId, platformId, true);
    }

    private BaseResult miniMessageSubscribeSendBase(String access_token, MiniSubscribeMessage templateMessage, Integer messageId, Integer platformId, boolean writeLog) {
        TemplateMessageResult templateMessageResult = new TemplateMessageResult();
        if (StringUtils.isEmpty((String)templateMessage.getTouser())) {
            templateMessageResult.setErrcode("\u7528\u6237\u4e0d\u5b58\u5728");
            templateMessageResult.setErrcode("1001");
            return templateMessageResult;
        }
        if (templateMessage.getData() == null) {
            templateMessageResult.setErrcode("\u6a21\u677f\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            templateMessageResult.setErrcode("1002");
            return templateMessageResult;
        }
        if (StringUtils.isEmpty((String)templateMessage.getTemplate_id())) {
            this.log.info("\u6a21\u677fid\u4e3a\u7a7a");
            templateMessageResult.setErrcode("\u6a21\u677fid\u4e3a\u7a7a");
            templateMessageResult.setErrcode("1003");
            return templateMessageResult;
        }
        if (StringUtils.isEmpty((String)access_token)) {
            this.log.info("\u83b7\u53d6accessToken\u5931\u8d25,accessToken\u4e3a\u7a7a");
            templateMessageResult.setErrcode("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            templateMessageResult.setErrcode("1004");
            return templateMessageResult;
        }
        Boolean isSucc = false;
        try {
            templateMessageResult = MessageAPI.messageSubscribeSend((String)access_token, (MiniSubscribeMessage)templateMessage);
            String errcode = templateMessageResult.getErrcode();
            isSucc = templateMessageResult.isSuccess();
            if (writeLog) {
                MallTemplateMessageLogEntity templateMessageLogEntity = new MallTemplateMessageLogEntity();
                templateMessageLogEntity.setLogId(UUID.randomUUID().toString().replace("-", ""));
                templateMessageLogEntity.setCreateTime(DateUtils.now());
                templateMessageLogEntity.setErrCode(errcode);
                templateMessageLogEntity.setMessageId(messageId);
                templateMessageLogEntity.setMessageName("");
                templateMessageLogEntity.setMessageText(templateMessage.toString());
                templateMessageLogEntity.setOpenId(templateMessage.getTouser());
                templateMessageLogEntity.setSource(platformId);
                templateMessageLogEntity.setTemplateId(templateMessage.getTemplate_id());
                templateMessageLogEntity.setUrl("");
                this.templateMessageLogInterface.save(templateMessageLogEntity);
            }
            if (isSucc.booleanValue()) {
                this.log.info("\u7528\u6237:{},\u6a21\u677f\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u6210\u529f", (Object)templateMessage.getTouser(), (Object)templateMessage.toString());
            } else {
                this.log.error("\u7528\u6237:{},\u6a21\u677f\u6d88\u606f\u5185\u5bb9:{},\u9519\u8bef\u6d88\u606f:{},\u53d1\u9001\u5931\u8d25", new Object[]{templateMessage.getTouser(), templateMessage.toString(), templateMessageResult.getErrcode() + ":" + templateMessageResult.getErrmsg()});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return templateMessageResult;
    }

    private TemplateMessageResult messageTemplateSendBase(String access_token, TemplateMessage templateMessage, Integer messageId, Integer platformId, boolean writeLog) {
        TemplateMessageResult templateMessageResult = new TemplateMessageResult();
        if (StringUtils.isEmpty((String)templateMessage.getTouser())) {
            templateMessageResult.setErrcode("\u7528\u6237\u4e0d\u5b58\u5728");
            templateMessageResult.setErrcode("1001");
            return templateMessageResult;
        }
        if (templateMessage.getData() == null) {
            templateMessageResult.setErrcode("\u6a21\u677f\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            templateMessageResult.setErrcode("1002");
            return templateMessageResult;
        }
        if (StringUtils.isEmpty((String)templateMessage.getTemplate_id())) {
            this.log.info("\u6a21\u677fid\u4e3a\u7a7a");
            templateMessageResult.setErrcode("\u6a21\u677fid\u4e3a\u7a7a");
            templateMessageResult.setErrcode("1003");
            return templateMessageResult;
        }
        if (StringUtils.isEmpty((String)access_token)) {
            this.log.info("\u83b7\u53d6accessToken\u5931\u8d25,accessToken\u4e3a\u7a7a");
            templateMessageResult.setErrcode("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            templateMessageResult.setErrcode("1004");
            return templateMessageResult;
        }
        Boolean isSucc = false;
        try {
            templateMessageResult = MessageAPI.messageTemplateSend((String)access_token, (TemplateMessage)templateMessage);
            String errcode = templateMessageResult.getErrcode();
            isSucc = templateMessageResult.isSuccess();
            if (writeLog) {
                MallTemplateMessageLogEntity templateMessageLogEntity = new MallTemplateMessageLogEntity();
                templateMessageLogEntity.setLogId(UUID.randomUUID().toString().replace("-", ""));
                templateMessageLogEntity.setCreateTime(DateUtils.now());
                templateMessageLogEntity.setErrCode(errcode);
                templateMessageLogEntity.setMessageId(messageId);
                templateMessageLogEntity.setMessageName("");
                templateMessageLogEntity.setMessageText(templateMessage.toString());
                templateMessageLogEntity.setOpenId(templateMessage.getTouser());
                templateMessageLogEntity.setSource(platformId);
                templateMessageLogEntity.setTemplateId(templateMessage.getTemplate_id());
                templateMessageLogEntity.setUrl("");
                this.templateMessageLogInterface.save(templateMessageLogEntity);
            }
            if (isSucc.booleanValue()) {
                this.log.info("\u7528\u6237:{},\u6a21\u677f\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u6210\u529f", (Object)templateMessage.getTouser(), (Object)templateMessage.toString());
            } else {
                this.log.info("\u7528\u6237:{},\u6a21\u677f\u6d88\u606f\u5185\u5bb9:{},\u53d1\u9001\u5931\u8d25", (Object)templateMessage.getTouser(), (Object)templateMessage.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return templateMessageResult;
    }

    @Override
    public BaseResult messageWxopenTemplateSendBase(String access_token, WxopenTemplateMessage templateMessage) {
        return null;
    }

    @Override
    public BaseJsonVo sendWechatMessage(String actionId, String customerId, Map<String, String> variableMap) {
        return this.sendWechatMessage(1000, actionId, customerId, variableMap);
    }

    @Override
    public BaseJsonVo sendWechatMessage(Integer platformGroupId, String actionId, String customerId, Map<String, String> variableMap) {
        List<MallMessageConfigEntity> list = this.messageConfigInterface.getMessageConfigEntityList(platformGroupId, actionId);
        boolean flag = false;
        for (MallMessageConfigEntity configEntity : list) {
            try {
                BaseJsonVo baseJsonVo = this.sendWechatMessageByCustomerId(configEntity, customerId, variableMap, true);
                if (!baseJsonVo.isSuccess()) continue;
                flag = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flag ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u6d88\u606f\u63a8\u9001\u5931\u8d25");
    }

    private BaseJsonVo sendWechatMessageByCustomerId(MallMessageConfigEntity configEntity, String customerId, Map<String, String> variableMap, boolean writeLog) {
        if (customerId.isEmpty()) {
            return BaseJsonVo.error((String)"customerId\u4e3a\u7a7a");
        }
        if (configEntity == null) {
            return BaseJsonVo.error((String)"\u6d88\u606f\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, configEntity.getPlatformId());
        if (customerDetailVo == null) {
            this.log.error("\u7528\u6237:{},\u672a\u5728\u5e73\u53f0{}\u4e0a\u6ce8\u518c", (Object)customerId, (Object)configEntity.getPlatformId());
            return BaseJsonVo.error((String)("\u7528\u6237\u672a\u5728\u5e73\u53f0" + configEntity.getPlatformId() + "\u6ce8\u518c"));
        }
        BaseJsonVo baseJsonVo = this.messageConfigInterface.getMessageConfig(configEntity.getMessageConfigId(), variableMap);
        if (!baseJsonVo.isSuccess()) {
            this.log.info("\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + baseJsonVo.getError_msg());
            return baseJsonVo;
        }
        return this.sendWechatMessageBase(configEntity.getPlatformId(), configEntity.getMessageId(), customerDetailVo.getOpenId(), (Map)baseJsonVo.getValue(), writeLog);
    }

    public BaseJsonVo sendWechatMessage(MessageTypeEnum messageType, Integer messageId, String openId, Map<String, String> variableMap, boolean writeLog) {
        BaseJsonVo baseJsonVo;
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        Integer platformId = 0;
        if (messageType.compareTo(MessageTypeEnum.CUSTOMZICE_MESSAGE) == 0) {
            WeiXinKeywordEntity keywordEntity = this.keywordInterface.getWeiXinKeywordById(messageId);
            if (keywordEntity == null) {
                return BaseJsonVo.error((String)"\u5173\u952e\u5b57\u4e0d\u5b58\u5728");
            }
            platformId = keywordEntity.getPlatformId();
            baseJsonVo = this.keywordInterface.getKeywordContent(keywordEntity, variableMap);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            map.put(messageType.getValue(), baseJsonVo.getValue());
        }
        if (messageType.compareTo(MessageTypeEnum.TEMPLATE_MESSAGE) == 0) {
            TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(messageId);
            if (templateMessageEntity == null) {
                return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u4e0d\u5b58\u5728");
            }
            platformId = templateMessageEntity.getPlatformId();
            baseJsonVo = this.templateMessageInterface.getTemplateMessageContent(messageId, variableMap);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            map.put(messageType.getValue(), baseJsonVo.getValue());
        }
        return this.sendWechatMessageBase(platformId, messageId, openId, map, writeLog);
    }

    private BaseJsonVo sendWechatMessage(MallMessageConfigEntity configEntity, String openId, Map<String, String> variableMap, boolean writeLog) {
        if (openId.isEmpty()) {
            return BaseJsonVo.error((String)"openId\u4e3a\u7a7a");
        }
        if (configEntity == null) {
            return BaseJsonVo.error((String)"\u6d88\u606f\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        BaseJsonVo baseJsonVo = this.messageConfigInterface.getMessageConfig(configEntity.getMessageConfigId(), variableMap);
        if (!baseJsonVo.isSuccess()) {
            this.log.info("\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + baseJsonVo.getError_msg());
            return baseJsonVo;
        }
        return this.sendWechatMessageBase(configEntity.getPlatformId(), configEntity.getMessageId(), openId, (Map)baseJsonVo.getValue(), writeLog);
    }

    private BaseJsonVo sendWechatMessageBase(Integer platformId, Integer messageId, String openId, Map<Integer, Object> sendMap, boolean writeLog) {
        String accessToken = this.weiXinBaseService.getAccessTokenValueByPlatformId(platformId);
        if (sendMap.containsKey(1)) {
            Message message = (Message)sendMap.get(1);
            message.setTouser(openId);
            try {
                BaseResult b = MessageAPI.messageCustomSend((String)accessToken, (Message)message);
                if (!b.isSuccess()) {
                    return BaseJsonVo.error((String)b.getErrmsg());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (sendMap.containsKey(2)) {
            try {
                TemplateMessage templateMessage;
                if (platformId == 1) {
                    templateMessage = (TemplateMessage)sendMap.get(2);
                    templateMessage.setTouser(openId);
                    TemplateMessageResult result = this.messageTemplateSendBase(accessToken, templateMessage, messageId, platformId, writeLog);
                    return result.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)result.getErrmsg());
                }
                if (platformId == 4) {
                    templateMessage = (MiniSubscribeMessage)sendMap.get(2);
                    templateMessage.setTouser(openId);
                    BaseResult baseResult = this.miniMessageSubscribeSendBase(accessToken, (MiniSubscribeMessage)templateMessage, messageId, platformId, writeLog);
                    return baseResult.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)baseResult.getErrmsg());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error("\u6a21\u677f\u6d88\u606f\u63a8\u9001\u51fa\u9519,\u9519\u8bef\u6d88\u606f:{}", (Object)e.getMessage());
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo testSendMessage(String sendObject, Integer messageConfigId, Integer platformId) {
        final CustomerDetailVo customer = this.customerService.getCustomerDetailByOpenid(sendObject, platformId);
        MallMessageConfigEntity mallMessageConfigEntity = this.messageConfigInterface.select(messageConfigId);
        return this.sendWechatMessage(mallMessageConfigEntity.getActionId(), customer.getCustomerId(), (Map<String, String>)(customer == null || StringUtils.isEmpty((String)customer.getNickName()) ? new HashMap<String, String>(1){
            {
                this.put("nickName", "\u4e50\u7eaf\u7684\u4f19\u4f34");
            }
        } : new HashMap<String, String>(1){
            {
                super(x0);
                this.put("nickName", customer.getNickName());
            }
        }));
    }
}

