/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.MiniCardMapper;
import cc.lechun.mall.entity.weixin.MiniCardDo;
import cc.lechun.mall.entity.weixin.MiniCardEntity;
import cc.lechun.mall.entity.weixin.MiniCardQueryVo;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.weixin.MiniCardInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.MediaAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.media.MiniCardMedia;

@Service
public class MiniCardService
extends BaseService<MiniCardEntity, Integer>
implements MiniCardInterface {
    @Resource
    private MiniCardMapper miniCardMapper;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseService;

    @Override
    public BaseJsonVo saveMiniCard(int platformId, MiniCardDo miniCardDo) {
        this.logger.info("\u53c2\u6570:{}", (Object)miniCardDo.toString());
        String accessToken = this.weiXinBaseService.getAccessTokenValueByPlatformId(platformId);
        MiniCardMedia miniCardMedia = new MiniCardMedia();
        BeanUtils.copyProperties((Object)miniCardDo, (Object)miniCardMedia);
        WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseService.getAccessTokenByPlatformId(miniCardDo.getPlatformId());
        if (weiXinBaseEntity != null) {
            miniCardMedia.setAppid(weiXinBaseEntity.getAppid());
        }
        if (StringUtils.isEmpty((String)miniCardMedia.getAppid())) {
            miniCardMedia.setAppid("wxccfc57d73bc81766");
        }
        this.logger.info("\u53c2\u6570:{}", (Object)miniCardMedia.toString());
        BaseResult baseResult = MediaAPI.setMiniCard((String)accessToken, (MiniCardMedia)miniCardMedia);
        if (baseResult.isSuccess()) {
            MiniCardEntity miniCardEntity = new MiniCardEntity();
            BeanUtils.copyProperties((Object)miniCardMedia, (Object)miniCardEntity);
            miniCardEntity.setCreateTime(DateUtils.now());
            miniCardEntity.setMediaId(miniCardMedia.getMedia_id());
            this.miniCardMapper.insertOrUpdate(miniCardEntity);
        }
        return baseResult.isSuccess() ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public PageInfo<MiniCardEntity> getMiniCardList(MiniCardQueryVo miniCardQueryVo) {
        Page page = PageHelper.startPage((int)miniCardQueryVo.getCurrentPage(), (int)miniCardQueryVo.getPageSize());
        page.setOrderBy("MINI_CARD_ID desc");
        ArrayList result = new ArrayList();
        MiniCardEntity query = new MiniCardEntity();
        BeanUtils.copyProperties((Object)miniCardQueryVo, (Object)query);
        this.miniCardMapper.getList(query);
        return page.toPageInfo();
    }
}

