/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.TemplateMessageContentMapper;
import cc.lechun.mall.entity.weixin.TemplateExecTypeEnum;
import cc.lechun.mall.entity.weixin.TemplateMessageContentEntity;
import cc.lechun.mall.entity.weixin.TemplateMessageContentVo;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.iservice.weixin.TemplateMessageContentInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateMessageContentService
extends BaseService<TemplateMessageContentEntity, Integer>
implements TemplateMessageContentInterface {
    @Resource
    private TemplateMessageContentMapper templateMessageContentMapper;
    @Autowired
    TemplateMessageInterface templateMessageInterface;

    @Override
    public List<TemplateMessageContentVo> getList(Integer messageId) {
        TemplateMessageContentEntity templateMessageContentEntity = new TemplateMessageContentEntity();
        templateMessageContentEntity.setMessageId(messageId);
        List list = this.templateMessageContentMapper.getList(templateMessageContentEntity);
        ArrayList<TemplateMessageContentVo> result = new ArrayList<TemplateMessageContentVo>();
        if (list.size() > 0) {
            for (TemplateMessageContentEntity item : list) {
                TemplateMessageContentVo templateMessageContentVo = new TemplateMessageContentVo();
                TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessage(item.getMessageId());
                BeanUtils.copyProperties((Object)item, (Object)templateMessageContentVo);
                templateMessageContentVo.setMessageName(templateMessageEntity == null ? "" : templateMessageEntity.getMessageName());
                templateMessageContentVo.setStatusName(item.getStatus() == 1 ? "\u53ef\u7528" : "\u4e0d\u53ef\u7528");
                templateMessageContentVo.setExecTypeName(TemplateExecTypeEnum.getName(item.getExecType()));
                result.add(templateMessageContentVo);
            }
        }
        return result;
    }

    @Override
    public TemplateMessageContentVo getPlateMessageContent(Integer messageId) {
        TemplateMessageContentVo templateMessageContentVo = new TemplateMessageContentVo();
        TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessage(messageId);
        BeanUtils.copyProperties((Object)templateMessageEntity, (Object)templateMessageContentVo);
        return templateMessageContentVo;
    }

    @Override
    public BaseJsonVo saveTemplateMessageContent(TemplateMessageContentEntity templateMessageContentEntity) {
        this.templateMessageContentMapper.insertOrUpdate(templateMessageContentEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }
}

