/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.MallTemplateMessageLogMapper;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.weixin.MallMessagePushQueryVo;
import cc.lechun.mall.entity.weixin.MallMessagePushRecordVo;
import cc.lechun.mall.entity.weixin.MallTemplateMessageLogEntity;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageLogInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateMessageLogService
extends BaseService
implements TemplateMessageLogInterface {
    @Autowired
    private MallTemplateMessageLogMapper templateMessageLogMapper;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordInterface;
    @Autowired
    private PlatFormInterface platFormInterface;

    @Override
    public PageInfo<MallMessagePushRecordVo> getTemplateMessageLogList(MallMessagePushQueryVo messagePushQueryVo) {
        Page page = PageHelper.startPage((int)messagePushQueryVo.getCurrentPage(), (int)messagePushQueryVo.getPageSize());
        page.setOrderBy("LOG_ID desc");
        ArrayList result = new ArrayList();
        if (messagePushQueryVo.getStart() == null) {
            messagePushQueryVo.setStart(DateUtils.currentDate());
        }
        if (messagePushQueryVo.getMessageType() != null) {
            TemplateMessageEntity templateMessageEntity;
            if (messagePushQueryVo.getMessageType().intValue() == MessageTypeEnum.TEMPLATE_MESSAGE.getValue()) {
                templateMessageEntity = this.templateMessageInterface.getTemplateMessage(messagePushQueryVo.getMessageId());
                messagePushQueryVo.setTemplateId(templateMessageEntity == null ? "" : templateMessageEntity.getTemplateId());
            } else if (messagePushQueryVo.getMessageType().intValue() == MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue()) {
                templateMessageEntity = this.templateMessageInterface.getTemplateMessage(messagePushQueryVo.getMessageId());
                messagePushQueryVo.setTemplateId("");
            }
        }
        this.logger.info("\u67e5\u8be2\u53c2\u6570:{}", (Object)messagePushQueryVo);
        List<MallTemplateMessageLogEntity> list = this.templateMessageLogMapper.getTemplateMessageLogList(messagePushQueryVo);
        if (list.size() > 0) {
            result.addAll(list.stream().map(message -> {
                MallMessagePushRecordVo messagePushRecordVo = new MallMessagePushRecordVo();
                BeanUtils.copyProperties((Object)message, (Object)messagePushRecordVo);
                CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetailByOpenid(message.getOpenId(), message.getSource());
                messagePushRecordVo.setHeadImageUrl(customerDetailVo == null ? "" : customerDetailVo.getHeadImageUrl());
                messagePushRecordVo.setNickName(customerDetailVo == null ? "" : customerDetailVo.getNickName());
                messagePushRecordVo.setCustomerId(customerDetailVo == null ? "" : customerDetailVo.getCustomerId());
                if (StringUtils.isNotEmpty((String)message.getTemplateId())) {
                    TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessage(message.getMessageId());
                    messagePushRecordVo.setMessageName(templateMessageEntity == null ? "" : templateMessageEntity.getMessageName());
                    messagePushRecordVo.setMessageTypeName("\u6a21\u677f\u6d88\u606f");
                } else {
                    WeiXinKeywordEntity weiXinKeywordEntity = this.weiXinKeywordInterface.getWeiXinKeywordById(message.getMessageId());
                    messagePushRecordVo.setMessageName(weiXinKeywordEntity == null ? "" : weiXinKeywordEntity.getKeyword());
                    messagePushRecordVo.setMessageTypeName("\u5ba2\u670d\u6d88\u606f");
                }
                messagePushRecordVo.setResultMessage("0".equals(message.getErrCode()) ? "\u6210\u529f" : "\u5931\u8d25");
                messagePushRecordVo.setErrCode(message.getErrCode());
                PlatFormEntity platFormEntity = this.platFormInterface.getPlatForm(message.getSource());
                messagePushRecordVo.setPlatformName(platFormEntity == null ? "" : platFormEntity.getPlatformName());
                messagePushRecordVo.setMessageContent(message.getMessageText());
                return messagePushRecordVo;
            }).collect(Collectors.toList()));
        }
        PageInfo pg = new PageInfo();
        pg.setList(result);
        pg.setTotal(page.getTotal());
        return pg;
    }

    @Override
    public List<Map> getTemplateMessageLogTotalList(MallMessagePushQueryVo messagePushQueryVo) {
        if (messagePushQueryVo.getStart() == null) {
            messagePushQueryVo.setStart(DateUtils.currentDate());
        }
        if (messagePushQueryVo.getMessageType() != null) {
            if (messagePushQueryVo.getMessageType().intValue() == MessageTypeEnum.TEMPLATE_MESSAGE.getValue()) {
                TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessage(messagePushQueryVo.getMessageId());
                messagePushQueryVo.setTemplateId(templateMessageEntity == null ? "" : templateMessageEntity.getTemplateId());
            } else if (messagePushQueryVo.getMessageType().intValue() == MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue()) {
                // empty if block
            }
        }
        return this.templateMessageLogMapper.getTemplateMessageLogTotalList(messagePushQueryVo);
    }

    @Override
    public boolean save(MallTemplateMessageLogEntity templateMessageLogEntity) {
        try {
            templateMessageLogEntity.setMessageText(templateMessageLogEntity.getMessageText().replace("'", "\uff07"));
            return this.templateMessageLogMapper.insert(templateMessageLogEntity) > 0;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean exists(MallTemplateMessageLogEntity templateMessageLogEntity) {
        return this.templateMessageLogMapper.existsByEntity(templateMessageLogEntity) > 0;
    }

    @Override
    public boolean exists(String logId) {
        return this.templateMessageLogMapper.exists((Serializable)((Object)logId)) > 0;
    }
}

