/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.TemplateMessageMapper;
import cc.lechun.mall.entity.weixin.TemplateMessageBodyVo;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.MessageAPI;
import weixin.popular.bean.message.GetAllPrivateTemplateResult;
import weixin.popular.bean.message.MiniTemplate;
import weixin.popular.bean.message.MiniTemplateResult;
import weixin.popular.bean.message.PrivateTemplate;
import weixin.popular.bean.message.templatemessage.MiniSubscribeMessage;
import weixin.popular.bean.message.templatemessage.MiniprogramMessageRedirectItem;
import weixin.popular.bean.message.templatemessage.TemplateMessage;
import weixin.popular.bean.message.templatemessage.TemplateMessageItem;

@Service
public class TemplateMessageService
extends BaseService
implements TemplateMessageInterface {
    @Autowired
    private TemplateMessageMapper templateMessageMapper;
    @Autowired
    private WeiXinKeywordInterface keywordInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseInterface;

    @Override
    @ReadThroughSingleCache(namespace="TemplateMessageService.getTemplateMessageById")
    public TemplateMessageEntity getTemplateMessageById(@ParameterValueKeyProvider Integer id) {
        return (TemplateMessageEntity)this.templateMessageMapper.selectByPrimaryKey(id);
    }

    @Override
    public BaseJsonVo save(TemplateMessageEntity templateMessageEntity) {
        boolean b = false;
        TemplateMessageEntity templateMessageEntity1 = new TemplateMessageEntity();
        templateMessageEntity1.setTemplateId(templateMessageEntity.getTemplateId());
        templateMessageEntity1.setPlatformId(templateMessageEntity.getPlatformId());
        templateMessageEntity1 = (TemplateMessageEntity)this.templateMessageMapper.getSingle(templateMessageEntity1);
        if (templateMessageEntity.getMessageId() == null || templateMessageEntity.getMessageId() == 0) {
            if (templateMessageEntity1 != null) {
                return BaseJsonVo.error((String)("\u5df2\u5b58\u5728\uff1a" + templateMessageEntity.getMessageName()));
            }
            templateMessageEntity.setCreatTime(DateUtils.now());
            b = this.templateMessageMapper.insertSelective(templateMessageEntity) > 0;
        } else {
            if (templateMessageEntity1 != null && templateMessageEntity1.getMessageId().intValue() != templateMessageEntity.getMessageId().intValue()) {
                return BaseJsonVo.error((String)("\u5df2\u5b58\u5728\uff1a" + templateMessageEntity.getMessageName()));
            }
            b = this.templateMessageMapper.updateByPrimaryKeySelective(templateMessageEntity) > 0;
        }
        this.memcachedService.delete("TemplateMessageService.getTemplateMessageById", templateMessageEntity.getTemplateId() == null ? "" : templateMessageEntity.getTemplateId());
        if (b) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public PageInfo list(Integer page, Integer pageSize, TemplateMessageEntity templateMessageEntity) {
        Page lst = PageHelper.startPage((int)page, (int)pageSize).setOrderBy("MESSAGE_ID DESC").doSelectPage(() -> this.templateMessageMapper.getTemplateMessageList(templateMessageEntity));
        return new PageInfo((List)lst);
    }

    @Override
    public boolean delete(Integer id) {
        this.memcachedService.delete("TemplateMessageService.getTemplateMessageById", String.valueOf(id));
        return this.templateMessageMapper.deleteByPrimaryKey(id) > 0;
    }

    @Override
    public List<TemplateMessageEntity> getTemplateMessageList(Integer platformId) {
        TemplateMessageEntity messageEntity = new TemplateMessageEntity();
        messageEntity.setPlatformId(platformId);
        messageEntity.setStatus(1);
        return this.templateMessageMapper.getList(messageEntity);
    }

    @Override
    public List<TemplateMessageEntity> getSubscribeTemplateMessageList(Integer platformId) {
        TemplateMessageEntity messageEntity = new TemplateMessageEntity();
        messageEntity.setPlatformId(platformId);
        messageEntity.setStatus(1);
        if (platformId.intValue() == PlatFormEnum.LECHUN_MINI.getValue()) {
            messageEntity.setMessageType(2);
        }
        if (platformId.intValue() == PlatFormEnum.LECHUN_WECHAT_MAIN.getValue()) {
            messageEntity.setMessageType(4);
        }
        return this.templateMessageMapper.getList(messageEntity);
    }

    @Override
    public BaseJsonVo getTemplateMessageContent(Integer messageId, Map<String, String> variable) {
        TemplateMessageEntity templateMessageEntity = this.getTemplateMessageById(messageId);
        if (templateMessageEntity == null) {
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u6a21\u677f");
        }
        try {
            if (templateMessageEntity.getPlatformId() == 4) {
                return this.getMiniTemplateMessageContent(templateMessageEntity, messageId, variable);
            }
            TemplateMessage templateMessage = new TemplateMessage();
            if (templateMessageEntity != null) {
                templateMessage.setTemplate_id(templateMessageEntity.getTemplateId());
                templateMessage.setTouser("");
                if (StringUtils.isNotEmpty((String)templateMessageEntity.getUrl())) {
                    templateMessage.setUrl(this.keywordInterface.replaceVariable(templateMessageEntity.getUrl(), variable));
                    if (!templateMessageEntity.getUrl().startsWith("http")) {
                        MiniprogramMessageRedirectItem miniprogramMessageRedirectItem = new MiniprogramMessageRedirectItem();
                        miniprogramMessageRedirectItem.setAppid("wxccfc57d73bc81766");
                        miniprogramMessageRedirectItem.setPagepath(templateMessage.getUrl());
                        templateMessage.setMiniprogram(miniprogramMessageRedirectItem);
                        templateMessage.setUrl("http://mp.weixin.qq.com");
                    }
                }
                LinkedHashMap<String, TemplateMessageItem> data = new LinkedHashMap<String, TemplateMessageItem>();
                TemplateMessageItem first = new TemplateMessageItem();
                first.setValue(this.keywordInterface.replaceVariable(templateMessageEntity.getFirst(), variable));
                first.setColor(templateMessageEntity.getTopColor());
                data.put("first", first);
                if (templateMessageEntity.getVariable().isEmpty()) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                String bodyStr = this.keywordInterface.replaceVariable(templateMessageEntity.getVariable(), variable);
                List bodyVos = JsonUtils.getListByArray(TemplateMessageBodyVo.class, (String)bodyStr);
                if (bodyVos == null || bodyVos.size() == 0) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                for (TemplateMessageBodyVo bodyVo : bodyVos) {
                    TemplateMessageItem body = new TemplateMessageItem();
                    body.setValue(bodyVo.getValue());
                    body.setColor(bodyVo.getColor());
                    data.put(bodyVo.getTitle(), body);
                }
                TemplateMessageItem remark = new TemplateMessageItem();
                remark.setValue(this.keywordInterface.replaceVariable(templateMessageEntity.getRemark(), variable));
                remark.setColor(templateMessageEntity.getBottomColor());
                data.put("remark", remark);
                templateMessage.setData(data);
            }
            return BaseJsonVo.success((Object)templateMessage);
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return BaseJsonVo.error((String)"\u7ec4\u7ec7\u6d88\u606f\u5360\u4f4d\u7b26Map\u5f02\u5e38");
        }
    }

    private BaseJsonVo<MiniSubscribeMessage> getMiniTemplateMessageContent(TemplateMessageEntity templateMessageEntity, Integer messageId, Map<String, String> variable) {
        try {
            MiniSubscribeMessage templateMessage = new MiniSubscribeMessage();
            LinkedHashMap data = new LinkedHashMap();
            if (templateMessageEntity != null) {
                templateMessage.setTemplate_id(templateMessageEntity.getTemplateId());
                templateMessage.setTouser("");
                if (StringUtils.isNotEmpty((String)templateMessageEntity.getUrl())) {
                    templateMessage.setPage(this.keywordInterface.replaceVariable(templateMessageEntity.getUrl(), variable));
                }
                if (templateMessageEntity.getVariable().isEmpty()) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                String bodyStr = this.keywordInterface.replaceVariable(templateMessageEntity.getVariable(), variable);
                List bodyVos = JsonUtils.getListByArray(TemplateMessageBodyVo.class, (String)bodyStr);
                if (bodyVos == null || bodyVos.size() == 0) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                for (TemplateMessageBodyVo bodyVo : bodyVos) {
                    LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
                    item.put("value", this.keywordInterface.replaceVariable(bodyVo.getValue(), variable));
                    data.put(bodyVo.getTitle(), item);
                }
                templateMessage.setData(data);
            }
            return BaseJsonVo.success((Object)templateMessage);
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return BaseJsonVo.error((String)"\u7ec4\u7ec7\u6d88\u606f\u5360\u4f4d\u7b26Map\u5f02\u5e38");
        }
    }

    @Override
    public TemplateMessageEntity getTemplateMessage(Integer id) {
        return (TemplateMessageEntity)this.templateMessageMapper.selectByPrimaryKey(id);
    }

    @Override
    public BaseJsonVo initWeixinTemplate(Integer platformId, Integer initAll) {
        String accessToken = this.weiXinBaseInterface.getAccessTokenByPlatformId(platformId).getAccessToken();
        GetAllPrivateTemplateResult templateResult = MessageAPI.templateGet_all_private_template((String)accessToken);
        if (templateResult.isSuccess()) {
            if (platformId == 1) {
                TemplateMessageEntity s1 = new TemplateMessageEntity();
                s1.setPlatformId(platformId);
                s1.setMessageType(2);
                s1.setStatus(1);
                List templateMessageEntities = this.templateMessageMapper.getList(s1);
                for (TemplateMessageEntity p : templateMessageEntities) {
                    if (templateResult.getTemplate_list().stream().filter(c -> c.getTemplate_id().equals(p.getTemplateId())).count() != 0L) continue;
                    p.setStatus(0);
                    this.templateMessageMapper.updateByPrimaryKeySelective(p);
                }
            }
            TemplateMessageEntity search = new TemplateMessageEntity();
            for (PrivateTemplate t : templateResult.getTemplate_list()) {
                search.setTemplateId(t.getTemplate_id());
                TemplateMessageEntity existEntity = (TemplateMessageEntity)this.templateMessageMapper.getSingle(search);
                if (existEntity == null) {
                    TemplateMessageEntity insert = new TemplateMessageEntity();
                    insert.setTemplateId(t.getTemplate_id());
                    insert.setCreatTime(new Date());
                    insert.setDays(0);
                    insert.setMessageName(t.getTitle());
                    insert.setMessageType(2);
                    insert.setPlatformGroupId(1000);
                    insert.setPlatformId(platformId);
                    insert.setSource(1);
                    insert.setStatus(1);
                    insert.setMessageNameOrigin(t.getTitle());
                    insert.setVariable(JsonUtils.toJson(this.convertContent(t.getContent()), (boolean)false));
                    insert.setIndustry(t.getPrimary_industry() + "-" + t.getDeputy_industry());
                    this.templateMessageMapper.insert(insert);
                } else {
                    if (Integer.valueOf(1).equals(initAll) && StringUtils.isNotEmpty((String)existEntity.getVariable()) && !String.valueOf("[]").equals(existEntity.getVariable())) {
                        this.logger.info("\u5fae\u4fe1\u6a21\u677f\uff1a" + JsonUtils.toJson((Object)existEntity, (boolean)true));
                        try {
                            List bodyVos = JsonUtils.getListByArray(TemplateMessageBodyVo.class, (String)existEntity.getVariable());
                            List<TemplateMessageBodyVo> weixinBodyVos = this.convertContent(t.getContent());
                            for (TemplateMessageBodyVo v : bodyVos) {
                                Optional<TemplateMessageBodyVo> find = weixinBodyVos.stream().filter(c -> c.getTitle().equals(v.getTitle())).findFirst();
                                if (!find.isPresent()) continue;
                                v.setName(find.get().getName());
                            }
                            existEntity.setVariable(JsonUtils.toJson((Object)bodyVos, (boolean)false));
                            this.templateMessageMapper.updateByPrimaryKeySelective(existEntity);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (StringUtils.isEmpty((String)existEntity.getVariable()) || String.valueOf("[]").equals(existEntity.getVariable())) {
                        existEntity.setVariable(JsonUtils.toJson(this.convertContent(t.getContent()), (boolean)false));
                        this.templateMessageMapper.updateByPrimaryKeySelective(existEntity);
                    }
                    existEntity.setMessageNameOrigin(t.getTitle());
                    this.templateMessageMapper.updateByPrimaryKeySelective(existEntity);
                }
                this.logger.info(JsonUtils.toJson((Object)t, (boolean)true));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo initMiniTemplate(Integer platformId, Integer initAll) {
        WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseInterface.getAccessTokenByPlatformId(platformId);
        if (weiXinBaseEntity == null) {
            return BaseJsonVo.error((String)"\u67e5\u8be2\u5e73\u53f0\u51fa\u9519\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        String accessToken = weiXinBaseEntity.getAccessToken();
        MiniTemplateResult templateResult = MessageAPI.getMiniTemplateList((String)accessToken);
        this.logger.info("\u5c0f\u7a0b\u5e8f\u6a21\u677f" + templateResult.isSuccess() + JsonUtils.toJson((Object)templateResult, (boolean)true));
        if (templateResult.isSuccess()) {
            TemplateMessageEntity s1 = new TemplateMessageEntity();
            s1.setPlatformId(platformId);
            s1.setStatus(1);
            s1.setMessageType(platformId == 1 ? 4 : 2);
            List templateMessageEntities = this.templateMessageMapper.getList(s1);
            for (TemplateMessageEntity p : templateMessageEntities) {
                if (templateResult.getData().stream().filter(c -> c.getPriTmplId().equals(p.getTemplateId())).count() != 0L) continue;
                p.setStatus(0);
                this.templateMessageMapper.updateByPrimaryKeySelective(p);
            }
            TemplateMessageEntity search = new TemplateMessageEntity();
            for (MiniTemplate t : templateResult.getData()) {
                search.setTemplateId(t.getPriTmplId());
                TemplateMessageEntity existEntity = (TemplateMessageEntity)this.templateMessageMapper.getSingle(search);
                if (existEntity == null) {
                    TemplateMessageEntity insert = new TemplateMessageEntity();
                    insert.setTemplateId(t.getPriTmplId());
                    insert.setCreatTime(new Date());
                    insert.setDays(0);
                    insert.setMessageName(t.getTitle());
                    insert.setMessageNameOrigin(t.getTitle());
                    insert.setMessageType(platformId == 1 ? 4 : 2);
                    insert.setPlatformGroupId(1000);
                    insert.setPlatformId(platformId);
                    insert.setSource(1);
                    insert.setStatus(1);
                    insert.setAppid(weiXinBaseEntity.getAppid());
                    insert.setVariable(JsonUtils.toJson(this.convertContent(t.getContent()), (boolean)false));
                    insert.setIndustry("");
                    this.templateMessageMapper.insert(insert);
                } else {
                    if (Integer.valueOf(1).equals(initAll) && StringUtils.isNotEmpty((String)existEntity.getVariable()) && !String.valueOf("[]").equals(existEntity.getVariable())) {
                        try {
                            List bodyVos = JsonUtils.getListByArray(TemplateMessageBodyVo.class, (String)existEntity.getVariable());
                            List<TemplateMessageBodyVo> weixinBodyVos = this.convertContent(t.getContent());
                            for (TemplateMessageBodyVo v : bodyVos) {
                                Optional<TemplateMessageBodyVo> find = weixinBodyVos.stream().filter(c -> c.getTitle().equals(v.getTitle())).findFirst();
                                if (!find.isPresent()) continue;
                                v.setName(find.get().getName());
                            }
                            existEntity.setVariable(JsonUtils.toJson((Object)bodyVos, (boolean)false));
                            existEntity.setAppid(weiXinBaseEntity.getAppid());
                            this.templateMessageMapper.updateByPrimaryKeySelective(existEntity);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (StringUtils.isEmpty((String)existEntity.getVariable()) || String.valueOf("[]").equals(existEntity.getVariable())) {
                        existEntity.setVariable(JsonUtils.toJson(this.convertContent(t.getContent()), (boolean)false));
                        this.templateMessageMapper.updateByPrimaryKeySelective(existEntity);
                    }
                    existEntity.setMessageNameOrigin(t.getTitle());
                    this.templateMessageMapper.updateByPrimaryKeySelective(existEntity);
                }
                this.logger.info(JsonUtils.toJson((Object)t, (boolean)true));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private List<TemplateMessageBodyVo> convertContent(String weixinContent) {
        if (StringUtils.isEmpty((String)weixinContent)) {
            return new ArrayList<TemplateMessageBodyVo>();
        }
        String[] arr = weixinContent.split("\n");
        ArrayList<TemplateMessageBodyVo> bodyVos = new ArrayList<TemplateMessageBodyVo>();
        for (String a : arr) {
            String[] arr1 = a.split("\uff1a");
            if (arr1.length < 2) {
                arr1 = a.split(":");
            }
            if (arr1.length != 2) continue;
            TemplateMessageBodyVo bodyVo = new TemplateMessageBodyVo();
            bodyVo.setColor("");
            bodyVo.setName(arr1[0]);
            bodyVo.setTitle(arr1[1].replace("{{", "").replace("}}", "").replace(".DATA", ""));
            bodyVo.setValue("");
            bodyVos.add(bodyVo);
        }
        if (bodyVos.size() > 0) {
            return bodyVos;
        }
        return new ArrayList<TemplateMessageBodyVo>();
    }
}

