/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.TemplateSubcriptConfigMapper;
import cc.lechun.mall.entity.page.PageLinkEntity;
import cc.lechun.mall.entity.weixin.TemplateSubcriptConfigEntity;
import cc.lechun.mall.entity.weixin.TemplateSubcriptConfigVo;
import cc.lechun.mall.iservice.page.PageLinkInterface;
import cc.lechun.mall.iservice.weixin.TemplateSubcriptConfigInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateSubcriptConfigService
extends BaseService<TemplateSubcriptConfigEntity, Integer>
implements TemplateSubcriptConfigInterface {
    @Resource
    private TemplateSubcriptConfigMapper templateSubcriptConfigMapper;
    @Autowired
    private PageLinkInterface pageLinkInterface;

    @Override
    public List<TemplateSubcriptConfigVo> getList(Integer pageLinkId) {
        if (pageLinkId == null) {
            return new ArrayList<TemplateSubcriptConfigVo>();
        }
        return this.templateSubcriptConfigMapper.getListByPageLinkId(pageLinkId);
    }

    @Override
    public BaseJsonVo save(TemplateSubcriptConfigEntity configEntity) {
        if (configEntity.getTemplateId() == null || Integer.valueOf(0).equals(configEntity.getTemplateId())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6a21\u677f");
        }
        if (configEntity.getPageLinkId() == null || Integer.valueOf(0).equals(configEntity.getPageLinkId())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u9875\u9762\u540e\u4fdd\u5b58");
        }
        PageLinkEntity pageLinkEntity = (PageLinkEntity)this.pageLinkInterface.selectByPrimaryKey(configEntity.getPageLinkId());
        if (pageLinkEntity != null) {
            configEntity.setPageUrl(pageLinkEntity.getPageLink());
        }
        if (configEntity.getPlatformId() == null || Integer.valueOf(0).equals(configEntity.getPlatformId())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u5e73\u53f0");
        }
        if (StringUtils.isEmpty((String)configEntity.getEvent())) {
            configEntity.setEvent("default");
        }
        String remark = configEntity.getRemark();
        configEntity.setRemark(null);
        if (configEntity.getId() != null) {
            Integer id = configEntity.getId();
            configEntity.setId(null);
            TemplateSubcriptConfigEntity c = (TemplateSubcriptConfigEntity)this.getSingle(configEntity);
            if (c != null && !c.getId().equals(id)) {
                return BaseJsonVo.error((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u5e94\u7684\u8ba2\u9605\u6a21\u677f(edit)");
            }
            configEntity.setRemark(remark);
            configEntity.setId(id);
            this.updateByPrimaryKeySelective(configEntity);
        } else {
            if (this.existsByEntity(configEntity) > 0) {
                return BaseJsonVo.error((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u5e94\u7684\u8ba2\u9605\u6a21\u677f(add)");
            }
            configEntity.setRemark(remark);
            configEntity.setCreatTime(new Date());
            configEntity.setSence(0);
            this.insertSelective(configEntity);
        }
        return BaseJsonVo.success((Object)configEntity.getId());
    }
}

